/*
 * Decompiled with CFR 0.152.
 */
package enigma;

import enigma.SteppingMechanism;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;

public class CryptoTerminal {
    private static SteppingMechanism stepMechComplete;
    private static String[] translator;
    private static String[] contacts;

    public static void main(String[] args) {
        BufferedReader tReader = new BufferedReader(new InputStreamReader(System.in));
        String tCommand = "";
        System.out.println("\n\n");
        System.out.println("    @======================================@");
        System.out.println("    |--Public--Enigma--Machine--Simulator--|");
        System.out.println("    |--------------------------------------|");
        System.out.println("    |-------Cryptanalytic---Terminal-------|");
        System.out.println("    @======================================@");
        System.out.println("    |----Author---Filippos---Manoudakis----|");
        System.out.println("    @======================================@");
        System.out.println("    |-------------------------2012/2013----|");
        System.out.println("    @======================================@");
        System.out.println("\n\n");
        System.out.println("ENIGMA> Configuration of an Enigma machine is required prior to using the terminal.");
        System.out.println("ENIGMA> Enter command to continue: ok/exit ");
        System.out.print("ENIGMA> Command: ");
        try {
            tCommand = tReader.readLine().toUpperCase();
        }
        catch (IOException ioe) {
            System.out.println("ENIGMA> IO Error trying to read your command.");
        }
        while (!tCommand.equals("OK") && !tCommand.equals("EXIT")) {
            System.out.println("ENIGMA> Invalid command.");
            System.out.print("ENIGMA> Command: ");
            try {
                tCommand = tReader.readLine().toUpperCase();
            }
            catch (IOException ioe) {
                System.out.println("ENIGMA> IO Error trying to read command.");
            }
        }
        if (tCommand.equals("EXIT")) {
            System.out.println("ENIGMA> Terminal will exit.");
            System.exit(0);
        }
        System.out.println("\n\n");
        System.out.println("    @======================================@");
        System.out.println("    |--------Machine--Configuration--------|");
        System.out.println("    @======================================@");
        System.out.println("    | Codes: D    | Enigma D               |");
        System.out.println("    |--------------------------------------|");
        System.out.println("    |        KR   | Enigma K Railway       |");
        System.out.println("    |        KS   | Enigma K Swiss         |");
        System.out.println("    |        KT   | Enigma T Tirpitz       |");
        System.out.println("    |--------------------------------------|");
        System.out.println("    |        GA   | Enigma A28             |");
        System.out.println("    |        G1   | Enigma G31 G-111       |");
        System.out.println("    |        G2   | Enigma G31 G-260       |");
        System.out.println("    |        G3   | Enigma G31 G-320       |");
        System.out.println("    |--------------------------------------|");
        System.out.println("    |        IS   | Enigma I Service       |");
        System.out.println("    |        IN   | Enigma I Norway        |");
        System.out.println("    |        IM3  | Enigma M3              |");
        System.out.println("    |        IM4  | Enigma M4              |");
        System.out.println("    @======================================@");
        System.out.println("\n\n");
        System.out.print("ENIGMA> Command: ");
        try {
            tCommand = tReader.readLine().toUpperCase();
        }
        catch (IOException ioe) {
            System.out.println("ENIGMA> IO Error trying to read command.");
        }
        while (!(tCommand.equals("D") || tCommand.equals("KR") || tCommand.equals("KS") || tCommand.equals("KT") || tCommand.equals("GA") || tCommand.equals("G1") || tCommand.equals("G2") || tCommand.equals("G3") || tCommand.equals("IS") || tCommand.equals("IN") || tCommand.equals("IM3") || tCommand.equals("IM4") || tCommand.equals("EXIT"))) {
            System.out.println("ENIGMA> Invalid command.");
            System.out.print("ENIGMA> Command: ");
            try {
                tCommand = tReader.readLine().toUpperCase();
            }
            catch (IOException ioe) {
                System.out.println("ENIGMA> IO Error trying to read command.");
            }
        }
        if (tCommand.equals("EXIT")) {
            System.out.println("ENIGMA> Terminal will exit.");
            System.exit(0);
        }
        System.out.println("ENIGMA> " + CryptoTerminal.machineType(tCommand) + " has been loaded.");
        SteppingMechanism stepMechSetup = new SteppingMechanism(tCommand);
        if (tCommand.equals("IS") || tCommand.equals("IN") || tCommand.equals("IM3") || tCommand.equals("IM4")) {
            System.out.println("ENIGMA> " + CryptoTerminal.machineType(tCommand) + " has a selection of Reflectors.");
            System.out.println("ENIGMA> Machine will be loaded with Reflector UKW-B.");
            System.out.println("ENIGMA> Would you like to load another Reflector? yes/no");
            System.out.print("ENIGMA> Command: ");
            try {
                tCommand = tReader.readLine().toUpperCase();
            }
            catch (IOException ioe) {
                System.out.println("ENIGMA> IO Error trying to read command.");
            }
            while (!(tCommand.equals("Y") || tCommand.equals("N") || tCommand.equals("YES") || tCommand.equals("NO") || tCommand.equals("EXIT"))) {
                System.out.println("ENIGMA> Invalid command.");
                System.out.print("ENIGMA> Command: ");
                try {
                    tCommand = tReader.readLine().toUpperCase();
                }
                catch (IOException ioe) {
                    System.out.println("ENIGMA> IO Error trying to read command.");
                }
            }
            if (tCommand.equals("Y") || tCommand.equals("YES")) {
                switch (stepMechSetup.getType()) {
                    case "IS": 
                    case "IN": {
                        System.out.println("\n\n");
                        System.out.println("    @======================================@");
                        System.out.println("    |---------Enigma--I--Reflectors--------|");
                        System.out.println("    @======================================@");
                        System.out.println("    | Codes: A    | UKW-A                  |");
                        System.out.println("    |        B    | UKW-B                  |");
                        System.out.println("    |        C    | UKW-C                  |");
                        System.out.println("    @======================================@");
                        System.out.println("\n\n");
                        System.out.print("ENIGMA> Command: ");
                        try {
                            tCommand = tReader.readLine().toUpperCase();
                        }
                        catch (IOException ioe) {
                            System.out.println("ENIGMA> IO Error trying to read command.");
                        }
                        while (!(tCommand.equals("A") || tCommand.equals("B") || tCommand.equals("C") || tCommand.equals("EXIT") || tCommand.equals("UKW-A") || tCommand.equals("UKW-B") || tCommand.equals("UKW-C"))) {
                            System.out.println("ENIGMA> Invalid command.");
                            System.out.print("ENIGMA> Command: ");
                            try {
                                tCommand = tReader.readLine().toUpperCase();
                            }
                            catch (IOException ioe) {
                                System.out.println("ENIGMA> IO Error trying to read command.");
                            }
                        }
                        if (tCommand.equals("A") || tCommand.equals("UKW-A")) {
                            stepMechSetup.setReflector("I.UKW-A");
                            System.out.println("ENIGMA> UKW-A Relfector has been loaded into the machine.");
                            break;
                        }
                        if (tCommand.equals("B") || tCommand.equals("UKW-B")) {
                            stepMechSetup.setReflector("I.UKW-B");
                            System.out.println("ENIGMA> UKW-B Relfector has been loaded into the machine.");
                            break;
                        }
                        if (tCommand.equals("C") || tCommand.equals("UKW-C")) {
                            stepMechSetup.setReflector("I.UKW-C");
                            System.out.println("ENIGMA> UKW-C Relfector has been loaded into the machine.");
                            break;
                        }
                        if (!tCommand.equals("EXIT")) break;
                        System.out.println("ENIGMA> Terminal will exit.");
                        System.exit(0);
                        break;
                    }
                    case "IM3": {
                        System.out.println("\n\n");
                        System.out.println("    @======================================@");
                        System.out.println("    |--------Enigma--M3--Reflectors--------|");
                        System.out.println("    @======================================@");
                        System.out.println("    | Codes: B    | UKW-B                  |");
                        System.out.println("    |        C    | UKW-C                  |");
                        System.out.println("    @======================================@");
                        System.out.println("\n\n");
                        System.out.print("ENIGMA> Command: ");
                        try {
                            tCommand = tReader.readLine().toUpperCase();
                        }
                        catch (IOException ioe) {
                            System.out.println("ENIGMA> IO Error trying to read command.");
                        }
                        while (!(tCommand.equals("B") || tCommand.equals("C") || tCommand.equals("EXIT") || tCommand.equals("UKW-B") || tCommand.equals("UKW-C"))) {
                            System.out.println("ENIGMA> Invalid command.");
                            System.out.print("ENIGMA> Command: ");
                            try {
                                tCommand = tReader.readLine().toUpperCase();
                            }
                            catch (IOException ioe) {
                                System.out.println("ENIGMA> IO Error trying to read command.");
                            }
                        }
                        if (tCommand.equals("B") || tCommand.equals("UKW-B")) {
                            stepMechSetup.setReflector("M3.UKW-B");
                            System.out.println("ENIGMA> UKW-B Relfector has been loaded into the machine.");
                            break;
                        }
                        if (tCommand.equals("C") || tCommand.equals("UKW-C")) {
                            stepMechSetup.setReflector("M3.UKW-C");
                            System.out.println("ENIGMA> UKW-C Relfector has been loaded into the machine.");
                            break;
                        }
                        if (!tCommand.equals("EXIT")) break;
                        System.out.println("ENIGMA> Terminal will exit.");
                        System.exit(0);
                        break;
                    }
                    case "IM4": {
                        System.out.println("\n\n");
                        System.out.println("    @======================================@");
                        System.out.println("    |--------Enigma--M4--Reflectors--------|");
                        System.out.println("    @======================================@");
                        System.out.println("    | Codes: B    | UKW-B                  |");
                        System.out.println("    |        C    | UKW-C                  |");
                        System.out.println("    @======================================@");
                        System.out.println("\n\n");
                        System.out.print("ENIGMA> Command: ");
                        try {
                            tCommand = tReader.readLine().toUpperCase();
                        }
                        catch (IOException ioe) {
                            System.out.println("ENIGMA> IO Error trying to read command.");
                        }
                        while (!(tCommand.equals("B") || tCommand.equals("C") || tCommand.equals("EXIT") || tCommand.equals("UKW-B") || tCommand.equals("UKW-C"))) {
                            System.out.println("ENIGMA> Invalid command.");
                            System.out.print("ENIGMA> Command: ");
                            try {
                                tCommand = tReader.readLine().toUpperCase();
                            }
                            catch (IOException ioe) {
                                System.out.println("ENIGMA> IO Error trying to read command.");
                            }
                        }
                        if (tCommand.equals("B") || tCommand.equals("UKW-B")) {
                            stepMechSetup.setReflector("M4.UKW-B");
                            System.out.println("ENIGMA> UKW-B Relfector has been loaded into the machine.");
                            break;
                        }
                        if (tCommand.equals("C") || tCommand.equals("UKW-C")) {
                            stepMechSetup.setReflector("M4.UKW-C");
                            System.out.println("ENIGMA> UKW-C Relfector has been loaded into the machine.");
                            break;
                        }
                        if (!tCommand.equals("EXIT")) break;
                        System.out.println("ENIGMA> Terminal will exit.");
                        System.exit(0);
                    }
                }
            } else if (tCommand.equals("EXIT")) {
                System.out.println("ENIGMA> Terminal will exit.");
                System.exit(0);
            }
        }
        String tempType = stepMechSetup.getType();
        String extraRotor = "";
        String rightRotor = "";
        String middleRotor = "";
        String leftRotor = "";
        if (tempType.equals("D") || tempType.equals("KR") || tempType.equals("KS") || tempType.equals("GA") || tempType.equals("G2") || tempType.equals("G3")) {
            System.out.println("\n\n");
            System.out.println("    @======================================@");
            System.out.println("    |-----------Rotor--Selection-----------|");
            System.out.println("    @======================================@");
            System.out.println("    | Codes: I    | One                    |");
            System.out.println("    |        II   | Two                    |");
            System.out.println("    |        III  | Three                  |");
            System.out.println("    @======================================@");
            System.out.println("\n\n");
            System.out.println("ENIGMA> Select Rotors to be loaded into the machine.");
            System.out.println("ENIGMA> Each position requires a uniquely identifiable Rotor.");
            System.out.println("ENIGMA> Enter Rotor identification code for right position.");
            System.out.print("ENIGMA> Command: ");
            try {
                tCommand = tReader.readLine().toUpperCase();
            }
            catch (IOException ioe) {
                System.out.println("ENIGMA> IO Error trying to read command.");
            }
            while (!((tCommand.equals("I") || tCommand.equals("II") || tCommand.equals("III") || tCommand.equals("ONE") || tCommand.equals("TWO") || tCommand.equals("THREE")) && !tCommand.equals("EXIT"))) {
                System.out.println("ENIGMA> Invalid command.");
                System.out.print("ENIGMA> Command: ");
                try {
                    tCommand = tReader.readLine().toUpperCase();
                }
                catch (IOException ioe) {
                    System.out.println("ENIGMA> IO Error trying to read command.");
                }
            }
            if (tCommand.equals("I") || tCommand.equals("ONE")) {
                rightRotor = "I";
                System.out.println("ENIGMA> Rotor I has been loaded into the right position of the machine.");
            } else if (tCommand.equals("II") || tCommand.equals("TWO")) {
                rightRotor = "II";
                System.out.println("ENIGMA> Rotor II has been loaded into the right position of the machine.");
            } else if (tCommand.equals("III") || tCommand.equals("THREE")) {
                rightRotor = "III";
                System.out.println("ENIGMA> Rotor III has been loaded into the right position of the machine.");
            } else if (tCommand.equals("EXIT")) {
                System.out.println("ENIGMA> Terminal will exit.");
                System.exit(0);
            }
            System.out.println("ENIGMA> Enter Rotor identification code for middle position.");
            System.out.print("ENIGMA> Command: ");
            try {
                tCommand = tReader.readLine().toUpperCase();
            }
            catch (IOException ioe) {
                System.out.println("ENIGMA> IO Error trying to read command.");
            }
            while (!((tCommand.equals("I") || tCommand.equals("II") || tCommand.equals("III") || tCommand.equals("ONE") || tCommand.equals("TWO") || tCommand.equals("THREE")) && !tCommand.equals("EXIT"))) {
                System.out.println("ENIGMA> Invalid command.");
                System.out.print("ENIGMA> Command: ");
                try {
                    tCommand = tReader.readLine().toUpperCase();
                }
                catch (IOException ioe) {
                    System.out.println("ENIGMA> IO Error trying to read command.");
                }
            }
            while (rightRotor.equals(tCommand)) {
                System.out.println("ENIGMA> Rotor is in use. Please use another Rotor.");
                System.out.print("ENIGMA> Command: ");
                try {
                    tCommand = tReader.readLine().toUpperCase();
                }
                catch (IOException ioe) {
                    System.out.println("ENIGMA> IO Error trying to read command.");
                }
            }
            if (tCommand.equals("I") || tCommand.equals("ONE")) {
                middleRotor = "I";
                System.out.println("ENIGMA> Rotor I has been loaded into the middle position of the machine.");
            } else if (tCommand.equals("II") || tCommand.equals("TWO")) {
                middleRotor = "II";
                System.out.println("ENIGMA> Rotor II has been loaded into the middle position of the machine.");
            } else if (tCommand.equals("III") || tCommand.equals("THREE")) {
                middleRotor = "III";
                System.out.println("ENIGMA> Rotor III has been loaded into the middle position of the machine.");
            } else if (tCommand.equals("EXIT")) {
                System.out.println("ENIGMA> Terminal will exit.");
                System.exit(0);
            }
            System.out.println("ENIGMA> Enter Rotor identification code for left position.");
            System.out.print("ENIGMA> Command: ");
            try {
                tCommand = tReader.readLine().toUpperCase();
            }
            catch (IOException ioe) {
                System.out.println("ENIGMA> IO Error trying to read command.");
            }
            while (!((tCommand.equals("I") || tCommand.equals("II") || tCommand.equals("III") || tCommand.equals("ONE") || tCommand.equals("TWO") || tCommand.equals("THREE")) && !tCommand.equals("EXIT"))) {
                System.out.println("ENIGMA> Invalid command.");
                System.out.print("ENIGMA> Command: ");
                try {
                    tCommand = tReader.readLine().toUpperCase();
                }
                catch (IOException ioe) {
                    System.out.println("ENIGMA> IO Error trying to read command.");
                }
            }
            while (rightRotor.equals(tCommand) || middleRotor.equals(tCommand)) {
                System.out.println("ENIGMA> Rotor is in use. Please use another Rotor.");
                System.out.print("ENIGMA> Command: ");
                try {
                    tCommand = tReader.readLine().toUpperCase();
                }
                catch (IOException ioe) {
                    System.out.println("ENIGMA> IO Error trying to read command.");
                }
            }
            if (tCommand.equals("I") || tCommand.equals("ONE")) {
                leftRotor = "I";
                System.out.println("ENIGMA> Rotor I has been loaded into the left position of the machine.");
            } else if (tCommand.equals("II") || tCommand.equals("TWO")) {
                leftRotor = "II";
                System.out.println("ENIGMA> Rotor II has been loaded into the left position of the machine.");
            } else if (tCommand.equals("III") || tCommand.equals("THREE")) {
                leftRotor = "III";
                System.out.println("ENIGMA> Rotor III has been loaded into the left position of the machine.");
            } else if (tCommand.equals("EXIT")) {
                System.out.println("ENIGMA> Terminal will exit.");
                System.exit(0);
            }
            System.out.println("ENIGMA> Rotors have been loaded into the machine.");
            System.out.println("ENIGMA> Arrangement from left to right: " + leftRotor + " - " + middleRotor + " - " + rightRotor);
            stepMechSetup.setRotors(null, leftRotor, middleRotor, rightRotor);
        } else if (tempType.equals("KT") || tempType.equals("IM3")) {
            System.out.println("\n\n");
            System.out.println("    @======================================@");
            System.out.println("    |-----------Rotor--Selection-----------|");
            System.out.println("    @======================================@");
            System.out.println("    | Codes: I    | One                    |");
            System.out.println("    |        II   | Two                    |");
            System.out.println("    |        III  | Three                  |");
            System.out.println("    |        IV   | Four                   |");
            System.out.println("    |        V    | Five                   |");
            System.out.println("    |        VI   | Six                    |");
            System.out.println("    |        VII  | Seven                  |");
            System.out.println("    |        VIII | Eight                  |");
            System.out.println("    @======================================@");
            System.out.println("\n\n");
            System.out.println("ENIGMA> Select Rotors to be loaded into the machine.");
            System.out.println("ENIGMA> Each position requires a uniquely identifiable Rotor.");
            System.out.println("ENIGMA> Enter Rotor identification code for right position.");
            System.out.print("ENIGMA> Command: ");
            try {
                tCommand = tReader.readLine().toUpperCase();
            }
            catch (IOException ioe) {
                System.out.println("ENIGMA> IO Error trying to read command.");
            }
            while (!(tCommand.equals("I") || tCommand.equals("II") || tCommand.equals("III") || tCommand.equals("IV") || tCommand.equals("V") || tCommand.equals("VI") || tCommand.equals("VII") || tCommand.equals("VIII") || tCommand.equals("ONE") || tCommand.equals("TWO") || tCommand.equals("THREE") || tCommand.equals("FOUR") || tCommand.equals("FIVE") || tCommand.equals("SIX") || tCommand.equals("SEVEN") || tCommand.equals("EIGHT") || tCommand.equals("EXIT"))) {
                System.out.println("ENIGMA> Invalid command.");
                System.out.print("ENIGMA> Command: ");
                try {
                    tCommand = tReader.readLine().toUpperCase();
                }
                catch (IOException ioe) {
                    System.out.println("ENIGMA> IO Error trying to read command.");
                }
            }
            if (tCommand.equals("I") || tCommand.equals("ONE")) {
                rightRotor = "I";
                System.out.println("ENIGMA> Rotor I has been loaded into the right position of the machine.");
            } else if (tCommand.equals("II") || tCommand.equals("TWO")) {
                rightRotor = "II";
                System.out.println("ENIGMA> Rotor II has been loaded into the right position of the machine.");
            } else if (tCommand.equals("III") || tCommand.equals("THREE")) {
                rightRotor = "III";
                System.out.println("ENIGMA> Rotor III has been loaded into the right position of the machine.");
            } else if (tCommand.equals("IV") || tCommand.equals("FOUR")) {
                rightRotor = "IV";
                System.out.println("ENIGMA> Rotor IV has been loaded into the right position of the machine.");
            } else if (tCommand.equals("V") || tCommand.equals("FIVE")) {
                rightRotor = "V";
                System.out.println("ENIGMA> Rotor V has been loaded into the right position of the machine.");
            } else if (tCommand.equals("VI") || tCommand.equals("SIX")) {
                rightRotor = "VI";
                System.out.println("ENIGMA> Rotor VI has been loaded into the right position of the machine.");
            } else if (tCommand.equals("VII") || tCommand.equals("SEVEN")) {
                rightRotor = "VII";
                System.out.println("ENIGMA> Rotor VII has been loaded into the right position of the machine.");
            } else if (tCommand.equals("VIII") || tCommand.equals("EIGHT")) {
                rightRotor = "VIII";
                System.out.println("ENIGMA> Rotor VIII has been loaded into the right position of the machine.");
            } else if (tCommand.equals("EXIT")) {
                System.out.println("ENIGMA> Terminal will exit.");
                System.exit(0);
            }
            System.out.println("ENIGMA> Enter Rotor identification code for middle position.");
            System.out.print("ENIGMA> Command: ");
            try {
                tCommand = tReader.readLine().toUpperCase();
            }
            catch (IOException ioe) {
                System.out.println("ENIGMA> IO Error trying to read command.");
            }
            while (!(tCommand.equals("I") || tCommand.equals("II") || tCommand.equals("III") || tCommand.equals("IV") || tCommand.equals("V") || tCommand.equals("VI") || tCommand.equals("VII") || tCommand.equals("VIII") || tCommand.equals("ONE") || tCommand.equals("TWO") || tCommand.equals("THREE") || tCommand.equals("FOUR") || tCommand.equals("FIVE") || tCommand.equals("SIX") || tCommand.equals("SEVEN") || tCommand.equals("EIGHT") || tCommand.equals("EXIT"))) {
                System.out.println("ENIGMA> Invalid command.");
                System.out.print("ENIGMA> Command: ");
                try {
                    tCommand = tReader.readLine().toUpperCase();
                }
                catch (IOException ioe) {
                    System.out.println("ENIGMA> IO Error trying to read command.");
                }
            }
            while (rightRotor.equals(tCommand)) {
                System.out.println("ENIGMA> Rotor is in use. Please use another Rotor.");
                System.out.print("ENIGMA> Command: ");
                try {
                    tCommand = tReader.readLine().toUpperCase();
                }
                catch (IOException ioe) {
                    System.out.println("ENIGMA> IO Error trying to read command.");
                }
            }
            if (tCommand.equals("I") || tCommand.equals("ONE")) {
                middleRotor = "I";
                System.out.println("ENIGMA> Rotor I has been loaded into the middle position of the machine.");
            } else if (tCommand.equals("II") || tCommand.equals("TWO")) {
                middleRotor = "II";
                System.out.println("ENIGMA> Rotor II has been loaded into the middle position of the machine.");
            } else if (tCommand.equals("III") || tCommand.equals("THREE")) {
                middleRotor = "III";
                System.out.println("ENIGMA> Rotor III has been loaded into the middle position of the machine.");
            } else if (tCommand.equals("IV") || tCommand.equals("FOUR")) {
                middleRotor = "IV";
                System.out.println("ENIGMA> Rotor IV has been loaded into the middle position of the machine.");
            } else if (tCommand.equals("V") || tCommand.equals("FIVE")) {
                middleRotor = "V";
                System.out.println("ENIGMA> Rotor V has been loaded into the middle position of the machine.");
            } else if (tCommand.equals("VI") || tCommand.equals("SIX")) {
                middleRotor = "VI";
                System.out.println("ENIGMA> Rotor VI has been loaded into the middle position of the machine.");
            } else if (tCommand.equals("VII") || tCommand.equals("SEVEN")) {
                middleRotor = "VII";
                System.out.println("ENIGMA> Rotor VII has been loaded into the middle position of the machine.");
            } else if (tCommand.equals("VIII") || tCommand.equals("EIGHT")) {
                middleRotor = "VIII";
                System.out.println("ENIGMA> Rotor VIII has been loaded into the middle position of the machine.");
            } else if (tCommand.equals("EXIT")) {
                System.out.println("ENIGMA> Terminal will exit.");
                System.exit(0);
            }
            System.out.println("ENIGMA> Enter Rotor identification code for left position.");
            System.out.print("ENIGMA> Command: ");
            try {
                tCommand = tReader.readLine().toUpperCase();
            }
            catch (IOException ioe) {
                System.out.println("ENIGMA> IO Error trying to read command.");
            }
            while (!(tCommand.equals("I") || tCommand.equals("II") || tCommand.equals("III") || tCommand.equals("IV") || tCommand.equals("V") || tCommand.equals("VI") || tCommand.equals("VII") || tCommand.equals("VIII") || tCommand.equals("ONE") || tCommand.equals("TWO") || tCommand.equals("THREE") || tCommand.equals("FOUR") || tCommand.equals("FIVE") || tCommand.equals("SIX") || tCommand.equals("SEVEN") || tCommand.equals("EIGHT") || tCommand.equals("EXIT"))) {
                System.out.println("ENIGMA> Invalid command.");
                System.out.print("ENIGMA> Command: ");
                try {
                    tCommand = tReader.readLine().toUpperCase();
                }
                catch (IOException ioe) {
                    System.out.println("ENIGMA> IO Error trying to read command.");
                }
            }
            while (rightRotor.equals(tCommand) || middleRotor.equals(tCommand)) {
                System.out.println("ENIGMA> Rotor is in use. Please use another Rotor.");
                System.out.print("ENIGMA> Command: ");
                try {
                    tCommand = tReader.readLine().toUpperCase();
                }
                catch (IOException ioe) {
                    System.out.println("ENIGMA> IO Error trying to read command.");
                }
            }
            if (tCommand.equals("I") || tCommand.equals("ONE")) {
                leftRotor = "I";
                System.out.println("ENIGMA> Rotor I has been loaded into the left position of the machine.");
            } else if (tCommand.equals("II") || tCommand.equals("TWO")) {
                leftRotor = "II";
                System.out.println("ENIGMA> Rotor II has been loaded into the left position of the machine.");
            } else if (tCommand.equals("III") || tCommand.equals("THREE")) {
                leftRotor = "III";
                System.out.println("ENIGMA> Rotor III has been loaded into the left position of the machine.");
            } else if (tCommand.equals("IV") || tCommand.equals("FOUR")) {
                leftRotor = "IV";
                System.out.println("ENIGMA> Rotor IV has been loaded into the left position of the machine.");
            } else if (tCommand.equals("V") || tCommand.equals("FIVE")) {
                leftRotor = "V";
                System.out.println("ENIGMA> Rotor V has been loaded into the left position of the machine.");
            } else if (tCommand.equals("VI") || tCommand.equals("SIX")) {
                leftRotor = "VI";
                System.out.println("ENIGMA> Rotor VI has been loaded into the left position of the machine.");
            } else if (tCommand.equals("VII") || tCommand.equals("SEVEN")) {
                leftRotor = "VII";
                System.out.println("ENIGMA> Rotor VII has been loaded into the left position of the machine.");
            } else if (tCommand.equals("VIII") || tCommand.equals("EIGHT")) {
                leftRotor = "VIII";
                System.out.println("ENIGMA> Rotor VIII has been loaded into the left position of the machine.");
            } else if (tCommand.equals("EXIT")) {
                System.out.println("ENIGMA> Terminal will exit.");
                System.exit(0);
            }
            System.out.println("ENIGMA> Rotors have been loaded into the machine.");
            System.out.println("ENIGMA> Arrangement from left to right: " + leftRotor + " - " + middleRotor + " - " + rightRotor);
            stepMechSetup.setRotors(null, leftRotor, middleRotor, rightRotor);
        } else if (tempType.equals("IS") || tempType.equals("IN")) {
            System.out.println("\n\n");
            System.out.println("    @======================================@");
            System.out.println("    |-----------Rotor--Selection-----------|");
            System.out.println("    @======================================@");
            System.out.println("    | Codes: I    | One                    |");
            System.out.println("    |        II   | Two                    |");
            System.out.println("    |        III  | Three                  |");
            System.out.println("    |        IV   | Four                   |");
            System.out.println("    |        V    | Five                   |");
            System.out.println("    @======================================@");
            System.out.println("\n\n");
            System.out.println("ENIGMA> Select Rotors to be loaded into the machine.");
            System.out.println("ENIGMA> Each position requires a uniquely identifiable Rotor.");
            System.out.println("ENIGMA> Enter Rotor identification code for right position.");
            System.out.print("ENIGMA> Command: ");
            try {
                tCommand = tReader.readLine().toUpperCase();
            }
            catch (IOException ioe) {
                System.out.println("ENIGMA> IO Error trying to read command.");
            }
            while (!(tCommand.equals("I") || tCommand.equals("II") || tCommand.equals("III") || tCommand.equals("IV") || tCommand.equals("V") || tCommand.equals("ONE") || tCommand.equals("TWO") || tCommand.equals("THREE") || tCommand.equals("FOUR") || tCommand.equals("FIVE") || tCommand.equals("EXIT"))) {
                System.out.println("ENIGMA> Invalid command.");
                System.out.print("ENIGMA> Command: ");
                try {
                    tCommand = tReader.readLine().toUpperCase();
                }
                catch (IOException ioe) {
                    System.out.println("ENIGMA> IO Error trying to read command.");
                }
            }
            if (tCommand.equals("I") || tCommand.equals("ONE")) {
                rightRotor = "I";
                System.out.println("ENIGMA> Rotor I has been loaded into the right position of the machine.");
            } else if (tCommand.equals("II") || tCommand.equals("TWO")) {
                rightRotor = "II";
                System.out.println("ENIGMA> Rotor II has been loaded into the right position of the machine.");
            } else if (tCommand.equals("III") || tCommand.equals("THREE")) {
                rightRotor = "III";
                System.out.println("ENIGMA> Rotor III has been loaded into the right position of the machine.");
            } else if (tCommand.equals("IV") || tCommand.equals("FOUR")) {
                rightRotor = "IV";
                System.out.println("ENIGMA> Rotor IV has been loaded into the right position of the machine.");
            } else if (tCommand.equals("V") || tCommand.equals("FIVE")) {
                rightRotor = "V";
                System.out.println("ENIGMA> Rotor V has been loaded into the right position of the machine.");
            } else if (tCommand.equals("EXIT")) {
                System.out.println("ENIGMA> Terminal will exit.");
                System.exit(0);
            }
            System.out.println("ENIGMA> Enter Rotor identification code for middle position.");
            System.out.print("ENIGMA> Command: ");
            try {
                tCommand = tReader.readLine().toUpperCase();
            }
            catch (IOException ioe) {
                System.out.println("ENIGMA> IO Error trying to read command.");
            }
            while (!(tCommand.equals("I") || tCommand.equals("II") || tCommand.equals("III") || tCommand.equals("IV") || tCommand.equals("V") || tCommand.equals("ONE") || tCommand.equals("TWO") || tCommand.equals("THREE") || tCommand.equals("FOUR") || tCommand.equals("FIVE") || tCommand.equals("EXIT"))) {
                System.out.println("ENIGMA> Invalid command.");
                System.out.print("ENIGMA> Command: ");
                try {
                    tCommand = tReader.readLine().toUpperCase();
                }
                catch (IOException ioe) {
                    System.out.println("ENIGMA> IO Error trying to read command.");
                }
            }
            while (rightRotor.equals(tCommand)) {
                System.out.println("ENIGMA> Rotor is in use. Please use another Rotor.");
                System.out.print("ENIGMA> Command: ");
                try {
                    tCommand = tReader.readLine().toUpperCase();
                }
                catch (IOException ioe) {
                    System.out.println("ENIGMA> IO Error trying to read command.");
                }
            }
            if (tCommand.equals("I") || tCommand.equals("ONE")) {
                middleRotor = "I";
                System.out.println("ENIGMA> Rotor I has been loaded into the middle position of the machine.");
            } else if (tCommand.equals("II") || tCommand.equals("TWO")) {
                middleRotor = "II";
                System.out.println("ENIGMA> Rotor II has been loaded into the middle position of the machine.");
            } else if (tCommand.equals("III") || tCommand.equals("THREE")) {
                middleRotor = "III";
                System.out.println("ENIGMA> Rotor III has been loaded into the middle position of the machine.");
            } else if (tCommand.equals("IV") || tCommand.equals("FOUR")) {
                middleRotor = "IV";
                System.out.println("ENIGMA> Rotor IV has been loaded into the middle position of the machine.");
            } else if (tCommand.equals("V") || tCommand.equals("FIVE")) {
                middleRotor = "V";
                System.out.println("ENIGMA> Rotor V has been loaded into the middle position of the machine.");
            } else if (tCommand.equals("EXIT")) {
                System.out.println("ENIGMA> Terminal will exit.");
                System.exit(0);
            }
            System.out.println("ENIGMA> Enter Rotor identification code for left position.");
            System.out.print("ENIGMA> Command: ");
            try {
                tCommand = tReader.readLine().toUpperCase();
            }
            catch (IOException ioe) {
                System.out.println("ENIGMA> IO Error trying to read command.");
            }
            while (!(tCommand.equals("I") || tCommand.equals("II") || tCommand.equals("III") || tCommand.equals("IV") || tCommand.equals("V") || tCommand.equals("ONE") || tCommand.equals("TWO") || tCommand.equals("THREE") || tCommand.equals("FOUR") || tCommand.equals("FIVE") || tCommand.equals("EXIT"))) {
                System.out.println("ENIGMA> Invalid command.");
                System.out.print("ENIGMA> Command: ");
                try {
                    tCommand = tReader.readLine().toUpperCase();
                }
                catch (IOException ioe) {
                    System.out.println("ENIGMA> IO Error trying to read command.");
                }
            }
            while (rightRotor.equals(tCommand) || middleRotor.equals(tCommand)) {
                System.out.println("ENIGMA> Rotor is in use. Please use another Rotor.");
                System.out.print("ENIGMA> Command: ");
                try {
                    tCommand = tReader.readLine().toUpperCase();
                }
                catch (IOException ioe) {
                    System.out.println("ENIGMA> IO Error trying to read command.");
                }
            }
            if (tCommand.equals("I") || tCommand.equals("ONE")) {
                leftRotor = "I";
                System.out.println("ENIGMA> Rotor I has been loaded into the left position of the machine.");
            } else if (tCommand.equals("II") || tCommand.equals("TWO")) {
                leftRotor = "II";
                System.out.println("ENIGMA> Rotor II has been loaded into the left position of the machine.");
            } else if (tCommand.equals("III") || tCommand.equals("THREE")) {
                leftRotor = "III";
                System.out.println("ENIGMA> Rotor III has been loaded into the left position of the machine.");
            } else if (tCommand.equals("IV") || tCommand.equals("FOUR")) {
                leftRotor = "IV";
                System.out.println("ENIGMA> Rotor IV has been loaded into the left position of the machine.");
            } else if (tCommand.equals("V") || tCommand.equals("FIVE")) {
                leftRotor = "V";
                System.out.println("ENIGMA> Rotor V has been loaded into the left position of the machine.");
            } else if (tCommand.equals("EXIT")) {
                System.out.println("ENIGMA> Terminal will exit.");
                System.exit(0);
            }
            System.out.println("ENIGMA> Rotors have been loaded into the machine.");
            System.out.println("ENIGMA> Arrangement from left to right: " + leftRotor + " - " + middleRotor + " - " + rightRotor);
            stepMechSetup.setRotors(null, leftRotor, middleRotor, rightRotor);
        } else if (tempType.equals("G1")) {
            System.out.println("\n\n");
            System.out.println("    @======================================@");
            System.out.println("    |-----------Rotor--Selection-----------|");
            System.out.println("    @======================================@");
            System.out.println("    | Codes: I    | One                    |");
            System.out.println("    |        II   | Two                    |");
            System.out.println("    |        V    | Five                   |");
            System.out.println("    @======================================@");
            System.out.println("\n\n");
            System.out.println("ENIGMA> Select Rotors to be loaded into the machine.");
            System.out.println("ENIGMA> Each position requires a uniquely identifiable Rotor.");
            System.out.println("ENIGMA> Enter Rotor identification code for right position.");
            System.out.print("ENIGMA> Command: ");
            try {
                tCommand = tReader.readLine().toUpperCase();
            }
            catch (IOException ioe) {
                System.out.println("ENIGMA> IO Error trying to read command.");
            }
            while (!((tCommand.equals("I") || tCommand.equals("II") || tCommand.equals("V") || tCommand.equals("ONE") || tCommand.equals("TWO") || tCommand.equals("FIVE")) && !tCommand.equals("EXIT"))) {
                System.out.println("ENIGMA> Invalid command.");
                System.out.print("ENIGMA> Command: ");
                try {
                    tCommand = tReader.readLine().toUpperCase();
                }
                catch (IOException ioe) {
                    System.out.println("ENIGMA> IO Error trying to read command.");
                }
            }
            if (tCommand.equals("I") || tCommand.equals("ONE")) {
                rightRotor = "I";
                System.out.println("ENIGMA> Rotor I has been loaded into the right position of the machine.");
            } else if (tCommand.equals("II") || tCommand.equals("TWO")) {
                rightRotor = "II";
                System.out.println("ENIGMA> Rotor II has been loaded into the right position of the machine.");
            } else if (tCommand.equals("V") || tCommand.equals("FIVE")) {
                rightRotor = "V";
                System.out.println("ENIGMA> Rotor V has been loaded into the right position of the machine.");
            } else if (tCommand.equals("EXIT")) {
                System.out.println("ENIGMA> Terminal will exit.");
                System.exit(0);
            }
            System.out.println("ENIGMA> Enter Rotor identification code for middle position.");
            System.out.print("ENIGMA> Command: ");
            try {
                tCommand = tReader.readLine().toUpperCase();
            }
            catch (IOException ioe) {
                System.out.println("ENIGMA> IO Error trying to read command.");
            }
            while (!(tCommand.equals("I") || tCommand.equals("II") || tCommand.equals("V") || tCommand.equals("ONE") || tCommand.equals("TWO") || tCommand.equals("FIVE") || tCommand.equals("EXIT"))) {
                System.out.println("ENIGMA> Invalid command.");
                System.out.print("ENIGMA> Command: ");
                try {
                    tCommand = tReader.readLine().toUpperCase();
                }
                catch (IOException ioe) {
                    System.out.println("ENIGMA> IO Error trying to read command.");
                }
            }
            while (rightRotor.equals(tCommand)) {
                System.out.println("ENIGMA> Rotor is in use. Please use another Rotor.");
                System.out.print("ENIGMA> Command: ");
                try {
                    tCommand = tReader.readLine().toUpperCase();
                }
                catch (IOException ioe) {
                    System.out.println("ENIGMA> IO Error trying to read command.");
                }
            }
            if (tCommand.equals("I") || tCommand.equals("ONE")) {
                middleRotor = "I";
                System.out.println("ENIGMA> Rotor I has been loaded into the middle position of the machine.");
            } else if (tCommand.equals("II") || tCommand.equals("TWO")) {
                middleRotor = "II";
                System.out.println("ENIGMA> Rotor II has been loaded into the middle position of the machine.");
            } else if (tCommand.equals("V") || tCommand.equals("FIVE")) {
                middleRotor = "V";
                System.out.println("ENIGMA> Rotor V has been loaded into the middle position of the machine.");
            } else if (tCommand.equals("EXIT")) {
                System.out.println("ENIGMA> Terminal will exit.");
                System.exit(0);
            }
            System.out.println("ENIGMA> Enter Rotor identification code for left position.");
            System.out.print("ENIGMA> Command: ");
            try {
                tCommand = tReader.readLine().toUpperCase();
            }
            catch (IOException ioe) {
                System.out.println("ENIGMA> IO Error trying to read command.");
            }
            while (!(tCommand.equals("I") || tCommand.equals("II") || tCommand.equals("V") || tCommand.equals("ONE") || tCommand.equals("TWO") || tCommand.equals("FIVE") || tCommand.equals("EXIT"))) {
                System.out.println("ENIGMA> Invalid command.");
                System.out.print("ENIGMA> Command: ");
                try {
                    tCommand = tReader.readLine().toUpperCase();
                }
                catch (IOException ioe) {
                    System.out.println("ENIGMA> IO Error trying to read command.");
                }
            }
            while (rightRotor.equals(tCommand) || middleRotor.equals(tCommand)) {
                System.out.println("ENIGMA> Rotor is in use. Please use another Rotor.");
                System.out.print("ENIGMA> Command: ");
                try {
                    tCommand = tReader.readLine().toUpperCase();
                }
                catch (IOException ioe) {
                    System.out.println("ENIGMA> IO Error trying to read command.");
                }
            }
            if (tCommand.equals("I") || tCommand.equals("ONE")) {
                leftRotor = "I";
                System.out.println("ENIGMA> Rotor I has been loaded into the left position of the machine.");
            } else if (tCommand.equals("II") || tCommand.equals("TWO")) {
                leftRotor = "II";
                System.out.println("ENIGMA> Rotor II has been loaded into the left position of the machine.");
            } else if (tCommand.equals("V") || tCommand.equals("FIVE")) {
                leftRotor = "V";
                System.out.println("ENIGMA> Rotor V has been loaded into the left position of the machine.");
            } else if (tCommand.equals("EXIT")) {
                System.out.println("ENIGMA> Terminal will exit.");
                System.exit(0);
            }
            System.out.println("ENIGMA> Rotors have been loaded into the machine.");
            System.out.println("ENIGMA> Arrangement from left to right: " + leftRotor + " - " + middleRotor + " - " + rightRotor);
            stepMechSetup.setRotors(null, leftRotor, middleRotor, rightRotor);
        } else if (tempType.equals("IM4")) {
            System.out.println("\n\n");
            System.out.println("    @======================================@");
            System.out.println("    |--------Extra--Rotor--Selection-------|");
            System.out.println("    @======================================@");
            System.out.println("    | Codes: B    | Beta                   |");
            System.out.println("    |        G    | Gamma                  |");
            System.out.println("    @======================================@");
            System.out.println("\n\n");
            System.out.println("ENIGMA> Select Rotors to be loaded into the machine.");
            System.out.println("ENIGMA> Each position requires a uniquely identifiable Rotor.");
            System.out.println("ENIGMA> Enigma M4 requires a fourth extra Rotor.");
            System.out.println("ENIGMA> Enter extra Rotor identification code for the far left position.");
            System.out.print("ENIGMA> Command: ");
            try {
                tCommand = tReader.readLine().toUpperCase();
            }
            catch (IOException ioe) {
                System.out.println("ENIGMA> IO Error trying to read command.");
            }
            while (!(tCommand.equals("B") || tCommand.equals("G") || tCommand.equals("BETA") || tCommand.equals("GAMMA") || tCommand.equals("EXIT"))) {
                System.out.println("ENIGMA> Invalid command.");
                System.out.print("ENIGMA> Command: ");
                try {
                    tCommand = tReader.readLine().toUpperCase();
                }
                catch (IOException ioe) {
                    System.out.println("ENIGMA> IO Error trying to read command.");
                }
            }
            if (tCommand.equals("B") || tCommand.equals("BETA")) {
                extraRotor = "BETA";
                System.out.println("ENIGMA> Beta Rotor has been loaded into the far left position of the machine.");
            } else if (tCommand.equals("G") || tCommand.equals("GAMMA")) {
                extraRotor = "GAMMA";
                System.out.println("ENIGMA> Gamma Rotor has been loaded into the far left position of the machine.");
            } else if (tCommand.equals("EXIT")) {
                System.out.println("ENIGMA> Terminal will exit.");
                System.exit(0);
            }
            System.out.println("\n\n");
            System.out.println("    @======================================@");
            System.out.println("    |-----------Rotor--Selection-----------|");
            System.out.println("    @======================================@");
            System.out.println("    | Codes: I    | One                    |");
            System.out.println("    |        II   | Two                    |");
            System.out.println("    |        III  | Three                  |");
            System.out.println("    |        IV   | Four                   |");
            System.out.println("    |        V    | Five                   |");
            System.out.println("    |        VI   | Six                    |");
            System.out.println("    |        VII  | Seven                  |");
            System.out.println("    |        VIII | Eight                  |");
            System.out.println("    @======================================@");
            System.out.println("\n\n");
            System.out.println("ENIGMA> Select Rotors to be loaded into the machine.");
            System.out.println("ENIGMA> Each position requires a uniquely identifiable Rotor.");
            System.out.println("ENIGMA> Enter Rotor identification code for right position.");
            System.out.print("ENIGMA> Command: ");
            try {
                tCommand = tReader.readLine().toUpperCase();
            }
            catch (IOException ioe) {
                System.out.println("ENIGMA> IO Error trying to read command.");
            }
            while (!(tCommand.equals("I") || tCommand.equals("II") || tCommand.equals("III") || tCommand.equals("IV") || tCommand.equals("V") || tCommand.equals("VI") || tCommand.equals("VII") || tCommand.equals("VIII") || tCommand.equals("ONE") || tCommand.equals("TWO") || tCommand.equals("THREE") || tCommand.equals("FOUR") || tCommand.equals("FIVE") || tCommand.equals("SIX") || tCommand.equals("SEVEN") || tCommand.equals("EIGHT") || tCommand.equals("EXIT"))) {
                System.out.println("ENIGMA> Invalid command.");
                System.out.print("ENIGMA> Command: ");
                try {
                    tCommand = tReader.readLine().toUpperCase();
                }
                catch (IOException ioe) {
                    System.out.println("ENIGMA> IO Error trying to read command.");
                }
            }
            if (tCommand.equals("I") || tCommand.equals("ONE")) {
                rightRotor = "I";
                System.out.println("ENIGMA> Rotor I has been loaded into the right position of the machine.");
            } else if (tCommand.equals("II") || tCommand.equals("TWO")) {
                rightRotor = "II";
                System.out.println("ENIGMA> Rotor II has been loaded into the right position of the machine.");
            } else if (tCommand.equals("III") || tCommand.equals("THREE")) {
                rightRotor = "III";
                System.out.println("ENIGMA> Rotor III has been loaded into the right position of the machine.");
            } else if (tCommand.equals("IV") || tCommand.equals("FOUR")) {
                rightRotor = "IV";
                System.out.println("ENIGMA> Rotor IV has been loaded into the right position of the machine.");
            } else if (tCommand.equals("V") || tCommand.equals("FIVE")) {
                rightRotor = "V";
                System.out.println("ENIGMA> Rotor V has been loaded into the right position of the machine.");
            } else if (tCommand.equals("VI") || tCommand.equals("SIX")) {
                rightRotor = "VI";
                System.out.println("ENIGMA> Rotor VI has been loaded into the right position of the machine.");
            } else if (tCommand.equals("VII") || tCommand.equals("SEVEN")) {
                rightRotor = "VII";
                System.out.println("ENIGMA> Rotor VII has been loaded into the right position of the machine.");
            } else if (tCommand.equals("VIII") || tCommand.equals("EIGHT")) {
                rightRotor = "VIII";
                System.out.println("ENIGMA> Rotor VIII has been loaded into the right position of the machine.");
            } else if (tCommand.equals("EXIT")) {
                System.out.println("ENIGMA> Terminal will exit.");
                System.exit(0);
            }
            System.out.println("ENIGMA> Enter Rotor identification code for middle position.");
            System.out.print("ENIGMA> Command: ");
            try {
                tCommand = tReader.readLine().toUpperCase();
            }
            catch (IOException ioe) {
                System.out.println("ENIGMA> IO Error trying to read command.");
            }
            while (!(tCommand.equals("I") || tCommand.equals("II") || tCommand.equals("III") || tCommand.equals("IV") || tCommand.equals("V") || tCommand.equals("VI") || tCommand.equals("VII") || tCommand.equals("VIII") || tCommand.equals("ONE") || tCommand.equals("TWO") || tCommand.equals("THREE") || tCommand.equals("FOUR") || tCommand.equals("FIVE") || tCommand.equals("SIX") || tCommand.equals("SEVEN") || tCommand.equals("EIGHT") || tCommand.equals("EXIT"))) {
                System.out.println("ENIGMA> Invalid command.");
                System.out.print("ENIGMA> Command: ");
                try {
                    tCommand = tReader.readLine().toUpperCase();
                }
                catch (IOException ioe) {
                    System.out.println("ENIGMA> IO Error trying to read command.");
                }
            }
            while (rightRotor.equals(tCommand)) {
                System.out.println("ENIGMA> Rotor is in use. Please use another Rotor.");
                System.out.print("ENIGMA> Command: ");
                try {
                    tCommand = tReader.readLine().toUpperCase();
                }
                catch (IOException ioe) {
                    System.out.println("ENIGMA> IO Error trying to read command.");
                }
            }
            if (tCommand.equals("I") || tCommand.equals("ONE")) {
                middleRotor = "I";
                System.out.println("ENIGMA> Rotor I has been loaded into the middle position of the machine.");
            } else if (tCommand.equals("II") || tCommand.equals("TWO")) {
                middleRotor = "II";
                System.out.println("ENIGMA> Rotor II has been loaded into the middle position of the machine.");
            } else if (tCommand.equals("III") || tCommand.equals("THREE")) {
                middleRotor = "III";
                System.out.println("ENIGMA> Rotor III has been loaded into the middle position of the machine.");
            } else if (tCommand.equals("IV") || tCommand.equals("FOUR")) {
                middleRotor = "IV";
                System.out.println("ENIGMA> Rotor IV has been loaded into the middle position of the machine.");
            } else if (tCommand.equals("V") || tCommand.equals("FIVE")) {
                middleRotor = "V";
                System.out.println("ENIGMA> Rotor V has been loaded into the middle position of the machine.");
            } else if (tCommand.equals("VI") || tCommand.equals("SIX")) {
                middleRotor = "VI";
                System.out.println("ENIGMA> Rotor VI has been loaded into the middle position of the machine.");
            } else if (tCommand.equals("VII") || tCommand.equals("SEVEN")) {
                middleRotor = "VII";
                System.out.println("ENIGMA> Rotor VII has been loaded into the middle position of the machine.");
            } else if (tCommand.equals("VIII") || tCommand.equals("EIGHT")) {
                middleRotor = "VIII";
                System.out.println("ENIGMA> Rotor VIII has been loaded into the middle position of the machine.");
            } else if (tCommand.equals("EXIT")) {
                System.out.println("ENIGMA> Terminal will exit.");
                System.exit(0);
            }
            System.out.println("ENIGMA> Enter Rotor identification code for left position.");
            System.out.print("ENIGMA> Command: ");
            try {
                tCommand = tReader.readLine().toUpperCase();
            }
            catch (IOException ioe) {
                System.out.println("ENIGMA> IO Error trying to read command.");
            }
            while (!(tCommand.equals("I") || tCommand.equals("II") || tCommand.equals("III") || tCommand.equals("IV") || tCommand.equals("V") || tCommand.equals("VI") || tCommand.equals("VII") || tCommand.equals("VIII") || tCommand.equals("ONE") || tCommand.equals("TWO") || tCommand.equals("THREE") || tCommand.equals("FOUR") || tCommand.equals("FIVE") || tCommand.equals("SIX") || tCommand.equals("SEVEN") || tCommand.equals("EIGHT") || tCommand.equals("EXIT"))) {
                System.out.println("ENIGMA> Invalid command.");
                System.out.print("ENIGMA> Command: ");
                try {
                    tCommand = tReader.readLine().toUpperCase();
                }
                catch (IOException ioe) {
                    System.out.println("ENIGMA> IO Error trying to read command.");
                }
            }
            while (rightRotor.equals(tCommand) || middleRotor.equals(tCommand)) {
                System.out.println("ENIGMA> Rotor is in use. Please use another Rotor.");
                System.out.print("ENIGMA> Command: ");
                try {
                    tCommand = tReader.readLine().toUpperCase();
                }
                catch (IOException ioe) {
                    System.out.println("ENIGMA> IO Error trying to read command.");
                }
            }
            if (tCommand.equals("I") || tCommand.equals("ONE")) {
                leftRotor = "I";
                System.out.println("ENIGMA> Rotor I has been loaded into the left position of the machine.");
            } else if (tCommand.equals("II") || tCommand.equals("TWO")) {
                leftRotor = "II";
                System.out.println("ENIGMA> Rotor II has been loaded into the left position of the machine.");
            } else if (tCommand.equals("III") || tCommand.equals("THREE")) {
                leftRotor = "III";
                System.out.println("ENIGMA> Rotor III has been loaded into the left position of the machine.");
            } else if (tCommand.equals("IV") || tCommand.equals("FOUR")) {
                leftRotor = "IV";
                System.out.println("ENIGMA> Rotor IV has been loaded into the left position of the machine.");
            } else if (tCommand.equals("V") || tCommand.equals("FIVE")) {
                leftRotor = "V";
                System.out.println("ENIGMA> Rotor V has been loaded into the left position of the machine.");
            } else if (tCommand.equals("VI") || tCommand.equals("SIX")) {
                leftRotor = "VI";
                System.out.println("ENIGMA> Rotor VI has been loaded into the left position of the machine.");
            } else if (tCommand.equals("VII") || tCommand.equals("SEVEN")) {
                leftRotor = "VII";
                System.out.println("ENIGMA> Rotor VII has been loaded into the left position of the machine.");
            } else if (tCommand.equals("VIII") || tCommand.equals("EIGHT")) {
                leftRotor = "VIII";
                System.out.println("ENIGMA> Rotor VIII has been loaded into the left position of the machine.");
            } else if (tCommand.equals("EXIT")) {
                System.out.println("ENIGMA> Terminal will exit.");
                System.exit(0);
            }
            System.out.println("ENIGMA> Rotors have been loaded into the machine.");
            System.out.println("ENIGMA> Arrangement from left to right: " + extraRotor + " - " + leftRotor + " - " + middleRotor + " - " + rightRotor);
            stepMechSetup.setRotors(extraRotor, leftRotor, middleRotor, rightRotor);
        }
        System.out.println("ENIGMA> Would you like to alter the Offset of the Rotors? yes/no");
        System.out.print("ENIGMA> Command: ");
        try {
            tCommand = tReader.readLine().toUpperCase();
        }
        catch (IOException ioe) {
            System.out.println("ENIGMA> IO Error trying to read command.");
        }
        while (!(tCommand.equals("YES") || tCommand.equals("Y") || tCommand.equals("NO") || tCommand.equals("N") || tCommand.equals("EXIT"))) {
            System.out.println("ENIGMA> Invalid command.");
            System.out.print("ENIGMA> Command: ");
            try {
                tCommand = tReader.readLine().toUpperCase();
            }
            catch (IOException ioe) {
                System.out.println("ENIGMA> IO Error trying to read command.");
            }
        }
        if (tCommand.equals("Y") || tCommand.equals("YES")) {
            System.out.println("ENIGMA> Offset position ranges from A to Z.");
            System.out.println("ENIGMA> Enter Offset for the right Rotor.");
            System.out.print("ENIGMA> Command: ");
            try {
                tCommand = tReader.readLine().toUpperCase();
            }
            catch (IOException ioe) {
                System.out.println("ENIGMA> IO Error trying to read command.");
            }
            while (tCommand.length() != 1 && !tCommand.equals("EXIT") || tCommand.matches(".*\\d.*")) {
                System.out.println("ENIGMA> Invalid command.");
                System.out.print("ENIGMA> Command: ");
                try {
                    tCommand = tReader.readLine().toUpperCase();
                }
                catch (IOException ioe) {
                    System.out.println("ENIGMA> IO Error trying to read command.");
                }
            }
            if (tCommand.length() == 1) {
                tCommand = tCommand.trim().replaceAll("\\P{L}+", "");
                stepMechSetup.setRotorOffset("RIGHT", tCommand);
                System.out.println("ENIGMA> Offset of right Rotor has been set to: " + tCommand);
            } else if (tCommand.equals("EXIT")) {
                System.out.println("ENIGMA> Terminal will exit.");
                System.exit(0);
            }
            System.out.println("ENIGMA> Offset position ranges from A to Z.");
            System.out.println("ENIGMA> Enter Offset for the middle Rotor.");
            System.out.print("ENIGMA> Command: ");
            try {
                tCommand = tReader.readLine().toUpperCase();
            }
            catch (IOException ioe) {
                System.out.println("ENIGMA> IO Error trying to read command.");
            }
            while (tCommand.length() != 1 && !tCommand.equals("EXIT") || tCommand.matches(".*\\d.*")) {
                System.out.println("ENIGMA> Invalid command.");
                System.out.print("ENIGMA> Command: ");
                try {
                    tCommand = tReader.readLine().toUpperCase();
                }
                catch (IOException ioe) {
                    System.out.println("ENIGMA> IO Error trying to read command.");
                }
            }
            if (tCommand.length() == 1) {
                tCommand = tCommand.trim().replaceAll("\\P{L}+", "");
                stepMechSetup.setRotorOffset("MIDDLE", tCommand);
                System.out.println("ENIGMA> Offset of middle Rotor has been set to: " + tCommand);
            } else if (tCommand.equals("EXIT")) {
                System.out.println("ENIGMA> Terminal will exit.");
                System.exit(0);
            }
            System.out.println("ENIGMA> Offset position ranges from A to Z.");
            System.out.println("ENIGMA> Enter Offset for the left Rotor.");
            System.out.print("ENIGMA> Command: ");
            try {
                tCommand = tReader.readLine().toUpperCase();
            }
            catch (IOException ioe) {
                System.out.println("ENIGMA> IO Error trying to read command.");
            }
            while (tCommand.length() != 1 && !tCommand.equals("EXIT") || tCommand.matches(".*\\d.*")) {
                System.out.println("ENIGMA> Invalid command.");
                System.out.print("ENIGMA> Command: ");
                try {
                    tCommand = tReader.readLine().toUpperCase();
                }
                catch (IOException ioe) {
                    System.out.println("ENIGMA> IO Error trying to read command.");
                }
            }
            if (tCommand.length() == 1) {
                tCommand = tCommand.trim().replaceAll("\\P{L}+", "");
                stepMechSetup.setRotorOffset("LEFT", tCommand);
                System.out.println("ENIGMA> Offset for left Rotor has been set to: " + tCommand);
            } else if (tCommand.equals("EXIT")) {
                System.out.println("ENIGMA> Terminal will exit.");
                System.exit(0);
            }
            if (stepMechSetup.getType().equals("IM4")) {
                System.out.println("ENIGMA> Offset position ranges from A to Z.");
                System.out.println("ENIGMA> Enter Offset for the extra Rotor.");
                System.out.print("ENIGMA> Command: ");
                try {
                    tCommand = tReader.readLine().toUpperCase();
                }
                catch (IOException ioe) {
                    System.out.println("ENIGMA> IO Error trying to read command.");
                }
                while (tCommand.length() != 1 && !tCommand.equals("EXIT") || tCommand.matches(".*\\d.*")) {
                    System.out.println("ENIGMA> Invalid command.");
                    System.out.print("ENIGMA> Command: ");
                    try {
                        tCommand = tReader.readLine().toUpperCase();
                    }
                    catch (IOException ioe) {
                        System.out.println("ENIGMA> IO Error trying to read command.");
                    }
                }
                if (tCommand.length() == 1) {
                    tCommand = tCommand.trim().replaceAll("\\P{L}+", "");
                    stepMechSetup.setRotorOffset("EXTRA", tCommand);
                    System.out.println("ENIGMA> Offset of extra Rotor has been set to: " + tCommand);
                } else if (tCommand.equals("EXIT")) {
                    System.out.println("ENIGMA> Terminal will exit.");
                    System.exit(0);
                }
            }
        } else if (tCommand.equals("EXIT")) {
            System.out.println("ENIGMA> Terminal will exit.");
            System.exit(0);
        }
        System.out.println("ENIGMA> Would you like to alter the starting position of the rotors? yes/no");
        System.out.print("ENIGMA> Command: ");
        try {
            tCommand = tReader.readLine().toUpperCase();
        }
        catch (IOException ioe) {
            System.out.println("ENIGMA> I/O Error trying to read your command.");
        }
        while (!(tCommand.equals("Y") || tCommand.equals("N") || tCommand.equals("YES") || tCommand.equals("NO") || tCommand.equals("EXIT"))) {
            System.out.println("ENIGMA> Invalid command.");
            System.out.print("ENIGMA> Command: ");
            try {
                tCommand = tReader.readLine().toUpperCase();
            }
            catch (IOException ioe) {
                System.out.println("ENIGMA> I/O Error trying to read your command.");
            }
        }
        if (tCommand.equals("Y") || tCommand.equals("YES")) {
            System.out.println("ENIGMA> Index position ranges from A to Z.");
            System.out.println("ENIGMA> Enter index for the right Rotor.");
            System.out.print("ENIGMA> Command: ");
            try {
                tCommand = tReader.readLine().toUpperCase();
            }
            catch (IOException ioe) {
                System.out.println("ENIGMA> IO Error trying to read command.");
            }
            while (tCommand.length() != 1 && !tCommand.equals("EXIT") || tCommand.matches(".*\\d.*")) {
                System.out.println("ENIGMA> Invalid command.");
                System.out.print("ENIGMA> Command: ");
                try {
                    tCommand = tReader.readLine().toUpperCase();
                }
                catch (IOException ioe) {
                    System.out.println("ENIGMA> IO Error trying to read command.");
                }
            }
            if (tCommand.length() == 1) {
                tCommand = tCommand.trim().replaceAll("\\P{L}+", "");
                stepMechSetup.setRotorIndex("RIGHT", tCommand);
                System.out.println("ENIGMA> Index of right Rotor has been set to: " + tCommand);
            } else if (tCommand.equals("EXIT")) {
                System.out.println("ENIGMA> Terminal will exit.");
                System.exit(0);
            }
            System.out.println("ENIGMA> Index position ranges from A to Z.");
            System.out.println("ENIGMA> Enter index for the middle Rotor.");
            System.out.print("ENIGMA> Command: ");
            try {
                tCommand = tReader.readLine().toUpperCase();
            }
            catch (IOException ioe) {
                System.out.println("ENIGMA> IO Error trying to read command.");
            }
            while (tCommand.length() != 1 && !tCommand.equals("EXIT") || tCommand.matches(".*\\d.*")) {
                System.out.println("ENIGMA> Invalid command.");
                System.out.print("ENIGMA> Command: ");
                try {
                    tCommand = tReader.readLine().toUpperCase();
                }
                catch (IOException ioe) {
                    System.out.println("ENIGMA> IO Error trying to read command.");
                }
            }
            if (tCommand.length() == 1) {
                tCommand = tCommand.trim().replaceAll("\\P{L}+", "");
                stepMechSetup.setRotorIndex("MIDDLE", tCommand);
                System.out.println("ENIGMA> Index of middle Rotor has been set to: " + tCommand);
            } else if (tCommand.equals("EXIT")) {
                System.out.println("ENIGMA> Terminal will exit.");
                System.exit(0);
            }
            System.out.println("ENIGMA> Index position ranges from A to Z.");
            System.out.println("ENIGMA> Enter index for the left Rotor.");
            System.out.print("ENIGMA> Command: ");
            try {
                tCommand = tReader.readLine().toUpperCase();
            }
            catch (IOException ioe) {
                System.out.println("ENIGMA> IO Error trying to read command.");
            }
            while (tCommand.length() != 1 && !tCommand.equals("EXIT") || tCommand.matches(".*\\d.*")) {
                System.out.println("ENIGMA> Invalid command.");
                System.out.print("ENIGMA> Command: ");
                try {
                    tCommand = tReader.readLine().toUpperCase();
                }
                catch (IOException ioe) {
                    System.out.println("ENIGMA> IO Error trying to read command.");
                }
            }
            if (tCommand.length() == 1) {
                tCommand = tCommand.trim().replaceAll("\\P{L}+", "");
                stepMechSetup.setRotorIndex("LEFT", tCommand);
                System.out.println("ENIGMA> Index of left Rotor has been set to: " + tCommand);
            } else if (tCommand.equals("EXIT")) {
                System.out.println("ENIGMA> Terminal will exit.");
                System.exit(0);
            }
            if (stepMechSetup.getType().equals("IM4")) {
                System.out.println("ENIGMA> Index position ranges from A to Z.");
                System.out.println("ENIGMA> Enter index for the extra Rotor.");
                System.out.print("ENIGMA> Command: ");
                try {
                    tCommand = tReader.readLine().toUpperCase();
                }
                catch (IOException ioe) {
                    System.out.println("ENIGMA> IO Error trying to read command.");
                }
                while (tCommand.length() != 1 && !tCommand.equals("EXIT") || tCommand.matches(".*\\d.*")) {
                    System.out.println("ENIGMA> Invalid command.");
                    System.out.print("ENIGMA> Command: ");
                    try {
                        tCommand = tReader.readLine().toUpperCase();
                    }
                    catch (IOException ioe) {
                        System.out.println("ENIGMA> IO Error trying to read command.");
                    }
                }
                if (tCommand.length() == 1) {
                    tCommand = tCommand.trim().replaceAll("\\P{L}+", "");
                    stepMechSetup.setRotorIndex("EXTRA", tCommand);
                    System.out.println("ENIGMA> Index of extra Rotor has been set to: " + tCommand);
                } else if (tCommand.equals("EXIT")) {
                    System.out.println("ENIGMA> Terminal will exit.");
                    System.exit(0);
                }
            }
        } else if (tCommand.equals("EXIT")) {
            System.out.println("ENIGMA> Terminal will exit.");
            System.exit(0);
        }
        try {
            tReader.reset();
            tReader.close();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        stepMechComplete = stepMechSetup;
        System.out.println("ENIGMA> Machine configuration has been completed.");
        System.out.println("ENIGMA> The machine key is presented below.");
        System.out.println("\n\n");
        System.out.println("@=========================================>");
        System.out.println("|Machine: " + CryptoTerminal.machineType(stepMechComplete.getType()));
        System.out.println("|Reflector: " + CryptoTerminal.reflectorType(stepMechComplete.getReflectorType()));
        System.out.println("|Extra Rotor: " + stepMechComplete.getRotorType("EXTRA") + " |");
        System.out.println("|Left Rotor: " + stepMechComplete.getRotorType("LEFT") + " |");
        System.out.println("|Middle Rotor: " + stepMechComplete.getRotorType("MIDDLE") + " |");
        System.out.println("|Right Rotor: " + stepMechComplete.getRotorType("Right") + " |");
        System.out.println("@=========================================>");
        System.out.println("|Offsets: " + CryptoTerminal.offsetArrangement());
        System.out.println("@=========================================>");
        System.out.println("\n\n");
        System.out.println("ENIGMA> Welcome to the Public Enigma Simulator.");
        System.out.println("ENIGMA> Stepping Mechanism is entering Analytical Mode.");
        System.out.println("ENIGMA> Redirecting to Terminal Menu.");
        CryptoTerminal.menu();
    }

    private static void menu() {
        System.out.println("\n\n");
        System.out.println("    @=========================================@");
        System.out.println("    |-------------Terminal---Menu-------------|");
        System.out.println("    @=========================================@");
        System.out.println("    | Codes: A | Simulation                   |");
        System.out.println("    |        B | Hyper Analytical Simulation  |");
        System.out.println("    |        C | Test | Stepping Procedure    |");
        System.out.println("    |        D | Test | Rotor Examination     |");
        System.out.println("    @=========================================@");
        System.out.println("    | Special Commands:                       |");
        System.out.println("    @=========================================@");
        System.out.println("    |     | Menu | Print | Reset | Exit |     |");
        System.out.println("    @=========================================@");
        System.out.println("\n\n");
        BufferedReader mReader = new BufferedReader(new InputStreamReader(System.in));
        String mCommand = "";
        System.out.print("ENIGMA> Command: ");
        try {
            mCommand = mReader.readLine().toUpperCase();
        }
        catch (IOException ioe) {
            System.out.println("ENIGMA>  IO Error trying to read command.");
        }
        while (!(mCommand.equals("A") || mCommand.equals("B") || mCommand.equals("C") || mCommand.equals("D") || mCommand.equals("EXIT"))) {
            System.out.println("ENIGMA> Invalid command.");
            System.out.print("ENIGMA> Command: ");
            try {
                mCommand = mReader.readLine().toUpperCase();
            }
            catch (IOException ioe) {
                System.out.println("ENIGMA> IO Error trying to read command.");
            }
        }
        switch (mCommand.toUpperCase()) {
            case "A": {
                CryptoTerminal.simulation();
                break;
            }
            case "B": {
                CryptoTerminal.analyticalSimulation();
                break;
            }
            case "C": {
                CryptoTerminal.steppingTest();
                break;
            }
            case "D": {
                CryptoTerminal.rotationTest();
                break;
            }
            case "E": {
                CryptoTerminal.endurance_performanceTest();
                break;
            }
            case "EXIT": {
                System.out.println("ENIGMA> Terminal will exit.");
                System.exit(0);
            }
        }
    }

    private static void simulation() {
        stepMechComplete.setAnalytical(false);
        System.out.println("ENIGMA> Simulation mode selected.");
        System.out.println("ENIGMA> Analytical Mode will be temporarily turned off.");
        System.out.println("ENIGMA> This is a command-only simulation of the Enigma Machine.");
        System.out.println("ENIGMA> Enter any character to see its cryptographic equivalent.");
        System.out.println("ENIGMA> Special commands are also available in this mode.");
        System.out.println("ENIGMA> Enter \"Info\" to view special commans list.");
        System.out.println("ENIGMA> Initialising...");
        boolean esc = false;
        while (!esc) {
            System.out.print("ENIGMA|SIM> Command: ");
            BufferedReader sReader = new BufferedReader(new InputStreamReader(System.in));
            String sCommand = null;
            try {
                sCommand = sReader.readLine().toUpperCase();
            }
            catch (IOException ioe) {
                System.out.println("ENIGMA|SIM> IO Error trying to read command.");
            }
            while (sCommand.length() != 1 && !sCommand.equals("EXIT") && !sCommand.equals("RESET") && !sCommand.equals("MENU") && !sCommand.equals("PRINT") && !sCommand.equals("INFO") || sCommand.matches(".*\\d.*")) {
                System.out.println("ENIGMA|SIM> Invalid command.");
                System.out.print("ENIGMA|SIM> Command: ");
                try {
                    sCommand = sReader.readLine().toUpperCase();
                }
                catch (IOException ioe) {
                    System.out.println("ENIGMA|SIM> IO Error trying to read command.");
                }
            }
            if (sCommand.length() == 1) {
                sCommand = sCommand.trim().replaceAll("\\P{L}+", "");
                stepMechComplete.step();
                char sCommandChar = sCommand.charAt(0);
                System.out.println("ENIGMA|SIM> Plain: " + sCommandChar + " | Cipher: " + stepMechComplete.encipher(sCommandChar));
                continue;
            }
            if (sCommand.equals("MENU")) {
                System.out.println("ENIGMA|SIM> Menu Redirection has not yet been implemented.");
                continue;
            }
            if (sCommand.equals("RESET")) {
                System.out.println("ENIGMA|SIM> Machine Reset has not yet been implemented.");
                continue;
            }
            if (sCommand.equals("PRINT")) {
                System.out.println("ENIGMA|SIM> Terminal Print has not yet been implemented.");
                continue;
            }
            if (sCommand.equals("INFO")) {
                System.out.println("\n\n");
                System.out.println("    @=========================================@");
                System.out.println("    | Special Commands:                       |");
                System.out.println("    @=========================================@");
                System.out.println("    |     | Menu | Print | Reset | Exit |     |");
                System.out.println("    @=========================================@");
                System.out.println("\n\n");
                continue;
            }
            if (!sCommand.equals("EXIT")) continue;
            esc = true;
        }
    }

    private static void analyticalSimulation() {
        stepMechComplete.setAnalytical(true);
        System.out.println("ENIGMA> Hyper Analytical Simulation mode selected.");
        System.out.println("ENIGMA> This is an analytical step-by-step simulation of the Enigma Machine.");
        System.out.println("ENIGMA> Every action of the cryptographic process will be shown.");
        System.out.println("ENIGMA> Enter any character to see its cryptographic equivalent.");
        System.out.println("ENIGMA> Special commands are also available in this mode.");
        System.out.println("ENIGMA> Enter \"Info\" to view special commans list.");
        System.out.println("ENIGMA> Initialising...");
        boolean esc = false;
        while (!esc) {
            System.out.print("ENIGMA|ANLTC|SIM> Command: ");
            BufferedReader sReader = new BufferedReader(new InputStreamReader(System.in));
            String sCommand = null;
            try {
                sCommand = sReader.readLine().toUpperCase();
            }
            catch (IOException ioe) {
                System.out.println("ENIGMA|ANLTC|SIM> IO Error trying to read command.");
            }
            while (sCommand.length() != 1 && !sCommand.equals("EXIT") && !sCommand.equals("RESET") && !sCommand.equals("MENU") && !sCommand.equals("PRINT") && !sCommand.equals("INFO") || sCommand.matches(".*\\d.*")) {
                System.out.println("ENIGMA|ANLTC|SIM> Invalid command.");
                System.out.print("ENIGMA|ANLTC|SIM> Command: ");
                try {
                    sCommand = sReader.readLine().toUpperCase();
                }
                catch (IOException ioe) {
                    System.out.println("ENIGMA|ANLTC|SIM> IO Error trying to read command.");
                }
            }
            if (sCommand.length() == 1) {
                sCommand = sCommand.trim().replaceAll("\\P{L}+", "");
                stepMechComplete.step();
                char sCommandChar = sCommand.charAt(0);
                System.out.println("@==INTERNAL==TRACE========================================@");
                char sCommandCipher = stepMechComplete.encipher(sCommandChar);
                System.out.println("@---------------------------------------------------------@");
                System.out.println("| Plain: " + sCommandChar + " | Cipher: " + sCommandCipher + " |");
                System.out.println("@=========================================================@");
                continue;
            }
            if (sCommand.equals("MENU")) {
                System.out.println("ENIGMA|ANLTC|SIM> Menu Redirection has not yet been implemented.");
                continue;
            }
            if (sCommand.equals("RESET")) {
                System.out.println("ENIGMA|ANLTC|SIM> Machine Reset has not yet been implemented.");
                continue;
            }
            if (sCommand.equals("PRINT")) {
                System.out.println("ENIGMA|ANLTC|SIM> Terminal Print has not yet been implemented.");
                continue;
            }
            if (sCommand.equals("INFO")) {
                System.out.println("\n\n");
                System.out.println("    @=========================================@");
                System.out.println("    | Special Commands:                       |");
                System.out.println("    @=========================================@");
                System.out.println("    |     | Menu | Print | Reset | Exit |     |");
                System.out.println("    @=========================================@");
                System.out.println("\n\n");
                continue;
            }
            if (!sCommand.equals("EXIT")) continue;
            esc = true;
        }
    }

    private static void steppingTest() {
        stepMechComplete.setAnalytical(true);
        System.out.println("ENIGMA>  Test of Stepping Procedure selected.");
        System.out.println("ENIGMA>  This is a test of the machine procedure that rotates the rotors.");
        System.out.println("ENIGMA>  Every process of the stepping mechanism will be shown.");
        System.out.println("ENIGMA>  The rotor face alteration sequence may also be shown upon request.");
        System.out.println("ENIGMA>  Special commands are not available in this mode.");
        System.out.println("ENIGMA>  Initialising...");
        BufferedReader stReader = new BufferedReader(new InputStreamReader(System.in));
        String stCommand = null;
        ArrayList<String> farLeftList = new ArrayList<String>();
        ArrayList<String> leftList = new ArrayList<String>();
        ArrayList<String> middleList = new ArrayList<String>();
        ArrayList<String> rightList = new ArrayList<String>();
        System.out.println("-----------------------------------------------------------");
        for (int i = 0; i < 100; ++i) {
            System.out.println("STEP>------------------------------------------------------");
            stepMechComplete.step();
            rightList.add(stepMechComplete.getFace("RIGHT"));
            middleList.add(stepMechComplete.getFace("MIDDLE"));
            leftList.add(stepMechComplete.getFace("LEFT"));
            farLeftList.add(stepMechComplete.getFace("FARLEFT"));
        }
        System.out.println("-----------------------------------------------------------");
        System.out.println("ENIGMA|TEST|SP> Output Enigma Rotor Face Sequence? yes/no");
        System.out.print("ENIGMA|TEST|SP> Command: ");
        try {
            stCommand = stReader.readLine().toUpperCase();
        }
        catch (IOException ioe) {
            System.out.println("ENIGMA|TEST|SP> IO Error trying to read your command.");
        }
        while (!(stCommand.equals("Y") || stCommand.equals("YES") || stCommand.equals("EXIT") || stCommand.equals("NO") || stCommand.equals("N"))) {
            System.out.println("ENIGMA|TEST|SP> Invalid command.");
            System.out.print("ENIGMA|TEST|SP> Command: ");
            try {
                stCommand = stReader.readLine().toUpperCase();
            }
            catch (IOException ioe) {
                System.out.println("ENIGMA|TEST|SP> IO Error trying to read command.");
            }
        }
        if (stCommand.equals("Y") || stCommand.equals("YES")) {
            System.out.println("ENIGMA|TEST|SP> Printing Rotor Face Sequence.");
            System.out.println("\n\n");
            if (farLeftList.get(0) == null) {
                System.out.println("@------------------@");
            } else {
                System.out.println("@---------------@");
            }
            for (int i = 0; i < 100; ++i) {
                System.out.println("| " + (String)farLeftList.get(i) + " | " + (String)leftList.get(i) + " | " + (String)middleList.get(i) + " | " + (String)rightList.get(i) + " |");
            }
            if (farLeftList.get(0) == null) {
                System.out.println("@------------------@");
                System.out.println("\n\n");
            } else {
                System.out.println("@---------------@");
                System.out.println("\n\n");
            }
        } else if (stCommand.equals("EXIT")) {
            System.out.println("ENIGMA|TEST|SP> Terminal will exit.");
            System.exit(0);
        }
    }

    private static void rotationTest() {
        BufferedReader rtReader = new BufferedReader(new InputStreamReader(System.in));
        String rtCommand = null;
        char[] aPress = new char[26];
        char[] bPress = new char[26];
        char[] cPress = new char[26];
        char[] dPress = new char[26];
        char[] ePress = new char[26];
        char[] fPress = new char[26];
        char[] gPress = new char[26];
        char[] hPress = new char[26];
        char[] iPress = new char[26];
        char[] jPress = new char[26];
        char[] kPress = new char[26];
        char[] lPress = new char[26];
        char[] mPress = new char[26];
        char[] nPress = new char[26];
        char[] oPress = new char[26];
        char[] pPress = new char[26];
        char[] qPress = new char[26];
        char[] rPress = new char[26];
        char[] sPress = new char[26];
        char[] tPress = new char[26];
        char[] uPress = new char[26];
        char[] vPress = new char[26];
        char[] wPress = new char[26];
        char[] xPress = new char[26];
        char[] yPress = new char[26];
        char[] zPress = new char[26];
        stepMechComplete.setAnalytical(false);
        System.out.println("ENIGMA|TEST|RR> Single Rotor Rotation and Examination Test selected.");
        System.out.println("ENIGMA|TEST|RR> Analytical Mode will be temporarily turned off.");
        System.out.println("ENIGMA|TEST|RR> Selected rotor will make a full rotation cycle.");
        System.out.println("ENIGMA|TEST|RR> For each of the 26 positions, all key presses will be recorded.");
        System.out.println("ENIGMA|TEST|RR> Special commands are not available in this mode.");
        System.out.println("ENIGMA|TEST|RR> Please select rotor position for examination.");
        System.out.println("ENIGMA|TEST|RR> Available positions: REFLECTOR | EXTRA | LEFT | MIDDLE | RIGHT");
        System.out.print("ENIGMA|TEST|RR> Command: ");
        try {
            rtCommand = rtReader.readLine().toUpperCase();
        }
        catch (IOException ioe) {
            System.out.println("ENIGMA|TEST|RR> IO Error trying to read command.");
        }
        while (!(rtCommand.equals("REFLECTOR") || rtCommand.equals("EXTRA") || rtCommand.equals("LEFT") || rtCommand.equals("MIDDLE") || rtCommand.equals("RIGHT") || rtCommand.equals("EXIT"))) {
            System.out.println("ENIGMA|TEST|RR>> Invalid command.");
            System.out.print("ENIGMA|TEST|RR>> Command: ");
            try {
                rtCommand = rtReader.readLine().toUpperCase();
            }
            catch (IOException ioe) {
                System.out.println("ENIGMA|TEST|RR>> IO Error trying to read command.");
            }
        }
        System.out.println("ENIGMA|TEST|RR> Initialising...");
        if (rtCommand.equals("REFLECTOR")) {
            int i;
            for (i = 0; i < 26; ++i) {
                stepMechComplete.getReflector().rotate();
                aPress[i] = stepMechComplete.encipher('A');
                bPress[i] = stepMechComplete.encipher('B');
                cPress[i] = stepMechComplete.encipher('C');
                dPress[i] = stepMechComplete.encipher('D');
                ePress[i] = stepMechComplete.encipher('E');
                fPress[i] = stepMechComplete.encipher('F');
                gPress[i] = stepMechComplete.encipher('G');
                hPress[i] = stepMechComplete.encipher('H');
                iPress[i] = stepMechComplete.encipher('I');
                jPress[i] = stepMechComplete.encipher('J');
                kPress[i] = stepMechComplete.encipher('K');
                lPress[i] = stepMechComplete.encipher('L');
                mPress[i] = stepMechComplete.encipher('M');
                nPress[i] = stepMechComplete.encipher('N');
                oPress[i] = stepMechComplete.encipher('O');
                pPress[i] = stepMechComplete.encipher('P');
                qPress[i] = stepMechComplete.encipher('Q');
                rPress[i] = stepMechComplete.encipher('R');
                sPress[i] = stepMechComplete.encipher('S');
                tPress[i] = stepMechComplete.encipher('T');
                uPress[i] = stepMechComplete.encipher('U');
                vPress[i] = stepMechComplete.encipher('V');
                wPress[i] = stepMechComplete.encipher('W');
                xPress[i] = stepMechComplete.encipher('X');
                yPress[i] = stepMechComplete.encipher('Y');
                zPress[i] = stepMechComplete.encipher('Z');
            }
            System.out.println("ENIGMA|TEST|RR> Printing rotor output table...");
            System.out.println("\n\n");
            System.out.println("|=======================================================|");
            System.out.println("|   |A|B|C|D|E|F|G|H|I|J|K|L|M|N|O|P|Q|R|S|T|U|V|W|X|Y|Z|");
            System.out.println("|=======================================================|");
            for (i = 0; i < 26; ++i) {
                if (i < 10) {
                    System.out.println("|" + i + "  |" + aPress[i] + "|" + bPress[i] + "|" + cPress[i] + "|" + dPress[i] + "|" + ePress[i] + "|" + fPress[i] + "|" + gPress[i] + "|" + hPress[i] + "|" + iPress[i] + "|" + jPress[i] + "|" + kPress[i] + "|" + lPress[i] + "|" + mPress[i] + "|" + nPress[i] + "|" + oPress[i] + "|" + pPress[i] + "|" + qPress[i] + "|" + rPress[i] + "|" + sPress[i] + "|" + tPress[i] + "|" + uPress[i] + "|" + vPress[i] + "|" + wPress[i] + "|" + xPress[i] + "|" + yPress[i] + "|" + zPress[i] + "|");
                    continue;
                }
                System.out.println("|" + i + " |" + aPress[i] + "|" + bPress[i] + "|" + cPress[i] + "|" + dPress[i] + "|" + ePress[i] + "|" + fPress[i] + "|" + gPress[i] + "|" + hPress[i] + "|" + iPress[i] + "|" + jPress[i] + "|" + kPress[i] + "|" + lPress[i] + "|" + mPress[i] + "|" + nPress[i] + "|" + oPress[i] + "|" + pPress[i] + "|" + qPress[i] + "|" + rPress[i] + "|" + sPress[i] + "|" + tPress[i] + "|" + uPress[i] + "|" + vPress[i] + "|" + wPress[i] + "|" + xPress[i] + "|" + yPress[i] + "|" + zPress[i] + "|");
            }
            System.out.println("|=======================================================|");
        } else if (rtCommand.equals("EXTRA")) {
            int i;
            for (i = 0; i < 26; ++i) {
                stepMechComplete.rotorDown("EXTRA");
                aPress[i] = stepMechComplete.encipher('A');
                bPress[i] = stepMechComplete.encipher('B');
                cPress[i] = stepMechComplete.encipher('C');
                dPress[i] = stepMechComplete.encipher('D');
                ePress[i] = stepMechComplete.encipher('E');
                fPress[i] = stepMechComplete.encipher('F');
                gPress[i] = stepMechComplete.encipher('G');
                hPress[i] = stepMechComplete.encipher('H');
                iPress[i] = stepMechComplete.encipher('I');
                jPress[i] = stepMechComplete.encipher('J');
                kPress[i] = stepMechComplete.encipher('K');
                lPress[i] = stepMechComplete.encipher('L');
                mPress[i] = stepMechComplete.encipher('M');
                nPress[i] = stepMechComplete.encipher('N');
                oPress[i] = stepMechComplete.encipher('O');
                pPress[i] = stepMechComplete.encipher('P');
                qPress[i] = stepMechComplete.encipher('Q');
                rPress[i] = stepMechComplete.encipher('R');
                sPress[i] = stepMechComplete.encipher('S');
                tPress[i] = stepMechComplete.encipher('T');
                uPress[i] = stepMechComplete.encipher('U');
                vPress[i] = stepMechComplete.encipher('V');
                wPress[i] = stepMechComplete.encipher('W');
                xPress[i] = stepMechComplete.encipher('X');
                yPress[i] = stepMechComplete.encipher('Y');
                zPress[i] = stepMechComplete.encipher('Z');
            }
            System.out.println("ENIGMA|TEST|RR> Printing rotor output table...");
            System.out.println("\n\n");
            System.out.println("|=======================================================|");
            System.out.println("|   |A|B|C|D|E|F|G|H|I|J|K|L|M|N|O|P|Q|R|S|T|U|V|W|X|Y|Z|");
            System.out.println("|=======================================================|");
            for (i = 0; i < 26; ++i) {
                if (i < 10) {
                    System.out.println("|" + i + "  |" + aPress[i] + "|" + bPress[i] + "|" + cPress[i] + "|" + dPress[i] + "|" + ePress[i] + "|" + fPress[i] + "|" + gPress[i] + "|" + hPress[i] + "|" + iPress[i] + "|" + jPress[i] + "|" + kPress[i] + "|" + lPress[i] + "|" + mPress[i] + "|" + nPress[i] + "|" + oPress[i] + "|" + pPress[i] + "|" + qPress[i] + "|" + rPress[i] + "|" + sPress[i] + "|" + tPress[i] + "|" + uPress[i] + "|" + vPress[i] + "|" + wPress[i] + "|" + xPress[i] + "|" + yPress[i] + "|" + zPress[i] + "|");
                    continue;
                }
                System.out.println("|" + i + " |" + aPress[i] + "|" + bPress[i] + "|" + cPress[i] + "|" + dPress[i] + "|" + ePress[i] + "|" + fPress[i] + "|" + gPress[i] + "|" + hPress[i] + "|" + iPress[i] + "|" + jPress[i] + "|" + kPress[i] + "|" + lPress[i] + "|" + mPress[i] + "|" + nPress[i] + "|" + oPress[i] + "|" + pPress[i] + "|" + qPress[i] + "|" + rPress[i] + "|" + sPress[i] + "|" + tPress[i] + "|" + uPress[i] + "|" + vPress[i] + "|" + wPress[i] + "|" + xPress[i] + "|" + yPress[i] + "|" + zPress[i] + "|");
            }
            System.out.println("|=======================================================|");
        } else if (rtCommand.equals("LEFT")) {
            int i;
            for (i = 0; i < 26; ++i) {
                stepMechComplete.rotorDown("LEFT");
                aPress[i] = stepMechComplete.encipher('A');
                bPress[i] = stepMechComplete.encipher('B');
                cPress[i] = stepMechComplete.encipher('C');
                dPress[i] = stepMechComplete.encipher('D');
                ePress[i] = stepMechComplete.encipher('E');
                fPress[i] = stepMechComplete.encipher('F');
                gPress[i] = stepMechComplete.encipher('G');
                hPress[i] = stepMechComplete.encipher('H');
                iPress[i] = stepMechComplete.encipher('I');
                jPress[i] = stepMechComplete.encipher('J');
                kPress[i] = stepMechComplete.encipher('K');
                lPress[i] = stepMechComplete.encipher('L');
                mPress[i] = stepMechComplete.encipher('M');
                nPress[i] = stepMechComplete.encipher('N');
                oPress[i] = stepMechComplete.encipher('O');
                pPress[i] = stepMechComplete.encipher('P');
                qPress[i] = stepMechComplete.encipher('Q');
                rPress[i] = stepMechComplete.encipher('R');
                sPress[i] = stepMechComplete.encipher('S');
                tPress[i] = stepMechComplete.encipher('T');
                uPress[i] = stepMechComplete.encipher('U');
                vPress[i] = stepMechComplete.encipher('V');
                wPress[i] = stepMechComplete.encipher('W');
                xPress[i] = stepMechComplete.encipher('X');
                yPress[i] = stepMechComplete.encipher('Y');
                zPress[i] = stepMechComplete.encipher('Z');
            }
            System.out.println("ENIGMA|TEST|RR> Printing rotor output table...");
            System.out.println("\n\n");
            System.out.println("|=======================================================|");
            System.out.println("|   |A|B|C|D|E|F|G|H|I|J|K|L|M|N|O|P|Q|R|S|T|U|V|W|X|Y|Z|");
            System.out.println("|=======================================================|");
            for (i = 0; i < 26; ++i) {
                if (i < 10) {
                    System.out.println("|" + i + "  |" + aPress[i] + "|" + bPress[i] + "|" + cPress[i] + "|" + dPress[i] + "|" + ePress[i] + "|" + fPress[i] + "|" + gPress[i] + "|" + hPress[i] + "|" + iPress[i] + "|" + jPress[i] + "|" + kPress[i] + "|" + lPress[i] + "|" + mPress[i] + "|" + nPress[i] + "|" + oPress[i] + "|" + pPress[i] + "|" + qPress[i] + "|" + rPress[i] + "|" + sPress[i] + "|" + tPress[i] + "|" + uPress[i] + "|" + vPress[i] + "|" + wPress[i] + "|" + xPress[i] + "|" + yPress[i] + "|" + zPress[i] + "|");
                    continue;
                }
                System.out.println("|" + i + " |" + aPress[i] + "|" + bPress[i] + "|" + cPress[i] + "|" + dPress[i] + "|" + ePress[i] + "|" + fPress[i] + "|" + gPress[i] + "|" + hPress[i] + "|" + iPress[i] + "|" + jPress[i] + "|" + kPress[i] + "|" + lPress[i] + "|" + mPress[i] + "|" + nPress[i] + "|" + oPress[i] + "|" + pPress[i] + "|" + qPress[i] + "|" + rPress[i] + "|" + sPress[i] + "|" + tPress[i] + "|" + uPress[i] + "|" + vPress[i] + "|" + wPress[i] + "|" + xPress[i] + "|" + yPress[i] + "|" + zPress[i] + "|");
            }
            System.out.println("|=======================================================|");
        } else if (rtCommand.equals("MIDDLE")) {
            int i;
            for (i = 0; i < 26; ++i) {
                stepMechComplete.rotorDown("MIDDLE");
                aPress[i] = stepMechComplete.encipher('A');
                bPress[i] = stepMechComplete.encipher('B');
                cPress[i] = stepMechComplete.encipher('C');
                dPress[i] = stepMechComplete.encipher('D');
                ePress[i] = stepMechComplete.encipher('E');
                fPress[i] = stepMechComplete.encipher('F');
                gPress[i] = stepMechComplete.encipher('G');
                hPress[i] = stepMechComplete.encipher('H');
                iPress[i] = stepMechComplete.encipher('I');
                jPress[i] = stepMechComplete.encipher('J');
                kPress[i] = stepMechComplete.encipher('K');
                lPress[i] = stepMechComplete.encipher('L');
                mPress[i] = stepMechComplete.encipher('M');
                nPress[i] = stepMechComplete.encipher('N');
                oPress[i] = stepMechComplete.encipher('O');
                pPress[i] = stepMechComplete.encipher('P');
                qPress[i] = stepMechComplete.encipher('Q');
                rPress[i] = stepMechComplete.encipher('R');
                sPress[i] = stepMechComplete.encipher('S');
                tPress[i] = stepMechComplete.encipher('T');
                uPress[i] = stepMechComplete.encipher('U');
                vPress[i] = stepMechComplete.encipher('V');
                wPress[i] = stepMechComplete.encipher('W');
                xPress[i] = stepMechComplete.encipher('X');
                yPress[i] = stepMechComplete.encipher('Y');
                zPress[i] = stepMechComplete.encipher('Z');
            }
            System.out.println("ENIGMA|TEST|RR> Printing rotor output table...");
            System.out.println("\n\n");
            System.out.println("|=======================================================|");
            System.out.println("|   |A|B|C|D|E|F|G|H|I|J|K|L|M|N|O|P|Q|R|S|T|U|V|W|X|Y|Z|");
            System.out.println("|=======================================================|");
            for (i = 0; i < 26; ++i) {
                if (i < 10) {
                    System.out.println("|" + i + "  |" + aPress[i] + "|" + bPress[i] + "|" + cPress[i] + "|" + dPress[i] + "|" + ePress[i] + "|" + fPress[i] + "|" + gPress[i] + "|" + hPress[i] + "|" + iPress[i] + "|" + jPress[i] + "|" + kPress[i] + "|" + lPress[i] + "|" + mPress[i] + "|" + nPress[i] + "|" + oPress[i] + "|" + pPress[i] + "|" + qPress[i] + "|" + rPress[i] + "|" + sPress[i] + "|" + tPress[i] + "|" + uPress[i] + "|" + vPress[i] + "|" + wPress[i] + "|" + xPress[i] + "|" + yPress[i] + "|" + zPress[i] + "|");
                    continue;
                }
                System.out.println("|" + i + " |" + aPress[i] + "|" + bPress[i] + "|" + cPress[i] + "|" + dPress[i] + "|" + ePress[i] + "|" + fPress[i] + "|" + gPress[i] + "|" + hPress[i] + "|" + iPress[i] + "|" + jPress[i] + "|" + kPress[i] + "|" + lPress[i] + "|" + mPress[i] + "|" + nPress[i] + "|" + oPress[i] + "|" + pPress[i] + "|" + qPress[i] + "|" + rPress[i] + "|" + sPress[i] + "|" + tPress[i] + "|" + uPress[i] + "|" + vPress[i] + "|" + wPress[i] + "|" + xPress[i] + "|" + yPress[i] + "|" + zPress[i] + "|");
            }
            System.out.println("|=======================================================|");
        } else if (rtCommand.equals("RIGHT")) {
            int i;
            for (i = 0; i < 26; ++i) {
                stepMechComplete.rotorDown("RIGHT");
                aPress[i] = stepMechComplete.encipher('A');
                bPress[i] = stepMechComplete.encipher('B');
                cPress[i] = stepMechComplete.encipher('C');
                dPress[i] = stepMechComplete.encipher('D');
                ePress[i] = stepMechComplete.encipher('E');
                fPress[i] = stepMechComplete.encipher('F');
                gPress[i] = stepMechComplete.encipher('G');
                hPress[i] = stepMechComplete.encipher('H');
                iPress[i] = stepMechComplete.encipher('I');
                jPress[i] = stepMechComplete.encipher('J');
                kPress[i] = stepMechComplete.encipher('K');
                lPress[i] = stepMechComplete.encipher('L');
                mPress[i] = stepMechComplete.encipher('M');
                nPress[i] = stepMechComplete.encipher('N');
                oPress[i] = stepMechComplete.encipher('O');
                pPress[i] = stepMechComplete.encipher('P');
                qPress[i] = stepMechComplete.encipher('Q');
                rPress[i] = stepMechComplete.encipher('R');
                sPress[i] = stepMechComplete.encipher('S');
                tPress[i] = stepMechComplete.encipher('T');
                uPress[i] = stepMechComplete.encipher('U');
                vPress[i] = stepMechComplete.encipher('V');
                wPress[i] = stepMechComplete.encipher('W');
                xPress[i] = stepMechComplete.encipher('X');
                yPress[i] = stepMechComplete.encipher('Y');
                zPress[i] = stepMechComplete.encipher('Z');
            }
            System.out.println("ENIGMA|TEST|RR> Printing rotor output table...");
            System.out.println("\n\n");
            System.out.println("|=======================================================|");
            System.out.println("|   |A|B|C|D|E|F|G|H|I|J|K|L|M|N|O|P|Q|R|S|T|U|V|W|X|Y|Z|");
            System.out.println("|=======================================================|");
            for (i = 0; i < 26; ++i) {
                if (i < 10) {
                    System.out.println("|" + i + "  |" + aPress[i] + "|" + bPress[i] + "|" + cPress[i] + "|" + dPress[i] + "|" + ePress[i] + "|" + fPress[i] + "|" + gPress[i] + "|" + hPress[i] + "|" + iPress[i] + "|" + jPress[i] + "|" + kPress[i] + "|" + lPress[i] + "|" + mPress[i] + "|" + nPress[i] + "|" + oPress[i] + "|" + pPress[i] + "|" + qPress[i] + "|" + rPress[i] + "|" + sPress[i] + "|" + tPress[i] + "|" + uPress[i] + "|" + vPress[i] + "|" + wPress[i] + "|" + xPress[i] + "|" + yPress[i] + "|" + zPress[i] + "|");
                    continue;
                }
                System.out.println("|" + i + " |" + aPress[i] + "|" + bPress[i] + "|" + cPress[i] + "|" + dPress[i] + "|" + ePress[i] + "|" + fPress[i] + "|" + gPress[i] + "|" + hPress[i] + "|" + iPress[i] + "|" + jPress[i] + "|" + kPress[i] + "|" + lPress[i] + "|" + mPress[i] + "|" + nPress[i] + "|" + oPress[i] + "|" + pPress[i] + "|" + qPress[i] + "|" + rPress[i] + "|" + sPress[i] + "|" + tPress[i] + "|" + uPress[i] + "|" + vPress[i] + "|" + wPress[i] + "|" + xPress[i] + "|" + yPress[i] + "|" + zPress[i] + "|");
            }
            System.out.println("|=======================================================|");
        } else if (rtCommand.equals("EXIT")) {
            System.out.println("ENIGMA> Terminal will exit.");
            System.exit(0);
        }
    }

    private static void endurance_performanceTest() {
    }

    private static String machineType(String mType) {
        switch (mType) {
            case "D": {
                mType = "Enigma D";
                break;
            }
            case "GA": {
                mType = "Enigma A28";
                break;
            }
            case "G1": {
                mType = "Enigma G31 G-111";
                break;
            }
            case "G2": {
                mType = "Enigma G31 G-260";
                break;
            }
            case "G3": {
                mType = "Enigma G31 G-312";
                break;
            }
            case "KT": {
                mType = "Enigma T Tirpitz";
                break;
            }
            case "KS": {
                mType = "Enigma K Swiss";
                break;
            }
            case "KR": {
                mType = "Enigma K Railway";
                break;
            }
            case "KD": {
                mType = "Enigma KD";
                break;
            }
            case "IS": {
                mType = "Enigma I Service";
                break;
            }
            case "IN": {
                mType = "Enigma I Norway";
                break;
            }
            case "IM3": {
                mType = "Enigma M3";
                break;
            }
            case "IM4": {
                mType = "Enigma M4";
            }
        }
        return mType;
    }

    private static String reflectorType(String rType) {
        switch (rType) {
            case "DEFAULT": 
            case "RAILWAY": 
            case "NORWAY": 
            case "TIRPITZ": 
            case "G3": {
                rType = "UKW";
                break;
            }
            case "I.UKW-A": {
                rType = "UKW - A";
                break;
            }
            case "I.UKW-B": 
            case "M3.UKW-B": 
            case "M4.UKW-B": {
                rType = "UKW - B";
                break;
            }
            case "I.UKW-C": 
            case "M3.UKW-C": 
            case "M4.UKW-C": {
                rType = "UKW - C";
                break;
            }
            case "REWIRABLE": {
                rType = "UKW - D";
            }
        }
        return rType;
    }

    private static String offsetArrangement() {
        int i;
        String arrangement = stepMechComplete.getRotorOffset("EXTRA");
        if (arrangement == null) {
            arrangement = "";
        } else {
            for (i = 0; i < 26; ++i) {
                if (!arrangement.equals(contacts[i])) continue;
                arrangement = contacts[i] + "-" + translator[i] + "  ";
                break;
            }
        }
        for (i = 0; i < 26; ++i) {
            if (!stepMechComplete.getRotorOffset("LEFT").equals(contacts[i])) continue;
            arrangement = arrangement + contacts[i] + "-" + translator[i] + "  ";
            break;
        }
        for (i = 0; i < 26; ++i) {
            if (!stepMechComplete.getRotorOffset("MIDDLE").equals(contacts[i])) continue;
            arrangement = arrangement + contacts[i] + "-" + translator[i] + "  ";
            break;
        }
        for (i = 0; i < 26; ++i) {
            if (!stepMechComplete.getRotorOffset("RIGHT").equals(contacts[i])) continue;
            arrangement = arrangement + contacts[i] + "-" + translator[i];
            break;
        }
        return arrangement;
    }

    static {
        translator = new String[]{"01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26"};
        contacts = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};
    }
}

