/*
 * Decompiled with CFR 0.152.
 */
package enigma;

public class Reflector {
    private String rType;
    private char[] entry;
    private char[] reflection;
    private char[] refGAF;
    private int index;
    private int input;
    private int output;
    private char[] face = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
    private boolean analytical = false;

    public Reflector(String type) {
        this.rType = type;
        this.index = 0;
        this.setReflector(this.rType);
    }

    public int reflect(int contact) {
        this.input = this.mod(contact + this.index, 26);
        for (int i = 0; i < 26; ++i) {
            if (this.reflection[this.input] != this.entry[i]) continue;
            this.output = i;
        }
        this.output = this.mod(this.output - this.index, 26);
        if (this.analytical) {
            System.out.println("Reflector " + this.rType + "> In: " + this.input + " Char: " + this.entry[this.input] + " || Out: " + this.output + " Char: " + this.entry[this.output] + "  |L-L");
        }
        return this.output;
    }

    public String getType() {
        return this.rType;
    }

    private void setReflector(String name) {
        this.entry = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
        switch (name) {
            case "DEFAULT": {
                this.reflection = new char[]{'I', 'M', 'E', 'T', 'C', 'G', 'F', 'R', 'A', 'Y', 'S', 'Q', 'B', 'Z', 'X', 'W', 'L', 'H', 'K', 'D', 'V', 'U', 'P', 'O', 'J', 'N'};
                break;
            }
            case "RAILWAY": {
                this.reflection = new char[]{'Q', 'Y', 'H', 'O', 'G', 'N', 'E', 'C', 'V', 'P', 'U', 'Z', 'T', 'F', 'D', 'J', 'A', 'X', 'W', 'M', 'K', 'I', 'S', 'R', 'B', 'L'};
                break;
            }
            case "NORWAY": {
                this.reflection = new char[]{'M', 'O', 'W', 'J', 'Y', 'P', 'U', 'X', 'N', 'D', 'S', 'R', 'A', 'I', 'B', 'F', 'V', 'L', 'K', 'Z', 'G', 'Q', 'C', 'H', 'E', 'T'};
                break;
            }
            case "TIRPITZ": {
                this.reflection = new char[]{'G', 'E', 'K', 'P', 'B', 'T', 'A', 'U', 'M', 'O', 'C', 'N', 'I', 'L', 'J', 'D', 'X', 'Z', 'Y', 'F', 'H', 'W', 'V', 'Q', 'S', 'R'};
                break;
            }
            case "G3": {
                this.reflection = new char[]{'R', 'U', 'L', 'Q', 'M', 'Z', 'J', 'S', 'Y', 'G', 'O', 'C', 'E', 'T', 'K', 'W', 'D', 'A', 'H', 'N', 'B', 'X', 'P', 'V', 'I', 'F'};
                break;
            }
            case "I.UKW-A": {
                this.reflection = new char[]{'E', 'J', 'M', 'Z', 'A', 'L', 'Y', 'X', 'V', 'B', 'W', 'F', 'C', 'R', 'Q', 'U', 'O', 'N', 'T', 'S', 'P', 'I', 'K', 'H', 'G', 'D'};
                break;
            }
            case "I.UKW-B": {
                this.reflection = new char[]{'Y', 'R', 'U', 'H', 'Q', 'S', 'L', 'D', 'P', 'X', 'N', 'G', 'O', 'K', 'M', 'I', 'E', 'B', 'F', 'Z', 'C', 'W', 'V', 'J', 'A', 'T'};
                break;
            }
            case "I.UKW-C": {
                this.reflection = new char[]{'F', 'V', 'P', 'J', 'I', 'A', 'O', 'Y', 'E', 'D', 'R', 'Z', 'X', 'W', 'G', 'C', 'T', 'K', 'U', 'Q', 'S', 'B', 'N', 'M', 'H', 'L'};
                break;
            }
            case "M3.UKW-B": {
                this.reflection = new char[]{'Y', 'R', 'U', 'H', 'Q', 'S', 'L', 'D', 'P', 'X', 'N', 'G', 'O', 'K', 'M', 'I', 'E', 'B', 'F', 'Z', 'C', 'W', 'V', 'J', 'A', 'T'};
                break;
            }
            case "M3.UKW-C": {
                this.reflection = new char[]{'F', 'V', 'P', 'J', 'I', 'A', 'O', 'Y', 'E', 'D', 'R', 'Z', 'X', 'W', 'G', 'C', 'T', 'K', 'U', 'Q', 'S', 'B', 'N', 'M', 'H', 'L'};
                break;
            }
            case "M4.UKW-B": {
                this.reflection = new char[]{'E', 'N', 'K', 'Q', 'A', 'U', 'Y', 'W', 'J', 'I', 'C', 'O', 'P', 'B', 'L', 'M', 'D', 'X', 'Z', 'V', 'F', 'T', 'H', 'R', 'G', 'S'};
                break;
            }
            case "M4.UKW-C": {
                this.reflection = new char[]{'R', 'D', 'O', 'B', 'J', 'N', 'T', 'K', 'V', 'E', 'H', 'M', 'L', 'F', 'C', 'W', 'Z', 'A', 'X', 'G', 'Y', 'I', 'P', 'S', 'U', 'Q'};
                break;
            }
            case "REWIRABLE": {
                this.reflection = new char[]{'D', 'F', 'O', 'A', 'P', 'B', 'L', 'K', 'M', 'Y', 'H', 'G', 'I', 'Q', 'C', 'E', 'N', 'W', 'V', 'Z', 'X', 'S', 'R', 'U', 'J', 'T'};
                this.refGAF = this.reflection;
            }
        }
    }

    public String getFace() {
        String faceTemp = Character.toString(this.entry[this.index]);
        return faceTemp;
    }

    public int getIndex() {
        return this.index;
    }

    public void indexDown() {
        this.index = this.mod(this.index + 1, 26);
    }

    public void indexUp() {
        this.index = this.mod(this.index - 1, 26);
    }

    protected void setIndex(int position) {
        int temp = position;
        if (temp > -1 && temp < 26) {
            this.index = position;
        }
    }

    public void rotate() {
        this.index = this.mod(this.index + 1, 26);
        if (this.analytical) {
            if (this.index < 10) {
                System.out.println("ROTATE> Index: |  " + this.index + " | , Position: | " + this.face[this.index] + " |" + " , Reflector");
            } else {
                System.out.println("ROTATE> Index: | " + this.index + " | , Position: | " + this.face[this.index] + " |" + " , Reflector");
            }
        }
    }

    public void resetUKWD() {
        if (this.rType.equals("REWIRABLE")) {
            System.arraycopy(this.refGAF, 0, this.reflection, 0, 26);
        }
    }

    public void cleanUKWD() {
        if (this.rType.equals("REWIRABLE")) {
            int i;
            for (i = 0; i < 9; ++i) {
                this.reflection[i] = '\u0000';
            }
            for (i = 10; i < 24; ++i) {
                this.reflection[i] = '\u0000';
            }
            this.reflection[25] = '\u0000';
        }
    }

    public void addCable(char letterOne, char letterTwo) {
        if (this.rType.equals("REWIRABLE")) {
            for (int i = 0; i < 26; ++i) {
                if (this.entry[i] == letterOne) {
                    this.reflection[i] = letterTwo;
                }
                if (this.entry[i] != letterTwo) continue;
                this.reflection[i] = letterOne;
            }
        }
    }

    public void removeCable(char letterOne, char letterTwo) {
        if (this.rType.equals("REWIRABLE")) {
            for (int i = 0; i < 26; ++i) {
                if (this.entry[i] == letterOne) {
                    this.reflection[i] = this.entry[i];
                }
                if (this.entry[i] != letterTwo) continue;
                this.reflection[i] = this.entry[i];
            }
        }
    }

    public char getPair(char letter) {
        char temp2 = '\u0000';
        if (this.rType.equals("REWIRABLE")) {
            for (int i = 0; i < 26; ++i) {
                if (this.entry[i] != letter) continue;
                temp2 = this.reflection[i];
            }
        }
        return temp2;
    }

    public char[] getGAF() {
        if (this.rType.equals("REWIRABLE")) {
            return this.refGAF;
        }
        return null;
    }

    public void setAnalytical(boolean state) {
        this.analytical = state;
    }

    private int mod(int x, int y) {
        int result = x % y;
        if (result < 0) {
            result += y;
        }
        return result;
    }
}

