/*
 * Decompiled with CFR 0.152.
 */
package enigma;

public class Rotor {
    private String rType;
    private int index;
    protected char[] face = new char[26];
    private char[] offsetface = new char[]{'Z', 'Y', 'X', 'W', 'V', 'U', 'T', 'S', 'R', 'Q', 'P', 'O', 'N', 'M', 'L', 'K', 'J', 'I', 'H', 'G', 'F', 'E', 'D', 'C', 'B', 'A'};
    private char[] turnoverFace = new char[]{'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'A'};
    protected char[] turnover;
    protected char[][] wiring = new char[2][26];
    private int input;
    private int output;
    private boolean analytical = false;

    public Rotor(String type) {
        this.rType = type;
        this.index = 0;
    }

    public int traceIn(int contact) {
        this.input = this.mod(contact + this.index, 26);
        for (int i = 0; i < 26; ++i) {
            if (this.wiring[1][this.input] != this.wiring[0][i]) continue;
            this.output = i;
            break;
        }
        this.output = this.mod(this.output - this.index, 26);
        if (this.analytical) {
            System.out.println("Rotor " + this.rType + "> In: " + this.input + " Char: " + this.face[this.input] + " || Out: " + this.output + " Char: " + this.face[this.output] + "  |R-L");
        }
        return this.output;
    }

    public int traceOut(int contact) {
        this.input = this.mod(contact + this.index, 26);
        for (int i = 0; i < 26; ++i) {
            if (this.wiring[0][this.input] != this.wiring[1][i]) continue;
            this.output = i;
            break;
        }
        this.output = this.mod(this.output - this.index, 26);
        if (this.analytical) {
            System.out.println("Rotor " + this.rType + "> In: " + this.input + " Char: " + this.face[this.input] + " || Out: " + this.output + " Char: " + this.face[this.output] + "  |L-R");
        }
        return this.output;
    }

    public String getFace() {
        String faceTemp = Character.toString(this.face[this.index]);
        return faceTemp;
    }

    public int getIndex() {
        return this.index;
    }

    public String getType() {
        return this.rType;
    }

    public String getOffset() {
        int find = 0;
        for (int i = 1; i < 26; ++i) {
            if (this.wiring[0][0] != this.face[i]) continue;
            find = i;
            break;
        }
        if (--find == -1) {
            find = 25;
        }
        return this.offsetface[find] + "";
    }

    protected void setIndex(int position) {
        int temp = position;
        if (temp > -1 && temp < 26) {
            this.index = position;
        }
    }

    protected void setOffset(char position) {
        int find = 0;
        for (int i = 1; i < 26; ++i) {
            if (position != this.face[i]) continue;
            find = i;
            break;
        }
        if (--find == -1) {
            find = 25;
        }
        while (this.offsetface[find] != this.wiring[0][0]) {
            int i;
            char[][] offsetArray = new char[2][26];
            char lastRight = this.wiring[0][25];
            char lastLeft = this.wiring[1][25];
            for (i = 0; i < 25; ++i) {
                offsetArray[0][i + 1] = this.wiring[0][i];
                offsetArray[1][i + 1] = this.wiring[1][i];
            }
            offsetArray[0][0] = lastRight;
            offsetArray[1][0] = lastLeft;
            for (i = 0; i < 26; ++i) {
                this.wiring[0][i] = offsetArray[0][i];
                this.wiring[1][i] = offsetArray[1][i];
            }
        }
    }

    public void indexDown() {
        this.index = this.mod(this.index + 1, 26);
    }

    public void indexUp() {
        this.index = this.mod(this.index - 1, 26);
    }

    public void rotate() {
        this.index = this.mod(this.index + 1, 26);
        if (this.analytical) {
            if (this.index < 10) {
                System.out.println("ROTATE> Index: |  " + this.index + " | , Position: | " + this.face[this.index] + " |" + " , Rotor: " + this.rType);
            } else {
                System.out.println("ROTATE> Index: | " + this.index + " | , Position: | " + this.face[this.index] + " |" + " , Rotor: " + this.rType);
            }
        }
    }

    public boolean turnover() {
        boolean notchFound = false;
        for (int i = 0; i < this.turnover.length; ++i) {
            if (this.turnover[i] != this.face[this.index]) continue;
            notchFound = true;
            break;
        }
        return notchFound;
    }

    public boolean realTurnover() {
        boolean notchFound = false;
        for (int i = 0; i < this.turnover.length; ++i) {
            if (this.turnover[i] != this.turnoverFace[this.index]) continue;
            notchFound = true;
            break;
        }
        return notchFound;
    }

    public void setAnalytical(boolean state) {
        this.analytical = state;
    }

    private int mod(int x, int y) {
        int result = x % y;
        if (result < 0) {
            result += y;
        }
        return result;
    }
}

