/*
 * Decompiled with CFR 0.152.
 */
package enigma;

public class Stator {
    private String sType;
    private char[] contacts;
    private boolean analytical = false;

    public Stator(String type) {
        this.sType = type;
        this.setStator(this.sType);
    }

    public int translateIn(char input) {
        int contactNum = 0;
        char charValue = input;
        for (int i = 0; i < 26; ++i) {
            if (charValue != this.contacts[i]) continue;
            contactNum = i;
            break;
        }
        return contactNum;
    }

    public char translateOut(int output) {
        char charValue = this.contacts[output];
        return charValue;
    }

    public String getType() {
        return this.sType;
    }

    public void setAnalytical(boolean state) {
        this.analytical = state;
    }

    private void setStator(String type) {
        switch (type) {
            case "DEFAULT": {
                this.contacts = new char[]{'Q', 'W', 'E', 'R', 'T', 'Z', 'U', 'I', 'O', 'A', 'S', 'D', 'F', 'G', 'H', 'J', 'K', 'P', 'Y', 'X', 'C', 'V', 'B', 'N', 'M', 'L'};
                break;
            }
            case "TYPEI": {
                this.contacts = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
                break;
            }
            case "TIRPITZ": {
                this.contacts = new char[]{'K', 'Z', 'R', 'O', 'U', 'Q', 'H', 'Y', 'A', 'I', 'G', 'B', 'L', 'W', 'V', 'S', 'T', 'D', 'X', 'F', 'P', 'N', 'M', 'C', 'J', 'E'};
            }
        }
    }
}

