/*
 * Decompiled with CFR 0.152.
 */
package enigma;

import enigma.Reflector;
import enigma.Rotor;
import enigma.Stator;
import enigma.rotors.DRotor;
import enigma.rotors.G1Rotor;
import enigma.rotors.G2Rotor;
import enigma.rotors.G3Rotor;
import enigma.rotors.GARotor;
import enigma.rotors.IM3Rotor;
import enigma.rotors.IM4Rotor;
import enigma.rotors.INRotor;
import enigma.rotors.ISRotor;
import enigma.rotors.KDRotor;
import enigma.rotors.KRRotor;
import enigma.rotors.KSRotor;
import enigma.rotors.KTRotor;

public final class SteppingMechanism {
    private String eType;
    private Stator etw;
    private Rotor rRight;
    private Rotor rMiddle;
    private Rotor rLeft;
    private Rotor rExtra;
    private Reflector ukw;
    private int trace;
    private char[] translate = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
    private char plain;
    private char cipher;
    private boolean ukwSettable;
    private boolean ukwMovable;
    private boolean extraRotor;
    private boolean doubleStep = false;
    private boolean analytical = false;

    public SteppingMechanism(String type) {
        this.eType = type;
        this.setMechanism();
    }

    public void step() {
        this.rRight.rotate();
        if (this.rRight.turnover()) {
            this.rMiddle.rotate();
            if (this.rMiddle.turnover()) {
                this.rLeft.rotate();
                if (this.rLeft.turnover() && this.ukwMovable) {
                    this.ukw.rotate();
                }
            }
        }
        if (this.doubleStep) {
            this.rMiddle.rotate();
            this.rLeft.rotate();
            this.doubleStep = false;
            if (this.analytical) {
                System.out.println("\n");
                System.out.println("@----------@^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^@---------@");
                System.out.println("@          | DOUBLE  STEPPING  ANOMALY  OCCURED |         @");
                System.out.println("@==========@====================================@=========@");
                System.out.println("\n");
            }
        }
        if (!this.eType.equals("GA") && !this.eType.equals("G1") && !this.eType.equals("G2") && !this.eType.equals("G3") && this.rLeft.getType().equals("III") && this.rMiddle.getType().equals("II") && this.rRight.getType().equals("I") && this.rMiddle.realTurnover()) {
            this.doubleStep = true;
        }
    }

    public char encipher(char letter) {
        this.plain = letter;
        this.trace = this.etw.translateIn(this.plain);
        this.trace = this.rRight.traceIn(this.trace);
        this.trace = this.rMiddle.traceIn(this.trace);
        this.trace = this.rLeft.traceIn(this.trace);
        if (this.extraRotor) {
            this.trace = this.rExtra.traceIn(this.trace);
        }
        this.trace = this.ukw.reflect(this.trace);
        if (this.extraRotor) {
            this.trace = this.rExtra.traceOut(this.trace);
        }
        this.trace = this.rLeft.traceOut(this.trace);
        this.trace = this.rMiddle.traceOut(this.trace);
        this.trace = this.rRight.traceOut(this.trace);
        this.cipher = this.etw.translateOut(this.trace);
        return this.cipher;
    }

    public String getFace(String position) {
        String window = null;
        switch (position) {
            case "RIGHT": {
                window = this.rRight.getFace();
                break;
            }
            case "MIDDLE": {
                window = this.rMiddle.getFace();
                break;
            }
            case "LEFT": {
                window = this.rLeft.getFace();
                break;
            }
            case "FARLEFT": {
                if (this.ukwSettable) {
                    window = this.ukw.getFace();
                    break;
                }
                if (!this.extraRotor) break;
                window = this.rExtra.getFace();
            }
        }
        return window;
    }

    public void rotorUp(String position) {
        switch (position) {
            case "RIGHT": {
                this.rRight.indexUp();
                break;
            }
            case "MIDDLE": {
                this.rMiddle.indexUp();
                break;
            }
            case "LEFT": {
                this.rLeft.indexUp();
                break;
            }
            case "FARLEFT": {
                if (this.ukwSettable) {
                    this.ukw.indexUp();
                    break;
                }
                if (!this.extraRotor) break;
                this.rExtra.indexUp();
            }
        }
    }

    public void rotorDown(String position) {
        switch (position) {
            case "RIGHT": {
                this.rRight.indexDown();
                break;
            }
            case "MIDDLE": {
                this.rMiddle.indexDown();
                break;
            }
            case "LEFT": {
                this.rLeft.indexDown();
                break;
            }
            case "FARLEFT": {
                if (this.ukwSettable) {
                    this.ukw.indexDown();
                    break;
                }
                if (!this.extraRotor) break;
                this.rExtra.indexDown();
            }
        }
    }

    public Reflector getReflector() {
        return this.ukw;
    }

    private void setMechanism() {
        switch (this.eType) {
            case "D": {
                this.ukwSettable = true;
                this.ukwMovable = false;
                this.extraRotor = false;
                this.etw = new Stator("DEFAULT");
                this.ukw = new Reflector("DEFAULT");
                break;
            }
            case "GA": {
                this.ukwSettable = true;
                this.ukwMovable = true;
                this.extraRotor = false;
                this.ukw = new Reflector("DEFAULT");
                this.etw = new Stator("DEFAULT");
                break;
            }
            case "G1": {
                this.ukwSettable = true;
                this.ukwMovable = true;
                this.extraRotor = false;
                this.ukw = new Reflector("DEFAULT");
                this.etw = new Stator("DEFAULT");
                break;
            }
            case "G2": {
                this.ukwSettable = true;
                this.ukwMovable = true;
                this.extraRotor = false;
                this.ukw = new Reflector("DEFAULT");
                this.etw = new Stator("DEFAULT");
                break;
            }
            case "G3": {
                this.ukwSettable = true;
                this.ukwMovable = true;
                this.extraRotor = false;
                this.ukw = new Reflector("G3");
                this.etw = new Stator("DEFAULT");
                break;
            }
            case "KT": {
                this.ukwSettable = true;
                this.ukwMovable = false;
                this.extraRotor = false;
                this.ukw = new Reflector("TIRPITZ");
                this.etw = new Stator("TIRPITZ");
                break;
            }
            case "KS": {
                this.ukwSettable = true;
                this.ukwMovable = false;
                this.extraRotor = false;
                this.ukw = new Reflector("DEFAULT");
                this.etw = new Stator("DEFAULT");
                break;
            }
            case "K": {
                this.ukwSettable = true;
                this.ukwMovable = false;
                this.extraRotor = false;
                this.ukw = new Reflector("DEFAULT");
                this.etw = new Stator("DEFAULT");
                break;
            }
            case "KR": {
                this.ukwSettable = true;
                this.ukwMovable = false;
                this.extraRotor = false;
                this.ukw = new Reflector("RAILWAY");
                this.etw = new Stator("DEFAULT");
                break;
            }
            case "KD": {
                this.ukwSettable = false;
                this.ukwMovable = false;
                this.extraRotor = false;
                this.ukw = new Reflector("REWIRABLE");
                this.etw = new Stator("DEFAULT");
                break;
            }
            case "IS": {
                this.ukwSettable = false;
                this.ukwMovable = false;
                this.extraRotor = false;
                this.etw = new Stator("TYPEI");
                this.ukw = new Reflector("I.UKW-B");
                break;
            }
            case "IN": {
                this.ukwSettable = false;
                this.ukwMovable = false;
                this.extraRotor = false;
                this.ukw = new Reflector("NORWAY");
                this.etw = new Stator("TYPEI");
                break;
            }
            case "IM3": {
                this.ukwSettable = false;
                this.ukwMovable = false;
                this.extraRotor = false;
                this.etw = new Stator("TYPEI");
                this.ukw = new Reflector("M3.UKW-B");
                break;
            }
            case "IM4": {
                this.ukwSettable = false;
                this.ukwMovable = false;
                this.extraRotor = true;
                this.etw = new Stator("TYPEI");
                this.ukw = new Reflector("M4.UKW-B");
                break;
            }
            case "IM4D": {
                this.ukwSettable = false;
                this.ukwMovable = false;
                this.extraRotor = false;
                this.etw = new Stator("TYPEI");
                this.ukw = new Reflector("REWIRABLE");
            }
        }
    }

    public void setRotors(String extra, String left, String middle, String right) {
        switch (this.eType) {
            case "D": {
                this.rRight = new DRotor(right);
                this.rMiddle = new DRotor(middle);
                this.rLeft = new DRotor(left);
                break;
            }
            case "GA": {
                this.rRight = new GARotor(right);
                this.rMiddle = new GARotor(middle);
                this.rLeft = new GARotor(left);
                break;
            }
            case "G1": {
                this.rRight = new G1Rotor(right);
                this.rMiddle = new G1Rotor(middle);
                this.rLeft = new G1Rotor(left);
                break;
            }
            case "G2": {
                this.rRight = new G2Rotor(right);
                this.rMiddle = new G2Rotor(middle);
                this.rLeft = new G2Rotor(left);
                break;
            }
            case "G3": {
                this.rRight = new G3Rotor(right);
                this.rMiddle = new G3Rotor(middle);
                this.rLeft = new G3Rotor(left);
                break;
            }
            case "KT": {
                this.rRight = new KTRotor(right);
                this.rMiddle = new KTRotor(middle);
                this.rLeft = new KTRotor(left);
                break;
            }
            case "KS": {
                this.rRight = new KSRotor(right);
                this.rMiddle = new KSRotor(middle);
                this.rLeft = new KSRotor(left);
                break;
            }
            case "KR": {
                this.rRight = new KRRotor(right);
                this.rMiddle = new KRRotor(middle);
                this.rLeft = new KRRotor(left);
                break;
            }
            case "KD": {
                this.rRight = new KDRotor(right);
                this.rMiddle = new KDRotor(middle);
                this.rLeft = new KDRotor(left);
                break;
            }
            case "IS": {
                this.rRight = new ISRotor(right);
                this.rMiddle = new ISRotor(middle);
                this.rLeft = new ISRotor(left);
                break;
            }
            case "IN": {
                this.rRight = new INRotor(right);
                this.rMiddle = new INRotor(middle);
                this.rLeft = new INRotor(left);
                break;
            }
            case "IM3": {
                this.rRight = new IM3Rotor(right);
                this.rMiddle = new IM3Rotor(middle);
                this.rLeft = new IM3Rotor(left);
                break;
            }
            case "IM4": {
                this.rRight = new IM4Rotor(right);
                this.rMiddle = new IM4Rotor(middle);
                this.rLeft = new IM4Rotor(left);
                this.rExtra = new IM4Rotor(extra);
                break;
            }
            case "IM4D": {
                this.rRight = new IM4Rotor(right);
                this.rMiddle = new IM4Rotor(middle);
                this.rLeft = new IM4Rotor(left);
            }
        }
    }

    public void setReflector(String type) {
        block6 : switch (this.eType) {
            case "IS": 
            case "IN": {
                switch (type) {
                    case "UKW - A": {
                        this.ukw = new Reflector("I.UKW-A");
                        break;
                    }
                    case "UKW - B": {
                        this.ukw = new Reflector("I.UKW-B");
                        break;
                    }
                    case "UKW - C": {
                        this.ukw = new Reflector("I.UKW-C");
                    }
                }
                break;
            }
            case "IM3": {
                switch (type) {
                    case "UKW - B": {
                        this.ukw = new Reflector("M3.UKW-B");
                        break;
                    }
                    case "UKW - C": {
                        this.ukw = new Reflector("M3.UKW-C");
                    }
                }
                break;
            }
            case "IM4": {
                switch (type) {
                    case "UKW - B": {
                        this.ukw = new Reflector("M4.UKW-B");
                        break block6;
                    }
                    case "UKW - C": {
                        this.ukw = new Reflector("M4.UKW-C");
                    }
                }
            }
        }
    }

    public String getRotorType(String position) {
        String temp = null;
        switch (position) {
            case "RIGHT": {
                temp = this.rRight.getType();
                break;
            }
            case "MIDDLE": {
                temp = this.rMiddle.getType();
                break;
            }
            case "LEFT": {
                temp = this.rLeft.getType();
                break;
            }
            case "EXTRA": {
                if (!this.extraRotor) break;
                temp = this.rExtra.getType();
            }
        }
        return temp;
    }

    public String getRotorIndex(String position) {
        int temp = 0;
        switch (position) {
            case "RIGHT": {
                temp = this.rRight.getIndex();
                break;
            }
            case "MIDDLE": {
                temp = this.rMiddle.getIndex();
                break;
            }
            case "LEFT": {
                temp = this.rLeft.getIndex();
                break;
            }
            case "EXTRA": {
                if (!this.extraRotor) break;
                temp = this.rExtra.getIndex();
            }
        }
        return "" + temp;
    }

    public String getRotorOffset(String position) {
        String temp = null;
        switch (position) {
            case "RIGHT": {
                temp = this.rRight.getOffset();
                break;
            }
            case "MIDDLE": {
                temp = this.rMiddle.getOffset();
                break;
            }
            case "LEFT": {
                temp = this.rLeft.getOffset();
                break;
            }
            case "EXTRA": {
                if (!this.extraRotor) break;
                temp = this.rExtra.getOffset();
            }
        }
        return temp;
    }

    public String getReflectorType() {
        return this.ukw.getType();
    }

    public String getType() {
        return this.eType;
    }

    public void setRotorIndex(String position, String index) {
        char tempind = index.charAt(0);
        int found = 0;
        for (int i = 0; i < 26; ++i) {
            if (tempind != this.translate[i]) continue;
            found = i;
            break;
        }
        switch (position) {
            case "RIGHT": {
                this.rRight.setIndex(found);
                break;
            }
            case "MIDDLE": {
                this.rMiddle.setIndex(found);
                break;
            }
            case "LEFT": {
                this.rLeft.setIndex(found);
                break;
            }
            case "EXTRA": {
                if (!this.extraRotor) break;
                this.rExtra.setIndex(found);
            }
        }
    }

    public void setRotorOffset(String position, String offset) {
        char tempind = offset.charAt(0);
        switch (position) {
            case "RIGHT": {
                this.rRight.setOffset(tempind);
                break;
            }
            case "MIDDLE": {
                this.rMiddle.setOffset(tempind);
                break;
            }
            case "LEFT": {
                this.rLeft.setOffset(tempind);
                break;
            }
            case "EXTRA": {
                if (!this.extraRotor) break;
                this.rExtra.setOffset(tempind);
            }
        }
    }

    public void setUKWIndex(String index) {
        char tempind = index.charAt(0);
        int found = 0;
        for (int i = 0; i < 26; ++i) {
            if (tempind != this.translate[i]) continue;
            found = i;
        }
        this.ukw.setIndex(found);
    }

    public void setAnalytical(boolean state) {
        this.analytical = state;
        this.etw.setAnalytical(state);
        this.rLeft.setAnalytical(state);
        this.rMiddle.setAnalytical(state);
        this.rRight.setAnalytical(state);
        if (this.extraRotor) {
            this.rExtra.setAnalytical(state);
        }
        this.ukw.setAnalytical(state);
    }
}

