/*
 * Decompiled with CFR 0.152.
 */
package frames;

import enigma.SteppingMechanism;
import frames.AboutFrame;
import frames.HelpFrame;
import frames.KeyFrame;
import frames.Menu;
import frames.MessageFrame;
import frames.Setup;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.LayoutStyle;
import javax.swing.Painter;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileView;
import machines.EnigmaG;
import machines.EnigmaI;
import machines.EnigmaK;
import machines.LampFrame;
import machines.PlugboardFrame;
import machines.ReflectorFrame;

public class FrameAssistant
extends JPanel {
    private SteppingMechanism stepMech;
    private String stepType;
    private String frameType;
    private final JPopupMenu menu;
    private MessageFrame msgFrame;
    private PlugboardFrame plugboardFrame;
    private ReflectorFrame reflectorFrame;
    private KeyFrame keyFrame;
    private LampFrame lampFrame;
    private final ImageIcon KICON = new ImageIcon(this.getClass().getResource("/resources/EnigmaFileLogo.png"));
    private ImageIcon kicon;
    private AboutFrame aboutFrame;
    private HelpFrame helpFrame;
    private JButton exitBtn;
    private JButton iconifyBtn;
    private JButton menuBtn;

    public FrameAssistant(String type, SteppingMechanism sm) {
        this.frameType = type;
        this.menu = new JPopupMenu("Menu");
        this.stepMech = sm;
        if (this.stepMech != null) {
            this.stepType = this.stepMech.getType();
            this.keyFrame = new KeyFrame(this.stepMech);
            this.kicon = this.KICON;
            this.helpFrame = new HelpFrame();
            this.aboutFrame = new AboutFrame();
        }
        this.initComponents();
        this.menuSetUp();
        MoveMouseListener mml = new MoveMouseListener(this);
        this.addMouseListener(mml);
        this.addMouseMotionListener(mml);
        try {
            for (UIManager.LookAndFeelInfo laf : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(laf.getName())) continue;
                UIManager.setLookAndFeel(laf.getClassName());
                UIManager.getLookAndFeelDefaults().put("PopupMenu[Enabled].backgroundPainter", new FillPainter(new Color(222, 184, 135)));
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e) {
            // empty catch block
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        ImageIcon rotorImage;
        super.paintComponent(g);
        Graphics2D gRotor = (Graphics2D)g;
        switch (this.frameType) {
            case "MACHINE.ARMY": {
                rotorImage = new ImageIcon(this.getClass().getResource("/resources/box/BoxTopArmy.png"));
                break;
            }
            case "MACHINE.DEFAULT": {
                rotorImage = new ImageIcon(this.getClass().getResource("/resources/box/BoxTopDefault.png"));
                break;
            }
            case "INSTANT": {
                rotorImage = new ImageIcon(this.getClass().getResource("/resources/box/BoxTopPlain.png"));
                break;
            }
            default: {
                rotorImage = new ImageIcon(this.getClass().getResource("/resources/box/BoxTopPlain.png"));
            }
        }
        Image image = rotorImage.getImage();
        if (image != null) {
            if (this.frameType.equals("MACHINE.ARMY") || this.frameType.equals("MACHINE.DEFAULT")) {
                gRotor.drawImage(image, 0, 0, 380, 20, this);
            } else {
                gRotor.drawImage(image, 0, 0, 800, 20, this);
            }
        }
    }

    private void menuSetUp() {
        if (this.frameType.equals("MACHINE.ARMY") || this.frameType.equals("MACHINE.DEFAULT")) {
            PopupActionListener actionListener = new PopupActionListener();
            JMenu fileMenu = new JMenu("File");
            JMenuItem menuItem = new JMenuItem("Menu");
            JMenuItem newItem = new JMenuItem("New ..");
            JMenuItem loadItem = new JMenuItem("Load ..");
            JMenuItem saveItem = new JMenuItem("Save ..");
            menuItem.addActionListener(actionListener);
            newItem.addActionListener(actionListener);
            loadItem.addActionListener(actionListener);
            saveItem.addActionListener(actionListener);
            fileMenu.add(menuItem);
            fileMenu.addSeparator();
            fileMenu.add(newItem);
            fileMenu.add(saveItem);
            fileMenu.add(loadItem);
            JMenu editMenu = new JMenu("Edit");
            JMenuItem setItem = new JMenuItem("Settings");
            JMenuItem plugItem = new JMenuItem("Plugboard");
            JMenuItem refItem = new JMenuItem("Reflector");
            setItem.addActionListener(actionListener);
            plugItem.addActionListener(actionListener);
            refItem.addActionListener(actionListener);
            plugItem.setEnabled(false);
            refItem.setEnabled(false);
            setItem.setEnabled(false);
            if (this.stepType.equals("IS") || this.stepType.equals("IN") || this.stepType.equals("IM3") || this.stepType.equals("IM4") || this.stepType.equals("IM4D")) {
                plugItem.setEnabled(true);
            }
            if (this.stepType.equals("IM4D") || this.stepType.equals("KD")) {
                refItem.setEnabled(true);
            }
            editMenu.add(setItem);
            editMenu.addSeparator();
            editMenu.add(plugItem);
            editMenu.add(refItem);
            JMenu toolsMenu = new JMenu("Tools");
            JMenuItem msgItem = new JMenuItem("Message board");
            JMenuItem lampItem = new JMenuItem("Lamp panel");
            JMenuItem instItem = new JMenuItem("Instant Enigma");
            JMenuItem keyItem = new JMenuItem("View key");
            msgItem.addActionListener(actionListener);
            lampItem.addActionListener(actionListener);
            instItem.addActionListener(actionListener);
            keyItem.addActionListener(actionListener);
            lampItem.setEnabled(false);
            if (this.stepType.equals("KS")) {
                lampItem.setEnabled(true);
            }
            toolsMenu.add(keyItem);
            toolsMenu.add(msgItem);
            toolsMenu.add(lampItem);
            toolsMenu.addSeparator();
            toolsMenu.add(instItem);
            JMenu helpMenu = new JMenu("Information");
            JMenuItem aboutItem = new JMenuItem("About");
            JMenuItem processItem = new JMenuItem("Help");
            aboutItem.addActionListener(actionListener);
            processItem.addActionListener(actionListener);
            processItem.setEnabled(false);
            helpMenu.add(processItem);
            helpMenu.addSeparator();
            helpMenu.add(aboutItem);
            this.menu.add(fileMenu);
            this.menu.addSeparator();
            this.menu.add(editMenu);
            this.menu.add(toolsMenu);
            this.menu.add(helpMenu);
            this.menu.addSeparator();
            this.menu.add("Exit").addActionListener(actionListener);
        } else if (this.frameType.equals("INSTANT")) {
            PopupActionListener actionListener = new PopupActionListener();
            JMenu fileMenu = new JMenu("File");
            JMenuItem saveItem = new JMenuItem("Save ..");
            saveItem.addActionListener(actionListener);
            fileMenu.add(saveItem);
            JMenu editMenu = new JMenu("Edit");
            JMenuItem plugItem = new JMenuItem("Plugboard");
            JMenuItem refItem = new JMenuItem("Reflector");
            plugItem.addActionListener(actionListener);
            refItem.addActionListener(actionListener);
            plugItem.setEnabled(false);
            refItem.setEnabled(false);
            if (this.stepType.equals("IS") || this.stepType.equals("IN") || this.stepType.equals("IM3") || this.stepType.equals("IM4") || this.stepType.equals("IM4D")) {
                plugItem.setEnabled(true);
            }
            if (this.stepType.equals("IM4D") || this.stepType.equals("KD")) {
                refItem.setEnabled(true);
            }
            editMenu.add(plugItem);
            editMenu.add(refItem);
            JMenu toolsMenu = new JMenu("Tools");
            JMenuItem keyItem = new JMenuItem("View key");
            keyItem.addActionListener(actionListener);
            toolsMenu.add(keyItem);
            this.menu.add(fileMenu);
            this.menu.addSeparator();
            this.menu.add(editMenu);
            this.menu.add(toolsMenu);
            this.menu.addSeparator();
            this.menu.add("Exit").addActionListener(actionListener);
        } else {
            this.menuBtn.setEnabled(false);
            this.menuBtn.setVisible(false);
        }
    }

    private void saveKey() {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setDragEnabled(false);
        fileChooser.setDialogType(1);
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.setApproveButtonText("Save");
        fileChooser.setDialogTitle("Save Key");
        fileChooser.setFileSelectionMode(0);
        fileChooser.setFileFilter(new EnigmaFileFilter());
        fileChooser.setFileView(new EnigmaFileView());
        if (fileChooser.showSaveDialog(this) == 0) {
            boolean doExport = true;
            boolean overrideExistingFile = false;
            File destinationFile = new File(fileChooser.getSelectedFile().getAbsolutePath());
            while (doExport && destinationFile.exists() && !overrideExistingFile) {
                ImageIcon iconReplace = new ImageIcon(this.getClass().getResource("/resources/popup/Quest.png"));
                int response = JOptionPane.showConfirmDialog(this, "<html><strong style=\"font-size: 100%\">File already exists.</strong><br>Would you like to replace the file?<html>", "File Settings", 0, 3, iconReplace);
                if (response == 0) {
                    overrideExistingFile = true;
                }
                if (overrideExistingFile) continue;
                if (fileChooser.showSaveDialog(this) == 0) {
                    destinationFile = new File(fileChooser.getSelectedFile().getAbsolutePath());
                    continue;
                }
                doExport = false;
            }
            if (doExport) {
                try {
                    int i;
                    if (!fileChooser.getSelectedFile().getAbsolutePath().endsWith(".ek")) {
                        destinationFile = new File(destinationFile + ".ek");
                    }
                    BufferedWriter writer = new BufferedWriter(new FileWriter(destinationFile));
                    writer.write(this.stepMech.getType());
                    writer.newLine();
                    writer.write(this.stepMech.getReflectorType());
                    writer.newLine();
                    writer.write(this.stepMech.getRotorType("EXTRA") + " " + this.stepMech.getRotorType("LEFT") + " " + this.stepMech.getRotorType("MIDDLE") + " " + this.stepMech.getRotorType("RIGHT"));
                    writer.newLine();
                    writer.write(this.stepMech.getRotorOffset("EXTRA") + " " + this.stepMech.getRotorOffset("LEFT") + " " + this.stepMech.getRotorOffset("MIDDLE") + " " + this.stepMech.getRotorOffset("RIGHT"));
                    writer.newLine();
                    if (this.stepMech.getType().equals("IM4D") || this.stepMech.getType().equals("IM4") || this.stepMech.getType().equals("IM3") || this.stepMech.getType().equals("IS") || this.stepMech.getType().equals("IN")) {
                        String[] pairs = this.plugboardFrame.getPairs();
                        for (i = 0; i < pairs.length; ++i) {
                            writer.write(pairs[i] + " ");
                        }
                        writer.newLine();
                    }
                    if ("REWIRABLE".equals(this.stepMech.getReflectorType())) {
                        String[] pairs2 = this.reflectorFrame.getPairs();
                        for (i = 0; i < pairs2.length; ++i) {
                            writer.write(pairs2[i] + " ");
                        }
                    }
                    writer.close();
                    ImageIcon icon23 = new ImageIcon(this.getClass().getResource("/resources/popup/Passed.png"));
                    JOptionPane.showMessageDialog(this, "<html><strong style=\"font-size: 100%\">Key saved.</strong><br>The key file has been saved succesfully.<html>", "Key Saved", 1, icon23);
                }
                catch (IOException e) {
                    ImageIcon icon11 = new ImageIcon(this.getClass().getResource("/resources/popup/Failed.png"));
                    JOptionPane.showMessageDialog(this, "<html><strong style=\"font-size: 100%\">Key fault.</strong><br>The key file has not been saved succesfully.<html>", "Key Fault", 0, icon11);
                }
            }
        }
    }

    private void loadKey() {
        JFileChooser fileChooser2 = new JFileChooser();
        fileChooser2.setDragEnabled(false);
        fileChooser2.setDialogType(0);
        fileChooser2.setMultiSelectionEnabled(false);
        fileChooser2.setAcceptAllFileFilterUsed(false);
        fileChooser2.setApproveButtonText("Load");
        fileChooser2.setDialogTitle("Load Key");
        fileChooser2.setFileSelectionMode(0);
        fileChooser2.setFileFilter(new EnigmaFileFilter());
        fileChooser2.setFileView(new EnigmaFileView());
        String[] cables = null;
        String[] swaps = null;
        if (fileChooser2.showOpenDialog(this) == 0) {
            File destinationFile = new File(fileChooser2.getSelectedFile().getAbsolutePath());
            try {
                if (!fileChooser2.getSelectedFile().getAbsolutePath().endsWith(".ek")) {
                    destinationFile = new File(destinationFile + ".ek");
                }
                BufferedReader reader = new BufferedReader(new FileReader(destinationFile));
                String machineCode = reader.readLine();
                String reflectorCode = reader.readLine();
                String allRotorsCode = reader.readLine();
                String[] token = allRotorsCode.split(" ");
                String extraRotor = token[0];
                String leftRotor = token[1];
                String middleRotor = token[2];
                String rightRotor = token[3].trim();
                String allOffsets = reader.readLine();
                String[] token2 = allOffsets.split(" ");
                String extraOffset = token2[0];
                String leftOffset = token2[1];
                String middleOffset = token2[2];
                String rightOffset = token2[3].trim();
                if (machineCode.equals("IM4D") || machineCode.equals("IM4") || machineCode.equals("IM3") || machineCode.equals("IS") || machineCode.equals("IN")) {
                    String[] token3;
                    String allSwaps = reader.readLine();
                    cables = token3 = allSwaps.split(" ");
                }
                if (reflectorCode.equals("REWIRABLE")) {
                    String allRefSwaps = reader.readLine();
                    Object token4 = allRefSwaps.split(" ");
                    swaps = token4;
                }
                reader.close();
                SteppingMechanism sm = new SteppingMechanism(machineCode);
                sm.setReflector(reflectorCode);
                sm.setRotors(extraRotor, leftRotor, middleRotor, rightRotor);
                if (extraRotor != null) {
                    sm.setRotorOffset("EXTRA", extraOffset);
                }
                sm.setRotorOffset("LEFT", leftOffset);
                sm.setRotorOffset("MIDDLE", middleOffset);
                sm.setRotorOffset("RIGHT", rightOffset);
                switch (machineCode) {
                    case "D": 
                    case "KT": 
                    case "KS": 
                    case "KR": 
                    case "KD": {
                        EnigmaK enigmaK = new EnigmaK(sm);
                        if (machineCode.equals("KD")) {
                            enigmaK.getReflector().resetPlugs();
                            for (int i = 0; i < 12; ++i) {
                                if (swaps[i] == null) continue;
                                enigmaK.getReflector().plugCable(swaps[i].charAt(0));
                                enigmaK.getReflector().plugCable(swaps[i].charAt(1));
                            }
                        }
                        enigmaK.refresh();
                        enigmaK.setVisible(true);
                        this.disposeFrame();
                        break;
                    }
                    case "GA": 
                    case "G1": 
                    case "G2": 
                    case "G3": {
                        EnigmaG enigmaG = new EnigmaG(sm);
                        enigmaG.refresh();
                        enigmaG.setVisible(true);
                        this.disposeFrame();
                        break;
                    }
                    case "IS": 
                    case "IN": 
                    case "IM3": 
                    case "IM4": 
                    case "IM4D": {
                        int i;
                        EnigmaI enigmaI = new EnigmaI(sm);
                        if (machineCode.equals("IM4D")) {
                            enigmaI.getReflector().resetPlugs();
                            for (i = 0; i < 12; ++i) {
                                if (swaps[i] == null) continue;
                                enigmaI.getReflector().plugCable(swaps[i].charAt(0));
                                enigmaI.getReflector().plugCable(swaps[i].charAt(1));
                            }
                        }
                        enigmaI.getPlugboard().resetPlugs();
                        for (i = 0; i < 13; ++i) {
                            if (cables[i] == null) continue;
                            enigmaI.getPlugboard().plugCable(cables[i].charAt(0));
                            enigmaI.getPlugboard().plugCable(cables[i].charAt(1));
                        }
                        enigmaI.refresh();
                        enigmaI.setVisible(true);
                        this.disposeFrame();
                    }
                }
                ImageIcon icon = new ImageIcon(this.getClass().getResource("/resources/popup/Passed.png"));
                JOptionPane.showMessageDialog(this, "<html><strong style=\"font-size: 100%\">Key loaded.</strong><br>The key file has been loaded succesfully.<html>", "Key Loaded", 1, icon);
            }
            catch (IOException e) {
                ImageIcon icon3 = new ImageIcon(this.getClass().getResource("/resources/popup/Failed.png"));
                JOptionPane.showMessageDialog(this, "<html><strong style=\"font-size: 100%\">Key fault.</strong><br>The key file has not been loaded succesfully.<html>", "Key Fault", 0, icon3);
            }
        }
    }

    private void disposeFrame() {
        JFrame ancestorFrame = (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, this);
        if (this.keyFrame != null) {
            this.keyFrame.dispose();
        }
        if (this.msgFrame != null) {
            this.msgFrame.dispose();
        }
        if (this.plugboardFrame != null) {
            this.plugboardFrame.dispose();
        }
        if (this.reflectorFrame != null) {
            this.reflectorFrame.dispose();
        }
        if (this.lampFrame != null) {
            this.lampFrame.dispose();
        }
        if (this.aboutFrame != null) {
            this.aboutFrame.dispose();
        }
        if (this.helpFrame != null) {
            this.helpFrame.dispose();
        }
        ancestorFrame.dispose();
    }

    public void setFrames(MessageFrame msg, PlugboardFrame pf, ReflectorFrame rf, LampFrame lf) {
        this.msgFrame = msg;
        this.plugboardFrame = pf;
        this.reflectorFrame = rf;
        this.lampFrame = lf;
        this.keyFrame.setFrames(pf, rf);
    }

    public void setMachineFrames(PlugboardFrame pf, ReflectorFrame rf) {
        this.plugboardFrame = pf;
        this.reflectorFrame = rf;
    }

    private void initComponents() {
        this.exitBtn = new JButton();
        this.iconifyBtn = new JButton();
        this.menuBtn = new JButton();
        this.setToolTipText("Move");
        this.setMaximumSize(new Dimension(380, 20));
        this.setMinimumSize(new Dimension(380, 20));
        this.setPreferredSize(new Dimension(380, 20));
        this.exitBtn.setIcon(new ImageIcon(this.getClass().getResource("/resources/buttons/FrameClose.png")));
        this.exitBtn.setContentAreaFilled(false);
        this.exitBtn.setFocusable(false);
        this.exitBtn.setRolloverIcon(new ImageIcon(this.getClass().getResource("/resources/buttons/FrameCloseRollover.png")));
        this.exitBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameAssistant.this.exitBtnActionPerformed(evt);
            }
        });
        this.iconifyBtn.setIcon(new ImageIcon(this.getClass().getResource("/resources/buttons/FrameMinimize.png")));
        this.iconifyBtn.setContentAreaFilled(false);
        this.iconifyBtn.setFocusable(false);
        this.iconifyBtn.setRolloverIcon(new ImageIcon(this.getClass().getResource("/resources/buttons/FrameMinimizeRollover.png")));
        this.iconifyBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrameAssistant.this.iconifyBtnActionPerformed(evt);
            }
        });
        this.menuBtn.setIcon(new ImageIcon(this.getClass().getResource("/resources/Menu.png")));
        this.menuBtn.setContentAreaFilled(false);
        this.menuBtn.setFocusable(false);
        this.menuBtn.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/MenuPress.png")));
        this.menuBtn.setRolloverIcon(new ImageIcon(this.getClass().getResource("/resources/MenuRollover.png")));
        this.menuBtn.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                FrameAssistant.this.menuBtnMouseEntered(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(5, 5, 5).addComponent(this.menuBtn, -2, 30, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 307, Short.MAX_VALUE).addComponent(this.iconifyBtn, -2, 18, -2).addGap(0, 0, 0).addComponent(this.exitBtn, -2, 18, -2).addGap(2, 2, 2)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.iconifyBtn, -2, 20, -2).addComponent(this.exitBtn, -2, 20, -2).addComponent(this.menuBtn, -2, 20, -2)).addGap(3, 3, 3)));
    }

    private void exitBtnActionPerformed(ActionEvent evt) {
        switch (this.frameType) {
            case "MAIN": 
            case "MACHINE.ARMY": 
            case "MACHINE.DEFAULT": {
                ImageIcon iconReplace = new ImageIcon(this.getClass().getResource("/resources/popup/Quest.png"));
                int response = JOptionPane.showConfirmDialog(this, "<html><strong style=\"font-size: 100%\">Exit application.</strong><br>Would you like to exit the application?<html>", "Exit", 0, 3, iconReplace);
                if (response != 0) break;
                this.disposeFrame();
                System.exit(0);
                break;
            }
            case "POPUP": 
            case "INSTANT": {
                this.disposeFrame();
            }
        }
    }

    private void iconifyBtnActionPerformed(ActionEvent evt) {
        JFrame ancestorFrame = (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, this);
        ancestorFrame.setState(1);
    }

    private void menuBtnMouseEntered(MouseEvent evt) {
        this.menu.show(this.menuBtn, this.menuBtn.getWidth() / 4, this.menuBtn.getHeight() + 1);
    }

    private class MoveMouseListener
    implements MouseListener,
    MouseMotionListener {
        private Point initialClick;
        JComponent target;

        public MoveMouseListener(JComponent target) {
            this.target = target;
        }

        public JFrame getFrame(Container target) {
            if (target instanceof JFrame) {
                return (JFrame)target;
            }
            return this.getFrame(target.getParent());
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.initialClick = e.getPoint();
            FrameAssistant.this.getComponentAt(this.initialClick);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            try {
                JFrame frame = this.getFrame(this.target);
                int thisX = frame.getLocation().x;
                int thisY = frame.getLocation().y;
                int xMoved = thisX + e.getX() - (thisX + this.initialClick.x);
                int yMoved = thisY + e.getY() - (thisY + this.initialClick.y);
                int X = thisX + xMoved;
                int Y = thisY + yMoved;
                frame.setLocation(X, Y);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }
    }

    private static class FillPainter
    implements Painter<JComponent> {
        private final Color color;

        FillPainter(Color c) {
            this.color = c;
        }

        @Override
        public void paint(Graphics2D g, JComponent object, int width, int height) {
            g.setColor(this.color);
            g.fillRect(0, 0, width - 1, height - 1);
        }
    }

    private class PopupActionListener
    implements ActionListener {
        private PopupActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            switch (actionEvent.getActionCommand()) {
                case "Menu": {
                    Menu m = new Menu();
                    m.setVisible(true);
                    FrameAssistant.this.disposeFrame();
                    break;
                }
                case "New ..": {
                    Setup s = new Setup("MACHINE");
                    s.setVisible(true);
                    FrameAssistant.this.disposeFrame();
                    break;
                }
                case "Save ..": {
                    FrameAssistant.this.saveKey();
                    break;
                }
                case "Load ..": {
                    FrameAssistant.this.loadKey();
                    break;
                }
                case "Settings": {
                    break;
                }
                case "Plugboard": {
                    FrameAssistant.this.plugboardFrame.setVisible(true);
                    break;
                }
                case "Reflector": {
                    FrameAssistant.this.reflectorFrame.setVisible(true);
                    break;
                }
                case "Message board": {
                    FrameAssistant.this.msgFrame.setVisible(true);
                    break;
                }
                case "Instant Enigma": {
                    Setup ies = new Setup("INSTANT");
                    ies.setVisible(true);
                    break;
                }
                case "Lamp panel": {
                    FrameAssistant.this.lampFrame.setVisible(true);
                    break;
                }
                case "View key": {
                    FrameAssistant.this.keyFrame.refresh();
                    FrameAssistant.this.keyFrame.setVisible(true);
                    break;
                }
                case "About": {
                    FrameAssistant.this.aboutFrame.setVisible(true);
                    break;
                }
                case "Help": {
                    FrameAssistant.this.helpFrame.setVisible(true);
                    break;
                }
                case "Exit": {
                    FrameAssistant.this.exitBtn.doClick();
                }
            }
        }
    }

    private class EnigmaFileView
    extends FileView {
        protected ImageIcon KEY_ICON;

        private EnigmaFileView() {
            this.KEY_ICON = FrameAssistant.this.kicon;
        }

        @Override
        public Icon getIcon(File f) {
            String name = f.getName().toLowerCase();
            if (name.endsWith(".ek")) {
                return this.KEY_ICON;
            }
            return null;
        }
    }

    private class EnigmaFileFilter
    extends FileFilter {
        private EnigmaFileFilter() {
        }

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            return f.getName().toLowerCase().endsWith(".ek");
        }

        @Override
        public String getDescription() {
            return "Enigma Key (*.ek)";
        }
    }
}

