/*
 * Decompiled with CFR 0.152.
 */
package frames;

import enigma.SteppingMechanism;
import frames.FrameAssistant;
import frames.panels.InstantPanel1;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;

public class InstantEnigma
extends JFrame {
    private JLabel boxBottom;
    private JLabel boxLeft;
    private JLabel boxRight;

    public InstantEnigma(SteppingMechanism sm) {
        this.initComponents();
        this.customComponents(sm);
        this.loadFrameIcon();
    }

    private void customComponents(SteppingMechanism sm) {
        FrameAssistant frameAssist = new FrameAssistant("INSTANT", sm);
        InstantPanel1 instantPanel = new InstantPanel1(sm);
        switch (sm.getType()) {
            case "IS": 
            case "IN": 
            case "IM3": 
            case "IM4": {
                frameAssist.setFrames(null, instantPanel.getPlugboardFrame(), null, null);
                break;
            }
            case "IM4D": {
                frameAssist.setFrames(null, instantPanel.getPlugboardFrame(), instantPanel.getReflectorFrame(), null);
                break;
            }
            case "KD": {
                frameAssist.setFrames(null, null, instantPanel.getReflectorFrame(), null);
            }
        }
        this.getContentPane().add((Component)frameAssist, "First");
        this.getContentPane().add((Component)instantPanel, "Center");
        this.setTitle("Instant Enigma");
        Dimension d1 = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((d1.width - this.getSize().width) / 2, (d1.height - this.getSize().height) / 2);
        this.pack();
    }

    private void loadFrameIcon() {
        ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("/resources/EnigmaLogo32.png"));
        Image image = imageIcon.getImage();
        this.setIconImage(image);
    }

    private void initComponents() {
        this.boxLeft = new JLabel();
        this.boxRight = new JLabel();
        this.boxBottom = new JLabel();
        this.setDefaultCloseOperation(3);
        this.setMaximumSize(new Dimension(557, 420));
        this.setMinimumSize(new Dimension(557, 420));
        this.setUndecorated(true);
        this.setPreferredSize(new Dimension(557, 420));
        this.setResizable(false);
        this.boxLeft.setHorizontalAlignment(0);
        this.boxLeft.setIcon(new ImageIcon(this.getClass().getResource("/resources/box/BoxHorizontal.png")));
        this.boxLeft.setFocusable(false);
        this.getContentPane().add((Component)this.boxLeft, "Before");
        this.boxRight.setHorizontalAlignment(0);
        this.boxRight.setIcon(new ImageIcon(this.getClass().getResource("/resources/box/BoxHorizontal.png")));
        this.boxRight.setFocusable(false);
        this.getContentPane().add((Component)this.boxRight, "After");
        this.boxBottom.setHorizontalAlignment(0);
        this.boxBottom.setIcon(new ImageIcon(this.getClass().getResource("/resources/box/BoxBottomPlain.png")));
        this.boxBottom.setFocusable(false);
        this.getContentPane().add((Component)this.boxBottom, "Last");
        this.pack();
    }
}

