/*
 * Decompiled with CFR 0.152.
 */
package frames;

import enigma.SteppingMechanism;
import frames.FrameAssistant;
import frames.panels.KeyPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import machines.PlugboardFrame;
import machines.ReflectorFrame;

public class KeyFrame
extends JFrame {
    private SteppingMechanism stepMech;
    private KeyPanel keyPanel;
    private JLabel boxBottom;
    private JLabel boxLeft;
    private JLabel boxRight;

    public KeyFrame(SteppingMechanism sm) {
        this.stepMech = sm;
        this.initComponents();
        this.loadFrameIcon();
        FrameAssistant frameAssist = new FrameAssistant("POPUP", null);
        this.keyPanel = new KeyPanel(this.stepMech);
        this.getContentPane().add((Component)frameAssist, "First");
        this.getContentPane().add((Component)this.keyPanel, "Center");
        this.setTitle("Key");
        Dimension d1 = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((d1.width - this.getSize().width) / 2, (d1.height - this.getSize().height) / 2);
    }

    private void loadFrameIcon() {
        ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("/resources/EnigmaLogo32.png"));
        Image image = imageIcon.getImage();
        this.setIconImage(image);
    }

    public void refresh() {
        this.keyPanel.refresh();
    }

    public void setFrames(PlugboardFrame pf, ReflectorFrame rf) {
        this.keyPanel.setFrames(pf, rf);
    }

    private void initComponents() {
        this.boxLeft = new JLabel();
        this.boxRight = new JLabel();
        this.boxBottom = new JLabel();
        this.setDefaultCloseOperation(3);
        this.setMaximumSize(new Dimension(260, 435));
        this.setMinimumSize(new Dimension(260, 435));
        this.setUndecorated(true);
        this.setPreferredSize(new Dimension(260, 435));
        this.setResizable(false);
        this.boxLeft.setHorizontalAlignment(0);
        this.boxLeft.setIcon(new ImageIcon(this.getClass().getResource("/resources/box/BoxHorizontal.png")));
        this.boxLeft.setFocusable(false);
        this.getContentPane().add((Component)this.boxLeft, "Before");
        this.boxRight.setHorizontalAlignment(0);
        this.boxRight.setIcon(new ImageIcon(this.getClass().getResource("/resources/box/BoxHorizontal.png")));
        this.boxRight.setFocusable(false);
        this.getContentPane().add((Component)this.boxRight, "After");
        this.boxBottom.setHorizontalAlignment(0);
        this.boxBottom.setIcon(new ImageIcon(this.getClass().getResource("/resources/box/BoxBottomPlain.png")));
        this.boxBottom.setFocusable(false);
        this.getContentPane().add((Component)this.boxBottom, "Last");
        this.pack();
    }
}

