/*
 * Decompiled with CFR 0.152.
 */
package frames;

import frames.FrameAssistant;
import frames.panels.SetupPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;

public class Setup
extends JFrame {
    private String sType;
    private JLabel boxBottom;
    private JLabel boxLeft;
    private JLabel boxRight;

    public Setup(String type) {
        this.initComponents();
        this.sType = type;
        this.customComponents();
        this.loadFrameIcon();
    }

    private void customComponents() {
        FrameAssistant frameAssist = this.sType.equals("MACHINE") ? new FrameAssistant("MAIN", null) : new FrameAssistant("POPUP", null);
        SetupPanel setupPanel = new SetupPanel(this.sType);
        this.getContentPane().add((Component)frameAssist, "First");
        this.getContentPane().add((Component)setupPanel, "Center");
        this.setTitle("Machine Setup");
        Dimension d1 = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((d1.width - this.getSize().width) / 2, (d1.height - this.getSize().height) / 2);
        this.pack();
    }

    private void loadFrameIcon() {
        ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("/resources/EnigmaLogo32.png"));
        Image image = imageIcon.getImage();
        this.setIconImage(image);
    }

    private void initComponents() {
        this.boxLeft = new JLabel();
        this.boxRight = new JLabel();
        this.boxBottom = new JLabel();
        this.setDefaultCloseOperation(3);
        this.setMaximumSize(new Dimension(630, 360));
        this.setMinimumSize(new Dimension(630, 360));
        this.setUndecorated(true);
        this.setPreferredSize(new Dimension(630, 360));
        this.setResizable(false);
        this.boxLeft.setIcon(new ImageIcon(this.getClass().getResource("/resources/box/BoxHorizontal.png")));
        this.boxLeft.setFocusable(false);
        this.getContentPane().add((Component)this.boxLeft, "Before");
        this.boxRight.setHorizontalAlignment(0);
        this.boxRight.setIcon(new ImageIcon(this.getClass().getResource("/resources/box/BoxHorizontal.png")));
        this.boxRight.setFocusable(false);
        this.getContentPane().add((Component)this.boxRight, "After");
        this.boxBottom.setHorizontalAlignment(0);
        this.boxBottom.setIcon(new ImageIcon(this.getClass().getResource("/resources/box/BoxBottomPlain.png")));
        this.boxBottom.setFocusable(false);
        this.getContentPane().add((Component)this.boxBottom, "Last");
        this.pack();
    }
}

