/*
 * Decompiled with CFR 0.152.
 */
package frames.panels;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import javax.swing.AbstractListModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class HelpPanel
extends JPanel {
    private JList helpList;
    private JTextPane helpPane;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane3;
    private JLabel titleLabel;

    public HelpPanel() {
        this.initComponents();
        this.helpList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                if (evt.getValueIsAdjusting()) {
                    return;
                }
                HelpPanel.this.refreshPane(HelpPanel.this.helpList.getSelectedValue().toString());
            }
        });
    }

    private void refreshPane(String selection) {
        switch (selection) {
            case "Introduction": {
                this.helpPane.removeAll();
                this.helpPane.setText("The Enigma machine hidden within the scenes of World War II presents a mysterious yet fascinating tale of espionage, secrecy and rivalry between opposite forces. It was the most famous cryptographic machine in the time of World War II, a combination of technology ,code braking and intelligence. It is the story of showcasing the brilliance behind this ingenious device. Manufactured to the highest standards, it was advanced enough to cause major trouble to anyone that came across it. This is to show the true creativity and craftsmanship of individuals.");
                break;
            }
            case "Procedure": {
                this.helpPane.removeAll();
                this.helpPane.setText("In order for  the machine to be set, the following steps must apply1. Set the position of the 3 rotors (rotor sequence) from left to right on the rotor shaft2. Set the number or letter rings on one of the 26 possible settings  on each rotor(code wheel)3. Set the starting position of the 3 rotors. The number or letter should be visible through the 3 windows at the start of coding.4. Insert Double-plug Cables into the plug board(Patch panel).Set the plug- in wire connections from 0-13 wires into any of the 26 sockets on plugboardThe machine is set to go!");
                break;
            }
            case "Rules": {
                this.helpPane.removeAll();
                this.helpPane.setText("In order for the cryptographic process to work, the same settings are required on both sides of the correspondence. This is to say that when messages are due to either be encrypted or decrypted, the machines require the same Key. This theoretical key is needed because both machines must be set up in the exact same way at the start of each procedure. ");
                break;
            }
            case "Details": {
                this.helpPane.removeAll();
                this.helpPane.setText(" the Enigma machine is a combination of electro-mechanical components . The mechanical components  consists of a keyboard; a set of rotating wheel-disks, called rotors and a lamp panel. There is a variety of machines with different characteristics which can render them incompatible to each other. This does not mean that the working principle is affected. All the machines work under the exact same principle.  Even with Type G which appears to apply some apparent irregularity. They also share the same set of components with the exception of Type I that also incorporates the Plug-board. The mechanism incorporates a range of components to carry out the cryptographic procedure. When a key is pressed, an electric signal passes through all components. In this process, the character is translated from point to point, until it reaches the lamp panel where it is displayed. The actual cryptographic components required to complete the process are three. The electric signal enters the Stator where it is translated to a contact; it then passes through all the Rotors, reaching the Reflector. The Reflector then passes the signal back to the opposite direction where it makes a trip through the same components in reverse.");
                break;
            }
            case "History": {
                this.helpPane.removeAll();
                this.helpPane.setText("The Enigma cipher machine came out in the early 1900\u2019s, out of a necessity that runs throughout history, that of protecting, securing and hiding essential information. The primary use of the machine was for military purposes, it was further extended for civilian use. The invention of Enigma machine by Arthur Scherbius was a modern take on a century-old problem. The Enigma evolved through the years, proving further technological advancements in every part of its production. During that regarded era, it was considered as an impenetrable defence mechanism, symbolizing power and awe.  This device proved to be a Trojan horse, build by their very hands.  This Trojan horse was used by the allied forces to infiltrate enemy lines and bring a decisive victory that ended one of the greatest wars in history. ");
                break;
            }
            case "Website": {
                this.helpPane.removeAll();
                this.helpPane.setText("The website of the public enigma simulator is located at: https://webprojects.eecs.qmul.ac.uk/phm3");
                break;
            }
            case "Disclaimer": {
                this.helpPane.removeAll();
                this.helpPane.setText("This software and the accompanying files are supplied ''as is'' and without warranties of any kind, either expressed or implied, with respect to this product, its quality or performance for any particular purpose. The entire risk as to its quality and performance is with the user .In no event will  the author of this software be liable for any direct, indirect or consequential damages, resulting out of the use or inability to use this software.");
            }
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D background = (Graphics2D)g;
        ImageIcon paperImage = new ImageIcon(this.getClass().getResource("/resources/EnigmaPaper.png"));
        Image image = paperImage.getImage();
        if (image != null) {
            background.drawImage(image, 0, 0, 500, 500, this);
        }
    }

    private void initComponents() {
        this.titleLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.helpPane = new JTextPane();
        this.jScrollPane3 = new JScrollPane();
        this.helpList = new JList();
        this.jLabel1 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.jLabel9 = new JLabel();
        this.setMaximumSize(new Dimension(450, 450));
        this.setMinimumSize(new Dimension(450, 450));
        this.setPreferredSize(new Dimension(450, 450));
        this.titleLabel.setHorizontalAlignment(0);
        this.titleLabel.setIcon(new ImageIcon(this.getClass().getResource("/resources/banners/Help.png")));
        this.helpPane.setEditable(false);
        this.helpPane.setText("The Enigma machine hidden within the scenes of World War II presents a mysterious yet fascinating tale of espionage, secrecy and rivalry between opposite forces. It was the most famous cryptographic machine in the time of World War II, a combination of technology ,code braking and intelligence. It is the story of showcasing the brilliance behind this ingenious device. Manufactured to the highest standards, it was advanced enough to cause major trouble to anyone that came across it. This is to show the true creativity and craftsmanship of individuals.");
        this.jScrollPane1.setViewportView(this.helpPane);
        this.helpList.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Introduction", "Procedure", "Rules", "History", "Website", "Disclaimer"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.helpList.setSelectionMode(0);
        this.jScrollPane3.setViewportView(this.helpList);
        this.jLabel1.setHorizontalAlignment(4);
        this.jLabel1.setIcon(new ImageIcon(this.getClass().getResource("/resources/shadow_down.png")));
        this.jLabel1.setVerticalTextPosition(1);
        this.jLabel3.setIcon(new ImageIcon(this.getClass().getResource("/resources/shadow_left.png")));
        this.jLabel4.setHorizontalAlignment(4);
        this.jLabel4.setIcon(new ImageIcon(this.getClass().getResource("/resources/shadow_right_top.png")));
        this.jLabel4.setVerticalTextPosition(1);
        this.jLabel5.setHorizontalAlignment(4);
        this.jLabel5.setIcon(new ImageIcon(this.getClass().getResource("/resources/shadow_right_bottom.png")));
        this.jLabel5.setVerticalAlignment(3);
        this.jLabel6.setHorizontalAlignment(4);
        this.jLabel6.setIcon(new ImageIcon(this.getClass().getResource("/resources/shadow_left_bottom.png")));
        this.jLabel6.setVerticalAlignment(3);
        this.jLabel7.setIcon(new ImageIcon(this.getClass().getResource("/resources/shadow_right.png")));
        this.jLabel8.setHorizontalAlignment(4);
        this.jLabel8.setIcon(new ImageIcon(this.getClass().getResource("/resources/shadow_left_top.png")));
        this.jLabel8.setVerticalTextPosition(1);
        this.jLabel9.setHorizontalAlignment(4);
        this.jLabel9.setIcon(new ImageIcon(this.getClass().getResource("/resources/shadow_up.png")));
        this.jLabel9.setVerticalTextPosition(1);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel8).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jLabel7, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel6, -1, -1, Short.MAX_VALUE))).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1, -2, 0, Short.MAX_VALUE).addComponent(this.jLabel9, -2, 0, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane3, -2, 100, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 324, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.titleLabel, -2, 428, -2).addGap(0, 0, 0))).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel3, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel4, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel5))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1, -2, 10, -2).addGap(0, 0, 0).addComponent(this.titleLabel, -2, 60, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane3, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jScrollPane1, -1, 364, Short.MAX_VALUE)).addGap(0, 0, 0).addComponent(this.jLabel9, -2, 10, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel4).addGap(0, 0, 0).addComponent(this.jLabel3, -2, 0, Short.MAX_VALUE).addGap(0, 0, 0).addComponent(this.jLabel5)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel8).addGap(0, 0, 0).addComponent(this.jLabel7, -2, 0, Short.MAX_VALUE).addGap(0, 0, 0).addComponent(this.jLabel6)));
    }
}

