/*
 * Decompiled with CFR 0.152.
 */
package frames.panels;

import enigma.SteppingMechanism;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.filechooser.FileFilter;
import machines.PlugboardFrame;
import machines.ReflectorFrame;

public class InstantPanel
extends JPanel {
    private SteppingMechanism stepMech;
    private PlugboardFrame plugboardFrame;
    private ReflectorFrame reflectorFrame;
    private boolean ukwSettable;
    private boolean ukwMovable;
    private boolean extraRotor;
    private String message = "";
    private String convertion = "";
    private ArrayList charList = new ArrayList();
    private char cipher;
    private int charCount = 0;
    private char[] charFinder = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
    private int[] charFreq = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private char[] textArray;
    private String data;
    private JProgressBar aBar;
    private JProgressBar bBar;
    private JProgressBar cBar;
    private JTextArea convArea;
    private JProgressBar convBar;
    private JButton copyBtn;
    private JProgressBar dBar;
    private JPanel downPanel;
    private JProgressBar eBar;
    private JProgressBar fBar;
    private JPanel facePanel;
    private JButton farLeftDown;
    private JLabel farLeftFace;
    private JButton farLeftUp;
    private JPanel freqContPanel;
    private JPanel freqPanel;
    private JProgressBar gBar;
    private JProgressBar hBar;
    private JProgressBar iBar;
    private JProgressBar jBar;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JProgressBar kBar;
    private JProgressBar lBar;
    private JButton leftDown;
    private JLabel leftFace;
    private JButton leftUp;
    private JProgressBar mBar;
    private JPanel machinePanel;
    private JButton middleDown;
    private JLabel middleFace;
    private JButton middleUp;
    private JTextArea msgArea;
    private JProgressBar nBar;
    private JProgressBar oBar;
    private JProgressBar pBar;
    private JButton pasteBtn;
    private JButton plugBtn;
    private JProgressBar qBar;
    private JProgressBar rBar;
    private JButton resetBtn;
    private JButton rightDown;
    private JLabel rightFace;
    private JButton rightUp;
    private JProgressBar sBar;
    private JButton saveBtn;
    private JButton startBtn;
    private JProgressBar tBar;
    private JLabel titleLabel;
    private JPanel titlePanel;
    private JProgressBar uBar;
    private JButton ukwBtn;
    private JPanel upPanel;
    private JProgressBar vBar;
    private JProgressBar wBar;
    private JProgressBar xBar;
    private JProgressBar yBar;
    private JProgressBar zBar;

    public InstantPanel(SteppingMechanism sm) {
        this.initComponents();
        this.stepMech = sm;
        switch (this.stepMech.getType()) {
            case "D": 
            case "KT": 
            case "KS": 
            case "KR": {
                this.ukwSettable = true;
                this.ukwMovable = false;
                this.extraRotor = false;
                this.plugBtn.setEnabled(false);
                this.ukwBtn.setEnabled(false);
                break;
            }
            case "GA": 
            case "G1": 
            case "G2": 
            case "G3": {
                this.ukwSettable = true;
                this.ukwMovable = true;
                this.extraRotor = false;
                this.plugBtn.setEnabled(false);
                this.ukwBtn.setEnabled(false);
                break;
            }
            case "KD": {
                this.ukwSettable = false;
                this.ukwMovable = false;
                this.extraRotor = false;
                this.farLeftFace.setText("D");
                this.farLeftFace.setForeground(Color.red);
                this.farLeftUp.setVisible(false);
                this.farLeftUp.setEnabled(false);
                this.farLeftDown.setVisible(false);
                this.farLeftDown.setEnabled(false);
                this.plugBtn.setEnabled(false);
                this.ukwBtn.setEnabled(true);
                this.reflectorFrame = new ReflectorFrame(this.stepMech);
                break;
            }
            case "IS": 
            case "IN": 
            case "IM3": {
                this.ukwSettable = false;
                this.ukwMovable = false;
                this.extraRotor = false;
                this.farLeftFace.setText("-");
                this.farLeftUp.setVisible(false);
                this.farLeftUp.setEnabled(false);
                this.farLeftDown.setVisible(false);
                this.farLeftDown.setEnabled(false);
                this.plugBtn.setEnabled(true);
                this.ukwBtn.setEnabled(false);
                this.plugboardFrame = new PlugboardFrame();
                break;
            }
            case "IM4": {
                this.ukwSettable = false;
                this.ukwMovable = false;
                this.extraRotor = true;
                this.plugBtn.setEnabled(true);
                this.ukwBtn.setEnabled(false);
                this.plugboardFrame = new PlugboardFrame();
                break;
            }
            case "IM4D": {
                this.ukwSettable = false;
                this.ukwMovable = false;
                this.extraRotor = false;
                this.farLeftFace.setText("D");
                this.farLeftFace.setForeground(Color.red);
                this.farLeftUp.setVisible(false);
                this.farLeftUp.setEnabled(false);
                this.farLeftDown.setVisible(false);
                this.farLeftDown.setEnabled(false);
                this.plugBtn.setEnabled(true);
                this.ukwBtn.setEnabled(true);
                this.plugboardFrame = new PlugboardFrame();
                this.reflectorFrame = new ReflectorFrame(this.stepMech);
            }
        }
        this.updateFace();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D gPaper = (Graphics2D)g;
        ImageIcon paperImage = new ImageIcon(this.getClass().getResource("/resources/EnigmaPaper.png"));
        Image image = paperImage.getImage();
        if (image != null) {
            gPaper.drawImage(image, 0, 0, 550, 400, this);
        }
    }

    private void updateFace() {
        this.rightFace.setText(this.stepMech.getFace("RIGHT"));
        this.middleFace.setText(this.stepMech.getFace("MIDDLE"));
        this.leftFace.setText(this.stepMech.getFace("LEFT"));
        if (!(this.stepMech.getType().equals("IM3") || this.stepMech.getType().equals("IS") || this.stepMech.getType().equals("IN") || this.stepMech.getType().equals("IM4D") || this.stepMech.getType().equals("KD"))) {
            this.farLeftFace.setText(this.stepMech.getFace("FARLEFT"));
        }
    }

    private void saveMessage() {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setDragEnabled(false);
        fileChooser.setDialogType(1);
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.setApproveButtonText("Save");
        fileChooser.setDialogTitle("Save message");
        fileChooser.setFileSelectionMode(0);
        fileChooser.setFileFilter(new TextFileFilter());
        if (fileChooser.showSaveDialog(this) == 0) {
            boolean doExport = true;
            boolean overrideExistingFile = false;
            File destinationFile = new File(fileChooser.getSelectedFile().getAbsolutePath());
            while (doExport && destinationFile.exists() && !overrideExistingFile) {
                ImageIcon iconReplace = new ImageIcon(this.getClass().getResource("/resources/popup/Quest.png"));
                int response = JOptionPane.showConfirmDialog(this, "<html><strong style=\"font-size: 100%\">File already exists.</strong><br>Would you like to replace the file?<html>", "File Settings", 0, 3, iconReplace);
                if (response == 0) {
                    overrideExistingFile = true;
                }
                if (overrideExistingFile) continue;
                if (fileChooser.showSaveDialog(this) == 0) {
                    destinationFile = new File(fileChooser.getSelectedFile().getAbsolutePath());
                    continue;
                }
                doExport = false;
            }
            if (doExport) {
                try {
                    BufferedWriter writer = null;
                    if (!fileChooser.getSelectedFile().getAbsolutePath().endsWith(".txt")) {
                        destinationFile = new File(destinationFile + ".txt");
                    }
                    writer = new BufferedWriter(new FileWriter(destinationFile));
                    SimpleDateFormat dateFormat = new SimpleDateFormat("dd/mm/yy HH:mm");
                    Date date = new Date();
                    String timeString = "Date: " + dateFormat.format(date);
                    String plainString = this.msgArea.getText().toUpperCase().trim();
                    String cipherString = this.convArea.getText().toUpperCase().trim();
                    writer.write("Enigma Machine Message");
                    writer.newLine();
                    writer.write(timeString);
                    writer.newLine();
                    writer.newLine();
                    writer.newLine();
                    writer.write("Plain text: ");
                    writer.newLine();
                    writer.newLine();
                    writer.write(plainString);
                    writer.newLine();
                    writer.newLine();
                    writer.write("Cipher text: ");
                    writer.newLine();
                    writer.newLine();
                    writer.write(cipherString);
                    writer.newLine();
                    writer.close();
                    ImageIcon icon11 = new ImageIcon(this.getClass().getResource("/resources/popup/Passed.png"));
                    JOptionPane.showMessageDialog(this, "<html><strong style=\"font-size: 100%\">Message saved.</strong><br>The message has been saved sucessfully.<html>", "Message Saved", 1, icon11);
                }
                catch (IOException e) {
                    ImageIcon icon11 = new ImageIcon(this.getClass().getResource("/resources/popup/Failed.png"));
                    JOptionPane.showMessageDialog(this, "<html><strong style=\"font-size: 100%\">Message fault.</strong><br>The message file has not been saved succesfully.<html>", "Message Fault", 0, icon11);
                }
            }
        }
    }

    private void convertText() {
        boolean approved = false;
        if (this.stepMech.getType().equals("IM4D") || this.stepMech.getType().equals("KD")) {
            if (!this.reflectorFrame.getReflectorPanel().isFull()) {
                ImageIcon icon23 = new ImageIcon(this.getClass().getResource("/resources/popup/Info.png"));
                JOptionPane.showMessageDialog(this, "<html><strong style=\"font-size: 100%\">UKW-D is not fully wired.</strong><br>The machine will not operate correctly until<br>the reflector has been fitted with all twelve cables.<html>", "UKW-D reflector", 1, icon23);
            } else {
                approved = true;
            }
        } else {
            approved = true;
        }
        if (approved) {
            this.machineEnabled(false);
            this.convArea.setEnabled(false);
            this.msgArea.setEnabled(false);
            this.startBtn.setEnabled(false);
            this.resetBtn.setEnabled(false);
            this.pasteBtn.setEnabled(false);
            this.copyBtn.setEnabled(false);
            this.saveBtn.setEnabled(false);
            if (this.stepMech.getType().equals("IM4D") || this.stepMech.getType().equals("KD")) {
                this.reflectorFrame.setVisible(false);
                this.ukwBtn.setEnabled(false);
            }
            if (this.stepMech.getType().equals("IM3") || this.stepMech.getType().equals("IS") || this.stepMech.getType().equals("IN") || this.stepMech.getType().equals("IM4D") || this.stepMech.getType().equals("IM4")) {
                this.plugboardFrame.setVisible(false);
                this.plugBtn.setEnabled(false);
            }
            String alphaOnly = this.msgArea.getText().toUpperCase().trim().replaceAll("[^a-zA-Z]+", "");
            this.textArray = alphaOnly.toCharArray();
            this.convBar.setMaximum(this.textArray.length);
            this.convBar.setStringPainted(true);
            for (int i = 0; i < this.textArray.length; ++i) {
                char plain = this.textArray[i];
                this.stepMech.step();
                if (this.stepMech.getType().equals("IM3") || this.stepMech.getType().equals("IS") || this.stepMech.getType().equals("IN") || this.stepMech.getType().equals("IM4D") || this.stepMech.getType().equals("IM4")) {
                    plain = this.plugboardFrame.getPlugB().swap(plain);
                }
                this.cipher = this.stepMech.encipher(plain);
                if (this.stepMech.getType().equals("IM3") || this.stepMech.getType().equals("IS") || this.stepMech.getType().equals("IN") || this.stepMech.getType().equals("IM4D") || this.stepMech.getType().equals("IM4")) {
                    this.cipher = this.plugboardFrame.getPlugB().swap(this.cipher);
                }
                ++this.charCount;
                this.convBar.setValue(this.charCount);
                this.updateFace();
                this.convArea.append(Character.toString(this.cipher));
                this.calcFrequency(this.cipher);
            }
            this.msgArea.setEnabled(true);
            this.convArea.setEnabled(true);
            this.copyBtn.setEnabled(true);
            this.saveBtn.setEnabled(true);
            this.resetBtn.setEnabled(true);
            if (this.stepMech.getType().equals("IM4D") || this.stepMech.getType().equals("KD")) {
                this.ukwBtn.setEnabled(true);
            }
            if (this.stepMech.getType().equals("IM3") || this.stepMech.getType().equals("IS") || this.stepMech.getType().equals("IN") || this.stepMech.getType().equals("IM4D") || this.stepMech.getType().equals("IM4")) {
                this.plugBtn.setEnabled(true);
            }
        }
    }

    private void resetPanel() {
        this.convBar.setValue(0);
        this.charCount = 0;
        this.msgArea.setText("");
        this.convArea.setText("");
        this.convArea.setEnabled(false);
        this.startBtn.setEnabled(true);
        this.copyBtn.setEnabled(false);
        this.saveBtn.setEnabled(false);
        this.pasteBtn.setEnabled(true);
        this.stepMech.setRotorIndex("LEFT", "A");
        this.stepMech.setRotorIndex("MIDDLE", "A");
        this.stepMech.setRotorIndex("RIGHT", "A");
        this.stepMech.setRotorIndex("EXTRA", "A");
        if (this.ukwSettable || this.ukwMovable) {
            this.stepMech.setUKWIndex("A");
        }
        this.updateFace();
        this.machineEnabled(true);
        this.resetFreq();
    }

    private void machineEnabled(boolean state) {
        this.rightUp.setEnabled(state);
        this.middleUp.setEnabled(state);
        this.leftUp.setEnabled(state);
        this.farLeftUp.setEnabled(state);
        this.rightDown.setEnabled(state);
        this.middleDown.setEnabled(state);
        this.leftDown.setEnabled(state);
        this.farLeftDown.setEnabled(state);
    }

    private void calcFrequency(char input) {
        for (int i = 0; i < 26; ++i) {
            if (input != this.charFinder[i]) continue;
            this.charFreq[i] = this.charFreq[i] + 1;
        }
        this.aBar.setValue(50 + this.charFreq[0] * 100 / this.charCount);
        this.aBar.setToolTipText("A: " + this.charFreq[0] * 100 / this.charCount + "%");
        this.bBar.setValue(50 + this.charFreq[1] * 100 / this.charCount);
        this.bBar.setToolTipText("B: " + this.charFreq[1] * 100 / this.charCount + "%");
        this.cBar.setValue(50 + this.charFreq[2] * 100 / this.charCount);
        this.cBar.setToolTipText("C: " + this.charFreq[2] * 100 / this.charCount + "%");
        this.dBar.setValue(50 + this.charFreq[3] * 100 / this.charCount);
        this.dBar.setToolTipText("D: " + this.charFreq[3] * 100 / this.charCount + "%");
        this.eBar.setValue(50 + this.charFreq[4] * 100 / this.charCount);
        this.eBar.setToolTipText("E: " + this.charFreq[4] * 100 / this.charCount + "%");
        this.fBar.setValue(50 + this.charFreq[5] * 100 / this.charCount);
        this.fBar.setToolTipText("F: " + this.charFreq[5] * 100 / this.charCount + "%");
        this.gBar.setValue(50 + this.charFreq[6] * 100 / this.charCount);
        this.gBar.setToolTipText("G: " + this.charFreq[6] * 100 / this.charCount + "%");
        this.hBar.setValue(50 + this.charFreq[7] * 100 / this.charCount);
        this.hBar.setToolTipText("H: " + this.charFreq[7] * 100 / this.charCount + "%");
        this.iBar.setValue(50 + this.charFreq[8] * 100 / this.charCount);
        this.iBar.setToolTipText("I: " + this.charFreq[8] * 100 / this.charCount + "%");
        this.jBar.setValue(50 + this.charFreq[9] * 100 / this.charCount);
        this.jBar.setToolTipText("J: " + this.charFreq[9] * 100 / this.charCount + "%");
        this.kBar.setValue(50 + this.charFreq[10] * 100 / this.charCount);
        this.kBar.setToolTipText("K: " + this.charFreq[10] * 100 / this.charCount + "%");
        this.lBar.setValue(50 + this.charFreq[11] * 100 / this.charCount);
        this.lBar.setToolTipText("L: " + this.charFreq[11] * 100 / this.charCount + "%");
        this.mBar.setValue(50 + this.charFreq[12] * 100 / this.charCount);
        this.mBar.setToolTipText("M: " + this.charFreq[12] * 100 / this.charCount + "%");
        this.nBar.setValue(50 + this.charFreq[13] * 100 / this.charCount);
        this.nBar.setToolTipText("N: " + this.charFreq[13] * 100 / this.charCount + "%");
        this.oBar.setValue(50 + this.charFreq[14] * 100 / this.charCount);
        this.oBar.setToolTipText("O: " + this.charFreq[14] * 100 / this.charCount + "%");
        this.pBar.setValue(50 + this.charFreq[15] * 100 / this.charCount);
        this.pBar.setToolTipText("P: " + this.charFreq[15] * 100 / this.charCount + "%");
        this.qBar.setValue(50 + this.charFreq[16] * 100 / this.charCount);
        this.qBar.setToolTipText("Q: " + this.charFreq[16] * 100 / this.charCount + "%");
        this.rBar.setValue(50 + this.charFreq[17] * 100 / this.charCount);
        this.rBar.setToolTipText("R: " + this.charFreq[17] * 100 / this.charCount + "%");
        this.sBar.setValue(50 + this.charFreq[18] * 100 / this.charCount);
        this.sBar.setToolTipText("S: " + this.charFreq[18] * 100 / this.charCount + "%");
        this.tBar.setValue(50 + this.charFreq[19] * 100 / this.charCount);
        this.tBar.setToolTipText("T: " + this.charFreq[19] * 100 / this.charCount + "%");
        this.uBar.setValue(50 + this.charFreq[20] * 100 / this.charCount);
        this.uBar.setToolTipText("U: " + this.charFreq[20] * 100 / this.charCount + "%");
        this.vBar.setValue(50 + this.charFreq[21] * 100 / this.charCount);
        this.vBar.setToolTipText("V: " + this.charFreq[21] * 100 / this.charCount + "%");
        this.wBar.setValue(50 + this.charFreq[22] * 100 / this.charCount);
        this.wBar.setToolTipText("W: " + this.charFreq[22] * 100 / this.charCount + "%");
        this.xBar.setValue(50 + this.charFreq[23] * 100 / this.charCount);
        this.xBar.setToolTipText("X: " + this.charFreq[23] * 100 / this.charCount + "%");
        this.yBar.setValue(50 + this.charFreq[24] * 100 / this.charCount);
        this.yBar.setToolTipText("Y: " + this.charFreq[24] * 100 / this.charCount + "%");
        this.zBar.setValue(50 + this.charFreq[25] * 100 / this.charCount);
        this.zBar.setToolTipText("Z: " + this.charFreq[25] * 100 / this.charCount + "%");
    }

    private void resetFreq() {
        this.aBar.setValue(50);
        this.aBar.setToolTipText("A");
        this.bBar.setValue(50);
        this.bBar.setToolTipText("B");
        this.cBar.setValue(50);
        this.cBar.setToolTipText("C");
        this.dBar.setValue(50);
        this.dBar.setToolTipText("D");
        this.eBar.setValue(50);
        this.eBar.setToolTipText("E");
        this.fBar.setValue(50);
        this.fBar.setToolTipText("F");
        this.gBar.setValue(50);
        this.gBar.setToolTipText("G");
        this.hBar.setValue(50);
        this.hBar.setToolTipText("H");
        this.iBar.setValue(50);
        this.iBar.setToolTipText("I");
        this.jBar.setValue(50);
        this.jBar.setToolTipText("J");
        this.kBar.setValue(50);
        this.kBar.setToolTipText("K");
        this.lBar.setValue(50);
        this.lBar.setToolTipText("L");
        this.mBar.setValue(50);
        this.mBar.setToolTipText("M");
        this.nBar.setValue(50);
        this.nBar.setToolTipText("N");
        this.oBar.setValue(50);
        this.oBar.setToolTipText("O");
        this.pBar.setValue(50);
        this.pBar.setToolTipText("P");
        this.qBar.setValue(50);
        this.qBar.setToolTipText("Q");
        this.rBar.setValue(50);
        this.rBar.setToolTipText("R");
        this.sBar.setValue(50);
        this.sBar.setToolTipText("S");
        this.tBar.setValue(50);
        this.tBar.setToolTipText("T");
        this.uBar.setValue(50);
        this.uBar.setToolTipText("U");
        this.vBar.setValue(50);
        this.vBar.setToolTipText("V");
        this.wBar.setValue(50);
        this.wBar.setToolTipText("W");
        this.xBar.setValue(50);
        this.xBar.setToolTipText("X");
        this.yBar.setValue(50);
        this.yBar.setToolTipText("Y");
        this.zBar.setValue(50);
        this.zBar.setToolTipText("Z");
        for (int i = 0; i < 26; ++i) {
            this.charFreq[i] = 0;
        }
    }

    public ReflectorFrame getReflectorFrame() {
        return this.reflectorFrame;
    }

    public PlugboardFrame getPlugboardFrame() {
        return this.plugboardFrame;
    }

    private void initComponents() {
        this.pasteBtn = new JButton();
        this.copyBtn = new JButton();
        this.convBar = new JProgressBar();
        this.titlePanel = new JPanel();
        this.titleLabel = new JLabel();
        this.saveBtn = new JButton();
        this.jSeparator2 = new JSeparator();
        this.startBtn = new JButton();
        this.resetBtn = new JButton();
        this.jPanel1 = new JPanel();
        this.machinePanel = new JPanel();
        this.upPanel = new JPanel();
        this.leftUp = new JButton();
        this.middleUp = new JButton();
        this.rightUp = new JButton();
        this.farLeftUp = new JButton();
        this.downPanel = new JPanel();
        this.leftDown = new JButton();
        this.middleDown = new JButton();
        this.rightDown = new JButton();
        this.farLeftDown = new JButton();
        this.facePanel = new JPanel();
        this.leftFace = new JLabel();
        this.middleFace = new JLabel();
        this.rightFace = new JLabel();
        this.farLeftFace = new JLabel();
        this.jLabel1 = new JLabel();
        this.freqPanel = new JPanel();
        this.freqContPanel = new JPanel();
        this.sBar = new JProgressBar();
        this.uBar = new JProgressBar();
        this.nBar = new JProgressBar();
        this.mBar = new JProgressBar();
        this.lBar = new JProgressBar();
        this.kBar = new JProgressBar();
        this.rBar = new JProgressBar();
        this.qBar = new JProgressBar();
        this.pBar = new JProgressBar();
        this.yBar = new JProgressBar();
        this.oBar = new JProgressBar();
        this.fBar = new JProgressBar();
        this.xBar = new JProgressBar();
        this.gBar = new JProgressBar();
        this.dBar = new JProgressBar();
        this.vBar = new JProgressBar();
        this.eBar = new JProgressBar();
        this.wBar = new JProgressBar();
        this.cBar = new JProgressBar();
        this.bBar = new JProgressBar();
        this.aBar = new JProgressBar();
        this.zBar = new JProgressBar();
        this.tBar = new JProgressBar();
        this.iBar = new JProgressBar();
        this.hBar = new JProgressBar();
        this.jBar = new JProgressBar();
        this.jLabel2 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.msgArea = new JTextArea();
        this.jScrollPane2 = new JScrollPane();
        this.convArea = new JTextArea();
        this.plugBtn = new JButton();
        this.ukwBtn = new JButton();
        this.jSeparator3 = new JSeparator();
        this.pasteBtn.setIcon(new ImageIcon(this.getClass().getResource("/resources/buttons/Paste.png")));
        this.pasteBtn.setContentAreaFilled(false);
        this.pasteBtn.setCursor(new Cursor(12));
        this.pasteBtn.setFocusable(false);
        this.pasteBtn.setMaximumSize(new Dimension(67, 26));
        this.pasteBtn.setMinimumSize(new Dimension(67, 26));
        this.pasteBtn.setPreferredSize(new Dimension(67, 26));
        this.pasteBtn.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/buttons/PastePress.png")));
        this.pasteBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InstantPanel.this.pasteBtnActionPerformed(evt);
            }
        });
        this.copyBtn.setIcon(new ImageIcon(this.getClass().getResource("/resources/buttons/Copy.png")));
        this.copyBtn.setToolTipText("");
        this.copyBtn.setContentAreaFilled(false);
        this.copyBtn.setCursor(new Cursor(12));
        this.copyBtn.setEnabled(false);
        this.copyBtn.setFocusable(false);
        this.copyBtn.setMaximumSize(new Dimension(67, 26));
        this.copyBtn.setMinimumSize(new Dimension(67, 26));
        this.copyBtn.setPreferredSize(new Dimension(67, 26));
        this.copyBtn.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/buttons/CopyPress.png")));
        this.copyBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InstantPanel.this.copyBtnActionPerformed(evt);
            }
        });
        this.convBar.setFocusable(false);
        this.convBar.setMaximumSize(new Dimension(146, 14));
        this.convBar.setMinimumSize(new Dimension(146, 14));
        this.titlePanel.setFocusable(false);
        this.titlePanel.setOpaque(false);
        this.titleLabel.setHorizontalAlignment(0);
        this.titleLabel.setIcon(new ImageIcon(this.getClass().getResource("/resources/banners/InstantEnigma.png")));
        this.titleLabel.setFocusable(false);
        this.titlePanel.add(this.titleLabel);
        this.saveBtn.setIcon(new ImageIcon(this.getClass().getResource("/resources/buttons/Save.png")));
        this.saveBtn.setContentAreaFilled(false);
        this.saveBtn.setCursor(new Cursor(12));
        this.saveBtn.setEnabled(false);
        this.saveBtn.setFocusable(false);
        this.saveBtn.setMaximumSize(new Dimension(67, 26));
        this.saveBtn.setMinimumSize(new Dimension(67, 26));
        this.saveBtn.setPreferredSize(new Dimension(67, 26));
        this.saveBtn.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/buttons/SavePress.png")));
        this.saveBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InstantPanel.this.saveBtnActionPerformed(evt);
            }
        });
        this.startBtn.setIcon(new ImageIcon(this.getClass().getResource("/resources/buttons/Start.png")));
        this.startBtn.setContentAreaFilled(false);
        this.startBtn.setCursor(new Cursor(12));
        this.startBtn.setFocusable(false);
        this.startBtn.setMaximumSize(new Dimension(67, 26));
        this.startBtn.setMinimumSize(new Dimension(67, 26));
        this.startBtn.setPreferredSize(new Dimension(67, 26));
        this.startBtn.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/buttons/StartPress.png")));
        this.startBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InstantPanel.this.startBtnActionPerformed(evt);
            }
        });
        this.resetBtn.setIcon(new ImageIcon(this.getClass().getResource("/resources/buttons/Reset.png")));
        this.resetBtn.setContentAreaFilled(false);
        this.resetBtn.setCursor(new Cursor(12));
        this.resetBtn.setFocusable(false);
        this.resetBtn.setMaximumSize(new Dimension(67, 26));
        this.resetBtn.setMinimumSize(new Dimension(67, 26));
        this.resetBtn.setPreferredSize(new Dimension(67, 26));
        this.resetBtn.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/buttons/ResetPress.png")));
        this.resetBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InstantPanel.this.resetBtnActionPerformed(evt);
            }
        });
        this.jPanel1.setOpaque(false);
        this.machinePanel.setFocusable(false);
        this.machinePanel.setMaximumSize(new Dimension(130, 120));
        this.machinePanel.setMinimumSize(new Dimension(130, 120));
        this.machinePanel.setOpaque(false);
        this.machinePanel.setPreferredSize(new Dimension(130, 120));
        this.machinePanel.setLayout(null);
        this.upPanel.setBackground(new Color(255, 51, 51));
        this.upPanel.setOpaque(false);
        this.leftUp.setContentAreaFilled(false);
        this.leftUp.setCursor(new Cursor(12));
        this.leftUp.setFocusable(false);
        this.leftUp.setRolloverIcon(new ImageIcon(this.getClass().getResource("/resources/buttons/ArrowUp.png")));
        this.leftUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InstantPanel.this.leftUpActionPerformed(evt);
            }
        });
        this.middleUp.setContentAreaFilled(false);
        this.middleUp.setCursor(new Cursor(12));
        this.middleUp.setFocusable(false);
        this.middleUp.setRolloverIcon(new ImageIcon(this.getClass().getResource("/resources/buttons/ArrowUp.png")));
        this.middleUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InstantPanel.this.middleUpActionPerformed(evt);
            }
        });
        this.rightUp.setContentAreaFilled(false);
        this.rightUp.setCursor(new Cursor(12));
        this.rightUp.setFocusable(false);
        this.rightUp.setRolloverIcon(new ImageIcon(this.getClass().getResource("/resources/buttons/ArrowUp.png")));
        this.rightUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InstantPanel.this.rightUpActionPerformed(evt);
            }
        });
        this.farLeftUp.setContentAreaFilled(false);
        this.farLeftUp.setCursor(new Cursor(12));
        this.farLeftUp.setFocusable(false);
        this.farLeftUp.setRolloverIcon(new ImageIcon(this.getClass().getResource("/resources/buttons/ArrowUp.png")));
        this.farLeftUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InstantPanel.this.farLeftUpActionPerformed(evt);
            }
        });
        GroupLayout upPanelLayout = new GroupLayout(this.upPanel);
        this.upPanel.setLayout(upPanelLayout);
        upPanelLayout.setHorizontalGroup(upPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(upPanelLayout.createSequentialGroup().addGap(11, 11, 11).addComponent(this.farLeftUp, -2, 30, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.leftUp, -2, 30, -2).addGap(8, 8, 8).addComponent(this.middleUp, -2, 30, -2).addGap(9, 9, 9).addComponent(this.rightUp, -2, 30, -2).addContainerGap()));
        upPanelLayout.setVerticalGroup(upPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(upPanelLayout.createSequentialGroup().addGap(5, 5, 5).addGroup(upPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.leftUp, GroupLayout.Alignment.TRAILING, -2, 30, -2).addComponent(this.farLeftUp, GroupLayout.Alignment.TRAILING, -2, 30, -2).addComponent(this.middleUp, GroupLayout.Alignment.TRAILING, -2, 30, -2).addComponent(this.rightUp, GroupLayout.Alignment.TRAILING, -2, 30, -2))));
        this.machinePanel.add(this.upPanel);
        this.upPanel.setBounds(0, 10, 160, 40);
        this.downPanel.setBackground(new Color(204, 51, 0));
        this.downPanel.setOpaque(false);
        this.leftDown.setContentAreaFilled(false);
        this.leftDown.setCursor(new Cursor(12));
        this.leftDown.setFocusable(false);
        this.leftDown.setRolloverIcon(new ImageIcon(this.getClass().getResource("/resources/buttons/ArrowDown.png")));
        this.leftDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InstantPanel.this.leftDownActionPerformed(evt);
            }
        });
        this.middleDown.setContentAreaFilled(false);
        this.middleDown.setCursor(new Cursor(12));
        this.middleDown.setFocusable(false);
        this.middleDown.setRolloverIcon(new ImageIcon(this.getClass().getResource("/resources/buttons/ArrowDown.png")));
        this.middleDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InstantPanel.this.middleDownActionPerformed(evt);
            }
        });
        this.rightDown.setContentAreaFilled(false);
        this.rightDown.setCursor(new Cursor(12));
        this.rightDown.setFocusable(false);
        this.rightDown.setRolloverIcon(new ImageIcon(this.getClass().getResource("/resources/buttons/ArrowDown.png")));
        this.rightDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InstantPanel.this.rightDownActionPerformed(evt);
            }
        });
        this.farLeftDown.setContentAreaFilled(false);
        this.farLeftDown.setCursor(new Cursor(12));
        this.farLeftDown.setFocusable(false);
        this.farLeftDown.setRolloverIcon(new ImageIcon(this.getClass().getResource("/resources/buttons/ArrowDown.png")));
        this.farLeftDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InstantPanel.this.farLeftDownActionPerformed(evt);
            }
        });
        GroupLayout downPanelLayout = new GroupLayout(this.downPanel);
        this.downPanel.setLayout(downPanelLayout);
        downPanelLayout.setHorizontalGroup(downPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(downPanelLayout.createSequentialGroup().addGap(11, 11, 11).addComponent(this.farLeftDown, -2, 30, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.leftDown, -2, 30, -2).addGap(8, 8, 8).addComponent(this.middleDown, -2, 30, -2).addGap(9, 9, 9).addComponent(this.rightDown, -2, 30, -2).addContainerGap()));
        downPanelLayout.setVerticalGroup(downPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.farLeftDown, GroupLayout.Alignment.TRAILING, -2, 30, -2).addComponent(this.leftDown, GroupLayout.Alignment.TRAILING, -2, 30, -2).addComponent(this.middleDown, GroupLayout.Alignment.TRAILING, -2, 30, -2).addComponent(this.rightDown, GroupLayout.Alignment.TRAILING, -2, 30, -2));
        this.machinePanel.add(this.downPanel);
        this.downPanel.setBounds(0, 70, 160, 30);
        this.facePanel.setOpaque(false);
        this.leftFace.setFont(new Font("Arial", 1, 11));
        this.leftFace.setHorizontalAlignment(0);
        this.leftFace.setText("A");
        this.leftFace.setHorizontalTextPosition(0);
        this.leftFace.setMaximumSize(new Dimension(20, 20));
        this.leftFace.setMinimumSize(new Dimension(20, 20));
        this.middleFace.setFont(new Font("Arial", 1, 11));
        this.middleFace.setHorizontalAlignment(0);
        this.middleFace.setText("A");
        this.middleFace.setHorizontalTextPosition(0);
        this.middleFace.setMaximumSize(new Dimension(20, 20));
        this.middleFace.setMinimumSize(new Dimension(20, 20));
        this.rightFace.setFont(new Font("Arial", 1, 11));
        this.rightFace.setHorizontalAlignment(0);
        this.rightFace.setText("A");
        this.rightFace.setHorizontalTextPosition(0);
        this.rightFace.setMaximumSize(new Dimension(20, 20));
        this.rightFace.setMinimumSize(new Dimension(20, 20));
        this.farLeftFace.setFont(new Font("Arial", 1, 11));
        this.farLeftFace.setHorizontalAlignment(0);
        this.farLeftFace.setText("A");
        GroupLayout facePanelLayout = new GroupLayout(this.facePanel);
        this.facePanel.setLayout(facePanelLayout);
        facePanelLayout.setHorizontalGroup(facePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(facePanelLayout.createSequentialGroup().addGap(17, 17, 17).addComponent(this.farLeftFace, -2, 16, -2).addGap(21, 21, 21).addComponent(this.leftFace, -2, 16, -2).addGap(22, 22, 22).addComponent(this.middleFace, -2, 16, -2).addGap(23, 23, 23).addComponent(this.rightFace, -2, 16, -2).addGap(17, 17, 17)));
        facePanelLayout.setVerticalGroup(facePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, facePanelLayout.createSequentialGroup().addGap(1, 1, 1).addGroup(facePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.leftFace, -2, 16, -2).addComponent(this.middleFace, -2, 16, -2).addComponent(this.rightFace, -2, 16, -2).addComponent(this.farLeftFace, -2, 16, -2))));
        this.machinePanel.add(this.facePanel);
        this.facePanel.setBounds(0, 48, 160, 17);
        this.jLabel1.setHorizontalAlignment(0);
        this.jLabel1.setIcon(new ImageIcon(this.getClass().getResource("/resources/MiniPanel.png")));
        this.machinePanel.add(this.jLabel1);
        this.jLabel1.setBounds(0, 0, 164, 113);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.machinePanel, -2, 164, -2).addGap(0, 2, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.machinePanel, -2, 112, -2).addGap(0, 0, 0)));
        this.freqPanel.setFocusable(false);
        this.freqPanel.setMaximumSize(new Dimension(166, 112));
        this.freqPanel.setMinimumSize(new Dimension(166, 112));
        this.freqPanel.setOpaque(false);
        this.freqPanel.setPreferredSize(new Dimension(166, 112));
        this.freqPanel.setLayout(null);
        this.freqContPanel.setFocusable(false);
        this.freqContPanel.setOpaque(false);
        this.sBar.setOrientation(1);
        this.sBar.setToolTipText("S");
        this.sBar.setValue(50);
        this.sBar.setFocusable(false);
        this.uBar.setOrientation(1);
        this.uBar.setToolTipText("U");
        this.uBar.setValue(50);
        this.uBar.setFocusable(false);
        this.nBar.setOrientation(1);
        this.nBar.setToolTipText("N");
        this.nBar.setValue(50);
        this.nBar.setFocusable(false);
        this.mBar.setOrientation(1);
        this.mBar.setToolTipText("M");
        this.mBar.setValue(50);
        this.mBar.setFocusable(false);
        this.lBar.setOrientation(1);
        this.lBar.setToolTipText("L");
        this.lBar.setValue(50);
        this.lBar.setFocusable(false);
        this.kBar.setOrientation(1);
        this.kBar.setToolTipText("K");
        this.kBar.setValue(50);
        this.kBar.setFocusable(false);
        this.rBar.setOrientation(1);
        this.rBar.setToolTipText("R");
        this.rBar.setValue(50);
        this.rBar.setFocusable(false);
        this.qBar.setOrientation(1);
        this.qBar.setToolTipText("Q");
        this.qBar.setValue(50);
        this.qBar.setFocusable(false);
        this.pBar.setOrientation(1);
        this.pBar.setToolTipText("P");
        this.pBar.setValue(50);
        this.pBar.setFocusable(false);
        this.yBar.setOrientation(1);
        this.yBar.setToolTipText("Y");
        this.yBar.setValue(50);
        this.yBar.setFocusable(false);
        this.oBar.setOrientation(1);
        this.oBar.setToolTipText("O");
        this.oBar.setValue(50);
        this.oBar.setFocusable(false);
        this.fBar.setOrientation(1);
        this.fBar.setToolTipText("F");
        this.fBar.setValue(50);
        this.fBar.setFocusable(false);
        this.xBar.setOrientation(1);
        this.xBar.setToolTipText("X");
        this.xBar.setValue(50);
        this.xBar.setFocusable(false);
        this.gBar.setOrientation(1);
        this.gBar.setToolTipText("G");
        this.gBar.setValue(50);
        this.gBar.setFocusable(false);
        this.dBar.setOrientation(1);
        this.dBar.setToolTipText("D");
        this.dBar.setValue(50);
        this.dBar.setFocusable(false);
        this.vBar.setOrientation(1);
        this.vBar.setToolTipText("V");
        this.vBar.setValue(50);
        this.vBar.setFocusable(false);
        this.eBar.setOrientation(1);
        this.eBar.setToolTipText("E");
        this.eBar.setValue(50);
        this.eBar.setFocusable(false);
        this.wBar.setOrientation(1);
        this.wBar.setToolTipText("W");
        this.wBar.setValue(50);
        this.wBar.setFocusable(false);
        this.cBar.setOrientation(1);
        this.cBar.setToolTipText("C");
        this.cBar.setValue(50);
        this.cBar.setFocusable(false);
        this.bBar.setOrientation(1);
        this.bBar.setToolTipText("B");
        this.bBar.setValue(50);
        this.bBar.setFocusable(false);
        this.aBar.setOrientation(1);
        this.aBar.setToolTipText("A");
        this.aBar.setValue(50);
        this.aBar.setFocusable(false);
        this.zBar.setOrientation(1);
        this.zBar.setToolTipText("Z");
        this.zBar.setValue(50);
        this.zBar.setFocusable(false);
        this.tBar.setOrientation(1);
        this.tBar.setToolTipText("T");
        this.tBar.setValue(50);
        this.tBar.setFocusable(false);
        this.iBar.setOrientation(1);
        this.iBar.setToolTipText("I");
        this.iBar.setValue(50);
        this.iBar.setFocusable(false);
        this.hBar.setOrientation(1);
        this.hBar.setToolTipText("H");
        this.hBar.setValue(50);
        this.hBar.setFocusable(false);
        this.jBar.setOrientation(1);
        this.jBar.setToolTipText("J");
        this.jBar.setValue(50);
        this.jBar.setFocusable(false);
        GroupLayout freqContPanelLayout = new GroupLayout(this.freqContPanel);
        this.freqContPanel.setLayout(freqContPanelLayout);
        freqContPanelLayout.setHorizontalGroup(freqContPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(freqContPanelLayout.createSequentialGroup().addGap(5, 5, 5).addComponent(this.aBar, -2, 4, -2).addGap(2, 2, 2).addComponent(this.bBar, -2, 4, -2).addGap(2, 2, 2).addComponent(this.cBar, -2, 4, -2).addGap(2, 2, 2).addComponent(this.dBar, -2, 4, -2).addGap(2, 2, 2).addComponent(this.eBar, -2, 4, -2).addGap(2, 2, 2).addComponent(this.fBar, -2, 4, -2).addGap(2, 2, 2).addComponent(this.gBar, -2, 4, -2).addGap(2, 2, 2).addComponent(this.hBar, -2, 4, -2).addGap(2, 2, 2).addComponent(this.iBar, -2, 4, -2).addGap(2, 2, 2).addComponent(this.jBar, -2, 4, -2).addGap(2, 2, 2).addComponent(this.kBar, -2, 4, -2).addGap(2, 2, 2).addComponent(this.lBar, -2, 4, -2).addGap(2, 2, 2).addComponent(this.mBar, -2, 4, -2).addGap(2, 2, 2).addComponent(this.nBar, -2, 4, -2).addGap(2, 2, 2).addComponent(this.oBar, -2, 4, -2).addGap(2, 2, 2).addComponent(this.pBar, -2, 4, -2).addGap(2, 2, 2).addComponent(this.qBar, -2, 4, -2).addGap(2, 2, 2).addComponent(this.rBar, -2, 4, -2).addGap(2, 2, 2).addComponent(this.sBar, -2, 4, -2).addGap(2, 2, 2).addComponent(this.tBar, -2, 4, -2).addGap(2, 2, 2).addComponent(this.uBar, -2, 4, -2).addGap(2, 2, 2).addComponent(this.vBar, -2, 4, -2).addGap(2, 2, 2).addComponent(this.wBar, -2, 4, -2).addGap(2, 2, 2).addComponent(this.xBar, -2, 4, -2).addGap(2, 2, 2).addComponent(this.yBar, -2, 4, -2).addGap(2, 2, 2).addComponent(this.zBar, -2, 4, -2).addGap(2, 2, 2)));
        freqContPanelLayout.setVerticalGroup(freqContPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, freqContPanelLayout.createSequentialGroup().addGap(4, 4, 4).addGroup(freqContPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.bBar, GroupLayout.Alignment.TRAILING, -2, 90, -2).addComponent(this.cBar, GroupLayout.Alignment.TRAILING, -2, 90, -2).addComponent(this.dBar, GroupLayout.Alignment.TRAILING, -2, 90, -2).addComponent(this.eBar, -2, 90, -2).addComponent(this.aBar, -2, 90, -2).addComponent(this.fBar, GroupLayout.Alignment.TRAILING, -2, 90, -2).addComponent(this.gBar, -2, 90, -2).addComponent(this.hBar, -2, 90, -2).addComponent(this.iBar, GroupLayout.Alignment.TRAILING, -2, 90, -2).addComponent(this.jBar, -2, 90, -2).addComponent(this.kBar, -2, 90, -2).addComponent(this.lBar, -2, 90, -2).addComponent(this.mBar, -2, 90, -2).addComponent(this.nBar, -2, 90, -2).addComponent(this.oBar, -2, 90, -2).addComponent(this.pBar, -2, 90, -2).addComponent(this.qBar, -2, 90, -2).addComponent(this.rBar, -2, 90, -2).addComponent(this.sBar, -2, 90, -2).addComponent(this.tBar, -2, 90, -2).addComponent(this.uBar, -2, 90, -2).addComponent(this.vBar, GroupLayout.Alignment.TRAILING, -2, 90, -2).addComponent(this.wBar, -2, 90, -2).addComponent(this.xBar, -2, 90, -2).addComponent(this.yBar, -2, 90, -2).addComponent(this.zBar, -2, 90, -2)).addContainerGap()));
        this.freqPanel.add(this.freqContPanel);
        this.freqContPanel.setBounds(0, 10, 161, 100);
        this.jLabel2.setHorizontalAlignment(0);
        this.jLabel2.setIcon(new ImageIcon(this.getClass().getResource("/resources/MiniMetal.png")));
        this.freqPanel.add(this.jLabel2);
        this.jLabel2.setBounds(0, 0, 164, 113);
        this.msgArea.setColumns(20);
        this.msgArea.setFont(new Font("Arial", 0, 11));
        this.msgArea.setLineWrap(true);
        this.msgArea.setRows(5);
        this.msgArea.setWrapStyleWord(true);
        this.msgArea.setCaretPosition(this.msgArea.getDocument().getLength());
        this.jScrollPane1.setViewportView(this.msgArea);
        this.convArea.setEditable(false);
        this.convArea.setColumns(20);
        this.convArea.setFont(new Font("Arial", 0, 11));
        this.convArea.setLineWrap(true);
        this.convArea.setRows(5);
        this.convArea.setWrapStyleWord(true);
        this.convArea.setCaretPosition(this.convArea.getDocument().getLength());
        this.convArea.setEnabled(false);
        this.jScrollPane2.setViewportView(this.convArea);
        this.plugBtn.setIcon(new ImageIcon(this.getClass().getResource("/resources/buttons/Plugs.png")));
        this.plugBtn.setContentAreaFilled(false);
        this.plugBtn.setEnabled(false);
        this.plugBtn.setMaximumSize(new Dimension(67, 26));
        this.plugBtn.setMinimumSize(new Dimension(67, 26));
        this.plugBtn.setPreferredSize(new Dimension(67, 26));
        this.plugBtn.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/buttons/PlugsPressed.png")));
        this.plugBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InstantPanel.this.plugBtnActionPerformed(evt);
            }
        });
        this.ukwBtn.setIcon(new ImageIcon(this.getClass().getResource("/resources/buttons/UKWD.png")));
        this.ukwBtn.setContentAreaFilled(false);
        this.ukwBtn.setEnabled(false);
        this.ukwBtn.setMaximumSize(new Dimension(67, 26));
        this.ukwBtn.setMinimumSize(new Dimension(67, 26));
        this.ukwBtn.setPreferredSize(new Dimension(67, 26));
        this.ukwBtn.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/buttons/UKWDPress.png")));
        this.ukwBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InstantPanel.this.ukwBtnActionPerformed(evt);
            }
        });
        this.jSeparator3.setOrientation(1);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(8, 8, 8).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane2, -2, 333, -2).addComponent(this.jSeparator2, -2, 513, -2)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.titlePanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.startBtn, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.resetBtn, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.plugBtn, -2, 67, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ukwBtn, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.pasteBtn, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.copyBtn, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.saveBtn, -2, -1, -2)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, GroupLayout.Alignment.TRAILING, -2, -1, -2).addComponent(this.freqPanel, -2, -1, -2)).addGap(5, 5, 5).addComponent(this.jSeparator3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.convBar, -1, -1, Short.MAX_VALUE).addComponent(this.jScrollPane1, -1, 333, Short.MAX_VALUE)))))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.titlePanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jScrollPane1).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)).addGap(2, 2, 2).addComponent(this.convBar, -2, -1, -2).addGap(2, 2, 2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.freqPanel, -2, -1, -2).addComponent(this.jScrollPane2, -2, 113, -2))).addComponent(this.jSeparator3, -2, 245, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator2, -2, 2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.startBtn, -2, -1, -2).addComponent(this.saveBtn, GroupLayout.Alignment.TRAILING, -2, -1, -2)).addComponent(this.pasteBtn, GroupLayout.Alignment.TRAILING, -2, -1, -2)).addComponent(this.copyBtn, -2, -1, -2)).addComponent(this.plugBtn, -2, -1, -2).addComponent(this.ukwBtn, -2, -1, -2).addComponent(this.resetBtn, -2, -1, -2)).addContainerGap()));
    }

    private void copyBtnActionPerformed(ActionEvent evt) {
        String info = "Enigma Machine Message\n";
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd/mm/yy HH:mm");
        Date date = new Date();
        String time = "Date: " + dateFormat.format(date) + "\n";
        String plainString = this.msgArea.getText().toUpperCase().trim();
        String cipherString = this.convArea.getText().toUpperCase().trim();
        String outputText = info + time + "\n\nPlain text:\n\n" + plainString + "\n\nCipher text: \n\n" + cipherString;
        StringSelection stringSelection = new StringSelection(outputText);
        Clipboard clpbrd = Toolkit.getDefaultToolkit().getSystemClipboard();
        clpbrd.setContents(stringSelection, null);
        ImageIcon icon11 = new ImageIcon(this.getClass().getResource("/resources/popup/Passed.png"));
        JOptionPane.showMessageDialog(this, "<html><strong style=\"font-size: 100%\">Message copied.</strong><br>The message has been copied to the clipboard.<html>", "Message copied", 1, icon11);
    }

    private void middleDownActionPerformed(ActionEvent evt) {
        this.stepMech.rotorDown("MIDDLE");
        this.middleFace.setText(this.stepMech.getFace("MIDDLE"));
    }

    private void rightUpActionPerformed(ActionEvent evt) {
        this.stepMech.rotorUp("RIGHT");
        this.rightFace.setText(this.stepMech.getFace("RIGHT"));
    }

    private void middleUpActionPerformed(ActionEvent evt) {
        this.stepMech.rotorUp("MIDDLE");
        this.middleFace.setText(this.stepMech.getFace("MIDDLE"));
    }

    private void leftUpActionPerformed(ActionEvent evt) {
        this.stepMech.rotorUp("LEFT");
        this.leftFace.setText(this.stepMech.getFace("LEFT"));
    }

    private void rightDownActionPerformed(ActionEvent evt) {
        this.stepMech.rotorDown("RIGHT");
        this.rightFace.setText(this.stepMech.getFace("RIGHT"));
    }

    private void leftDownActionPerformed(ActionEvent evt) {
        this.stepMech.rotorDown("LEFT");
        this.leftFace.setText(this.stepMech.getFace("LEFT"));
    }

    private void startBtnActionPerformed(ActionEvent evt) {
        if ("".equals(this.msgArea.getText().trim())) {
            ImageIcon icon2 = new ImageIcon(this.getClass().getResource("/resources/popup/Info.png"));
            JOptionPane.showMessageDialog(this, "<html><strong style=\"font-size: 100%\">Message area is empty.</strong><br>No data due for convertion<html>", "No data", 2, icon2);
        } else {
            ConvertionThread myThread = new ConvertionThread();
            myThread.start();
        }
    }

    private void pasteBtnActionPerformed(ActionEvent evt) {
        String dataTemp = "";
        try {
            dataTemp = (String)Toolkit.getDefaultToolkit().getSystemClipboard().getData(DataFlavor.stringFlavor);
        }
        catch (UnsupportedFlavorException | IOException ex) {
            ImageIcon icon2 = new ImageIcon(this.getClass().getResource("/resources/popup/NotAllowed.png"));
            JOptionPane.showMessageDialog(this, "<html><strong style=\"font-size: 100%\">Invalid data.</strong><br>The imported data is not valid.<br>Please make sure it is a text file.<html>", "Indvalid data", 2, icon2);
        }
        this.msgArea.setText(dataTemp);
    }

    private void saveBtnActionPerformed(ActionEvent evt) {
        this.saveMessage();
    }

    private void resetBtnActionPerformed(ActionEvent evt) {
        this.resetPanel();
    }

    private void farLeftDownActionPerformed(ActionEvent evt) {
        this.stepMech.rotorDown("FARLEFT");
        this.farLeftFace.setText(this.stepMech.getFace("FARLEFT"));
    }

    private void farLeftUpActionPerformed(ActionEvent evt) {
        this.stepMech.rotorUp("FARLEFT");
        this.farLeftFace.setText(this.stepMech.getFace("FARLEFT"));
    }

    private void plugBtnActionPerformed(ActionEvent evt) {
        this.plugboardFrame.setVisible(true);
    }

    private void ukwBtnActionPerformed(ActionEvent evt) {
        this.reflectorFrame.setVisible(true);
    }

    public class TextFileFilter
    extends FileFilter {
        @Override
        public boolean accept(File file) {
            return file.getName().toLowerCase().endsWith(".txt") || file.isDirectory();
        }

        @Override
        public String getDescription() {
            return "Text File (*.txt)";
        }
    }

    private class ConvertionThread
    extends Thread {
        private ConvertionThread() {
        }

        @Override
        public void run() {
            InstantPanel.this.convertText();
        }
    }
}

