/*
 * Decompiled with CFR 0.152.
 */
package frames.panels;

import enigma.SteppingMechanism;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import machines.PlugboardFrame;
import machines.ReflectorFrame;

public class KeyPanel
extends JPanel {
    private SteppingMechanism stepMech;
    private ReflectorFrame ukw;
    private PlugboardFrame plugboard;
    private String[] translator = new String[]{"01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26"};
    private String[] contacts = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JTextField machineInfo;
    private JTextField offsetsInfo;
    private JTextField reflectorInfo;
    private JTextField rotorsInfo;
    private JTextField swapsInfo;
    private JTextField ukwdInfo;

    public KeyPanel(SteppingMechanism sm) {
        this.stepMech = sm;
        this.initComponents();
    }

    public void setFrames(PlugboardFrame pf, ReflectorFrame rf) {
        this.plugboard = pf;
        this.ukw = rf;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D gPaper = (Graphics2D)g;
        ImageIcon paperImage = new ImageIcon(this.getClass().getResource("/resources/EnigmaPaper.png"));
        Image image = paperImage.getImage();
        if (image != null) {
            gPaper.drawImage(image, 0, 0, 250, 410, this);
        }
    }

    private String machineType() {
        String eType;
        switch (eType = this.stepMech.getType()) {
            case "D": {
                eType = "Enigma D -- Commecrial";
                break;
            }
            case "GA": {
                eType = "Enigma A28 -- Z\u00e4hlwerk";
                break;
            }
            case "G1": {
                eType = "Enigma G31 -- Z\u00e4hlwerk (G-111)";
                break;
            }
            case "G2": {
                eType = "Enigma G31 -- Abwehr (G-260)";
                break;
            }
            case "G3": {
                eType = "Enigma G31 -- Abwehr (G-312)";
                break;
            }
            case "KT": {
                eType = "Enigma T -- Tirpitz";
                break;
            }
            case "KS": {
                eType = "Enigma K -- Swiss";
                break;
            }
            case "KR": {
                eType = "Enigma K -- Railway";
                break;
            }
            case "KD": {
                eType = "Enigma KD -- Mil Amt";
                break;
            }
            case "IS": {
                eType = "Enigma I -- Service";
                break;
            }
            case "IN": {
                eType = "Enigma I -- Norway";
                break;
            }
            case "IM3": {
                eType = "Enigma M3 -- Heer";
                break;
            }
            case "IM4": {
                eType = "Enigma M4 -- Shark";
                break;
            }
            case "IM4D": {
                eType = "Enigma M4 -- Shark";
            }
        }
        return eType;
    }

    private String reflectorType() {
        String rType;
        switch (rType = this.stepMech.getReflectorType()) {
            case "DEFAULT": 
            case "RAILWAY": 
            case "NORWAY": 
            case "TIRPITZ": 
            case "G3": {
                rType = "UKW";
                break;
            }
            case "I.UKW-A": {
                rType = "UKW - A";
                break;
            }
            case "I.UKW-B": 
            case "M3.UKW-B": 
            case "M4.UKW-B": {
                rType = "UKW - B";
                break;
            }
            case "I.UKW-C": 
            case "M3.UKW-C": 
            case "M4.UKW-C": {
                rType = "UKW - C";
                break;
            }
            case "REWIRABLE": {
                rType = "UKW - D";
            }
        }
        return rType;
    }

    private String rotorArrangement() {
        String arrangement = this.stepMech.getRotorType("EXTRA");
        if (arrangement == null) {
            arrangement = "";
        }
        arrangement = arrangement + "  " + this.stepMech.getRotorType("LEFT") + "  ";
        arrangement = arrangement + this.stepMech.getRotorType("MIDDLE") + "  ";
        arrangement = arrangement + this.stepMech.getRotorType("RIGHT");
        return arrangement;
    }

    private String offsetArrangement() {
        int i;
        String arrangement = this.stepMech.getRotorOffset("EXTRA");
        if (arrangement == null) {
            arrangement = "";
        } else {
            for (i = 0; i < 26; ++i) {
                if (!arrangement.equals(this.contacts[i])) continue;
                arrangement = this.contacts[i] + "-" + this.translator[i] + "  ";
                break;
            }
        }
        for (i = 0; i < 26; ++i) {
            if (!this.stepMech.getRotorOffset("LEFT").equals(this.contacts[i])) continue;
            arrangement = arrangement + this.contacts[i] + "-" + this.translator[i] + "  ";
            break;
        }
        for (i = 0; i < 26; ++i) {
            if (!this.stepMech.getRotorOffset("MIDDLE").equals(this.contacts[i])) continue;
            arrangement = arrangement + this.contacts[i] + "-" + this.translator[i] + "  ";
            break;
        }
        for (i = 0; i < 26; ++i) {
            if (!this.stepMech.getRotorOffset("RIGHT").equals(this.contacts[i])) continue;
            arrangement = arrangement + this.contacts[i] + "-" + this.translator[i];
            break;
        }
        return arrangement;
    }

    private String plugboardPairs() {
        String pairsInfo = "";
        if (this.stepMech.getType().equals("IS") || this.stepMech.getType().equals("IN") || this.stepMech.getType().equals("IM3") || this.stepMech.getType().equals("IM4") || this.stepMech.getType().equals("IM4D")) {
            this.swapsInfo.setEnabled(true);
            this.jLabel6.setEnabled(true);
            String[] pairs = this.plugboard.getPairs();
            if (pairs.length != 0) {
                for (int i = 0; i < 13; ++i) {
                    if (pairs[i] == null) continue;
                    pairsInfo = pairsInfo + pairs[i] + " ";
                }
            }
        } else {
            pairsInfo = "";
        }
        return pairsInfo;
    }

    private String ukwdPairs() {
        String pairsInfo = "JY ";
        if (this.reflectorType().equals("UKW - D")) {
            this.ukwdInfo.setEnabled(true);
            this.jLabel7.setEnabled(true);
            String[] pairs = this.ukw.getPairs();
            if (pairs.length != 0) {
                for (int i = 0; i < 12; ++i) {
                    if (pairs[i] == null) continue;
                    pairsInfo = pairsInfo + pairs[i] + " ";
                }
            }
        } else {
            pairsInfo = "";
        }
        return pairsInfo;
    }

    public void refresh() {
        this.machineInfo.removeAll();
        this.reflectorInfo.removeAll();
        this.rotorsInfo.removeAll();
        this.offsetsInfo.removeAll();
        this.swapsInfo.removeAll();
        this.ukwdInfo.removeAll();
        this.machineInfo.setText(this.machineType());
        this.reflectorInfo.setText(this.reflectorType());
        this.rotorsInfo.setText(this.rotorArrangement());
        this.offsetsInfo.setText(this.offsetArrangement());
        this.swapsInfo.setText(this.plugboardPairs());
        this.ukwdInfo.setText(this.ukwdPairs());
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.rotorsInfo = new JTextField();
        this.reflectorInfo = new JTextField();
        this.machineInfo = new JTextField();
        this.offsetsInfo = new JTextField();
        this.swapsInfo = new JTextField();
        this.ukwdInfo = new JTextField();
        this.jLabel8 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jLabel10 = new JLabel();
        this.jLabel11 = new JLabel();
        this.jLabel12 = new JLabel();
        this.jLabel13 = new JLabel();
        this.jLabel14 = new JLabel();
        this.jLabel15 = new JLabel();
        this.jLabel1.setHorizontalAlignment(0);
        this.jLabel1.setIcon(new ImageIcon(this.getClass().getResource("/resources/banners/Key.png")));
        this.jLabel2.setText("Machine: ");
        this.jLabel3.setText("Reflector:");
        this.jLabel4.setText("Rotors: ");
        this.jLabel5.setText("Offsets:");
        this.jLabel6.setText("Plugboard:");
        this.jLabel6.setToolTipText("");
        this.jLabel6.setEnabled(false);
        this.jLabel7.setText("UKW-D:");
        this.jLabel7.setEnabled(false);
        this.rotorsInfo.setEditable(false);
        this.rotorsInfo.setFont(new Font("Arial", 0, 12));
        this.rotorsInfo.setHorizontalAlignment(0);
        this.rotorsInfo.setFocusable(false);
        this.reflectorInfo.setEditable(false);
        this.reflectorInfo.setFont(new Font("Arial", 0, 12));
        this.reflectorInfo.setHorizontalAlignment(0);
        this.reflectorInfo.setFocusable(false);
        this.machineInfo.setEditable(false);
        this.machineInfo.setFont(new Font("Arial", 0, 12));
        this.machineInfo.setHorizontalAlignment(0);
        this.machineInfo.setFocusable(false);
        this.offsetsInfo.setEditable(false);
        this.offsetsInfo.setFont(new Font("Arial", 0, 12));
        this.offsetsInfo.setHorizontalAlignment(0);
        this.offsetsInfo.setFocusable(false);
        this.swapsInfo.setEditable(false);
        this.swapsInfo.setFont(new Font("Arial", 0, 9));
        this.swapsInfo.setHorizontalAlignment(0);
        this.swapsInfo.setEnabled(false);
        this.swapsInfo.setFocusable(false);
        this.ukwdInfo.setEditable(false);
        this.ukwdInfo.setFont(new Font("Arial", 0, 9));
        this.ukwdInfo.setHorizontalAlignment(0);
        this.ukwdInfo.setEnabled(false);
        this.ukwdInfo.setFocusable(false);
        this.jLabel8.setHorizontalAlignment(4);
        this.jLabel8.setIcon(new ImageIcon(this.getClass().getResource("/resources/shadow_left_top.png")));
        this.jLabel8.setVerticalTextPosition(1);
        this.jLabel9.setIcon(new ImageIcon(this.getClass().getResource("/resources/shadow_right.png")));
        this.jLabel10.setHorizontalAlignment(4);
        this.jLabel10.setIcon(new ImageIcon(this.getClass().getResource("/resources/shadow_left_bottom.png")));
        this.jLabel10.setVerticalAlignment(3);
        this.jLabel11.setHorizontalAlignment(4);
        this.jLabel11.setIcon(new ImageIcon(this.getClass().getResource("/resources/shadow_down.png")));
        this.jLabel11.setVerticalTextPosition(1);
        this.jLabel12.setHorizontalAlignment(4);
        this.jLabel12.setIcon(new ImageIcon(this.getClass().getResource("/resources/shadow_up.png")));
        this.jLabel12.setVerticalTextPosition(1);
        this.jLabel13.setHorizontalAlignment(4);
        this.jLabel13.setIcon(new ImageIcon(this.getClass().getResource("/resources/shadow_right_top.png")));
        this.jLabel13.setVerticalTextPosition(1);
        this.jLabel14.setIcon(new ImageIcon(this.getClass().getResource("/resources/shadow_left.png")));
        this.jLabel15.setHorizontalAlignment(4);
        this.jLabel15.setIcon(new ImageIcon(this.getClass().getResource("/resources/shadow_right_bottom.png")));
        this.jLabel15.setVerticalAlignment(3);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel8).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jLabel9, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel10))).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 0, 0).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel5, -2, 60, -2).addComponent(this.jLabel7, -2, 60, -2).addComponent(this.jLabel2, -2, 60, -2).addComponent(this.jLabel3, -2, 60, -2).addComponent(this.jLabel4, -2, 60, -2).addComponent(this.jLabel6).addComponent(this.ukwdInfo).addComponent(this.swapsInfo).addComponent(this.offsetsInfo).addComponent(this.rotorsInfo).addComponent(this.reflectorInfo).addComponent(this.machineInfo).addComponent(this.jLabel1, -1, 220, Short.MAX_VALUE)).addGap(0, 0, 0)).addGroup(layout.createSequentialGroup().addGap(0, 0, 0).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel12, -2, 0, Short.MAX_VALUE).addComponent(this.jLabel11, -2, 0, Short.MAX_VALUE)))).addGap(0, 0, 0).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel14, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel13, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel15)).addGap(0, 0, 0)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel11, -2, 10, -2).addGap(0, 0, 0).addComponent(this.jLabel1, -2, 60, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addGap(1, 1, 1).addComponent(this.machineInfo, -2, 30, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3).addGap(1, 1, 1).addComponent(this.reflectorInfo, -2, 30, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel4).addGap(1, 1, 1).addComponent(this.rotorsInfo, -2, 30, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel5).addGap(1, 1, 1).addComponent(this.offsetsInfo, -2, 30, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel6).addGap(1, 1, 1).addComponent(this.swapsInfo, -2, 30, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel7).addGap(1, 1, 1).addComponent(this.ukwdInfo, -2, 30, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jLabel12, -2, 10, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel8).addGap(0, 0, 0).addComponent(this.jLabel9, -2, 0, Short.MAX_VALUE).addGap(0, 0, 0).addComponent(this.jLabel10)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel13).addGap(0, 0, 0).addComponent(this.jLabel14, -2, 0, Short.MAX_VALUE).addGap(0, 0, 0).addComponent(this.jLabel15)));
    }
}

