/*
 * Decompiled with CFR 0.152.
 */
package frames.panels;

import enigma.SteppingMechanism;
import frames.AboutFrame;
import frames.HelpFrame;
import frames.Setup;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileView;
import machines.EnigmaG;
import machines.EnigmaI;
import machines.EnigmaK;

public class MenuPanel
extends JPanel {
    private final ImageIcon KICON = new ImageIcon(this.getClass().getResource("/resources/EnigmaFileLogo.png"));
    private ImageIcon kicon;
    private AboutFrame aboutFrame = new AboutFrame();
    private HelpFrame helpFrame = new HelpFrame();
    private JButton AboutFilmBtn;
    private JLabel blueStampLabel;
    private JLabel clipperTapeLabel;
    private JLabel codebookLabel;
    private JButton exitBtn;
    private JButton helpBtn;
    private JLabel horTapeLabel;
    private JButton instantBtn;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel leftTapeLabel;
    private JLabel leftTapeLabel1;
    private JButton loadBtn;
    private JPanel menuCard;
    private JLabel paperLabel;
    private JLabel pinLabel;
    private JLabel postLabel;
    private JLabel redStampLabel;
    private JLabel rightTapeLabel;
    private JButton startBtn;
    private JLabel titleLabel;
    private JPanel titlePanel;

    public MenuPanel() {
        this.initComponents();
        this.kicon = this.KICON;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D gPaper = (Graphics2D)g;
        ImageIcon paperImage = new ImageIcon(this.getClass().getResource("/resources/EnigmaPaper.png"));
        Image image = paperImage.getImage();
        if (image != null) {
            gPaper.drawImage(image, 0, 0, 420, 400, this);
        }
    }

    private void loadKey() {
        JFileChooser fileChooser2 = new JFileChooser();
        fileChooser2.setDragEnabled(false);
        fileChooser2.setDialogType(0);
        fileChooser2.setMultiSelectionEnabled(false);
        fileChooser2.setAcceptAllFileFilterUsed(false);
        fileChooser2.setApproveButtonText("Load");
        fileChooser2.setDialogTitle("Load Key");
        fileChooser2.setFileSelectionMode(0);
        fileChooser2.setFileFilter(new EnigmaFileFilter());
        fileChooser2.setFileView(new EnigmaFileView());
        String[] cables = null;
        String[] swaps = null;
        if (fileChooser2.showOpenDialog(this) == 0) {
            File destinationFile = new File(fileChooser2.getSelectedFile().getAbsolutePath());
            try {
                if (!fileChooser2.getSelectedFile().getAbsolutePath().endsWith(".ek")) {
                    destinationFile = new File(destinationFile + ".ek");
                }
                BufferedReader reader = new BufferedReader(new FileReader(destinationFile));
                String machineCode = reader.readLine();
                String reflectorCode = reader.readLine();
                String allRotorsCode = reader.readLine();
                String[] token = allRotorsCode.split(" ");
                String extraRotor = token[0];
                String leftRotor = token[1];
                String middleRotor = token[2];
                String rightRotor = token[3].trim();
                String allOffsets = reader.readLine();
                String[] token2 = allOffsets.split(" ");
                String extraOffset = token2[0];
                String leftOffset = token2[1];
                String middleOffset = token2[2];
                String rightOffset = token2[3].trim();
                if (machineCode.equals("IM4D") || machineCode.equals("IM4") || machineCode.equals("IM3") || machineCode.equals("IS") || machineCode.equals("IN")) {
                    String[] token3;
                    String allSwaps = reader.readLine();
                    cables = token3 = allSwaps.split(" ");
                }
                if (reflectorCode.equals("REWIRABLE")) {
                    String allRefSwaps = reader.readLine();
                    Object token4 = allRefSwaps.split(" ");
                    swaps = token4;
                }
                reader.close();
                SteppingMechanism sm = new SteppingMechanism(machineCode);
                sm.setReflector(reflectorCode);
                sm.setRotors(extraRotor, leftRotor, middleRotor, rightRotor);
                if (extraRotor != null) {
                    sm.setRotorOffset("EXTRA", extraOffset);
                }
                sm.setRotorOffset("LEFT", leftOffset);
                sm.setRotorOffset("MIDDLE", middleOffset);
                sm.setRotorOffset("RIGHT", rightOffset);
                switch (machineCode) {
                    case "D": 
                    case "KT": 
                    case "KS": 
                    case "KR": 
                    case "KD": {
                        EnigmaK enigmaK = new EnigmaK(sm);
                        if (machineCode.equals("KD")) {
                            enigmaK.getReflector().resetPlugs();
                            for (int i = 0; i < 12; ++i) {
                                if (swaps[i] == null) continue;
                                enigmaK.getReflector().plugCable(swaps[i].charAt(0));
                                enigmaK.getReflector().plugCable(swaps[i].charAt(1));
                            }
                        }
                        enigmaK.refresh();
                        enigmaK.setVisible(true);
                        this.disposeFrame();
                        break;
                    }
                    case "GA": 
                    case "G1": 
                    case "G2": 
                    case "G3": {
                        EnigmaG enigmaG = new EnigmaG(sm);
                        enigmaG.refresh();
                        enigmaG.setVisible(true);
                        this.disposeFrame();
                        break;
                    }
                    case "IS": 
                    case "IN": 
                    case "IM3": 
                    case "IM4": 
                    case "IM4D": {
                        int i;
                        EnigmaI enigmaI = new EnigmaI(sm);
                        if (machineCode.equals("IM4D")) {
                            enigmaI.getReflector().resetPlugs();
                            for (i = 0; i < 12; ++i) {
                                if (swaps[i] == null) continue;
                                enigmaI.getReflector().plugCable(swaps[i].charAt(0));
                                enigmaI.getReflector().plugCable(swaps[i].charAt(1));
                            }
                        }
                        enigmaI.getPlugboard().resetPlugs();
                        for (i = 0; i < 13; ++i) {
                            if (cables[i] == null) continue;
                            enigmaI.getPlugboard().plugCable(cables[i].charAt(0));
                            enigmaI.getPlugboard().plugCable(cables[i].charAt(1));
                        }
                        enigmaI.refresh();
                        enigmaI.setVisible(true);
                        this.disposeFrame();
                    }
                }
                ImageIcon icon = new ImageIcon(this.getClass().getResource("/resources/popup/Passed.png"));
                JOptionPane.showMessageDialog(this, "<html><strong style=\"font-size: 100%\">Key loaded.</strong><br>The key file has been loaded succesfully.<html>", "Key Loaded", 1, icon);
            }
            catch (IOException e) {
                ImageIcon icon3 = new ImageIcon(this.getClass().getResource("/resources/popup/Failed.png"));
                JOptionPane.showMessageDialog(this, "<html><strong style=\"font-size: 100%\">Key fault.</strong><br>The key file has not been loaded succesfully.<html>", "Key Fault", 0, icon3);
            }
        }
    }

    private void disposeFrame() {
        JFrame ancestorFrame = (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, this);
        ancestorFrame.dispose();
        this.aboutFrame.dispose();
        this.helpFrame.dispose();
    }

    private void initComponents() {
        this.jLabel3 = new JLabel();
        this.titlePanel = new JPanel();
        this.titleLabel = new JLabel();
        this.jLabel1 = new JLabel();
        this.clipperTapeLabel = new JLabel();
        this.AboutFilmBtn = new JButton();
        this.instantBtn = new JButton();
        this.pinLabel = new JLabel();
        this.leftTapeLabel = new JLabel();
        this.leftTapeLabel1 = new JLabel();
        this.horTapeLabel = new JLabel();
        this.menuCard = new JPanel();
        this.startBtn = new JButton();
        this.loadBtn = new JButton();
        this.helpBtn = new JButton();
        this.exitBtn = new JButton();
        this.rightTapeLabel = new JLabel();
        this.postLabel = new JLabel();
        this.paperLabel = new JLabel();
        this.redStampLabel = new JLabel();
        this.jLabel2 = new JLabel();
        this.blueStampLabel = new JLabel();
        this.codebookLabel = new JLabel();
        this.jLabel4 = new JLabel();
        this.setMaximumSize(new Dimension(618, 382));
        this.setMinimumSize(new Dimension(618, 382));
        this.setPreferredSize(new Dimension(618, 382));
        this.setLayout(null);
        this.jLabel3.setHorizontalAlignment(0);
        this.jLabel3.setIcon(new ImageIcon(this.getClass().getResource("/resources/shadow_left.png")));
        this.add(this.jLabel3);
        this.jLabel3.setBounds(390, 0, 30, 300);
        this.titlePanel.setOpaque(false);
        this.titleLabel.setHorizontalAlignment(2);
        this.titleLabel.setIcon(new ImageIcon(this.getClass().getResource("/resources/klu.png")));
        this.jLabel1.setIcon(new ImageIcon(this.getClass().getResource("/resources/shadow_down.png")));
        GroupLayout titlePanelLayout = new GroupLayout(this.titlePanel);
        this.titlePanel.setLayout(titlePanelLayout);
        titlePanelLayout.setHorizontalGroup(titlePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(titlePanelLayout.createSequentialGroup().addComponent(this.jLabel1, -2, 443, -2).addGap(0, 0, Short.MAX_VALUE)).addGroup(titlePanelLayout.createSequentialGroup().addGap(58, 58, 58).addComponent(this.titleLabel, -2, 169, -2).addContainerGap(-1, Short.MAX_VALUE)));
        titlePanelLayout.setVerticalGroup(titlePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(titlePanelLayout.createSequentialGroup().addComponent(this.jLabel1, -2, 10, -2).addGap(0, 0, 0).addComponent(this.titleLabel).addGap(657, 657, 657)));
        this.add(this.titlePanel);
        this.titlePanel.setBounds(0, 0, 420, 50);
        this.clipperTapeLabel.setHorizontalAlignment(0);
        this.clipperTapeLabel.setIcon(new ImageIcon(this.getClass().getResource("/resources/menu/TapeClipper.png")));
        this.clipperTapeLabel.setFocusable(false);
        this.add(this.clipperTapeLabel);
        this.clipperTapeLabel.setBounds(310, 10, 90, 70);
        this.AboutFilmBtn.setIcon(new ImageIcon(this.getClass().getResource("/resources/menu/buttons/Film.png")));
        this.AboutFilmBtn.setContentAreaFilled(false);
        this.AboutFilmBtn.setRolloverIcon(new ImageIcon(this.getClass().getResource("/resources/menu/buttons/FilmRollover.png")));
        this.AboutFilmBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MenuPanel.this.AboutFilmBtnActionPerformed(evt);
            }
        });
        this.add(this.AboutFilmBtn);
        this.AboutFilmBtn.setBounds(270, 40, 90, 80);
        this.instantBtn.setIcon(new ImageIcon(this.getClass().getResource("/resources/menu/buttons/Rotor.png")));
        this.instantBtn.setContentAreaFilled(false);
        this.instantBtn.setRolloverIcon(new ImageIcon(this.getClass().getResource("/resources/menu/buttons/RotorRollover.png")));
        this.instantBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MenuPanel.this.instantBtnActionPerformed(evt);
            }
        });
        this.add(this.instantBtn);
        this.instantBtn.setBounds(260, 140, 150, 150);
        this.pinLabel.setHorizontalAlignment(0);
        this.pinLabel.setIcon(new ImageIcon(this.getClass().getResource("/resources/menu/Pin.png")));
        this.pinLabel.setFocusable(false);
        this.add(this.pinLabel);
        this.pinLabel.setBounds(210, 60, 42, 170);
        this.leftTapeLabel.setHorizontalAlignment(0);
        this.leftTapeLabel.setIcon(new ImageIcon(this.getClass().getResource("/resources/menu/TapeTwo.png")));
        this.add(this.leftTapeLabel);
        this.leftTapeLabel.setBounds(160, 240, 70, 50);
        this.leftTapeLabel1.setHorizontalAlignment(0);
        this.leftTapeLabel1.setIcon(new ImageIcon(this.getClass().getResource("/resources/menu/TapeTwo.png")));
        this.add(this.leftTapeLabel1);
        this.leftTapeLabel1.setBounds(0, 30, 70, 50);
        this.horTapeLabel.setHorizontalAlignment(0);
        this.horTapeLabel.setIcon(new ImageIcon(this.getClass().getResource("/resources/menu/TapeVertical.png")));
        this.add(this.horTapeLabel);
        this.horTapeLabel.setBounds(10, 20, 40, 90);
        this.menuCard.setMaximumSize(new Dimension(120, 90));
        this.menuCard.setMinimumSize(new Dimension(120, 90));
        this.menuCard.setOpaque(false);
        this.menuCard.setPreferredSize(new Dimension(120, 90));
        this.startBtn.setIcon(new ImageIcon(this.getClass().getResource("/resources/menu/buttons/Start.png")));
        this.startBtn.setContentAreaFilled(false);
        this.startBtn.setFocusable(false);
        this.startBtn.setMaximumSize(new Dimension(100, 35));
        this.startBtn.setMinimumSize(new Dimension(100, 35));
        this.startBtn.setPreferredSize(new Dimension(100, 35));
        this.startBtn.setRolloverIcon(new ImageIcon(this.getClass().getResource("/resources/menu/buttons/StartRollover.png")));
        this.startBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MenuPanel.this.startBtnActionPerformed(evt);
            }
        });
        this.menuCard.add(this.startBtn);
        this.loadBtn.setIcon(new ImageIcon(this.getClass().getResource("/resources/menu/buttons/Load.png")));
        this.loadBtn.setContentAreaFilled(false);
        this.loadBtn.setHorizontalTextPosition(0);
        this.loadBtn.setMaximumSize(new Dimension(100, 35));
        this.loadBtn.setMinimumSize(new Dimension(100, 35));
        this.loadBtn.setPreferredSize(new Dimension(100, 35));
        this.loadBtn.setRolloverIcon(new ImageIcon(this.getClass().getResource("/resources/menu/buttons/LoadRollover.png")));
        this.loadBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MenuPanel.this.loadBtnActionPerformed(evt);
            }
        });
        this.menuCard.add(this.loadBtn);
        this.helpBtn.setIcon(new ImageIcon(this.getClass().getResource("/resources/menu/buttons/Help.png")));
        this.helpBtn.setContentAreaFilled(false);
        this.helpBtn.setEnabled(false);
        this.helpBtn.setMaximumSize(new Dimension(100, 35));
        this.helpBtn.setMinimumSize(new Dimension(100, 35));
        this.helpBtn.setPreferredSize(new Dimension(100, 35));
        this.helpBtn.setRolloverIcon(new ImageIcon(this.getClass().getResource("/resources/menu/buttons/HelpRollover.png")));
        this.helpBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MenuPanel.this.helpBtnActionPerformed(evt);
            }
        });
        this.menuCard.add(this.helpBtn);
        this.exitBtn.setIcon(new ImageIcon(this.getClass().getResource("/resources/menu/buttons/Exit.png")));
        this.exitBtn.setContentAreaFilled(false);
        this.exitBtn.setMaximumSize(new Dimension(100, 35));
        this.exitBtn.setMinimumSize(new Dimension(100, 35));
        this.exitBtn.setPreferredSize(new Dimension(100, 35));
        this.exitBtn.setRolloverIcon(new ImageIcon(this.getClass().getResource("/resources/menu/buttons/ExitRollover.png")));
        this.exitBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MenuPanel.this.exitBtnActionPerformed(evt);
            }
        });
        this.menuCard.add(this.exitBtn);
        this.add(this.menuCard);
        this.menuCard.setBounds(30, 80, 160, 170);
        this.rightTapeLabel.setHorizontalAlignment(0);
        this.rightTapeLabel.setIcon(new ImageIcon(this.getClass().getResource("/resources/menu/TapeOne.png")));
        this.add(this.rightTapeLabel);
        this.rightTapeLabel.setBounds(160, 230, 70, 60);
        this.postLabel.setHorizontalAlignment(0);
        this.postLabel.setIcon(new ImageIcon(this.getClass().getResource("/resources/menu/PostStamp.png")));
        this.postLabel.setFocusable(false);
        this.add(this.postLabel);
        this.postLabel.setBounds(20, 220, 68, 56);
        this.paperLabel.setHorizontalAlignment(0);
        this.paperLabel.setIcon(new ImageIcon(this.getClass().getResource("/resources/menu/Papere.png")));
        this.paperLabel.setFocusable(false);
        this.add(this.paperLabel);
        this.paperLabel.setBounds(10, 50, 191, 240);
        this.redStampLabel.setHorizontalAlignment(0);
        this.redStampLabel.setIcon(new ImageIcon(this.getClass().getResource("/resources/menu/StampRed.png")));
        this.redStampLabel.setFocusable(false);
        this.add(this.redStampLabel);
        this.redStampLabel.setBounds(80, 0, 70, 68);
        this.jLabel2.setIcon(new ImageIcon(this.getClass().getResource("/resources/shadow_up.png")));
        this.add(this.jLabel2);
        this.jLabel2.setBounds(0, 280, 430, 20);
        this.blueStampLabel.setHorizontalAlignment(0);
        this.blueStampLabel.setIcon(new ImageIcon(this.getClass().getResource("/resources/menu/StampBlue.png")));
        this.blueStampLabel.setFocusable(false);
        this.add(this.blueStampLabel);
        this.blueStampLabel.setBounds(120, 10, 70, 63);
        this.codebookLabel.setHorizontalAlignment(0);
        this.codebookLabel.setIcon(new ImageIcon(this.getClass().getResource("/resources/menu/Codebook.png")));
        this.add(this.codebookLabel);
        this.codebookLabel.setBounds(160, 10, 363, 298);
        this.jLabel4.setHorizontalAlignment(2);
        this.jLabel4.setIcon(new ImageIcon(this.getClass().getResource("/resources/shadow_right.png")));
        this.add(this.jLabel4);
        this.jLabel4.setBounds(0, 0, 10, 300);
    }

    private void instantBtnActionPerformed(ActionEvent evt) {
        Setup ies = new Setup("INSTANT");
        ies.setVisible(true);
    }

    private void startBtnActionPerformed(ActionEvent evt) {
        this.disposeFrame();
        Setup ms = new Setup("MACHINE");
        ms.setVisible(true);
    }

    private void loadBtnActionPerformed(ActionEvent evt) {
        this.loadKey();
    }

    private void helpBtnActionPerformed(ActionEvent evt) {
        this.helpFrame.setVisible(true);
    }

    private void exitBtnActionPerformed(ActionEvent evt) {
        this.disposeFrame();
        System.exit(0);
    }

    private void AboutFilmBtnActionPerformed(ActionEvent evt) {
        this.aboutFrame.setVisible(true);
    }

    class EnigmaFileView
    extends FileView {
        protected ImageIcon KEY_ICON;

        EnigmaFileView() {
            this.KEY_ICON = MenuPanel.this.kicon;
        }

        @Override
        public Icon getIcon(File f) {
            String name = f.getName().toLowerCase();
            if (name.endsWith(".ek")) {
                return this.KEY_ICON;
            }
            return null;
        }
    }

    class EnigmaFileFilter
    extends FileFilter {
        EnigmaFileFilter() {
        }

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            return f.getName().toLowerCase().endsWith(".ek");
        }

        @Override
        public String getDescription() {
            return "Enigma Key (*.ek)";
        }
    }
}

