/*
 * Decompiled with CFR 0.152.
 */
package frames.panels;

import frames.panels.JCopyTextArea;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.filechooser.FileFilter;

public class MessagePanel
extends JPanel {
    private int charAmount;
    private String wrapStyle = "NORMAL";
    private JCheckBox cFormat;
    private JLabel cGroups;
    private JTextField cGroupsNum;
    private JTextField charInfo;
    private JTextArea cipherText;
    private JButton clearBtn;
    private JButton copyBtn;
    private JCheckBox eFormat;
    private Box.Filler filler1;
    private JLabel formatLabel;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JProgressBar jProgressBar1;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JSeparator jSeparator2;
    private JSeparator jSeparator6;
    private JCheckBox nFormat;
    private JTextArea plainText;
    private JComboBox<String> sBox;
    private JButton saveBtn;
    private JComboBox<String> tBox;
    private JLabel titleLabel;

    public MessagePanel() {
        this.initComponents();
        this.charAmount = 0;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D gPaper = (Graphics2D)g;
        ImageIcon paperImage = new ImageIcon(this.getClass().getResource("/resources/EnigmaPaper.png"));
        Image image = paperImage.getImage();
        if (image != null) {
            gPaper.drawImage(image, 0, 0, 460, 440, this);
        }
    }

    public void printPlain(char plainChar) {
        String temp1 = Character.toString(plainChar);
        this.plainText.append(temp1);
        this.setCharAmount();
        this.wrapChars("PLAIN");
    }

    public void printCipher(char cipherChar) {
        String temp2 = Character.toString(cipherChar);
        this.cipherText.append(temp2);
        this.wrapChars("CIPHER");
    }

    private void saveMessage() {
        if ("".equals(this.plainText.getText())) {
            ImageIcon icon11 = new ImageIcon(this.getClass().getResource("/resources/popup/Info.png"));
            JOptionPane.showMessageDialog(this, "<html><strong style=\"font-size: 100%\">Nothing to copy.</strong><br>The message area is empty.<html>", "Save message", 1, icon11);
        } else {
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setDragEnabled(false);
            fileChooser.setDialogType(1);
            fileChooser.setMultiSelectionEnabled(false);
            fileChooser.setAcceptAllFileFilterUsed(false);
            fileChooser.setApproveButtonText("Save");
            fileChooser.setDialogTitle("Save message");
            fileChooser.setFileSelectionMode(0);
            fileChooser.setFileFilter(new TextFileFilter());
            if (fileChooser.showSaveDialog(this) == 0) {
                boolean doExport = true;
                boolean overrideExistingFile = false;
                File destinationFile = new File(fileChooser.getSelectedFile().getAbsolutePath());
                while (doExport && destinationFile.exists() && !overrideExistingFile) {
                    ImageIcon iconReplace = new ImageIcon(this.getClass().getResource("/resources/popup/Quest.png"));
                    int response = JOptionPane.showConfirmDialog(this, "<html><strong style=\"font-size: 100%\">File already exists.</strong><br>Would you like to replace the file?<html>", "File Settings", 0, 3, iconReplace);
                    if (response == 0) {
                        overrideExistingFile = true;
                    }
                    if (overrideExistingFile) continue;
                    if (fileChooser.showSaveDialog(this) == 0) {
                        destinationFile = new File(fileChooser.getSelectedFile().getAbsolutePath());
                        continue;
                    }
                    doExport = false;
                }
                if (doExport) {
                    try {
                        if (!fileChooser.getSelectedFile().getAbsolutePath().endsWith(".txt")) {
                            destinationFile = new File(destinationFile + ".txt");
                        }
                        BufferedWriter writer = new BufferedWriter(new FileWriter(destinationFile));
                        SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yy HH:mm");
                        Date date = new Date();
                        String timeString = "Date: " + dateFormat.format(date);
                        String plainString = this.plainText.getText().toUpperCase().trim();
                        String cipherString = this.cipherText.getText().toUpperCase().trim();
                        writer.write("Enigma Machine Message");
                        writer.newLine();
                        writer.write(timeString);
                        writer.newLine();
                        writer.write("Characters: " + this.charInfo.getText());
                        writer.newLine();
                        writer.newLine();
                        writer.newLine();
                        writer.write("Plain text: ");
                        writer.newLine();
                        writer.newLine();
                        writer.write(plainString);
                        writer.newLine();
                        writer.newLine();
                        writer.write("Cipher text: ");
                        writer.newLine();
                        writer.newLine();
                        writer.write(cipherString);
                        writer.newLine();
                        writer.close();
                        ImageIcon icon11 = new ImageIcon(this.getClass().getResource("/resources/popup/Passed.png"));
                        JOptionPane.showMessageDialog(this, "<html><strong style=\"font-size: 100%\">Message saved.</strong><br>The message has been saved sucessfully.<html>", "Message Saved", 1, icon11);
                    }
                    catch (IOException e) {
                        ImageIcon icon11 = new ImageIcon(this.getClass().getResource("/resources/popup/Failed.png"));
                        JOptionPane.showMessageDialog(this, "<html><strong style=\"font-size: 100%\">Message fault.</strong><br>The message file has not been saved succesfully.<html>", "Message Fault", 0, icon11);
                    }
                }
            }
        }
    }

    private void copyMessage() {
        if ("".equals(this.plainText.getText())) {
            ImageIcon icon11 = new ImageIcon(this.getClass().getResource("/resources/popup/Info.png"));
            JOptionPane.showMessageDialog(this, "<html><strong style=\"font-size: 100%\">Nothing to copy.</strong><br>The message is empty.<html>", "Copy message", 1, icon11);
        } else {
            String info = "Enigma Machine Message\n";
            SimpleDateFormat dateFormat = new SimpleDateFormat("dd/mm/yy HH:mm");
            Date date = new Date();
            String time = "Date: " + dateFormat.format(date) + "\n";
            String charSum = "Characters: " + this.charInfo.getText() + "\n";
            String plainString = this.plainText.getText().toUpperCase().trim();
            String cipherString = this.cipherText.getText().toUpperCase().trim();
            String outputText = info + time + charSum + "\n\nPlain text:\n\n" + plainString + "\n\nCipher text: \n\n" + cipherString;
            StringSelection stringSelection = new StringSelection(outputText);
            Clipboard clpbrd = Toolkit.getDefaultToolkit().getSystemClipboard();
            clpbrd.setContents(stringSelection, null);
            ImageIcon icon11 = new ImageIcon(this.getClass().getResource("/resources/popup/Passed.png"));
            JOptionPane.showMessageDialog(this, "<html><strong style=\"font-size: 100%\">Message copied.</strong><br>The message has been copied to the clipboard.<html>", "Message copied", 1, icon11);
        }
    }

    private void setCharAmount() {
        ++this.charAmount;
        this.charInfo.setText("" + this.charAmount);
    }

    private void wrapChars(String textArea) {
        ArrayList<Character> charList = new ArrayList<Character>();
        int groupSum = 0;
        int groupSize = 0;
        String textCopy = "";
        if (this.cFormat.isSelected()) {
            String sizeNum = this.cGroupsNum.getText().toString().trim().replaceAll("[^0-9]", "");
            if ("".equals(sizeNum = sizeNum.replaceAll("[^\\p{L}\\p{N}]", ""))) {
                groupSize = 0;
            } else {
                try {
                    groupSize = Math.abs(Integer.parseInt(sizeNum));
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            if (groupSize > 99) {
                groupSize = 0;
            }
            this.cGroupsNum.setText(Integer.toString(groupSize));
        }
        switch (textArea) {
            case "PLAIN": {
                textCopy = this.plainText.getText().toUpperCase().trim();
                break;
            }
            case "CIPHER": {
                textCopy = this.cipherText.getText().toUpperCase().trim();
            }
        }
        textCopy = textCopy.replaceAll("\\s", "");
        if (this.wrapStyle.equals("ENIGMA") || this.wrapStyle.equals("CUSTOM")) {
            int i;
            char[] charArray = textCopy.toCharArray();
            for (i = 0; i < charArray.length; ++i) {
                charList.add(Character.valueOf(charArray[i]));
                if ((++groupSum != 5 || !this.wrapStyle.equals("ENIGMA")) && (groupSum != groupSize || !this.wrapStyle.equals("CUSTOM"))) continue;
                groupSum = 0;
                charList.add(Character.valueOf(' '));
            }
            textCopy = "";
            for (i = 0; i < charList.size(); ++i) {
                textCopy = textCopy + charList.get(i);
            }
        }
        switch (textArea) {
            case "PLAIN": {
                this.plainText.setText(textCopy);
                break;
            }
            case "CIPHER": {
                this.cipherText.setText(textCopy);
            }
        }
    }

    private void setFont() {
        int fSize = 12;
        int fType = 0;
        if (this.sBox.getSelectedItem() == "Small") {
            fSize = 10;
        } else if (this.sBox.getSelectedItem() == "Medium") {
            fSize = 12;
        } else if (this.sBox.getSelectedItem() == "Large") {
            fSize = 14;
        } else if (this.sBox.getSelectedItem() == "Extra Large") {
            fSize = 16;
        }
        if (this.tBox.getSelectedItem() == "Normal") {
            fType = 0;
        } else if (this.tBox.getSelectedItem() == "Italic") {
            fType = 2;
        } else if (this.tBox.getSelectedItem() == "Bold") {
            fType = 1;
        } else if (this.tBox.getSelectedItem() == "Italic Bold") {
            fType = 3;
        }
        this.plainText.setFont(new Font("Arial", fType, fSize));
        this.cipherText.setFont(new Font("Arial", fType, fSize));
    }

    private void initComponents() {
        this.jProgressBar1 = new JProgressBar();
        this.filler1 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.titleLabel = new JLabel();
        this.copyBtn = new JButton();
        this.saveBtn = new JButton();
        this.jScrollPane3 = new JScrollPane();
        this.plainText = new JCopyTextArea();
        this.jScrollPane4 = new JScrollPane();
        this.cipherText = new JCopyTextArea();
        this.eFormat = new JCheckBox();
        this.nFormat = new JCheckBox();
        this.cFormat = new JCheckBox();
        this.jSeparator6 = new JSeparator();
        this.cGroupsNum = new JTextField();
        this.cGroups = new JLabel();
        this.jSeparator2 = new JSeparator();
        this.formatLabel = new JLabel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.sBox = new JComboBox();
        this.jLabel3 = new JLabel();
        this.tBox = new JComboBox();
        this.charInfo = new JTextField();
        this.clearBtn = new JButton();
        this.jLabel8 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jLabel10 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel11 = new JLabel();
        this.jLabel12 = new JLabel();
        this.jLabel13 = new JLabel();
        this.jLabel14 = new JLabel();
        this.setRequestFocusEnabled(false);
        this.titleLabel.setHorizontalAlignment(0);
        this.titleLabel.setIcon(new ImageIcon(this.getClass().getResource("/resources/banners/Message.png")));
        this.titleLabel.setFocusable(false);
        this.copyBtn.setIcon(new ImageIcon(this.getClass().getResource("/resources/buttons/CopyNew.png")));
        this.copyBtn.setContentAreaFilled(false);
        this.copyBtn.setCursor(new Cursor(12));
        this.copyBtn.setFocusable(false);
        this.copyBtn.setMaximumSize(new Dimension(67, 26));
        this.copyBtn.setMinimumSize(new Dimension(67, 26));
        this.copyBtn.setPreferredSize(new Dimension(67, 26));
        this.copyBtn.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/buttons/CopyNewPress.png")));
        this.copyBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MessagePanel.this.copyBtnActionPerformed(evt);
            }
        });
        this.saveBtn.setIcon(new ImageIcon(this.getClass().getResource("/resources/buttons/SaveNew.png")));
        this.saveBtn.setContentAreaFilled(false);
        this.saveBtn.setCursor(new Cursor(12));
        this.saveBtn.setFocusable(false);
        this.saveBtn.setMaximumSize(new Dimension(67, 26));
        this.saveBtn.setMinimumSize(new Dimension(67, 26));
        this.saveBtn.setPreferredSize(new Dimension(67, 26));
        this.saveBtn.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/buttons/SaveNewPress.png")));
        this.saveBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MessagePanel.this.saveBtnActionPerformed(evt);
            }
        });
        this.plainText.setEditable(false);
        this.plainText.setColumns(20);
        this.plainText.setFont(new Font("Arial", 0, 12));
        this.plainText.setLineWrap(true);
        this.plainText.setRows(5);
        this.plainText.setToolTipText("Plain text");
        this.plainText.setWrapStyleWord(true);
        this.plainText.setCaretPosition(this.plainText.getDocument().getLength());
        this.plainText.setMaximumSize(new Dimension(224, 79));
        this.plainText.setMinimumSize(new Dimension(224, 79));
        this.jScrollPane3.setViewportView(this.plainText);
        this.cipherText.setEditable(false);
        this.cipherText.setColumns(20);
        this.cipherText.setFont(new Font("Arial", 0, 12));
        this.cipherText.setLineWrap(true);
        this.cipherText.setRows(5);
        this.cipherText.setToolTipText("Cipher text");
        this.cipherText.setWrapStyleWord(true);
        this.cipherText.setCaretPosition(this.cipherText.getDocument().getLength());
        this.cipherText.setMaximumSize(new Dimension(224, 79));
        this.cipherText.setMinimumSize(new Dimension(224, 79));
        this.jScrollPane4.setViewportView(this.cipherText);
        this.eFormat.setText("Enigma");
        this.eFormat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MessagePanel.this.eFormatActionPerformed(evt);
            }
        });
        this.nFormat.setSelected(true);
        this.nFormat.setText("Normal");
        this.nFormat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MessagePanel.this.nFormatActionPerformed(evt);
            }
        });
        this.cFormat.setText("Custom");
        this.cFormat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MessagePanel.this.cFormatActionPerformed(evt);
            }
        });
        this.cGroupsNum.setHorizontalAlignment(0);
        this.cGroupsNum.setText("2");
        this.cGroupsNum.setEnabled(false);
        this.cGroupsNum.setMaximumSize(new Dimension(30, 30));
        this.cGroupsNum.setMinimumSize(new Dimension(30, 30));
        this.cGroupsNum.setPreferredSize(new Dimension(30, 30));
        this.cGroupsNum.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                MessagePanel.this.cGroupsNumKeyReleased(evt);
            }
        });
        this.cGroups.setText("Groups:");
        this.cGroups.setEnabled(false);
        this.jSeparator2.setOrientation(1);
        this.formatLabel.setHorizontalAlignment(0);
        this.formatLabel.setIcon(new ImageIcon(this.getClass().getResource("/resources/banners/FormatWrap.png")));
        this.jLabel1.setHorizontalAlignment(0);
        this.jLabel1.setIcon(new ImageIcon(this.getClass().getResource("/resources/banners/Font.png")));
        this.jLabel2.setText("Size:");
        this.sBox.setFont(new Font("Tahoma", 0, 10));
        this.sBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Small", "Medium", "Large", "Extra Large"}));
        this.sBox.setSelectedItem("Medium");
        this.sBox.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent evt) {
                MessagePanel.this.sBoxMouseWheelMoved(evt);
            }
        });
        this.sBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MessagePanel.this.sBoxActionPerformed(evt);
            }
        });
        this.jLabel3.setText("Type:");
        this.tBox.setFont(new Font("Tahoma", 0, 10));
        this.tBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Normal", "Bold", "Italic", "Italic Bold"}));
        this.tBox.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent evt) {
                MessagePanel.this.tBoxMouseWheelMoved(evt);
            }
        });
        this.tBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MessagePanel.this.tBoxActionPerformed(evt);
            }
        });
        this.charInfo.setEditable(false);
        this.charInfo.setFont(new Font("Tahoma", 0, 12));
        this.charInfo.setHorizontalAlignment(0);
        this.charInfo.setText("0");
        this.charInfo.setFocusable(false);
        this.clearBtn.setIcon(new ImageIcon(this.getClass().getResource("/resources/buttons/ClearNew.png")));
        this.clearBtn.setContentAreaFilled(false);
        this.clearBtn.setCursor(new Cursor(12));
        this.clearBtn.setFocusable(false);
        this.clearBtn.setMaximumSize(new Dimension(67, 26));
        this.clearBtn.setMinimumSize(new Dimension(67, 26));
        this.clearBtn.setPreferredSize(new Dimension(67, 26));
        this.clearBtn.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/buttons/ClearNewPress.png")));
        this.clearBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MessagePanel.this.clearBtnActionPerformed(evt);
            }
        });
        this.jLabel8.setHorizontalAlignment(4);
        this.jLabel8.setIcon(new ImageIcon(this.getClass().getResource("/resources/shadow_left_top.png")));
        this.jLabel8.setVerticalTextPosition(1);
        this.jLabel9.setIcon(new ImageIcon(this.getClass().getResource("/resources/shadow_right.png")));
        this.jLabel10.setHorizontalAlignment(4);
        this.jLabel10.setIcon(new ImageIcon(this.getClass().getResource("/resources/shadow_left_bottom.png")));
        this.jLabel10.setVerticalAlignment(3);
        this.jLabel4.setHorizontalAlignment(4);
        this.jLabel4.setIcon(new ImageIcon(this.getClass().getResource("/resources/shadow_down.png")));
        this.jLabel4.setVerticalTextPosition(1);
        this.jLabel11.setHorizontalAlignment(4);
        this.jLabel11.setIcon(new ImageIcon(this.getClass().getResource("/resources/shadow_up.png")));
        this.jLabel11.setVerticalTextPosition(1);
        this.jLabel12.setHorizontalAlignment(4);
        this.jLabel12.setIcon(new ImageIcon(this.getClass().getResource("/resources/shadow_right_top.png")));
        this.jLabel12.setVerticalTextPosition(1);
        this.jLabel13.setIcon(new ImageIcon(this.getClass().getResource("/resources/shadow_left.png")));
        this.jLabel14.setHorizontalAlignment(4);
        this.jLabel14.setIcon(new ImageIcon(this.getClass().getResource("/resources/shadow_right_bottom.png")));
        this.jLabel14.setVerticalAlignment(3);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel8).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jLabel9, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel10))).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator6).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.charInfo, -2, 80, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.clearBtn, -2, 75, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.saveBtn, -2, 75, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.copyBtn, -2, 75, -2)).addComponent(this.titleLabel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel11, -2, 439, -2).addComponent(this.jLabel4, -2, 0, Short.MAX_VALUE)).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane3).addComponent(this.jScrollPane4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.sBox, GroupLayout.Alignment.LEADING, 0, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addGap(21, 21, 21).addComponent(this.cGroups).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cGroupsNum, -1, -1, Short.MAX_VALUE)).addComponent(this.formatLabel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel1, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.cFormat, GroupLayout.Alignment.LEADING).addComponent(this.nFormat, GroupLayout.Alignment.LEADING).addComponent(this.eFormat, GroupLayout.Alignment.LEADING).addComponent(this.jLabel3, GroupLayout.Alignment.LEADING, -2, 50, -2).addComponent(this.jLabel2, GroupLayout.Alignment.LEADING, -2, 50, -2).addComponent(this.tBox, -2, 100, -2)))).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel13, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel12, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel14)).addGap(2, 2, 2)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel4, -2, 10, -2).addGap(0, 0, 0).addComponent(this.titleLabel, -2, 60, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane3, -2, 150, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane4, -2, 150, -2)).addComponent(this.jSeparator2)).addGroup(layout.createSequentialGroup().addComponent(this.formatLabel, -2, 40, -2).addGap(6, 6, 6).addComponent(this.eFormat).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nFormat).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cFormat).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cGroups).addComponent(this.cGroupsNum, -2, 30, -2)).addGap(18, 18, 18).addComponent(this.jLabel1, -2, 41, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addGap(2, 2, 2).addComponent(this.sBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3).addGap(2, 2, 2).addComponent(this.tBox, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator6, -2, 2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.clearBtn, -2, 30, -2).addComponent(this.copyBtn, -1, -1, Short.MAX_VALUE).addComponent(this.saveBtn, -1, -1, Short.MAX_VALUE).addComponent(this.charInfo)).addGap(0, 0, 0).addComponent(this.jLabel11, -2, 10, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel8).addGap(0, 0, 0).addComponent(this.jLabel9, -2, 0, Short.MAX_VALUE).addGap(0, 0, 0).addComponent(this.jLabel10)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel12).addGap(0, 0, 0).addComponent(this.jLabel13, -2, 0, Short.MAX_VALUE).addGap(0, 0, 0).addComponent(this.jLabel14)));
    }

    private void copyBtnActionPerformed(ActionEvent evt) {
        this.copyMessage();
    }

    private void saveBtnActionPerformed(ActionEvent evt) {
        this.saveMessage();
    }

    private void nFormatActionPerformed(ActionEvent evt) {
        this.wrapStyle = "NORMAL";
        if (!this.nFormat.isSelected()) {
            this.nFormat.setSelected(true);
        }
        this.eFormat.setSelected(false);
        this.cFormat.setSelected(false);
        this.cGroups.setEnabled(false);
        this.cGroupsNum.setEnabled(false);
        this.wrapChars("PLAIN");
        this.wrapChars("CIPHER");
    }

    private void sBoxActionPerformed(ActionEvent evt) {
        this.setFont();
    }

    private void tBoxActionPerformed(ActionEvent evt) {
        this.setFont();
    }

    private void eFormatActionPerformed(ActionEvent evt) {
        if (!this.eFormat.isSelected()) {
            this.wrapStyle = "NORMAL";
            this.nFormat.setSelected(true);
        } else {
            this.wrapStyle = "ENIGMA";
            this.nFormat.setSelected(false);
            this.cFormat.setSelected(false);
            this.cGroups.setEnabled(false);
            this.cGroupsNum.setEnabled(false);
        }
        this.wrapChars("PLAIN");
        this.wrapChars("CIPHER");
    }

    private void cFormatActionPerformed(ActionEvent evt) {
        if (!this.cFormat.isSelected()) {
            this.wrapStyle = "NORMAL";
            this.nFormat.setSelected(true);
            this.cGroups.setEnabled(false);
            this.cGroupsNum.setEnabled(false);
        } else {
            this.wrapStyle = "CUSTOM";
            this.nFormat.setSelected(false);
            this.eFormat.setSelected(false);
            this.cGroups.setEnabled(true);
            this.cGroupsNum.setEnabled(true);
        }
        this.wrapChars("PLAIN");
        this.wrapChars("CIPHER");
    }

    private void cGroupsNumKeyReleased(KeyEvent evt) {
        this.wrapChars("PLAIN");
        this.wrapChars("CIPHER");
    }

    private void sBoxMouseWheelMoved(MouseWheelEvent evt) {
        if (evt.getWheelRotation() < 0) {
            int newIndex = this.sBox.getSelectedIndex() - 1;
            if (newIndex >= 0) {
                this.sBox.setSelectedIndex(newIndex);
            }
        } else {
            int newIndex = this.sBox.getSelectedIndex() + 1;
            if (newIndex < this.sBox.getItemCount()) {
                this.sBox.setSelectedIndex(newIndex);
            }
        }
    }

    private void tBoxMouseWheelMoved(MouseWheelEvent evt) {
        if (evt.getWheelRotation() < 0) {
            int newIndex = this.tBox.getSelectedIndex() - 1;
            if (newIndex >= 0) {
                this.tBox.setSelectedIndex(newIndex);
            }
        } else {
            int newIndex = this.tBox.getSelectedIndex() + 1;
            if (newIndex < this.tBox.getItemCount()) {
                this.tBox.setSelectedIndex(newIndex);
            }
        }
    }

    private void clearBtnActionPerformed(ActionEvent evt) {
        ImageIcon iconReplace = new ImageIcon(this.getClass().getResource("/resources/popup/Quest.png"));
        int response = JOptionPane.showConfirmDialog(this, "<html><strong style=\"font-size: 100%\">Clear message.</strong><br>Would you like to clear the message area?<html>", "Clear", 0, 3, iconReplace);
        if (response == 0) {
            this.plainText.setText("");
            this.cipherText.setText("");
            this.charInfo.setText("0");
            this.charAmount = 0;
        }
    }

    public class TextFileFilter
    extends FileFilter {
        @Override
        public boolean accept(File file) {
            return file.getName().toLowerCase().endsWith(".txt") || file.isDirectory();
        }

        @Override
        public String getDescription() {
            return "Text File (*.txt)";
        }
    }
}

