/*
 * Decompiled with CFR 0.152.
 */
package frames.panels;

import enigma.SteppingMechanism;
import frames.InstantEnigma;
import frames.Menu;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerListModel;
import javax.swing.SwingUtilities;
import machines.EnigmaG;
import machines.EnigmaI;
import machines.EnigmaK;

public class SetupPanel
extends JPanel {
    private SteppingMechanism stepMech;
    private String setupType;
    private JSeparator buttonsSeperator;
    private JPanel containerPanel;
    private JPanel controlPanel;
    private JSpinner extraOffset;
    private JLabel extraOffsetLabel;
    private JSpinner extraPosition;
    private JLabel extraPositionLabel;
    private JLabel extraRotorLabel;
    private JComboBox<String> extraType;
    private JLabel infoLabel;
    private JPanel infoPanel;
    private JSpinner leftOffset;
    private JLabel leftOffsetLabel;
    private JSpinner leftPosition;
    private JLabel leftPositionLabel;
    private JLabel leftRotorLabel;
    private JComboBox<String> leftType;
    private JLabel machineLabel;
    private JComboBox<String> machineType;
    private JButton menuBtn;
    private JSpinner middleOffset;
    private JLabel middleOffsetLabel;
    private JSpinner middlePosition;
    private JLabel middlePositionLabel;
    private JLabel middleRotorLabel;
    private JSeparator middleSeperator;
    private JComboBox<String> middleType;
    private JLabel reflectorLabel;
    private JSpinner reflectorPosition;
    private JLabel reflectorPositionLabel;
    private JComboBox<String> reflectorType;
    private JSpinner rightOffset;
    private JLabel rightOffsetLabel;
    private JSpinner rightPosition;
    private JLabel rightPositionLabel;
    private JLabel rightRotorLabel;
    private JSeparator rightSeperator;
    private JComboBox<String> rightType;
    private JPanel settingsPanel;
    private JButton startBtn;
    private JLabel titleLabel;
    private JPanel titlePanel;
    private JSeparator topSeperator;

    public SetupPanel(String type) {
        this.initComponents();
        this.setupType = type;
        if (this.setupType.equals("INSTANT")) {
            this.menuBtn.setEnabled(false);
            this.menuBtn.setVisible(false);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D background = (Graphics2D)g;
        ImageIcon paperImage = new ImageIcon(this.getClass().getResource("/resources/EnigmaPaper.png"));
        Image image = paperImage.getImage();
        if (image != null) {
            background.drawImage(image, 0, 0, 610, 400, this);
        }
    }

    private boolean checkValues() {
        boolean checked = false;
        if (this.leftType.getSelectedIndex() != this.middleType.getSelectedIndex() && this.leftType.getSelectedIndex() != this.rightType.getSelectedIndex() && this.middleType.getSelectedIndex() != this.rightType.getSelectedIndex()) {
            checked = true;
        }
        return checked;
    }

    private void custom() {
        if (this.reflectorType.getSelectedIndex() != -1 && this.machineType.getSelectedIndex() == 12) {
            String refType = this.reflectorType.getSelectedItem().toString();
            this.extraType.removeAllItems();
            switch (refType) {
                case "UKW - D": {
                    this.extraType.addItem("N\\A");
                    this.extraType.setEnabled(false);
                    this.extraOffset.setEnabled(false);
                    this.extraPosition.setEnabled(false);
                    this.extraPosition.setValue("A");
                    this.extraOffset.setValue("A");
                    this.infoLabel.setToolTipText("<html><strong style=\"font-size: 100%\"><center>Enigma M4</strong></center>Year: 1944<br>Use: Navy (U-Boot)<br>Stepping: Regular<br>Plugboard: Available<br>Rotors: 3<br>UKW: Rewirable</html>");
                    this.infoLabel.setIcon(new ImageIcon(this.getClass().getResource("/resources/tiles/IM4D.png")));
                    break;
                }
                case "UKW - B": 
                case "UKW - C": {
                    this.extraType.addItem("Beta");
                    this.extraType.addItem("Gamma");
                    this.extraType.setEnabled(true);
                    this.extraOffset.setEnabled(true);
                    this.extraPosition.setEnabled(true);
                    this.infoLabel.setToolTipText("<html><strong style=\"font-size: 100%\"><center>Enigma M4</strong></center>Year: 1941<br>Use: Navy (U-Boot)<br>Stepping: Regular<br>Plugboard: Available<br>Rotors: 4<br>UKW: Fixed</html>");
                    this.infoLabel.setIcon(new ImageIcon(this.getClass().getResource("/resources/tiles/IM4.png")));
                }
            }
        }
    }

    private void start() {
        String machineCode;
        block15 : switch (machineCode = this.machineType.getSelectedItem().toString()) {
            case "Enigma D -- Commercial": {
                this.stepMech = new SteppingMechanism("D");
                this.stepMech.setRotors(null, this.leftType.getSelectedItem().toString(), this.middleType.getSelectedItem().toString(), this.rightType.getSelectedItem().toString());
                this.stepMech.setUKWIndex(this.reflectorPosition.getValue().toString());
                this.stepMech.setRotorOffset("LEFT", this.leftOffset.getValue().toString());
                this.stepMech.setRotorOffset("MIDDLE", this.middleOffset.getValue().toString());
                this.stepMech.setRotorOffset("RIGHT", this.rightOffset.getValue().toString());
                this.stepMech.setRotorIndex("LEFT", this.leftPosition.getValue().toString());
                this.stepMech.setRotorIndex("MIDDLE", this.middlePosition.getValue().toString());
                this.stepMech.setRotorIndex("RIGHT", this.rightPosition.getValue().toString());
                switch (this.setupType) {
                    case "MACHINE": {
                        EnigmaK enigmaK = new EnigmaK(this.stepMech);
                        enigmaK.refresh();
                        enigmaK.setVisible(true);
                        break;
                    }
                    case "INSTANT": {
                        InstantEnigma ie = new InstantEnigma(this.stepMech);
                        ie.setVisible(true);
                    }
                }
                break;
            }
            case "Enigma I -- Service": {
                this.stepMech = new SteppingMechanism("IS");
                this.stepMech.setRotors(null, this.leftType.getSelectedItem().toString(), this.middleType.getSelectedItem().toString(), this.rightType.getSelectedItem().toString());
                this.stepMech.setReflector(this.reflectorType.getSelectedItem().toString());
                this.stepMech.setRotorOffset("LEFT", this.leftOffset.getValue().toString());
                this.stepMech.setRotorOffset("MIDDLE", this.middleOffset.getValue().toString());
                this.stepMech.setRotorOffset("RIGHT", this.rightOffset.getValue().toString());
                this.stepMech.setRotorIndex("LEFT", this.leftPosition.getValue().toString());
                this.stepMech.setRotorIndex("MIDDLE", this.middlePosition.getValue().toString());
                this.stepMech.setRotorIndex("RIGHT", this.rightPosition.getValue().toString());
                switch (this.setupType) {
                    case "MACHINE": {
                        EnigmaI enigmaIS = new EnigmaI(this.stepMech);
                        enigmaIS.refresh();
                        enigmaIS.setVisible(true);
                        break;
                    }
                    case "INSTANT": {
                        InstantEnigma ie = new InstantEnigma(this.stepMech);
                        ie.setVisible(true);
                    }
                }
                break;
            }
            case "Enigma I -- Norway": {
                this.stepMech = new SteppingMechanism("IN");
                this.stepMech.setRotors(null, this.leftType.getSelectedItem().toString(), this.middleType.getSelectedItem().toString(), this.rightType.getSelectedItem().toString());
                this.stepMech.setRotorOffset("LEFT", this.leftOffset.getValue().toString());
                this.stepMech.setRotorOffset("MIDDLE", this.middleOffset.getValue().toString());
                this.stepMech.setRotorOffset("RIGHT", this.rightOffset.getValue().toString());
                this.stepMech.setRotorIndex("LEFT", this.leftPosition.getValue().toString());
                this.stepMech.setRotorIndex("MIDDLE", this.middlePosition.getValue().toString());
                this.stepMech.setRotorIndex("RIGHT", this.rightPosition.getValue().toString());
                switch (this.setupType) {
                    case "MACHINE": {
                        EnigmaI enigmaIN = new EnigmaI(this.stepMech);
                        enigmaIN.refresh();
                        enigmaIN.setVisible(true);
                        break;
                    }
                    case "INSTANT": {
                        InstantEnigma ie = new InstantEnigma(this.stepMech);
                        ie.setVisible(true);
                    }
                }
                break;
            }
            case "Enigma M3 -- Heer": {
                this.stepMech = new SteppingMechanism("IM3");
                this.stepMech.setRotors(null, this.leftType.getSelectedItem().toString(), this.middleType.getSelectedItem().toString(), this.rightType.getSelectedItem().toString());
                this.stepMech.setReflector(this.reflectorType.getSelectedItem().toString());
                this.stepMech.setRotorOffset("LEFT", this.leftOffset.getValue().toString());
                this.stepMech.setRotorOffset("MIDDLE", this.middleOffset.getValue().toString());
                this.stepMech.setRotorOffset("RIGHT", this.rightOffset.getValue().toString());
                this.stepMech.setRotorIndex("LEFT", this.leftPosition.getValue().toString());
                this.stepMech.setRotorIndex("MIDDLE", this.middlePosition.getValue().toString());
                this.stepMech.setRotorIndex("RIGHT", this.rightPosition.getValue().toString());
                switch (this.setupType) {
                    case "MACHINE": {
                        EnigmaI enigmaIM3 = new EnigmaI(this.stepMech);
                        enigmaIM3.refresh();
                        enigmaIM3.setVisible(true);
                        break;
                    }
                    case "INSTANT": {
                        InstantEnigma ie = new InstantEnigma(this.stepMech);
                        ie.setVisible(true);
                    }
                }
                break;
            }
            case "Enigma M4 -- Shark": {
                if (this.reflectorType.getSelectedItem().toString().equals("UKW - D")) {
                    this.stepMech = new SteppingMechanism("IM4D");
                    this.stepMech.setRotors(null, this.leftType.getSelectedItem().toString(), this.middleType.getSelectedItem().toString(), this.rightType.getSelectedItem().toString());
                    this.stepMech.setRotorOffset("LEFT", this.leftOffset.getValue().toString());
                    this.stepMech.setRotorOffset("MIDDLE", this.middleOffset.getValue().toString());
                    this.stepMech.setRotorOffset("RIGHT", this.rightOffset.getValue().toString());
                    this.stepMech.setRotorIndex("LEFT", this.leftPosition.getValue().toString());
                    this.stepMech.setRotorIndex("MIDDLE", this.middlePosition.getValue().toString());
                    this.stepMech.setRotorIndex("RIGHT", this.rightPosition.getValue().toString());
                } else {
                    this.stepMech = new SteppingMechanism("IM4");
                    this.stepMech.setRotors(this.extraType.getSelectedItem().toString().toUpperCase(), this.leftType.getSelectedItem().toString(), this.middleType.getSelectedItem().toString(), this.rightType.getSelectedItem().toString());
                    this.stepMech.setReflector(this.reflectorType.getSelectedItem().toString());
                    this.stepMech.setRotorOffset("EXTRA", this.extraOffset.getValue().toString());
                    this.stepMech.setRotorOffset("LEFT", this.leftOffset.getValue().toString());
                    this.stepMech.setRotorOffset("MIDDLE", this.middleOffset.getValue().toString());
                    this.stepMech.setRotorOffset("RIGHT", this.rightOffset.getValue().toString());
                    this.stepMech.setRotorIndex("EXTRA", this.extraPosition.getValue().toString());
                    this.stepMech.setRotorIndex("LEFT", this.leftPosition.getValue().toString());
                    this.stepMech.setRotorIndex("MIDDLE", this.middlePosition.getValue().toString());
                    this.stepMech.setRotorIndex("RIGHT", this.rightPosition.getValue().toString());
                }
                switch (this.setupType) {
                    case "MACHINE": {
                        EnigmaI enigmaIM4 = new EnigmaI(this.stepMech);
                        enigmaIM4.refresh();
                        enigmaIM4.setVisible(true);
                        break;
                    }
                    case "INSTANT": {
                        InstantEnigma ie = new InstantEnigma(this.stepMech);
                        ie.setVisible(true);
                    }
                }
                break;
            }
            case "Enigma K -- Swiss": {
                this.stepMech = new SteppingMechanism("KS");
                this.stepMech.setRotors(null, this.leftType.getSelectedItem().toString(), this.middleType.getSelectedItem().toString(), this.rightType.getSelectedItem().toString());
                this.stepMech.setRotorOffset("LEFT", this.leftOffset.getValue().toString());
                this.stepMech.setRotorOffset("MIDDLE", this.middleOffset.getValue().toString());
                this.stepMech.setRotorOffset("RIGHT", this.rightOffset.getValue().toString());
                this.stepMech.setUKWIndex(this.reflectorPosition.getValue().toString());
                this.stepMech.setRotorIndex("LEFT", this.leftPosition.getValue().toString());
                this.stepMech.setRotorIndex("MIDDLE", this.middlePosition.getValue().toString());
                this.stepMech.setRotorIndex("RIGHT", this.rightPosition.getValue().toString());
                switch (this.setupType) {
                    case "MACHINE": {
                        EnigmaK enigmaKS = new EnigmaK(this.stepMech);
                        enigmaKS.refresh();
                        enigmaKS.setVisible(true);
                        break;
                    }
                    case "INSTANT": {
                        InstantEnigma ie = new InstantEnigma(this.stepMech);
                        ie.setVisible(true);
                    }
                }
                break;
            }
            case "Enigma T -- Tirpitz": {
                this.stepMech = new SteppingMechanism("KT");
                this.stepMech.setRotors(null, this.leftType.getSelectedItem().toString(), this.middleType.getSelectedItem().toString(), this.rightType.getSelectedItem().toString());
                this.stepMech.setRotorOffset("LEFT", this.leftOffset.getValue().toString());
                this.stepMech.setRotorOffset("MIDDLE", this.middleOffset.getValue().toString());
                this.stepMech.setRotorOffset("RIGHT", this.rightOffset.getValue().toString());
                this.stepMech.setUKWIndex(this.reflectorPosition.getValue().toString());
                this.stepMech.setRotorIndex("LEFT", this.leftPosition.getValue().toString());
                this.stepMech.setRotorIndex("MIDDLE", this.middlePosition.getValue().toString());
                this.stepMech.setRotorIndex("RIGHT", this.rightPosition.getValue().toString());
                switch (this.setupType) {
                    case "MACHINE": {
                        EnigmaK enigmaKT = new EnigmaK(this.stepMech);
                        enigmaKT.refresh();
                        enigmaKT.setVisible(true);
                        break;
                    }
                    case "INSTANT": {
                        InstantEnigma ie = new InstantEnigma(this.stepMech);
                        ie.setVisible(true);
                    }
                }
                break;
            }
            case "Enigma K -- Rocket": {
                this.stepMech = new SteppingMechanism("KR");
                this.stepMech.setRotors(null, this.leftType.getSelectedItem().toString(), this.middleType.getSelectedItem().toString(), this.rightType.getSelectedItem().toString());
                this.stepMech.setRotorOffset("LEFT", this.leftOffset.getValue().toString());
                this.stepMech.setRotorOffset("MIDDLE", this.middleOffset.getValue().toString());
                this.stepMech.setRotorOffset("RIGHT", this.rightOffset.getValue().toString());
                this.stepMech.setUKWIndex(this.reflectorPosition.getValue().toString());
                this.stepMech.setRotorIndex("LEFT", this.leftPosition.getValue().toString());
                this.stepMech.setRotorIndex("MIDDLE", this.middlePosition.getValue().toString());
                this.stepMech.setRotorIndex("RIGHT", this.rightPosition.getValue().toString());
                switch (this.setupType) {
                    case "MACHINE": {
                        EnigmaK enigmaKR = new EnigmaK(this.stepMech);
                        enigmaKR.refresh();
                        enigmaKR.setVisible(true);
                        break;
                    }
                    case "INSTANT": {
                        InstantEnigma ie = new InstantEnigma(this.stepMech);
                        ie.setVisible(true);
                    }
                }
                break;
            }
            case "Enigma KD -- Mil Amt": {
                this.stepMech = new SteppingMechanism("KD");
                this.stepMech.setRotors(null, this.leftType.getSelectedItem().toString(), this.middleType.getSelectedItem().toString(), this.rightType.getSelectedItem().toString());
                this.stepMech.setRotorOffset("LEFT", this.leftOffset.getValue().toString());
                this.stepMech.setRotorOffset("MIDDLE", this.middleOffset.getValue().toString());
                this.stepMech.setRotorOffset("RIGHT", this.rightOffset.getValue().toString());
                this.stepMech.setRotorIndex("LEFT", this.leftPosition.getValue().toString());
                this.stepMech.setRotorIndex("MIDDLE", this.middlePosition.getValue().toString());
                this.stepMech.setRotorIndex("RIGHT", this.rightPosition.getValue().toString());
                switch (this.setupType) {
                    case "MACHINE": {
                        EnigmaK enigmaKD = new EnigmaK(this.stepMech);
                        enigmaKD.refresh();
                        enigmaKD.setVisible(true);
                        break;
                    }
                    case "INSTANT": {
                        InstantEnigma ie = new InstantEnigma(this.stepMech);
                        ie.setVisible(true);
                    }
                }
                break;
            }
            case "Enigma G31 -- Abwehr (G-312)": {
                this.stepMech = new SteppingMechanism("G3");
                this.stepMech.setRotors(null, this.leftType.getSelectedItem().toString(), this.middleType.getSelectedItem().toString(), this.rightType.getSelectedItem().toString());
                this.stepMech.setRotorOffset("LEFT", this.leftOffset.getValue().toString());
                this.stepMech.setRotorOffset("MIDDLE", this.middleOffset.getValue().toString());
                this.stepMech.setRotorOffset("RIGHT", this.rightOffset.getValue().toString());
                this.stepMech.setUKWIndex(this.reflectorPosition.getValue().toString());
                this.stepMech.setRotorIndex("LEFT", this.leftPosition.getValue().toString());
                this.stepMech.setRotorIndex("MIDDLE", this.middlePosition.getValue().toString());
                this.stepMech.setRotorIndex("RIGHT", this.rightPosition.getValue().toString());
                switch (this.setupType) {
                    case "MACHINE": {
                        EnigmaG enigmaG3 = new EnigmaG(this.stepMech);
                        enigmaG3.refresh();
                        enigmaG3.setVisible(true);
                        break;
                    }
                    case "INSTANT": {
                        InstantEnigma ie = new InstantEnigma(this.stepMech);
                        ie.setVisible(true);
                    }
                }
                break;
            }
            case "Enigma G31 -- Abwehr (G-260)": {
                this.stepMech = new SteppingMechanism("G2");
                this.stepMech.setRotors(null, this.leftType.getSelectedItem().toString(), this.middleType.getSelectedItem().toString(), this.rightType.getSelectedItem().toString());
                this.stepMech.setRotorOffset("LEFT", this.leftOffset.getValue().toString());
                this.stepMech.setRotorOffset("MIDDLE", this.middleOffset.getValue().toString());
                this.stepMech.setRotorOffset("RIGHT", this.rightOffset.getValue().toString());
                this.stepMech.setUKWIndex(this.reflectorPosition.getValue().toString());
                this.stepMech.setRotorIndex("LEFT", this.leftPosition.getValue().toString());
                this.stepMech.setRotorIndex("MIDDLE", this.middlePosition.getValue().toString());
                this.stepMech.setRotorIndex("RIGHT", this.rightPosition.getValue().toString());
                switch (this.setupType) {
                    case "MACHINE": {
                        EnigmaG enigmaG2 = new EnigmaG(this.stepMech);
                        enigmaG2.refresh();
                        enigmaG2.setVisible(true);
                        break;
                    }
                    case "INSTANT": {
                        InstantEnigma ie = new InstantEnigma(this.stepMech);
                        ie.setVisible(true);
                    }
                }
                break;
            }
            case "Enigma G31 -- Z\u00e4hlwerk (G-111)": {
                this.stepMech = new SteppingMechanism("G1");
                this.stepMech.setRotors(null, this.leftType.getSelectedItem().toString(), this.middleType.getSelectedItem().toString(), this.rightType.getSelectedItem().toString());
                this.stepMech.setRotorOffset("LEFT", this.leftOffset.getValue().toString());
                this.stepMech.setRotorOffset("MIDDLE", this.middleOffset.getValue().toString());
                this.stepMech.setRotorOffset("RIGHT", this.rightOffset.getValue().toString());
                this.stepMech.setUKWIndex(this.reflectorPosition.getValue().toString());
                this.stepMech.setRotorIndex("LEFT", this.leftPosition.getValue().toString());
                this.stepMech.setRotorIndex("MIDDLE", this.middlePosition.getValue().toString());
                this.stepMech.setRotorIndex("RIGHT", this.rightPosition.getValue().toString());
                switch (this.setupType) {
                    case "MACHINE": {
                        EnigmaG enigmaG1 = new EnigmaG(this.stepMech);
                        enigmaG1.refresh();
                        enigmaG1.setVisible(true);
                        break;
                    }
                    case "INSTANT": {
                        InstantEnigma ie = new InstantEnigma(this.stepMech);
                        ie.setVisible(true);
                    }
                }
                break;
            }
            case "Enigma A28 -- Z\u00e4hlwerk": {
                this.stepMech = new SteppingMechanism("GA");
                this.stepMech.setRotors(null, this.leftType.getSelectedItem().toString(), this.middleType.getSelectedItem().toString(), this.rightType.getSelectedItem().toString());
                this.stepMech.setRotorOffset("LEFT", this.leftOffset.getValue().toString());
                this.stepMech.setRotorOffset("MIDDLE", this.middleOffset.getValue().toString());
                this.stepMech.setRotorOffset("RIGHT", this.rightOffset.getValue().toString());
                this.stepMech.setUKWIndex(this.reflectorPosition.getValue().toString());
                this.stepMech.setRotorIndex("LEFT", this.leftPosition.getValue().toString());
                this.stepMech.setRotorIndex("MIDDLE", this.middlePosition.getValue().toString());
                this.stepMech.setRotorIndex("RIGHT", this.rightPosition.getValue().toString());
                switch (this.setupType) {
                    case "MACHINE": {
                        EnigmaG enigmaGA = new EnigmaG(this.stepMech);
                        enigmaGA.refresh();
                        enigmaGA.setVisible(true);
                        break block15;
                    }
                    case "INSTANT": {
                        InstantEnigma ie = new InstantEnigma(this.stepMech);
                        ie.setVisible(true);
                    }
                }
            }
        }
    }

    private void refresh() {
        String obj;
        switch (obj = this.machineType.getSelectedItem().toString()) {
            case "Enigma D -- Commercial": {
                this.reflectorType.removeAllItems();
                this.reflectorType.addItem("UKW");
                this.reflectorType.setEnabled(false);
                this.reflectorPosition.setEnabled(true);
                this.extraType.removeAllItems();
                this.extraType.addItem("N\\A");
                this.extraType.setEnabled(false);
                this.extraOffset.setEnabled(false);
                this.extraPosition.setEnabled(false);
                this.extraPosition.setValue("A");
                this.extraOffset.setValue("A");
                this.leftType.removeAllItems();
                this.leftType.addItem("I");
                this.leftType.addItem("II");
                this.leftType.addItem("III");
                this.middleType.removeAllItems();
                this.middleType.addItem("I");
                this.middleType.addItem("II");
                this.middleType.addItem("III");
                this.rightType.removeAllItems();
                this.rightType.addItem("I");
                this.rightType.addItem("II");
                this.rightType.addItem("III");
                this.infoLabel.setIcon(new ImageIcon(this.getClass().getResource("/resources/tiles/D.png")));
                this.infoLabel.setToolTipText("<html><strong style=\"font-size: 100%\"><center>Enigma D</strong></center>Year: 1926<br>Use: Commecrial<br>Stepping: Regular<br>Plugboard: N\\A<br>Rotors: 3<br>UKW: Settable</html>");
                break;
            }
            case "Enigma I -- Service": {
                this.reflectorType.removeAllItems();
                this.reflectorType.addItem("UKW - A");
                this.reflectorType.addItem("UKW - B");
                this.reflectorType.addItem("UKW - C");
                this.reflectorType.setEnabled(true);
                this.reflectorPosition.setEnabled(false);
                this.reflectorPosition.setValue("A");
                this.extraType.removeAllItems();
                this.extraType.addItem("N\\A");
                this.extraType.setEnabled(false);
                this.extraOffset.setEnabled(false);
                this.extraPosition.setEnabled(false);
                this.extraPosition.setValue("A");
                this.extraOffset.setValue("A");
                this.leftType.removeAllItems();
                this.leftType.addItem("I");
                this.leftType.addItem("II");
                this.leftType.addItem("III");
                this.leftType.addItem("IV");
                this.leftType.addItem("V");
                this.middleType.removeAllItems();
                this.middleType.addItem("I");
                this.middleType.addItem("II");
                this.middleType.addItem("III");
                this.middleType.addItem("IV");
                this.middleType.addItem("V");
                this.rightType.removeAllItems();
                this.rightType.addItem("I");
                this.rightType.addItem("II");
                this.rightType.addItem("III");
                this.rightType.addItem("IV");
                this.rightType.addItem("V");
                this.infoLabel.setIcon(new ImageIcon(this.getClass().getResource("/resources/tiles/ISN.png")));
                this.infoLabel.setToolTipText("<html><strong style=\"font-size: 100%\"><center>Enigma I</strong></center>Year: 1932<br>Use: Army, Air Force<br>Stepping: Regular<br>Plugboard: Available<br>Rotors: 3<br>UKW: Fixed</html>");
                break;
            }
            case "Enigma I -- Norway": {
                this.reflectorType.removeAllItems();
                this.reflectorType.addItem("UKW");
                this.reflectorType.setEnabled(false);
                this.reflectorPosition.setEnabled(false);
                this.reflectorPosition.setValue("A");
                this.extraType.removeAllItems();
                this.extraType.addItem("N\\A");
                this.extraType.setEnabled(false);
                this.extraOffset.setEnabled(false);
                this.extraPosition.setEnabled(false);
                this.extraPosition.setValue("A");
                this.extraOffset.setValue("A");
                this.leftType.removeAllItems();
                this.leftType.addItem("I");
                this.leftType.addItem("II");
                this.leftType.addItem("III");
                this.leftType.addItem("IV");
                this.leftType.addItem("V");
                this.middleType.removeAllItems();
                this.middleType.addItem("I");
                this.middleType.addItem("II");
                this.middleType.addItem("III");
                this.middleType.addItem("IV");
                this.middleType.addItem("V");
                this.rightType.removeAllItems();
                this.rightType.addItem("I");
                this.rightType.addItem("II");
                this.rightType.addItem("III");
                this.rightType.addItem("IV");
                this.rightType.addItem("V");
                this.infoLabel.setIcon(new ImageIcon(this.getClass().getResource("/resources/tiles/ISN.png")));
                this.infoLabel.setToolTipText("<html><strong style=\"font-size: 100%\"><center>Enigma I</strong></center>Year: 1932 (1945)<br>Use: Norway (NPSS)<br>Stepping: Regular<br>Plugboard: Available<br>Rotors: 3<br>UKW: Fixed</html>");
                break;
            }
            case "Enigma M3 -- Heer": {
                this.reflectorType.removeAllItems();
                this.reflectorType.addItem("UKW - B");
                this.reflectorType.addItem("UKW - C");
                this.reflectorType.setEnabled(true);
                this.reflectorPosition.setEnabled(false);
                this.reflectorPosition.setValue("A");
                this.extraType.removeAllItems();
                this.extraType.addItem("N\\A");
                this.extraType.setEnabled(false);
                this.extraOffset.setEnabled(false);
                this.extraPosition.setEnabled(false);
                this.extraPosition.setValue("A");
                this.extraOffset.setValue("A");
                this.leftType.removeAllItems();
                this.leftType.addItem("I");
                this.leftType.addItem("II");
                this.leftType.addItem("III");
                this.leftType.addItem("IV");
                this.leftType.addItem("V");
                this.leftType.addItem("VI");
                this.leftType.addItem("VII");
                this.leftType.addItem("VIII");
                this.middleType.removeAllItems();
                this.middleType.addItem("I");
                this.middleType.addItem("II");
                this.middleType.addItem("III");
                this.middleType.addItem("IV");
                this.middleType.addItem("V");
                this.middleType.addItem("VI");
                this.middleType.addItem("VII");
                this.middleType.addItem("VIII");
                this.rightType.removeAllItems();
                this.rightType.addItem("I");
                this.rightType.addItem("II");
                this.rightType.addItem("III");
                this.rightType.addItem("IV");
                this.rightType.addItem("V");
                this.rightType.addItem("VI");
                this.rightType.addItem("VII");
                this.rightType.addItem("VIII");
                this.infoLabel.setIcon(new ImageIcon(this.getClass().getResource("/resources/tiles/IM3.png")));
                this.infoLabel.setToolTipText("<html><strong style=\"font-size: 100%\"><center>Enigma M3</strong></center>Year: 1940<br>Use: Navy<br>Stepping: Regular<br>Plugboard: Available<br>Rotors: 3<br>UKW: Fixed</html>");
                break;
            }
            case "Enigma M4 -- Shark": {
                this.reflectorType.removeAllItems();
                this.reflectorType.addItem("UKW - B");
                this.reflectorType.addItem("UKW - C");
                this.reflectorType.addItem("UKW - D");
                this.reflectorType.setEnabled(true);
                this.reflectorPosition.setEnabled(false);
                this.reflectorPosition.setValue("A");
                this.extraType.removeAllItems();
                this.extraType.addItem("Beta");
                this.extraType.addItem("Gamma");
                this.extraType.setEnabled(true);
                this.extraOffset.setEnabled(true);
                this.extraPosition.setEnabled(true);
                this.leftType.removeAllItems();
                this.leftType.addItem("I");
                this.leftType.addItem("II");
                this.leftType.addItem("III");
                this.leftType.addItem("IV");
                this.leftType.addItem("V");
                this.leftType.addItem("VI");
                this.leftType.addItem("VII");
                this.leftType.addItem("VIII");
                this.middleType.removeAllItems();
                this.middleType.addItem("I");
                this.middleType.addItem("II");
                this.middleType.addItem("III");
                this.middleType.addItem("IV");
                this.middleType.addItem("V");
                this.middleType.addItem("VI");
                this.middleType.addItem("VII");
                this.middleType.addItem("VIII");
                this.rightType.removeAllItems();
                this.rightType.addItem("I");
                this.rightType.addItem("II");
                this.rightType.addItem("III");
                this.rightType.addItem("IV");
                this.rightType.addItem("V");
                this.rightType.addItem("VI");
                this.rightType.addItem("VII");
                this.rightType.addItem("VIII");
                this.infoLabel.setIcon(new ImageIcon(this.getClass().getResource("/resources/tiles/IM4.png")));
                this.infoLabel.setToolTipText("<html><strong style=\"font-size: 100%\"><center>Enigma M4</strong></center>Year: 1941<br>Use: Navy (U-Boot)<br>Stepping: Regular<br>Plugboard: Available<br>Rotors: 4<br>UKW: Fixed</html>");
                break;
            }
            case "Enigma K -- Swiss": {
                this.reflectorType.removeAllItems();
                this.reflectorType.addItem("UKW");
                this.reflectorType.setEnabled(false);
                this.reflectorPosition.setEnabled(true);
                this.extraType.removeAllItems();
                this.extraType.addItem("N\\A");
                this.extraType.setEnabled(false);
                this.extraOffset.setEnabled(false);
                this.extraPosition.setEnabled(false);
                this.extraPosition.setValue("A");
                this.extraOffset.setValue("A");
                this.leftType.removeAllItems();
                this.leftType.addItem("I");
                this.leftType.addItem("II");
                this.leftType.addItem("III");
                this.middleType.removeAllItems();
                this.middleType.addItem("I");
                this.middleType.addItem("II");
                this.middleType.addItem("III");
                this.rightType.removeAllItems();
                this.rightType.addItem("I");
                this.rightType.addItem("II");
                this.rightType.addItem("III");
                this.infoLabel.setIcon(new ImageIcon(this.getClass().getResource("/resources/tiles/KRS.png")));
                this.infoLabel.setToolTipText("<html><strong style=\"font-size: 100%\"><center>Enigma K</strong></center>Year: 1938<br>Use: Swiss Army<br>Stepping: Regular<br>Plugboard: N\\A<br>Rotors: 3<br>UKW: Settable</html>");
                break;
            }
            case "Enigma T -- Tirpitz": {
                this.reflectorType.removeAllItems();
                this.reflectorType.addItem("UKW");
                this.reflectorType.setEnabled(false);
                this.reflectorPosition.setEnabled(true);
                this.extraType.removeAllItems();
                this.extraType.addItem("N\\A");
                this.extraType.setEnabled(false);
                this.extraOffset.setEnabled(false);
                this.extraPosition.setEnabled(false);
                this.extraPosition.setValue("A");
                this.extraOffset.setValue("A");
                this.leftType.removeAllItems();
                this.leftType.addItem("I");
                this.leftType.addItem("II");
                this.leftType.addItem("III");
                this.leftType.addItem("IV");
                this.leftType.addItem("V");
                this.leftType.addItem("VI");
                this.leftType.addItem("VII");
                this.leftType.addItem("VIII");
                this.middleType.removeAllItems();
                this.middleType.addItem("I");
                this.middleType.addItem("II");
                this.middleType.addItem("III");
                this.middleType.addItem("IV");
                this.middleType.addItem("V");
                this.middleType.addItem("VI");
                this.middleType.addItem("VII");
                this.middleType.addItem("VIII");
                this.rightType.removeAllItems();
                this.rightType.addItem("I");
                this.rightType.addItem("II");
                this.rightType.addItem("III");
                this.rightType.addItem("IV");
                this.rightType.addItem("V");
                this.rightType.addItem("VI");
                this.rightType.addItem("VII");
                this.rightType.addItem("VIII");
                this.infoLabel.setIcon(new ImageIcon(this.getClass().getResource("/resources/tiles/KT.png")));
                this.infoLabel.setToolTipText("<html><strong style=\"font-size: 100%\"><center>Enigma T</strong></center>Year: 1942<br>Use: Japanese Army<br>Stepping: Regular<br>Plugboard: N\\A<br>Rotors: 3<br>UKW: Settable</html>");
                break;
            }
            case "Enigma K -- Rocket": {
                this.reflectorType.removeAllItems();
                this.reflectorType.addItem("UKW");
                this.reflectorType.setEnabled(false);
                this.reflectorPosition.setEnabled(true);
                this.extraType.removeAllItems();
                this.extraType.addItem("N\\A");
                this.extraType.setEnabled(false);
                this.extraOffset.setEnabled(false);
                this.extraPosition.setEnabled(false);
                this.extraPosition.setValue("A");
                this.extraOffset.setValue("A");
                this.leftType.removeAllItems();
                this.leftType.addItem("I");
                this.leftType.addItem("II");
                this.leftType.addItem("III");
                this.middleType.removeAllItems();
                this.middleType.addItem("I");
                this.middleType.addItem("II");
                this.middleType.addItem("III");
                this.rightType.removeAllItems();
                this.rightType.addItem("I");
                this.rightType.addItem("II");
                this.rightType.addItem("III");
                this.infoLabel.setIcon(new ImageIcon(this.getClass().getResource("/resources/tiles/KRS.png")));
                this.infoLabel.setToolTipText("<html><strong style=\"font-size: 100%\"><center>Enigma K</strong></center>Year: 1927<br>Use: Railway<br>Stepping: Regular<br>Plugboard: N\\A<br>Rotors: 3<br>UKW: Settable</html>");
                break;
            }
            case "Enigma KD -- Mil Amt": {
                this.reflectorType.removeAllItems();
                this.reflectorType.addItem("UKW - D");
                this.reflectorType.setEnabled(false);
                this.reflectorPosition.setEnabled(false);
                this.reflectorPosition.setValue("A");
                this.extraType.removeAllItems();
                this.extraType.addItem("N\\A");
                this.extraType.setEnabled(false);
                this.extraOffset.setEnabled(false);
                this.extraPosition.setEnabled(false);
                this.extraPosition.setValue("A");
                this.extraOffset.setValue("A");
                this.leftType.removeAllItems();
                this.leftType.addItem("I");
                this.leftType.addItem("II");
                this.leftType.addItem("III");
                this.middleType.removeAllItems();
                this.middleType.addItem("I");
                this.middleType.addItem("II");
                this.middleType.addItem("III");
                this.rightType.removeAllItems();
                this.rightType.addItem("I");
                this.rightType.addItem("II");
                this.rightType.addItem("III");
                this.infoLabel.setIcon(new ImageIcon(this.getClass().getResource("/resources/tiles/KD.png")));
                this.infoLabel.setToolTipText("<html><strong style=\"font-size: 100%\"><center>Enigma KD</strong></center>Year: 1944<br>Use: Mil Amt<br>Stepping: Regular<br>Plugboard: N\\A<br>Rotors: 3<br>UKW: Rewirable</html>");
                break;
            }
            case "Enigma G31 -- Abwehr (G-312)": {
                this.reflectorType.removeAllItems();
                this.reflectorType.addItem("UKW");
                this.reflectorType.setEnabled(false);
                this.reflectorPosition.setEnabled(true);
                this.extraType.removeAllItems();
                this.extraType.addItem("N\\A");
                this.extraType.setEnabled(false);
                this.extraOffset.setEnabled(false);
                this.extraPosition.setEnabled(false);
                this.extraPosition.setValue("A");
                this.extraOffset.setValue("A");
                this.leftType.removeAllItems();
                this.leftType.addItem("I");
                this.leftType.addItem("II");
                this.leftType.addItem("III");
                this.middleType.removeAllItems();
                this.middleType.addItem("I");
                this.middleType.addItem("II");
                this.middleType.addItem("III");
                this.rightType.removeAllItems();
                this.rightType.addItem("I");
                this.rightType.addItem("II");
                this.rightType.addItem("III");
                this.infoLabel.setIcon(new ImageIcon(this.getClass().getResource("/resources/tiles/G123.png")));
                this.infoLabel.setToolTipText("<html><strong style=\"font-size: 100%\"><center>Enigma G312</strong></center>Year: 1931<br>Use: Abwehr<br>Stepping: Irregular<br>Plugboard: N\\A<br>Rotors: 3<br>UKW: Movable</html>");
                break;
            }
            case "Enigma G31 -- Abwehr (G-260)": {
                this.reflectorType.removeAllItems();
                this.reflectorType.addItem("UKW");
                this.reflectorType.setEnabled(false);
                this.reflectorPosition.setEnabled(true);
                this.extraType.removeAllItems();
                this.extraType.addItem("N\\A");
                this.extraType.setEnabled(false);
                this.extraOffset.setEnabled(false);
                this.extraPosition.setEnabled(false);
                this.extraPosition.setValue("A");
                this.extraOffset.setValue("A");
                this.leftType.removeAllItems();
                this.leftType.addItem("I");
                this.leftType.addItem("II");
                this.leftType.addItem("III");
                this.middleType.removeAllItems();
                this.middleType.addItem("I");
                this.middleType.addItem("II");
                this.middleType.addItem("III");
                this.rightType.removeAllItems();
                this.rightType.addItem("I");
                this.rightType.addItem("II");
                this.rightType.addItem("III");
                this.infoLabel.setIcon(new ImageIcon(this.getClass().getResource("/resources/tiles/G123.png")));
                this.infoLabel.setToolTipText("<html><strong style=\"font-size: 100%\"><center>Enigma G260</strong></center>Year: 1931<br>Use: Abwehr<br>Stepping: Irregular<br>Plugboard: N\\A<br>Rotors: 3<br>UKW: Movable</html>");
                break;
            }
            case "Enigma G31 -- Z\u00e4hlwerk (G-111)": {
                this.reflectorType.removeAllItems();
                this.reflectorType.addItem("UKW");
                this.reflectorType.setEnabled(false);
                this.reflectorPosition.setEnabled(true);
                this.extraType.removeAllItems();
                this.extraType.addItem("N\\A");
                this.extraType.setEnabled(false);
                this.extraOffset.setEnabled(false);
                this.extraPosition.setEnabled(false);
                this.extraPosition.setValue("A");
                this.extraOffset.setValue("A");
                this.leftType.removeAllItems();
                this.leftType.addItem("I");
                this.leftType.addItem("II");
                this.leftType.addItem("V");
                this.middleType.removeAllItems();
                this.middleType.addItem("I");
                this.middleType.addItem("II");
                this.middleType.addItem("V");
                this.rightType.removeAllItems();
                this.rightType.addItem("I");
                this.rightType.addItem("II");
                this.rightType.addItem("V");
                this.infoLabel.setIcon(new ImageIcon(this.getClass().getResource("/resources/tiles/G123.png")));
                this.infoLabel.setToolTipText("<html><strong style=\"font-size: 100%\"><center>Enigma G111</strong></center>Year: 1931<br>Use: -<br>Stepping: Irregular<br>Plugboard: N\\A<br>Rotors: 3<br>UKW: Movable</html>");
                break;
            }
            case "Enigma A28 -- Z\u00e4hlwerk": {
                this.reflectorType.removeAllItems();
                this.reflectorType.addItem("UKW");
                this.reflectorType.setEnabled(false);
                this.reflectorPosition.setEnabled(true);
                this.extraType.removeAllItems();
                this.extraType.addItem("N\\A");
                this.extraType.setEnabled(false);
                this.extraOffset.setEnabled(false);
                this.extraPosition.setEnabled(false);
                this.extraPosition.setValue("A");
                this.extraOffset.setValue("A");
                this.leftType.removeAllItems();
                this.leftType.addItem("I");
                this.leftType.addItem("II");
                this.leftType.addItem("III");
                this.middleType.removeAllItems();
                this.middleType.addItem("I");
                this.middleType.addItem("II");
                this.middleType.addItem("III");
                this.rightType.removeAllItems();
                this.rightType.addItem("I");
                this.rightType.addItem("II");
                this.rightType.addItem("III");
                this.infoLabel.setIcon(new ImageIcon(this.getClass().getResource("/resources/tiles/GA.png")));
                this.infoLabel.setToolTipText("<html><strong style=\"font-size: 100%\"><center>Enigma A28</strong></center>Year: 1928<br>Use: Abwehr<br>Stepping: Irregular<br>Plugboard: N\\A<br>Rotors: 3<br>UKW: Movable</html>");
            }
        }
    }

    private void setStartBtn() {
        if (!this.checkValues()) {
            this.startBtn.setEnabled(false);
        } else {
            this.startBtn.setEnabled(true);
        }
    }

    private void initComponents() {
        this.titlePanel = new JPanel();
        this.titleLabel = new JLabel();
        this.containerPanel = new JPanel();
        this.settingsPanel = new JPanel();
        this.machineType = new JComboBox();
        this.reflectorType = new JComboBox();
        this.extraType = new JComboBox();
        this.leftType = new JComboBox();
        this.middleType = new JComboBox();
        this.rightType = new JComboBox();
        this.extraOffset = new JSpinner();
        this.middlePosition = new JSpinner();
        this.extraPosition = new JSpinner();
        this.leftPosition = new JSpinner();
        this.machineLabel = new JLabel();
        this.reflectorLabel = new JLabel();
        this.extraRotorLabel = new JLabel();
        this.leftRotorLabel = new JLabel();
        this.middleRotorLabel = new JLabel();
        this.rightRotorLabel = new JLabel();
        this.middleOffsetLabel = new JLabel();
        this.extraOffsetLabel = new JLabel();
        this.leftOffsetLabel = new JLabel();
        this.rightOffsetLabel = new JLabel();
        this.leftPositionLabel = new JLabel();
        this.middleOffset = new JSpinner();
        this.rightPositionLabel = new JLabel();
        this.reflectorPositionLabel = new JLabel();
        this.extraPositionLabel = new JLabel();
        this.rightPosition = new JSpinner();
        this.reflectorPosition = new JSpinner();
        this.rightOffset = new JSpinner();
        this.leftOffset = new JSpinner();
        this.middlePositionLabel = new JLabel();
        this.topSeperator = new JSeparator();
        this.middleSeperator = new JSeparator();
        this.rightSeperator = new JSeparator();
        this.infoPanel = new JPanel();
        this.infoLabel = new JLabel();
        this.controlPanel = new JPanel();
        this.startBtn = new JButton();
        this.buttonsSeperator = new JSeparator();
        this.menuBtn = new JButton();
        this.setMaximumSize(new Dimension(595, 350));
        this.setMinimumSize(new Dimension(595, 350));
        this.setOpaque(false);
        this.setPreferredSize(new Dimension(595, 350));
        this.setLayout(new BorderLayout());
        this.titlePanel.setFocusable(false);
        this.titlePanel.setMaximumSize(new Dimension(260, 70));
        this.titlePanel.setMinimumSize(new Dimension(260, 70));
        this.titlePanel.setOpaque(false);
        this.titlePanel.setPreferredSize(new Dimension(260, 70));
        this.titleLabel.setHorizontalAlignment(0);
        this.titleLabel.setIcon(new ImageIcon(this.getClass().getResource("/resources/banners/MachineSetup.png")));
        this.titleLabel.setFocusable(false);
        this.titlePanel.add(this.titleLabel);
        this.add((Component)this.titlePanel, "First");
        this.containerPanel.setFocusable(false);
        this.containerPanel.setMaximumSize(new Dimension(595, 240));
        this.containerPanel.setMinimumSize(new Dimension(595, 240));
        this.containerPanel.setOpaque(false);
        this.containerPanel.setPreferredSize(new Dimension(595, 240));
        this.containerPanel.setLayout(new BoxLayout(this.containerPanel, 2));
        this.settingsPanel.setFocusable(false);
        this.settingsPanel.setMaximumSize(new Dimension(415, 232));
        this.settingsPanel.setMinimumSize(new Dimension(415, 232));
        this.settingsPanel.setOpaque(false);
        this.settingsPanel.setPreferredSize(new Dimension(415, 232));
        this.machineType.setModel(new DefaultComboBoxModel<String>(new String[]{"Enigma D -- Commercial", "Enigma K -- Rocket", "Enigma K -- Swiss", "Enigma T -- Tirpitz", "Enigma KD -- Mil Amt", "Enigma A28 -- Z\u00e4hlwerk", "Enigma G31 -- Z\u00e4hlwerk (G-111)", "Enigma G31 -- Abwehr (G-260)", "Enigma G31 -- Abwehr (G-312)", "Enigma I -- Service", "Enigma I -- Norway", "Enigma M3 -- Heer", "Enigma M4 -- Shark"}));
        this.machineType.setMaximumSize(new Dimension(298, 25));
        this.machineType.setMinimumSize(new Dimension(298, 25));
        this.machineType.setPreferredSize(new Dimension(298, 25));
        this.machineType.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent evt) {
                SetupPanel.this.machineTypeMouseWheelMoved(evt);
            }
        });
        this.machineType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SetupPanel.this.machineTypeActionPerformed(evt);
            }
        });
        this.reflectorType.setModel(new DefaultComboBoxModel<String>(new String[]{"UKW"}));
        this.reflectorType.setEnabled(false);
        this.reflectorType.setLightWeightPopupEnabled(false);
        this.reflectorType.setMaximumSize(new Dimension(182, 25));
        this.reflectorType.setMinimumSize(new Dimension(182, 25));
        this.reflectorType.setPreferredSize(new Dimension(182, 25));
        this.reflectorType.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent evt) {
                SetupPanel.this.reflectorTypeMouseWheelMoved(evt);
            }
        });
        this.reflectorType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SetupPanel.this.reflectorTypeActionPerformed(evt);
            }
        });
        this.extraType.setModel(new DefaultComboBoxModel<String>(new String[]{"N\\A"}));
        this.extraType.setEnabled(false);
        this.extraType.setMaximumSize(new Dimension(80, 25));
        this.extraType.setMinimumSize(new Dimension(80, 25));
        this.extraType.setPreferredSize(new Dimension(80, 25));
        this.extraType.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent evt) {
                SetupPanel.this.extraTypeMouseWheelMoved(evt);
            }
        });
        this.leftType.setModel(new DefaultComboBoxModel<String>(new String[]{"I", "II", "III"}));
        this.leftType.setMaximumSize(new Dimension(80, 25));
        this.leftType.setMinimumSize(new Dimension(80, 25));
        this.leftType.setPreferredSize(new Dimension(80, 25));
        this.leftType.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent evt) {
                SetupPanel.this.leftTypeMouseWheelMoved(evt);
            }
        });
        this.leftType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SetupPanel.this.leftTypeActionPerformed(evt);
            }
        });
        this.middleType.setModel(new DefaultComboBoxModel<String>(new String[]{"I", "II", "III"}));
        this.middleType.setMaximumSize(new Dimension(80, 25));
        this.middleType.setMinimumSize(new Dimension(80, 25));
        this.middleType.setPreferredSize(new Dimension(80, 25));
        this.middleType.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent evt) {
                SetupPanel.this.middleTypeMouseWheelMoved(evt);
            }
        });
        this.middleType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SetupPanel.this.middleTypeActionPerformed(evt);
            }
        });
        this.rightType.setModel(new DefaultComboBoxModel<String>(new String[]{"I", "II", "III"}));
        this.rightType.setMaximumSize(new Dimension(80, 25));
        this.rightType.setMinimumSize(new Dimension(80, 25));
        this.rightType.setPreferredSize(new Dimension(80, 25));
        this.rightType.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent evt) {
                SetupPanel.this.rightTypeMouseWheelMoved(evt);
            }
        });
        this.rightType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SetupPanel.this.rightTypeActionPerformed(evt);
            }
        });
        this.extraOffset.setModel(new SpinnerListModel(new String[]{"Z", "Y", "X", "W", "V", "U", "T", "S", "R", "Q", "P", "O", "N", "M", "L", "K", "J", "I", "H", "G", "F", "E", "D", "C", "B", "A"}));
        this.extraOffset.setEditor(new JSpinner.DefaultEditor(this.extraOffset));
        this.extraOffset.setEnabled(false);
        this.extraOffset.setMaximumSize(new Dimension(50, 25));
        this.extraOffset.setMinimumSize(new Dimension(50, 25));
        this.extraOffset.setPreferredSize(new Dimension(50, 25));
        this.extraOffset.setValue("A");
        this.extraOffset.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent evt) {
                SetupPanel.this.extraOffsetMouseWheelMoved(evt);
            }
        });
        this.middlePosition.setModel(new SpinnerListModel(new String[]{"Z", "Y", "X", "W", "V", "U", "T", "S", "R", "Q", "P", "O", "N", "M", "L", "K", "J", "I", "H", "G", "F", "E", "D", "C", "B", "A"}));
        this.middlePosition.setEditor(new JSpinner.DefaultEditor(this.middlePosition));
        this.middlePosition.setMaximumSize(new Dimension(50, 25));
        this.middlePosition.setMinimumSize(new Dimension(50, 25));
        this.middlePosition.setPreferredSize(new Dimension(50, 25));
        this.middlePosition.setValue("A");
        this.middlePosition.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent evt) {
                SetupPanel.this.middlePositionMouseWheelMoved(evt);
            }
        });
        this.extraPosition.setModel(new SpinnerListModel(new String[]{"Z", "Y", "X", "W", "V", "U", "T", "S", "R", "Q", "P", "O", "N", "M", "L", "K", "J", "I", "H", "G", "F", "E", "D", "C", "B", "A"}));
        this.extraPosition.setEditor(new JSpinner.DefaultEditor(this.extraPosition));
        this.extraPosition.setEnabled(false);
        this.extraPosition.setMaximumSize(new Dimension(50, 25));
        this.extraPosition.setMinimumSize(new Dimension(50, 25));
        this.extraPosition.setPreferredSize(new Dimension(50, 25));
        this.extraPosition.setValue("A");
        this.extraPosition.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent evt) {
                SetupPanel.this.extraPositionMouseWheelMoved(evt);
            }
        });
        this.leftPosition.setModel(new SpinnerListModel(new String[]{"Z", "Y", "X", "W", "V", "U", "T", "S", "R", "Q", "P", "O", "N", "M", "L", "K", "J", "I", "H", "G", "F", "E", "D", "C", "B", "A"}));
        this.leftPosition.setEditor(new JSpinner.DefaultEditor(this.leftPosition));
        this.leftPosition.setMaximumSize(new Dimension(50, 25));
        this.leftPosition.setMinimumSize(new Dimension(50, 25));
        this.leftPosition.setPreferredSize(new Dimension(50, 25));
        this.leftPosition.setValue("A");
        this.leftPosition.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent evt) {
                SetupPanel.this.leftPositionMouseWheelMoved(evt);
            }
        });
        this.machineLabel.setText("Machine:");
        this.machineLabel.setFocusable(false);
        this.machineLabel.setMaximumSize(new Dimension(80, 25));
        this.machineLabel.setMinimumSize(new Dimension(80, 25));
        this.machineLabel.setPreferredSize(new Dimension(80, 25));
        this.reflectorLabel.setText("Reflector:");
        this.reflectorLabel.setFocusable(false);
        this.reflectorLabel.setMaximumSize(new Dimension(80, 25));
        this.reflectorLabel.setMinimumSize(new Dimension(80, 25));
        this.reflectorLabel.setPreferredSize(new Dimension(80, 25));
        this.extraRotorLabel.setHorizontalAlignment(2);
        this.extraRotorLabel.setText("Extra rotor:");
        this.extraRotorLabel.setFocusable(false);
        this.extraRotorLabel.setHorizontalTextPosition(0);
        this.extraRotorLabel.setMaximumSize(new Dimension(80, 25));
        this.extraRotorLabel.setMinimumSize(new Dimension(80, 25));
        this.extraRotorLabel.setPreferredSize(new Dimension(80, 25));
        this.leftRotorLabel.setHorizontalAlignment(2);
        this.leftRotorLabel.setText("Left rotor:");
        this.leftRotorLabel.setFocusable(false);
        this.leftRotorLabel.setMaximumSize(new Dimension(80, 25));
        this.leftRotorLabel.setMinimumSize(new Dimension(80, 25));
        this.leftRotorLabel.setPreferredSize(new Dimension(80, 25));
        this.middleRotorLabel.setHorizontalAlignment(2);
        this.middleRotorLabel.setText("Middle rotor:");
        this.middleRotorLabel.setFocusable(false);
        this.middleRotorLabel.setMaximumSize(new Dimension(80, 25));
        this.middleRotorLabel.setMinimumSize(new Dimension(80, 25));
        this.middleRotorLabel.setPreferredSize(new Dimension(80, 25));
        this.rightRotorLabel.setHorizontalAlignment(2);
        this.rightRotorLabel.setText("Right rotor:");
        this.rightRotorLabel.setFocusable(false);
        this.rightRotorLabel.setMaximumSize(new Dimension(80, 25));
        this.rightRotorLabel.setMinimumSize(new Dimension(80, 25));
        this.rightRotorLabel.setPreferredSize(new Dimension(80, 25));
        this.middleOffsetLabel.setText("Offset:");
        this.middleOffsetLabel.setFocusable(false);
        this.middleOffsetLabel.setMaximumSize(new Dimension(40, 25));
        this.middleOffsetLabel.setMinimumSize(new Dimension(40, 25));
        this.middleOffsetLabel.setPreferredSize(new Dimension(40, 25));
        this.extraOffsetLabel.setText("Offset:");
        this.extraOffsetLabel.setFocusable(false);
        this.extraOffsetLabel.setMaximumSize(new Dimension(40, 25));
        this.extraOffsetLabel.setMinimumSize(new Dimension(40, 25));
        this.extraOffsetLabel.setPreferredSize(new Dimension(40, 25));
        this.leftOffsetLabel.setText("Offset:");
        this.leftOffsetLabel.setFocusable(false);
        this.leftOffsetLabel.setMaximumSize(new Dimension(40, 25));
        this.leftOffsetLabel.setMinimumSize(new Dimension(40, 25));
        this.leftOffsetLabel.setPreferredSize(new Dimension(40, 25));
        this.rightOffsetLabel.setText("Offset:");
        this.rightOffsetLabel.setFocusable(false);
        this.rightOffsetLabel.setMaximumSize(new Dimension(40, 25));
        this.rightOffsetLabel.setMinimumSize(new Dimension(40, 25));
        this.rightOffsetLabel.setPreferredSize(new Dimension(40, 25));
        this.leftPositionLabel.setText("Position:");
        this.leftPositionLabel.setFocusable(false);
        this.leftPositionLabel.setMaximumSize(new Dimension(50, 25));
        this.leftPositionLabel.setMinimumSize(new Dimension(50, 25));
        this.leftPositionLabel.setPreferredSize(new Dimension(50, 25));
        this.middleOffset.setModel(new SpinnerListModel(new String[]{"Z", "Y", "X", "W", "V", "U", "T", "S", "R", "Q", "P", "O", "N", "M", "L", "K", "J", "I", "H", "G", "F", "E", "D", "C", "B", "A"}));
        this.middleOffset.setEditor(new JSpinner.DefaultEditor(this.middleOffset));
        this.middleOffset.setMaximumSize(new Dimension(50, 25));
        this.middleOffset.setMinimumSize(new Dimension(50, 25));
        this.middleOffset.setPreferredSize(new Dimension(50, 25));
        this.middleOffset.setValue("A");
        this.middleOffset.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent evt) {
                SetupPanel.this.middleOffsetMouseWheelMoved(evt);
            }
        });
        this.rightPositionLabel.setText("Position:");
        this.rightPositionLabel.setFocusable(false);
        this.rightPositionLabel.setMaximumSize(new Dimension(50, 25));
        this.rightPositionLabel.setMinimumSize(new Dimension(50, 25));
        this.rightPositionLabel.setPreferredSize(new Dimension(50, 25));
        this.reflectorPositionLabel.setText("Position:");
        this.reflectorPositionLabel.setFocusable(false);
        this.reflectorPositionLabel.setMaximumSize(new Dimension(50, 25));
        this.reflectorPositionLabel.setMinimumSize(new Dimension(50, 25));
        this.reflectorPositionLabel.setPreferredSize(new Dimension(50, 25));
        this.extraPositionLabel.setText("Position:");
        this.extraPositionLabel.setFocusable(false);
        this.extraPositionLabel.setMaximumSize(new Dimension(50, 25));
        this.extraPositionLabel.setMinimumSize(new Dimension(50, 25));
        this.extraPositionLabel.setPreferredSize(new Dimension(50, 25));
        this.rightPosition.setModel(new SpinnerListModel(new String[]{"Z", "Y", "X", "W", "V", "U", "T", "S", "R", "Q", "P", "O", "N", "M", "L", "K", "J", "I", "H", "G", "F", "E", "D", "C", "B", "A"}));
        this.rightPosition.setEditor(new JSpinner.DefaultEditor(this.rightPosition));
        this.rightPosition.setMaximumSize(new Dimension(50, 25));
        this.rightPosition.setMinimumSize(new Dimension(50, 25));
        this.rightPosition.setPreferredSize(new Dimension(50, 25));
        this.rightPosition.setValue("A");
        this.rightPosition.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent evt) {
                SetupPanel.this.rightPositionMouseWheelMoved(evt);
            }
        });
        this.reflectorPosition.setModel(new SpinnerListModel(new String[]{"Z", "Y", "X", "W", "V", "U", "T", "S", "R", "Q", "P", "O", "N", "M", "L", "K", "J", "I", "H", "G", "F", "E", "D", "C", "B", "A"}));
        this.reflectorPosition.setEditor(new JSpinner.DefaultEditor(this.reflectorPosition));
        this.reflectorPosition.setMaximumSize(new Dimension(50, 25));
        this.reflectorPosition.setMinimumSize(new Dimension(50, 25));
        this.reflectorPosition.setPreferredSize(new Dimension(50, 25));
        this.reflectorPosition.setValue("A");
        this.reflectorPosition.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent evt) {
                SetupPanel.this.reflectorPositionMouseWheelMoved(evt);
            }
        });
        this.rightOffset.setModel(new SpinnerListModel(new String[]{"Z", "Y", "X", "W", "V", "U", "T", "S", "R", "Q", "P", "O", "N", "M", "L", "K", "J", "I", "H", "G", "F", "E", "D", "C", "B", "A"}));
        this.rightOffset.setEditor(new JSpinner.DefaultEditor(this.rightOffset));
        this.rightOffset.setMaximumSize(new Dimension(50, 25));
        this.rightOffset.setMinimumSize(new Dimension(50, 25));
        this.rightOffset.setPreferredSize(new Dimension(50, 25));
        this.rightOffset.setValue("A");
        this.rightOffset.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent evt) {
                SetupPanel.this.rightOffsetMouseWheelMoved(evt);
            }
        });
        this.leftOffset.setModel(new SpinnerListModel(new String[]{"Z", "Y", "X", "W", "V", "U", "T", "S", "R", "Q", "P", "O", "N", "M", "L", "K", "J", "I", "H", "G", "F", "E", "D", "C", "B", "A"}));
        this.leftOffset.setEditor(new JSpinner.DefaultEditor(this.leftOffset));
        this.leftOffset.setMaximumSize(new Dimension(50, 25));
        this.leftOffset.setMinimumSize(new Dimension(50, 25));
        this.leftOffset.setPreferredSize(new Dimension(50, 25));
        this.leftOffset.setValue("A");
        this.leftOffset.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent evt) {
                SetupPanel.this.leftOffsetMouseWheelMoved(evt);
            }
        });
        this.middlePositionLabel.setText("Position:");
        this.middlePositionLabel.setFocusable(false);
        this.middlePositionLabel.setMaximumSize(new Dimension(50, 25));
        this.middlePositionLabel.setMinimumSize(new Dimension(50, 25));
        this.middlePositionLabel.setPreferredSize(new Dimension(50, 25));
        this.rightSeperator.setOrientation(1);
        GroupLayout settingsPanelLayout = new GroupLayout(this.settingsPanel);
        this.settingsPanel.setLayout(settingsPanelLayout);
        settingsPanelLayout.setHorizontalGroup(settingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(settingsPanelLayout.createSequentialGroup().addContainerGap().addGroup(settingsPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.topSeperator).addComponent(this.middleSeperator, GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.LEADING, settingsPanelLayout.createSequentialGroup().addGroup(settingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.reflectorLabel, -2, 80, -2).addComponent(this.machineLabel, -2, 80, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(settingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(settingsPanelLayout.createSequentialGroup().addComponent(this.reflectorType, 0, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.reflectorPositionLabel, -2, 60, -2).addGap(2, 2, 2).addComponent(this.reflectorPosition, -2, 50, -2)).addComponent(this.machineType, 0, -1, Short.MAX_VALUE))).addGroup(GroupLayout.Alignment.LEADING, settingsPanelLayout.createSequentialGroup().addComponent(this.middleRotorLabel, -2, 80, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.middleType, -2, 80, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.middleOffsetLabel, -2, 45, -2).addGap(2, 2, 2).addComponent(this.middleOffset, -2, 50, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.middlePositionLabel, -2, 60, -2).addGap(2, 2, 2).addComponent(this.middlePosition, -2, 50, -2)).addGroup(GroupLayout.Alignment.LEADING, settingsPanelLayout.createSequentialGroup().addGroup(settingsPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(GroupLayout.Alignment.LEADING, settingsPanelLayout.createSequentialGroup().addComponent(this.rightRotorLabel, -2, 80, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rightType, -2, 80, -2)).addGroup(GroupLayout.Alignment.LEADING, settingsPanelLayout.createSequentialGroup().addGroup(settingsPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.extraRotorLabel, -2, 80, -2).addComponent(this.leftRotorLabel, -2, 80, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(settingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.leftType, -2, 80, -2).addComponent(this.extraType, -2, 80, -2)))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(settingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(settingsPanelLayout.createSequentialGroup().addComponent(this.rightOffsetLabel, -2, 45, -2).addGap(2, 2, 2).addComponent(this.rightOffset, -2, 50, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.rightPositionLabel, -2, 60, -2).addGap(2, 2, 2).addComponent(this.rightPosition, -2, 50, -2)).addGroup(settingsPanelLayout.createSequentialGroup().addGroup(settingsPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.leftOffsetLabel, -2, 45, -2).addComponent(this.extraOffsetLabel, -2, 45, -2)).addGap(2, 2, 2).addGroup(settingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(settingsPanelLayout.createSequentialGroup().addComponent(this.extraOffset, -2, 50, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.extraPositionLabel, -2, 60, -2).addGap(2, 2, 2).addComponent(this.extraPosition, -2, 50, -2)).addGroup(GroupLayout.Alignment.TRAILING, settingsPanelLayout.createSequentialGroup().addComponent(this.leftOffset, -2, 50, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.leftPositionLabel, -2, 60, -2).addGap(2, 2, 2).addComponent(this.leftPosition, -2, 50, -2))))))).addGap(6, 6, 6).addComponent(this.rightSeperator, -2, 2, -2).addGap(4, 4, 4)));
        settingsPanelLayout.setVerticalGroup(settingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(settingsPanelLayout.createSequentialGroup().addContainerGap().addGroup(settingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(settingsPanelLayout.createSequentialGroup().addGroup(settingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.machineType, -2, 25, -2).addComponent(this.machineLabel, -2, 25, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.topSeperator, -2, 2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(settingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.reflectorType, -2, 25, -2).addComponent(this.reflectorLabel, -2, 25, -2).addComponent(this.reflectorPositionLabel, -2, 25, -2).addComponent(this.reflectorPosition, -2, 25, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.middleSeperator, -2, 2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(settingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.extraRotorLabel, -2, 25, -2).addComponent(this.extraType, -2, 25, -2).addComponent(this.extraOffsetLabel, -2, 25, -2).addComponent(this.extraOffset, -2, 25, -2).addComponent(this.extraPositionLabel, -2, 25, -2).addComponent(this.extraPosition, -2, 25, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(settingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.leftType, -2, 25, -2).addComponent(this.leftRotorLabel, -2, 25, -2).addComponent(this.leftOffsetLabel, -2, 25, -2).addComponent(this.leftOffset, -2, 25, -2).addComponent(this.leftPositionLabel, -2, 25, -2).addComponent(this.leftPosition, -2, 25, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(settingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.middleRotorLabel, -2, 25, -2).addComponent(this.middleType, -2, 25, -2).addComponent(this.middleOffsetLabel, -2, 25, -2).addComponent(this.middleOffset, -2, 25, -2).addComponent(this.middlePositionLabel, -2, 25, -2).addComponent(this.middlePosition, -2, 25, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(settingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.rightRotorLabel, -2, 25, -2).addComponent(this.rightType, -2, 25, -2).addComponent(this.rightOffsetLabel, -2, 25, -2).addComponent(this.rightOffset, -2, 25, -2).addComponent(this.rightPositionLabel, -2, 25, -2).addComponent(this.rightPosition, -2, 25, -2)).addGap(0, 11, Short.MAX_VALUE)).addComponent(this.rightSeperator)).addContainerGap()));
        this.containerPanel.add(this.settingsPanel);
        this.infoPanel.setMaximumSize(new Dimension(180, 232));
        this.infoPanel.setMinimumSize(new Dimension(180, 232));
        this.infoPanel.setOpaque(false);
        this.infoPanel.setPreferredSize(new Dimension(180, 232));
        this.infoLabel.setHorizontalAlignment(0);
        this.infoLabel.setIcon(new ImageIcon(this.getClass().getResource("/resources/tiles/D.png")));
        this.infoLabel.setToolTipText("<html><strong style=\"font-size: 100%\"><center>Enigma D</strong></center>Year: 1926<br>Use: Commecrial<br>Stepping: Regular<br>Plugboard: N\\A<br>Rotors: 3<br>UKW: Settable</html>");
        this.infoLabel.setFocusable(false);
        GroupLayout infoPanelLayout = new GroupLayout(this.infoPanel);
        this.infoPanel.setLayout(infoPanelLayout);
        infoPanelLayout.setHorizontalGroup(infoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(infoPanelLayout.createSequentialGroup().addGap(2, 2, 2).addComponent(this.infoLabel, -1, 172, Short.MAX_VALUE).addGap(6, 6, 6)));
        infoPanelLayout.setVerticalGroup(infoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(infoPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.infoLabel, -1, 207, Short.MAX_VALUE).addContainerGap()));
        this.containerPanel.add(this.infoPanel);
        this.add((Component)this.containerPanel, "After");
        this.controlPanel.setFocusable(false);
        this.controlPanel.setMaximumSize(new Dimension(624, 60));
        this.controlPanel.setMinimumSize(new Dimension(624, 60));
        this.controlPanel.setOpaque(false);
        this.startBtn.setIcon(new ImageIcon(this.getClass().getResource("/resources/buttons/StartNew.png")));
        this.startBtn.setContentAreaFilled(false);
        this.startBtn.setCursor(new Cursor(12));
        this.startBtn.setEnabled(false);
        this.startBtn.setFocusable(false);
        this.startBtn.setHorizontalTextPosition(0);
        this.startBtn.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/buttons/StartNewPress.png")));
        this.startBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SetupPanel.this.startBtnActionPerformed(evt);
            }
        });
        this.menuBtn.setIcon(new ImageIcon(this.getClass().getResource("/resources/buttons/MenuNew.png")));
        this.menuBtn.setContentAreaFilled(false);
        this.menuBtn.setCursor(new Cursor(12));
        this.menuBtn.setFocusable(false);
        this.menuBtn.setHorizontalTextPosition(0);
        this.menuBtn.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/buttons/MenuNewPress.png")));
        this.menuBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SetupPanel.this.menuBtnActionPerformed(evt);
            }
        });
        GroupLayout controlPanelLayout = new GroupLayout(this.controlPanel);
        this.controlPanel.setLayout(controlPanelLayout);
        controlPanelLayout.setHorizontalGroup(controlPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(controlPanelLayout.createSequentialGroup().addGap(12, 12, 12).addGroup(controlPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(controlPanelLayout.createSequentialGroup().addGap(2, 2, 2).addComponent(this.menuBtn, -2, 75, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 420, Short.MAX_VALUE).addComponent(this.startBtn, -2, 75, -2)).addComponent(this.buttonsSeperator)).addGap(11, 11, 11)));
        controlPanelLayout.setVerticalGroup(controlPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, controlPanelLayout.createSequentialGroup().addGap(2, 2, 2).addComponent(this.buttonsSeperator, -2, 2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(controlPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.startBtn, -2, 30, -2).addComponent(this.menuBtn, -2, 30, -2)).addContainerGap()));
        this.add((Component)this.controlPanel, "Last");
    }

    private void machineTypeActionPerformed(ActionEvent evt) {
        this.refresh();
        this.setStartBtn();
    }

    private void reflectorTypeActionPerformed(ActionEvent evt) {
        this.custom();
    }

    private void startBtnActionPerformed(ActionEvent evt) {
        this.start();
        JFrame ancestorFrame = (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, this);
        ancestorFrame.dispose();
    }

    private void menuBtnActionPerformed(ActionEvent evt) {
        Menu m = new Menu();
        m.setVisible(true);
        JFrame ancestorFrame = (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, this);
        ancestorFrame.dispose();
    }

    private void machineTypeMouseWheelMoved(MouseWheelEvent evt) {
        if (evt.getWheelRotation() < 0) {
            int newIndex = this.machineType.getSelectedIndex() - 1;
            if (newIndex >= 0) {
                this.machineType.setSelectedIndex(newIndex);
            }
        } else {
            int newIndex = this.machineType.getSelectedIndex() + 1;
            if (newIndex < this.machineType.getItemCount()) {
                this.machineType.setSelectedIndex(newIndex);
            }
        }
        this.setStartBtn();
    }

    private void reflectorTypeMouseWheelMoved(MouseWheelEvent evt) {
        if (evt.getWheelRotation() < 0) {
            int newIndex = this.reflectorType.getSelectedIndex() - 1;
            if (newIndex >= 0) {
                this.reflectorType.setSelectedIndex(newIndex);
            }
        } else {
            int newIndex = this.reflectorType.getSelectedIndex() + 1;
            if (newIndex < this.reflectorType.getItemCount()) {
                this.reflectorType.setSelectedIndex(newIndex);
            }
        }
    }

    private void extraTypeMouseWheelMoved(MouseWheelEvent evt) {
        if (evt.getWheelRotation() < 0) {
            int newIndex = this.extraType.getSelectedIndex() - 1;
            if (newIndex >= 0) {
                this.extraType.setSelectedIndex(newIndex);
            }
        } else {
            int newIndex = this.extraType.getSelectedIndex() + 1;
            if (newIndex < this.extraType.getItemCount()) {
                this.extraType.setSelectedIndex(newIndex);
            }
        }
    }

    private void leftTypeMouseWheelMoved(MouseWheelEvent evt) {
        if (evt.getWheelRotation() < 0) {
            int newIndex = this.leftType.getSelectedIndex() - 1;
            if (newIndex >= 0) {
                this.leftType.setSelectedIndex(newIndex);
            }
        } else {
            int newIndex = this.leftType.getSelectedIndex() + 1;
            if (newIndex < this.leftType.getItemCount()) {
                this.leftType.setSelectedIndex(newIndex);
            }
        }
        this.setStartBtn();
    }

    private void middleTypeMouseWheelMoved(MouseWheelEvent evt) {
        if (evt.getWheelRotation() < 0) {
            int newIndex = this.middleType.getSelectedIndex() - 1;
            if (newIndex >= 0) {
                this.middleType.setSelectedIndex(newIndex);
            }
        } else {
            int newIndex = this.middleType.getSelectedIndex() + 1;
            if (newIndex < this.middleType.getItemCount()) {
                this.middleType.setSelectedIndex(newIndex);
            }
        }
        this.setStartBtn();
    }

    private void rightTypeMouseWheelMoved(MouseWheelEvent evt) {
        if (evt.getWheelRotation() < 0) {
            int newIndex = this.rightType.getSelectedIndex() - 1;
            if (newIndex >= 0) {
                this.rightType.setSelectedIndex(newIndex);
            }
        } else {
            int newIndex = this.rightType.getSelectedIndex() + 1;
            if (newIndex < this.rightType.getItemCount()) {
                this.rightType.setSelectedIndex(newIndex);
            }
        }
        this.setStartBtn();
    }

    private void reflectorPositionMouseWheelMoved(MouseWheelEvent evt) {
        if (this.reflectorPosition.isEnabled()) {
            if (evt.getWheelRotation() < 0) {
                if (this.reflectorPosition.getNextValue() != null) {
                    this.reflectorPosition.setValue(this.reflectorPosition.getNextValue());
                }
            } else if (this.reflectorPosition.getPreviousValue() != null) {
                this.reflectorPosition.setValue(this.reflectorPosition.getPreviousValue());
            }
        }
    }

    private void extraPositionMouseWheelMoved(MouseWheelEvent evt) {
        if (this.extraPosition.isEnabled()) {
            if (evt.getWheelRotation() < 0) {
                if (this.extraPosition.getNextValue() != null) {
                    this.extraPosition.setValue(this.extraPosition.getNextValue());
                }
            } else if (this.extraPosition.getPreviousValue() != null) {
                this.extraPosition.setValue(this.extraPosition.getPreviousValue());
            }
        }
    }

    private void leftPositionMouseWheelMoved(MouseWheelEvent evt) {
        if (evt.getWheelRotation() < 0) {
            if (this.leftPosition.getNextValue() != null) {
                this.leftPosition.setValue(this.leftPosition.getNextValue());
            }
        } else if (this.leftPosition.getPreviousValue() != null) {
            this.leftPosition.setValue(this.leftPosition.getPreviousValue());
        }
    }

    private void middlePositionMouseWheelMoved(MouseWheelEvent evt) {
        if (evt.getWheelRotation() < 0) {
            if (this.middlePosition.getNextValue() != null) {
                this.middlePosition.setValue(this.middlePosition.getNextValue());
            }
        } else if (this.middlePosition.getPreviousValue() != null) {
            this.middlePosition.setValue(this.middlePosition.getPreviousValue());
        }
    }

    private void rightPositionMouseWheelMoved(MouseWheelEvent evt) {
        if (evt.getWheelRotation() < 0) {
            if (this.rightPosition.getNextValue() != null) {
                this.rightPosition.setValue(this.rightPosition.getNextValue());
            }
        } else if (this.rightPosition.getPreviousValue() != null) {
            this.rightPosition.setValue(this.rightPosition.getPreviousValue());
        }
    }

    private void extraOffsetMouseWheelMoved(MouseWheelEvent evt) {
        if (this.extraOffset.isEnabled()) {
            if (evt.getWheelRotation() < 0) {
                if (this.extraOffset.getNextValue() != null) {
                    this.extraOffset.setValue(this.extraOffset.getNextValue());
                }
            } else if (this.extraOffset.getPreviousValue() != null) {
                this.extraOffset.setValue(this.extraOffset.getPreviousValue());
            }
        }
    }

    private void leftOffsetMouseWheelMoved(MouseWheelEvent evt) {
        if (evt.getWheelRotation() < 0) {
            if (this.leftOffset.getNextValue() != null) {
                this.leftOffset.setValue(this.leftOffset.getNextValue());
            }
        } else if (this.leftOffset.getPreviousValue() != null) {
            this.leftOffset.setValue(this.leftOffset.getPreviousValue());
        }
    }

    private void middleOffsetMouseWheelMoved(MouseWheelEvent evt) {
        if (evt.getWheelRotation() < 0) {
            if (this.middleOffset.getNextValue() != null) {
                this.middleOffset.setValue(this.middleOffset.getNextValue());
            }
        } else if (this.middleOffset.getPreviousValue() != null) {
            this.middleOffset.setValue(this.middleOffset.getPreviousValue());
        }
    }

    private void rightOffsetMouseWheelMoved(MouseWheelEvent evt) {
        if (evt.getWheelRotation() < 0) {
            if (this.rightOffset.getNextValue() != null) {
                this.rightOffset.setValue(this.rightOffset.getNextValue());
            }
        } else if (this.rightOffset.getPreviousValue() != null) {
            this.rightOffset.setValue(this.rightOffset.getPreviousValue());
        }
    }

    private void leftTypeActionPerformed(ActionEvent evt) {
        this.setStartBtn();
    }

    private void middleTypeActionPerformed(ActionEvent evt) {
        this.setStartBtn();
    }

    private void rightTypeActionPerformed(ActionEvent evt) {
        this.setStartBtn();
    }
}

