/*
 * Decompiled with CFR 0.152.
 */
package machines;

import enigma.SteppingMechanism;
import frames.FrameAssistant;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import machines.Exchanger;
import machines.PlugboardFrame;
import machines.ReflectorFrame;
import machines.panels.IKeyboardPanel;
import machines.panels.IM4LampPanel;
import machines.panels.LampPanel;
import machines.panels.RotorPanel;

public class EnigmaI
extends JFrame {
    private Exchanger exchanger;
    private String eType;
    private SteppingMechanism stepMech;
    private ReflectorFrame refFrame;
    private JPanel machinePanel;
    private JPanel enigmaPanel;
    private RotorPanel rotorPanel;
    private LampPanel lampPanel;
    private IKeyboardPanel iKeyboardPanel;
    private IM4LampPanel im4LampPanel;
    private JLabel plugPanel;
    private PlugboardFrame plugboardFrame;
    private JLabel boxBottom;
    private JLabel boxLeft;
    private JLabel boxRight;

    public EnigmaI(SteppingMechanism sm) {
        this.stepMech = sm;
        this.eType = this.stepMech.getType();
        this.initComponents();
        this.customComponents();
        this.loadFrameIcon();
    }

    public void refresh() {
        this.rotorPanel.updateWindow();
    }

    public ReflectorFrame getReflector() {
        return this.refFrame;
    }

    public PlugboardFrame getPlugboard() {
        return this.plugboardFrame;
    }

    private void customComponents() {
        this.exchanger = new Exchanger();
        this.exchanger.setSteppingMechanism(this.stepMech);
        if (this.eType.equals("IM4D")) {
            this.refFrame = new ReflectorFrame(this.stepMech);
        }
        this.machinePanel = new JPanel();
        this.enigmaPanel = new JPanel();
        this.rotorPanel = new RotorPanel(this.stepMech);
        this.exchanger.setRotorPanel(this.rotorPanel);
        FrameAssistant frameAssist = new FrameAssistant("MACHINE.DEFAULT", this.stepMech);
        switch (this.eType) {
            case "IS": 
            case "IN": {
                this.lampPanel = new LampPanel(this.eType);
                this.exchanger.setLampPanel(this.lampPanel);
                break;
            }
            case "IM3": 
            case "IM4": 
            case "IM4D": {
                this.im4LampPanel = new IM4LampPanel();
                this.exchanger.setIM4LampPanel(this.im4LampPanel);
                frameAssist = new FrameAssistant("MACHINE.ARMY", this.stepMech);
                this.boxBottom.setIcon(new ImageIcon(this.getClass().getResource("/resources/box/BoxBottomArmy.png")));
            }
        }
        this.iKeyboardPanel = new IKeyboardPanel(this.exchanger);
        this.exchanger.setIKeyPanel(this.iKeyboardPanel);
        this.plugboardFrame = this.iKeyboardPanel.getPlugFrame();
        if (this.eType.equals("IM4D")) {
            frameAssist.setFrames(this.iKeyboardPanel.getMessageBoard(), this.iKeyboardPanel.getPlugFrame(), this.refFrame, null);
            this.exchanger.setReflectorPanel(this.refFrame.getReflectorPanel());
        } else {
            frameAssist.setFrames(this.iKeyboardPanel.getMessageBoard(), this.iKeyboardPanel.getPlugFrame(), null, null);
        }
        this.plugPanel = new JLabel();
        this.plugPanel.setIcon(new ImageIcon(this.getClass().getResource("/resources/panels/PlugPad.png")));
        this.plugPanel.setToolTipText("Double click for plugboard");
        this.plugPanel.setCursor(new Cursor(12));
        this.plugPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    EnigmaI.this.plugboardFrame.setVisible(true);
                }
            }
        });
        this.enigmaPanel.setLayout(new BorderLayout());
        this.enigmaPanel.add((Component)this.rotorPanel, "North");
        if (this.eType.equals("IM4") || this.eType.equals("IM3") || this.eType.equals("IM4D")) {
            this.enigmaPanel.add((Component)this.im4LampPanel, "Center");
        } else {
            this.enigmaPanel.add((Component)this.lampPanel, "Center");
        }
        this.enigmaPanel.add((Component)this.iKeyboardPanel, "South");
        this.machinePanel.setLayout(new BorderLayout());
        this.machinePanel.add((Component)this.enigmaPanel, "Center");
        this.machinePanel.add((Component)this.plugPanel, "South");
        this.getContentPane().add((Component)frameAssist, "First");
        this.getContentPane().add((Component)this.machinePanel, "Center");
        switch (this.eType) {
            case "IS": {
                this.setTitle("Enigma I Service");
                break;
            }
            case "IN": {
                this.setTitle("Enigma I Norway");
                break;
            }
            case "IM3": {
                this.setTitle("Enigma M3");
                break;
            }
            case "IM4": {
                this.setTitle("Enigma M4");
                break;
            }
            case "IM4D": {
                this.setTitle("Enigma M4 with UKW-D");
            }
        }
        Dimension d1 = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((d1.width - this.getSize().width) / 2, (d1.height - this.getSize().height) / 2);
        this.pack();
    }

    private void loadFrameIcon() {
        ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("/resources/EnigmaLogo32.png"));
        Image image = imageIcon.getImage();
        this.setIconImage(image);
    }

    private void initComponents() {
        this.boxLeft = new JLabel();
        this.boxRight = new JLabel();
        this.boxBottom = new JLabel();
        this.setDefaultCloseOperation(3);
        this.setMaximumSize(new Dimension(380, 480));
        this.setMinimumSize(new Dimension(380, 480));
        this.setUndecorated(true);
        this.setPreferredSize(new Dimension(380, 480));
        this.setResizable(false);
        this.boxLeft.setHorizontalAlignment(0);
        this.boxLeft.setIcon(new ImageIcon(this.getClass().getResource("/resources/box/BoxHorizontal.png")));
        this.boxLeft.setFocusable(false);
        this.getContentPane().add((Component)this.boxLeft, "Before");
        this.boxRight.setHorizontalAlignment(0);
        this.boxRight.setIcon(new ImageIcon(this.getClass().getResource("/resources/box/BoxHorizontal.png")));
        this.boxRight.setFocusable(false);
        this.getContentPane().add((Component)this.boxRight, "After");
        this.boxBottom.setHorizontalAlignment(0);
        this.boxBottom.setIcon(new ImageIcon(this.getClass().getResource("/resources/box/BoxBottomtDefault.png")));
        this.boxBottom.setFocusable(false);
        this.getContentPane().add((Component)this.boxBottom, "Last");
        this.pack();
    }
}

