/*
 * Decompiled with CFR 0.152.
 */
package machines;

import enigma.SteppingMechanism;
import frames.FrameAssistant;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import machines.Exchanger;
import machines.ReflectorFrame;
import machines.panels.KeyboardPanel;
import machines.panels.LampPanel;
import machines.panels.RotorPanel;

public class EnigmaK
extends JFrame {
    private Exchanger exchanger;
    private SteppingMechanism stepMech;
    private ReflectorFrame refFrame;
    private JPanel enigmaPanel;
    private RotorPanel rotorPanel;
    private LampPanel lampPanel;
    private KeyboardPanel keyboardPanel;
    private String eType;
    private JLabel boxBottom;
    private JLabel boxLeft;
    private JLabel boxRight;

    public EnigmaK(SteppingMechanism sm) {
        this.stepMech = sm;
        this.eType = this.stepMech.getType();
        this.initComponents();
        this.customComponents();
        this.loadFrameIcon();
    }

    public void refresh() {
        this.rotorPanel.updateWindow();
    }

    public ReflectorFrame getReflector() {
        return this.refFrame;
    }

    private void customComponents() {
        this.exchanger = new Exchanger();
        this.exchanger.setSteppingMechanism(this.stepMech);
        if (this.eType.equals("KD")) {
            this.refFrame = new ReflectorFrame(this.stepMech);
            this.exchanger.setReflectorPanel(this.refFrame.getReflectorPanel());
        }
        this.enigmaPanel = new JPanel();
        this.rotorPanel = new RotorPanel(this.stepMech);
        this.exchanger.setRotorPanel(this.rotorPanel);
        this.lampPanel = new LampPanel(this.eType);
        this.exchanger.setLampPanel(this.lampPanel);
        this.keyboardPanel = new KeyboardPanel(this.exchanger);
        this.exchanger.setKeyPanel(this.keyboardPanel);
        FrameAssistant frameAssist = new FrameAssistant("MACHINE.DEFAULT", this.stepMech);
        switch (this.eType) {
            case "KD": {
                frameAssist.setFrames(this.keyboardPanel.getMessageBoard(), null, this.refFrame, null);
                break;
            }
            case "KS": {
                frameAssist.setFrames(this.keyboardPanel.getMessageBoard(), null, null, this.keyboardPanel.getLampFrame());
                break;
            }
            default: {
                frameAssist.setFrames(this.keyboardPanel.getMessageBoard(), null, null, null);
            }
        }
        this.enigmaPanel.setLayout(new BorderLayout());
        this.enigmaPanel.add((Component)this.rotorPanel, "North");
        this.enigmaPanel.add((Component)this.lampPanel, "Center");
        this.enigmaPanel.add((Component)this.keyboardPanel, "South");
        this.getContentPane().add((Component)frameAssist, "First");
        this.getContentPane().add((Component)this.enigmaPanel, "Center");
        switch (this.eType) {
            case "D": {
                this.setTitle("Enigma D");
                break;
            }
            case "K": {
                this.setTitle("Enigma K");
                break;
            }
            case "KD": {
                this.setTitle("Enigma KD");
                break;
            }
            case "KS": {
                this.setTitle("Enigma K Swiss");
                break;
            }
            case "KR": {
                this.setTitle("Enigma K Railway");
                break;
            }
            case "KT": {
                this.setTitle("Enigma T Tirpitz");
            }
        }
        Dimension d1 = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((d1.width - this.getSize().width) / 2, (d1.height - this.getSize().height) / 2);
        this.pack();
    }

    private void loadFrameIcon() {
        ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("/resources/EnigmaLogo32.png"));
        Image image = imageIcon.getImage();
        this.setIconImage(image);
    }

    private void initComponents() {
        this.boxLeft = new JLabel();
        this.boxRight = new JLabel();
        this.boxBottom = new JLabel();
        this.setDefaultCloseOperation(3);
        this.setMaximumSize(new Dimension(380, 416));
        this.setMinimumSize(new Dimension(380, 416));
        this.setUndecorated(true);
        this.setPreferredSize(new Dimension(380, 416));
        this.setResizable(false);
        this.boxLeft.setHorizontalAlignment(0);
        this.boxLeft.setIcon(new ImageIcon(this.getClass().getResource("/resources/box/BoxHorizontal.png")));
        this.boxLeft.setFocusable(false);
        this.getContentPane().add((Component)this.boxLeft, "Before");
        this.boxRight.setHorizontalAlignment(0);
        this.boxRight.setIcon(new ImageIcon(this.getClass().getResource("/resources/box/BoxHorizontal.png")));
        this.boxRight.setFocusable(false);
        this.getContentPane().add((Component)this.boxRight, "After");
        this.boxBottom.setHorizontalAlignment(0);
        this.boxBottom.setIcon(new ImageIcon(this.getClass().getResource("/resources/box/BoxBottomtDefault.png")));
        this.boxBottom.setFocusable(false);
        this.getContentPane().add((Component)this.boxBottom, "Last");
        this.pack();
    }
}

