/*
 * Decompiled with CFR 0.152.
 */
package machines;

import enigma.Plugboard;
import frames.FrameAssistant;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import machines.panels.PlugboardPanel;

public class PlugboardFrame
extends JFrame {
    private FrameAssistant frameAssist = new FrameAssistant("POPUP", null);
    private PlugboardPanel plugboardPanel = new PlugboardPanel();
    private JLabel boxBottom;
    private JLabel boxLeft;
    private JLabel boxRight;

    public PlugboardFrame() {
        this.initComponents();
        this.loadFrameIcon();
        this.getContentPane().add((Component)this.frameAssist, "First");
        this.getContentPane().add((Component)this.plugboardPanel, "Center");
        this.setTitle("Plugboard");
        Dimension d1 = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((d1.width - this.getSize().width) / 2, (d1.height - this.getSize().height) / 2);
        this.pack();
    }

    private void loadFrameIcon() {
        ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("/resources/EnigmaLogo32.png"));
        Image image = imageIcon.getImage();
        this.setIconImage(image);
    }

    public Plugboard getPlugB() {
        return this.plugboardPanel.getPlugB();
    }

    public String[] getPairs() {
        return this.plugboardPanel.getPairs();
    }

    public void resetPlugs() {
        this.plugboardPanel.resetPlugs();
    }

    public void plugCable(char letter) {
        this.plugboardPanel.plugCable(letter);
    }

    private void initComponents() {
        this.boxLeft = new JLabel();
        this.boxRight = new JLabel();
        this.boxBottom = new JLabel();
        this.setDefaultCloseOperation(3);
        this.setMaximumSize(new Dimension(380, 305));
        this.setMinimumSize(new Dimension(380, 305));
        this.setUndecorated(true);
        this.setPreferredSize(new Dimension(380, 305));
        this.setResizable(false);
        this.boxLeft.setHorizontalAlignment(0);
        this.boxLeft.setIcon(new ImageIcon(this.getClass().getResource("/resources/box/BoxHorizontal.png")));
        this.boxLeft.setFocusable(false);
        this.getContentPane().add((Component)this.boxLeft, "Before");
        this.boxRight.setHorizontalAlignment(0);
        this.boxRight.setIcon(new ImageIcon(this.getClass().getResource("/resources/box/BoxHorizontal.png")));
        this.boxRight.setFocusable(false);
        this.getContentPane().add((Component)this.boxRight, "After");
        this.boxBottom.setHorizontalAlignment(0);
        this.boxBottom.setIcon(new ImageIcon(this.getClass().getResource("/resources/box/BoxBottomPlain.png")));
        this.boxBottom.setFocusable(false);
        this.getContentPane().add((Component)this.boxBottom, "Last");
        this.pack();
    }
}

