/*
 * Decompiled with CFR 0.152.
 */
package machines;

import enigma.SteppingMechanism;
import frames.FrameAssistant;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import machines.panels.ReflectorPanel;

public class ReflectorFrame
extends JFrame {
    private SteppingMechanism stepMech;
    private ReflectorPanel reflectorPanel;
    private JLabel boxBottom;
    private JLabel boxLeft;
    private JLabel boxRight;

    public ReflectorFrame(SteppingMechanism sm) {
        this.stepMech = sm;
        this.initComponents();
        this.customComponents();
        this.loadFrameIcon();
    }

    private void customComponents() {
        FrameAssistant frameAssist = new FrameAssistant("POPUP", null);
        this.reflectorPanel = new ReflectorPanel(this.stepMech);
        this.getContentPane().add((Component)frameAssist, "First");
        this.getContentPane().add((Component)this.reflectorPanel, "Center");
        this.setTitle("UKW-D reflector");
        Dimension d1 = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((d1.width - this.getSize().width) / 2, (d1.height - this.getSize().height) / 2);
        this.pack();
    }

    private void loadFrameIcon() {
        ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("/resources/EnigmaLogo32.png"));
        Image image = imageIcon.getImage();
        this.setIconImage(image);
    }

    public String[] getPairs() {
        return this.reflectorPanel.getPairs();
    }

    public void resetPlugs() {
        this.reflectorPanel.resetPlugs();
    }

    public void plugCable(char letter) {
        this.reflectorPanel.plugCable(letter);
    }

    public ReflectorPanel getReflectorPanel() {
        return this.reflectorPanel;
    }

    private void initComponents() {
        this.boxLeft = new JLabel();
        this.boxRight = new JLabel();
        this.boxBottom = new JLabel();
        this.setDefaultCloseOperation(3);
        this.setMaximumSize(new Dimension(270, 372));
        this.setMinimumSize(new Dimension(270, 372));
        this.setUndecorated(true);
        this.setPreferredSize(new Dimension(270, 372));
        this.setResizable(false);
        this.boxLeft.setIcon(new ImageIcon(this.getClass().getResource("/resources/box/BoxHorizontal.png")));
        this.boxLeft.setFocusable(false);
        this.getContentPane().add((Component)this.boxLeft, "Before");
        this.boxRight.setHorizontalAlignment(0);
        this.boxRight.setIcon(new ImageIcon(this.getClass().getResource("/resources/box/BoxHorizontal.png")));
        this.boxRight.setFocusable(false);
        this.getContentPane().add((Component)this.boxRight, "After");
        this.boxBottom.setHorizontalAlignment(0);
        this.boxBottom.setIcon(new ImageIcon(this.getClass().getResource("/resources/box/BoxBottomPlain.png")));
        this.boxBottom.setFocusable(false);
        this.getContentPane().add((Component)this.boxBottom, "Last");
        this.pack();
    }
}

