/*
 * Decompiled with CFR 0.152.
 */
package machines.panels;

import enigma.Plugboard;
import enigma.SteppingMechanism;
import frames.MessageFrame;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import machines.Exchanger;
import machines.PlugboardFrame;
import machines.panels.IM4LampPanel;
import machines.panels.LampPanel;
import machines.panels.RotorPanel;

public class IKeyboardPanel
extends JPanel {
    private Exchanger exchanger;
    private SteppingMechanism stepMech;
    private RotorPanel rotorPanel;
    private IM4LampPanel im4LampPanel;
    private LampPanel lampPanel;
    private MessageFrame msgBoard;
    private PlugboardFrame plugboardFrame;
    private Plugboard plugboard;
    private char prevCipher;
    private char cipher;
    private String eType;
    private JButton btnA;
    private JButton btnB;
    private JButton btnC;
    private JButton btnD;
    private JButton btnE;
    private JButton btnF;
    private JButton btnG;
    private JButton btnH;
    private JButton btnI;
    private JButton btnJ;
    private JButton btnK;
    private JButton btnL;
    private JButton btnM;
    private JButton btnN;
    private JButton btnO;
    private JButton btnP;
    private JButton btnQ;
    private JButton btnR;
    private JButton btnS;
    private JButton btnT;
    private JButton btnU;
    private JButton btnV;
    private JButton btnW;
    private JButton btnX;
    private JButton btnY;
    private JButton btnZ;

    public IKeyboardPanel(Exchanger e) {
        this.initComponents();
        this.btnQ.getInputMap().put(KeyStroke.getKeyStroke("SPACE"), "doNothing");
        this.exchanger = e;
        this.stepMech = this.exchanger.getSteppingMechanism();
        this.eType = this.stepMech.getType();
        if (this.eType.equals("IM4") || this.eType.equals("IM3") || this.eType.equals("IM4D")) {
            this.im4LampPanel = this.exchanger.getIM4LampPanel();
            this.setBakeliteKeys();
        } else {
            this.lampPanel = this.exchanger.getLampPanel();
        }
        this.rotorPanel = this.exchanger.getRotorPanel();
        this.msgBoard = new MessageFrame();
        this.plugboardFrame = new PlugboardFrame();
        this.plugboard = this.plugboardFrame.getPlugB();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D gKey = (Graphics2D)g;
        ImageIcon keyImage = new ImageIcon(this.getClass().getResource("/resources/panels/IKey.png"));
        switch (this.eType) {
            case "IM3": 
            case "IS": 
            case "IN": {
                keyImage = new ImageIcon(this.getClass().getResource("/resources/panels/IKey.png"));
                break;
            }
            case "IM4": 
            case "IM4D": {
                keyImage = new ImageIcon(this.getClass().getResource("/resources/panels/IM4Key.png"));
            }
        }
        Image image = keyImage.getImage();
        if (image != null) {
            gKey.drawImage(image, 0, 0, 360, 115, this);
        }
    }

    private void pressKey(char letter) {
        if (this.eType.equals("IM4D")) {
            if (this.exchanger.getReflectorPanel().isFull()) {
                char plain = letter;
                this.im4LampPanel.deactivate(this.prevCipher);
                this.stepMech.step();
                this.rotorPanel.updateWindow();
                letter = this.plugboard.swap(letter);
                this.cipher = this.stepMech.encipher(letter);
                this.cipher = this.plugboard.swap(this.cipher);
                this.im4LampPanel.activate(this.cipher);
                this.prevCipher = this.cipher;
                this.msgBoard.getMessagePanel().printPlain(plain);
                this.msgBoard.getMessagePanel().printCipher(this.cipher);
            } else {
                ImageIcon icon23 = new ImageIcon(this.getClass().getResource("/resources/popup/Info.png"));
                JOptionPane.showMessageDialog(this, "<html><strong style=\"font-size: 100%\">UKW-D is not fully wired.</strong><br>The machine will not operate correctly until<br>the reflector has been fitted with all twelve cables.<html>", "UKW-D reflector", 1, icon23);
            }
        } else {
            char plain = letter;
            if (this.eType.equals("IM4") || this.eType.equals("IM3") || this.eType.equals("IM4D")) {
                this.im4LampPanel.deactivate(this.prevCipher);
            } else {
                this.lampPanel.deactivate(this.prevCipher);
            }
            this.stepMech.step();
            this.rotorPanel.updateWindow();
            letter = this.plugboard.swap(letter);
            this.cipher = this.stepMech.encipher(letter);
            this.cipher = this.plugboard.swap(this.cipher);
            if (this.eType.equals("IM4") || this.eType.equals("IM3") || this.eType.equals("IM4D")) {
                this.im4LampPanel.activate(this.cipher);
            } else {
                this.lampPanel.activate(this.cipher);
            }
            this.prevCipher = this.cipher;
            this.msgBoard.getMessagePanel().printPlain(plain);
            this.msgBoard.getMessagePanel().printCipher(this.cipher);
        }
    }

    public MessageFrame getMessageBoard() {
        return this.msgBoard;
    }

    public PlugboardFrame getPlugFrame() {
        return this.plugboardFrame;
    }

    private void setBakeliteKeys() {
        this.btnQ.setIcon(new ImageIcon(this.getClass().getResource("/resources/keys/bakelite/Q.png")));
        this.btnQ.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/keys/bakelite/QPress.png")));
        this.btnW.setIcon(new ImageIcon(this.getClass().getResource("/resources/keys/bakelite/W.png")));
        this.btnW.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/keys/bakelite/WPress.png")));
        this.btnE.setIcon(new ImageIcon(this.getClass().getResource("/resources/keys/bakelite/E.png")));
        this.btnE.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/keys/bakelite/EPress.png")));
        this.btnR.setIcon(new ImageIcon(this.getClass().getResource("/resources/keys/bakelite/R.png")));
        this.btnR.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/keys/bakelite/RPress.png")));
        this.btnT.setIcon(new ImageIcon(this.getClass().getResource("/resources/keys/bakelite/T.png")));
        this.btnT.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/keys/bakelite/TPress.png")));
        this.btnZ.setIcon(new ImageIcon(this.getClass().getResource("/resources/keys/bakelite/Z.png")));
        this.btnZ.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/keys/bakelite/ZPress.png")));
        this.btnU.setIcon(new ImageIcon(this.getClass().getResource("/resources/keys/bakelite/U.png")));
        this.btnU.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/keys/bakelite/UPress.png")));
        this.btnI.setIcon(new ImageIcon(this.getClass().getResource("/resources/keys/bakelite/I.png")));
        this.btnI.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/keys/bakelite/IPress.png")));
        this.btnO.setIcon(new ImageIcon(this.getClass().getResource("/resources/keys/bakelite/O.png")));
        this.btnO.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/keys/bakelite/OPress.png")));
        this.btnA.setIcon(new ImageIcon(this.getClass().getResource("/resources/keys/bakelite/A.png")));
        this.btnA.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/keys/bakelite/APress.png")));
        this.btnS.setIcon(new ImageIcon(this.getClass().getResource("/resources/keys/bakelite/S.png")));
        this.btnS.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/keys/bakelite/SPress.png")));
        this.btnD.setIcon(new ImageIcon(this.getClass().getResource("/resources/keys/bakelite/D.png")));
        this.btnD.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/keys/bakelite/DPress.png")));
        this.btnF.setIcon(new ImageIcon(this.getClass().getResource("/resources/keys/bakelite/F.png")));
        this.btnF.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/keys/bakelite/FPress.png")));
        this.btnG.setIcon(new ImageIcon(this.getClass().getResource("/resources/keys/bakelite/G.png")));
        this.btnG.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/keys/bakelite/GPress.png")));
        this.btnH.setIcon(new ImageIcon(this.getClass().getResource("/resources/keys/bakelite/H.png")));
        this.btnH.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/keys/bakelite/HPress.png")));
        this.btnJ.setIcon(new ImageIcon(this.getClass().getResource("/resources/keys/bakelite/J.png")));
        this.btnJ.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/keys/bakelite/JPress.png")));
        this.btnK.setIcon(new ImageIcon(this.getClass().getResource("/resources/keys/bakelite/K.png")));
        this.btnK.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/keys/bakelite/KPress.png")));
        this.btnP.setIcon(new ImageIcon(this.getClass().getResource("/resources/keys/bakelite/P.png")));
        this.btnP.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/keys/bakelite/PPress.png")));
        this.btnY.setIcon(new ImageIcon(this.getClass().getResource("/resources/keys/bakelite/Y.png")));
        this.btnY.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/keys/bakelite/YPress.png")));
        this.btnX.setIcon(new ImageIcon(this.getClass().getResource("/resources/keys/bakelite/X.png")));
        this.btnX.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/keys/bakelite/XPress.png")));
        this.btnC.setIcon(new ImageIcon(this.getClass().getResource("/resources/keys/bakelite/C.png")));
        this.btnC.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/keys/bakelite/CPress.png")));
        this.btnV.setIcon(new ImageIcon(this.getClass().getResource("/resources/keys/bakelite/V.png")));
        this.btnV.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/keys/bakelite/VPress.png")));
        this.btnB.setIcon(new ImageIcon(this.getClass().getResource("/resources/keys/bakelite/B.png")));
        this.btnB.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/keys/bakelite/BPress.png")));
        this.btnN.setIcon(new ImageIcon(this.getClass().getResource("/resources/keys/bakelite/N.png")));
        this.btnN.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/keys/bakelite/NPress.png")));
        this.btnM.setIcon(new ImageIcon(this.getClass().getResource("/resources/keys/bakelite/M.png")));
        this.btnM.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/keys/bakelite/MPress.png")));
        this.btnL.setIcon(new ImageIcon(this.getClass().getResource("/resources/keys/bakelite/L.png")));
        this.btnL.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/keys/bakelite/LPress.png")));
    }

    private void initComponents() {
        this.btnA = new JButton();
        this.btnS = new JButton();
        this.btnD = new JButton();
        this.btnF = new JButton();
        this.btnG = new JButton();
        this.btnH = new JButton();
        this.btnJ = new JButton();
        this.btnK = new JButton();
        this.btnB = new JButton();
        this.btnV = new JButton();
        this.btnC = new JButton();
        this.btnO = new JButton();
        this.btnQ = new JButton();
        this.btnP = new JButton();
        this.btnY = new JButton();
        this.btnX = new JButton();
        this.btnN = new JButton();
        this.btnM = new JButton();
        this.btnL = new JButton();
        this.btnW = new JButton();
        this.btnE = new JButton();
        this.btnR = new JButton();
        this.btnT = new JButton();
        this.btnZ = new JButton();
        this.btnU = new JButton();
        this.btnI = new JButton();
        this.setMinimumSize(new Dimension(360, 91));
        this.setPreferredSize(new Dimension(360, 115));
        this.btnA.addKeyListener(new EnigmaKeyListener());
        this.btnA.setIcon(new ImageIcon(this.getClass().getResource("/resources/keys/A.png")));
        this.btnA.setBorder(null);
        this.btnA.setContentAreaFilled(false);
        this.btnA.setCursor(new Cursor(12));
        this.btnA.setFocusPainted(false);
        this.btnA.setFocusable(false);
        this.btnA.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/keys/Apress.png")));
        this.btnA.setRequestFocusEnabled(false);
        this.btnA.setRolloverEnabled(false);
        this.btnA.setVerifyInputWhenFocusTarget(false);
        this.btnA.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IKeyboardPanel.this.btnAActionPerformed(evt);
            }
        });
        this.btnS.addKeyListener(new EnigmaKeyListener());
        this.btnS.setIcon(new ImageIcon(this.getClass().getResource("/resources/keys/S.png")));
        this.btnS.setContentAreaFilled(false);
        this.btnS.setCursor(new Cursor(12));
        this.btnS.setFocusPainted(false);
        this.btnS.setFocusable(false);
        this.btnS.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/keys/Spress.png")));
        this.btnS.setRequestFocusEnabled(false);
        this.btnS.setRolloverEnabled(false);
        this.btnS.setVerifyInputWhenFocusTarget(false);
        this.btnS.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IKeyboardPanel.this.btnSActionPerformed(evt);
            }
        });
        this.btnD.setIcon(new ImageIcon(this.getClass().getResource("/resources/keys/D.png")));
        this.btnD.setContentAreaFilled(false);
        this.btnD.setCursor(new Cursor(12));
        this.btnD.setFocusPainted(false);
        this.btnD.setFocusable(false);
        this.btnD.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/keys/Dpress.png")));
        this.btnD.setRequestFocusEnabled(false);
        this.btnD.setRolloverEnabled(false);
        this.btnD.setVerifyInputWhenFocusTarget(false);
        this.btnD.addKeyListener(new EnigmaKeyListener());
        this.btnD.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IKeyboardPanel.this.btnDActionPerformed(evt);
            }
        });
        this.btnF.setIcon(new ImageIcon(this.getClass().getResource("/resources/keys/F.png")));
        this.btnF.setContentAreaFilled(false);
        this.btnF.setCursor(new Cursor(12));
        this.btnF.setFocusPainted(false);
        this.btnF.setFocusable(false);
        this.btnF.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/keys/Fpress.png")));
        this.btnF.setRequestFocusEnabled(false);
        this.btnF.setRolloverEnabled(false);
        this.btnF.setVerifyInputWhenFocusTarget(false);
        this.btnF.addKeyListener(new EnigmaKeyListener());
        this.btnF.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IKeyboardPanel.this.btnFActionPerformed(evt);
            }
        });
        this.btnG.setIcon(new ImageIcon(this.getClass().getResource("/resources/keys/G.png")));
        this.btnG.setContentAreaFilled(false);
        this.btnG.setCursor(new Cursor(12));
        this.btnG.setFocusPainted(false);
        this.btnG.setFocusable(false);
        this.btnG.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/keys/Gpress.png")));
        this.btnG.setRequestFocusEnabled(false);
        this.btnG.setRolloverEnabled(false);
        this.btnG.setVerifyInputWhenFocusTarget(false);
        this.btnG.addKeyListener(new EnigmaKeyListener());
        this.btnG.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IKeyboardPanel.this.btnGActionPerformed(evt);
            }
        });
        this.btnH.setIcon(new ImageIcon(this.getClass().getResource("/resources/keys/H.png")));
        this.btnH.setContentAreaFilled(false);
        this.btnH.setCursor(new Cursor(12));
        this.btnH.setFocusPainted(false);
        this.btnH.setFocusable(false);
        this.btnH.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/keys/Hpress.png")));
        this.btnH.setRequestFocusEnabled(false);
        this.btnH.setRolloverEnabled(false);
        this.btnH.setVerifyInputWhenFocusTarget(false);
        this.btnH.addKeyListener(new EnigmaKeyListener());
        this.btnH.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IKeyboardPanel.this.btnHActionPerformed(evt);
            }
        });
        this.btnJ.setIcon(new ImageIcon(this.getClass().getResource("/resources/keys/J.png")));
        this.btnJ.setContentAreaFilled(false);
        this.btnJ.setCursor(new Cursor(12));
        this.btnJ.setFocusPainted(false);
        this.btnJ.setFocusable(false);
        this.btnJ.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/keys/Jpress.png")));
        this.btnJ.setRequestFocusEnabled(false);
        this.btnJ.setRolloverEnabled(false);
        this.btnJ.setVerifyInputWhenFocusTarget(false);
        this.btnJ.addKeyListener(new EnigmaKeyListener());
        this.btnJ.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IKeyboardPanel.this.btnJActionPerformed(evt);
            }
        });
        this.btnK.setIcon(new ImageIcon(this.getClass().getResource("/resources/keys/K.png")));
        this.btnK.setContentAreaFilled(false);
        this.btnK.setCursor(new Cursor(12));
        this.btnK.setFocusPainted(false);
        this.btnK.setFocusable(false);
        this.btnK.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/keys/Kpress.png")));
        this.btnK.setRequestFocusEnabled(false);
        this.btnK.setRolloverEnabled(false);
        this.btnK.setVerifyInputWhenFocusTarget(false);
        this.btnK.addKeyListener(new EnigmaKeyListener());
        this.btnK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IKeyboardPanel.this.btnKActionPerformed(evt);
            }
        });
        this.btnB.setIcon(new ImageIcon(this.getClass().getResource("/resources/keys/B.png")));
        this.btnB.setContentAreaFilled(false);
        this.btnB.setCursor(new Cursor(12));
        this.btnB.setFocusPainted(false);
        this.btnB.setFocusable(false);
        this.btnB.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/keys/Bpress.png")));
        this.btnB.setRequestFocusEnabled(false);
        this.btnB.setRolloverEnabled(false);
        this.btnB.setVerifyInputWhenFocusTarget(false);
        this.btnB.addKeyListener(new EnigmaKeyListener());
        this.btnB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IKeyboardPanel.this.btnBActionPerformed(evt);
            }
        });
        this.btnV.setIcon(new ImageIcon(this.getClass().getResource("/resources/keys/V.png")));
        this.btnV.setContentAreaFilled(false);
        this.btnV.setCursor(new Cursor(12));
        this.btnV.setFocusPainted(false);
        this.btnV.setFocusable(false);
        this.btnV.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/keys/Vpress.png")));
        this.btnV.setRequestFocusEnabled(false);
        this.btnV.setRolloverEnabled(false);
        this.btnV.setVerifyInputWhenFocusTarget(false);
        this.btnV.addKeyListener(new EnigmaKeyListener());
        this.btnV.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IKeyboardPanel.this.btnVActionPerformed(evt);
            }
        });
        this.btnC.setIcon(new ImageIcon(this.getClass().getResource("/resources/keys/C.png")));
        this.btnC.setContentAreaFilled(false);
        this.btnC.setCursor(new Cursor(12));
        this.btnC.setFocusPainted(false);
        this.btnC.setFocusable(false);
        this.btnC.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/keys/Cpress.png")));
        this.btnC.setRequestFocusEnabled(false);
        this.btnC.setRolloverEnabled(false);
        this.btnC.setVerifyInputWhenFocusTarget(false);
        this.btnC.addKeyListener(new EnigmaKeyListener());
        this.btnC.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IKeyboardPanel.this.btnCActionPerformed(evt);
            }
        });
        this.btnO.setIcon(new ImageIcon(this.getClass().getResource("/resources/keys/O.png")));
        this.btnO.setContentAreaFilled(false);
        this.btnO.setCursor(new Cursor(12));
        this.btnO.setFocusPainted(false);
        this.btnO.setFocusable(false);
        this.btnO.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/keys/Opress.png")));
        this.btnO.setRequestFocusEnabled(false);
        this.btnO.setRolloverEnabled(false);
        this.btnO.setVerifyInputWhenFocusTarget(false);
        this.btnO.addKeyListener(new EnigmaKeyListener());
        this.btnO.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IKeyboardPanel.this.btnOActionPerformed(evt);
            }
        });
        this.btnQ.setIcon(new ImageIcon(this.getClass().getResource("/resources/keys/Q.png")));
        this.btnQ.setContentAreaFilled(false);
        this.btnQ.setCursor(new Cursor(12));
        this.btnQ.setFocusPainted(false);
        this.btnQ.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/keys/Qpress.png")));
        this.btnQ.setRequestFocusEnabled(false);
        this.btnQ.setRolloverEnabled(false);
        this.btnQ.setVerifyInputWhenFocusTarget(false);
        this.btnQ.addKeyListener(new EnigmaKeyListener());
        this.btnQ.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IKeyboardPanel.this.btnQActionPerformed(evt);
            }
        });
        this.btnP.setIcon(new ImageIcon(this.getClass().getResource("/resources/keys/P.png")));
        this.btnP.setContentAreaFilled(false);
        this.btnP.setCursor(new Cursor(12));
        this.btnP.setFocusPainted(false);
        this.btnP.setFocusable(false);
        this.btnP.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/keys/Ppress.png")));
        this.btnP.setRequestFocusEnabled(false);
        this.btnP.setRolloverEnabled(false);
        this.btnP.setVerifyInputWhenFocusTarget(false);
        this.btnP.addKeyListener(new EnigmaKeyListener());
        this.btnP.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IKeyboardPanel.this.btnPActionPerformed(evt);
            }
        });
        this.btnY.setIcon(new ImageIcon(this.getClass().getResource("/resources/keys/Y.png")));
        this.btnY.setContentAreaFilled(false);
        this.btnY.setCursor(new Cursor(12));
        this.btnY.setFocusPainted(false);
        this.btnY.setFocusable(false);
        this.btnY.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/keys/Ypress.png")));
        this.btnY.setRequestFocusEnabled(false);
        this.btnY.setRolloverEnabled(false);
        this.btnY.setVerifyInputWhenFocusTarget(false);
        this.btnY.addKeyListener(new EnigmaKeyListener());
        this.btnY.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IKeyboardPanel.this.btnYActionPerformed(evt);
            }
        });
        this.btnX.setIcon(new ImageIcon(this.getClass().getResource("/resources/keys/X.png")));
        this.btnX.setContentAreaFilled(false);
        this.btnX.setCursor(new Cursor(12));
        this.btnX.setFocusPainted(false);
        this.btnX.setFocusable(false);
        this.btnX.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/keys/Xpress.png")));
        this.btnX.setRequestFocusEnabled(false);
        this.btnX.setRolloverEnabled(false);
        this.btnX.setVerifyInputWhenFocusTarget(false);
        this.btnX.addKeyListener(new EnigmaKeyListener());
        this.btnX.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IKeyboardPanel.this.btnXActionPerformed(evt);
            }
        });
        this.btnN.setIcon(new ImageIcon(this.getClass().getResource("/resources/keys/N.png")));
        this.btnN.setContentAreaFilled(false);
        this.btnN.setCursor(new Cursor(12));
        this.btnN.setFocusPainted(false);
        this.btnN.setFocusable(false);
        this.btnN.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/keys/Npress.png")));
        this.btnN.setRequestFocusEnabled(false);
        this.btnN.setRolloverEnabled(false);
        this.btnN.setVerifyInputWhenFocusTarget(false);
        this.btnN.addKeyListener(new EnigmaKeyListener());
        this.btnN.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IKeyboardPanel.this.btnNActionPerformed(evt);
            }
        });
        this.btnM.setIcon(new ImageIcon(this.getClass().getResource("/resources/keys/M.png")));
        this.btnM.setContentAreaFilled(false);
        this.btnM.setCursor(new Cursor(12));
        this.btnM.setFocusPainted(false);
        this.btnM.setFocusable(false);
        this.btnM.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/keys/Mpress.png")));
        this.btnM.setRequestFocusEnabled(false);
        this.btnM.setRolloverEnabled(false);
        this.btnM.setVerifyInputWhenFocusTarget(false);
        this.btnM.addKeyListener(new EnigmaKeyListener());
        this.btnM.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IKeyboardPanel.this.btnMActionPerformed(evt);
            }
        });
        this.btnL.setIcon(new ImageIcon(this.getClass().getResource("/resources/keys/L.png")));
        this.btnL.setContentAreaFilled(false);
        this.btnL.setCursor(new Cursor(12));
        this.btnL.setFocusPainted(false);
        this.btnL.setFocusable(false);
        this.btnL.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/keys/Lpress.png")));
        this.btnL.setRequestFocusEnabled(false);
        this.btnL.setRolloverEnabled(false);
        this.btnL.setVerifyInputWhenFocusTarget(false);
        this.btnL.addKeyListener(new EnigmaKeyListener());
        this.btnL.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IKeyboardPanel.this.btnLActionPerformed(evt);
            }
        });
        this.btnW.setIcon(new ImageIcon(this.getClass().getResource("/resources/keys/W.png")));
        this.btnW.setContentAreaFilled(false);
        this.btnW.setCursor(new Cursor(12));
        this.btnW.setFocusPainted(false);
        this.btnW.setFocusable(false);
        this.btnW.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/keys/Wpress.png")));
        this.btnW.setRequestFocusEnabled(false);
        this.btnW.setRolloverEnabled(false);
        this.btnW.setVerifyInputWhenFocusTarget(false);
        this.btnW.addKeyListener(new EnigmaKeyListener());
        this.btnW.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IKeyboardPanel.this.btnWActionPerformed(evt);
            }
        });
        this.btnE.setIcon(new ImageIcon(this.getClass().getResource("/resources/keys/E.png")));
        this.btnE.setContentAreaFilled(false);
        this.btnE.setCursor(new Cursor(12));
        this.btnE.setFocusPainted(false);
        this.btnE.setFocusable(false);
        this.btnE.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/keys/Epress.png")));
        this.btnE.setRequestFocusEnabled(false);
        this.btnE.setRolloverEnabled(false);
        this.btnE.setVerifyInputWhenFocusTarget(false);
        this.btnE.addKeyListener(new EnigmaKeyListener());
        this.btnE.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IKeyboardPanel.this.btnEActionPerformed(evt);
            }
        });
        this.btnR.setIcon(new ImageIcon(this.getClass().getResource("/resources/keys/R.png")));
        this.btnR.setContentAreaFilled(false);
        this.btnR.setCursor(new Cursor(12));
        this.btnR.setFocusPainted(false);
        this.btnR.setFocusable(false);
        this.btnR.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/keys/Rpress.png")));
        this.btnR.setRequestFocusEnabled(false);
        this.btnR.setRolloverEnabled(false);
        this.btnR.setVerifyInputWhenFocusTarget(false);
        this.btnR.addKeyListener(new EnigmaKeyListener());
        this.btnR.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IKeyboardPanel.this.btnRActionPerformed(evt);
            }
        });
        this.btnT.setIcon(new ImageIcon(this.getClass().getResource("/resources/keys/T.png")));
        this.btnT.setContentAreaFilled(false);
        this.btnT.setCursor(new Cursor(12));
        this.btnT.setFocusPainted(false);
        this.btnT.setFocusable(false);
        this.btnT.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/keys/Tpress.png")));
        this.btnT.setRequestFocusEnabled(false);
        this.btnT.setRolloverEnabled(false);
        this.btnT.setVerifyInputWhenFocusTarget(false);
        this.btnT.addKeyListener(new EnigmaKeyListener());
        this.btnT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IKeyboardPanel.this.btnTActionPerformed(evt);
            }
        });
        this.btnZ.setIcon(new ImageIcon(this.getClass().getResource("/resources/keys/Z.png")));
        this.btnZ.setContentAreaFilled(false);
        this.btnZ.setCursor(new Cursor(12));
        this.btnZ.setFocusPainted(false);
        this.btnZ.setFocusable(false);
        this.btnZ.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/keys/Zpress.png")));
        this.btnZ.setRequestFocusEnabled(false);
        this.btnZ.setRolloverEnabled(false);
        this.btnZ.setVerifyInputWhenFocusTarget(false);
        this.btnZ.addKeyListener(new EnigmaKeyListener());
        this.btnZ.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IKeyboardPanel.this.btnZActionPerformed(evt);
            }
        });
        this.btnU.setIcon(new ImageIcon(this.getClass().getResource("/resources/keys/U.png")));
        this.btnU.setContentAreaFilled(false);
        this.btnU.setCursor(new Cursor(12));
        this.btnU.setFocusPainted(false);
        this.btnU.setFocusable(false);
        this.btnU.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/keys/Upress.png")));
        this.btnU.setRequestFocusEnabled(false);
        this.btnU.setRolloverEnabled(false);
        this.btnU.setVerifyInputWhenFocusTarget(false);
        this.btnU.addKeyListener(new EnigmaKeyListener());
        this.btnU.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IKeyboardPanel.this.btnUActionPerformed(evt);
            }
        });
        this.btnI.setIcon(new ImageIcon(this.getClass().getResource("/resources/keys/I.png")));
        this.btnI.setContentAreaFilled(false);
        this.btnI.setCursor(new Cursor(12));
        this.btnI.setFocusPainted(false);
        this.btnI.setFocusable(false);
        this.btnI.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/keys/Ipress.png")));
        this.btnI.setRequestFocusEnabled(false);
        this.btnI.setRolloverEnabled(false);
        this.btnI.setVerifyInputWhenFocusTarget(false);
        this.btnI.addKeyListener(new EnigmaKeyListener());
        this.btnI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IKeyboardPanel.this.btnIActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(45, 45, 45).addComponent(this.btnA, -2, 29, -2).addGap(5, 5, 5).addComponent(this.btnS, -2, 29, -2).addGap(5, 5, 5).addComponent(this.btnD, -2, 29, -2).addGap(5, 5, 5).addComponent(this.btnF, -2, 29, -2).addGap(5, 5, 5).addComponent(this.btnG, -2, 29, -2).addGap(5, 5, 5).addComponent(this.btnH, -2, 29, -2).addGap(5, 5, 5).addComponent(this.btnJ, -2, 29, -2).addGap(5, 5, 5).addComponent(this.btnK, -2, 29, -2).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addGap(35, 35, 35).addComponent(this.btnQ, -2, 29, -2).addGap(5, 5, 5).addComponent(this.btnW, -2, 29, -2).addGap(5, 5, 5).addComponent(this.btnE, -2, 29, -2).addGap(5, 5, 5).addComponent(this.btnR, -2, 29, -2).addGap(5, 5, 5).addComponent(this.btnT, -2, 29, -2).addGap(5, 5, 5).addComponent(this.btnZ, -2, 29, -2).addGap(5, 5, 5).addComponent(this.btnU, -2, 29, -2).addGap(5, 5, 5).addComponent(this.btnI, -2, 29, -2).addGap(5, 5, 5).addComponent(this.btnO, -2, 29, -2)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addGap(25, 25, 25).addComponent(this.btnP, -2, 29, -2).addGap(5, 5, 5).addComponent(this.btnY, -2, 29, -2).addGap(5, 5, 5).addComponent(this.btnX, -2, 29, -2).addGap(5, 5, 5).addComponent(this.btnC, -2, 29, -2).addGap(5, 5, 5).addComponent(this.btnV, -2, 29, -2).addGap(5, 5, 5).addComponent(this.btnB, -2, 29, -2).addGap(5, 5, 5).addComponent(this.btnN, -2, 29, -2).addGap(5, 5, 5).addComponent(this.btnM, -2, 29, -2).addGap(5, 5, 5).addComponent(this.btnL, -2, 29, -2))).addGap(25, 25, 25)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 0, 0).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btnO, -2, 29, -2).addComponent(this.btnQ, -2, 29, -2).addComponent(this.btnW, -2, 29, -2).addComponent(this.btnE, -2, 29, -2).addComponent(this.btnR, -2, 29, -2).addComponent(this.btnT, -2, 29, -2).addComponent(this.btnZ, -2, 29, -2).addComponent(this.btnU, -2, 29, -2).addComponent(this.btnI, -2, 29, -2)).addGap(1, 1, 1).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btnF, -2, 29, -2).addComponent(this.btnK, -2, 29, -2).addComponent(this.btnD, -2, 29, -2).addComponent(this.btnA, -2, 29, -2).addComponent(this.btnJ, -2, 29, -2).addComponent(this.btnH, -2, 29, -2).addComponent(this.btnG, -2, 29, -2).addComponent(this.btnS, -2, 29, -2)).addGap(2, 2, 2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btnY, -2, 29, -2).addComponent(this.btnB, -2, 29, -2).addComponent(this.btnV, -2, 29, -2).addComponent(this.btnC, -2, 29, -2).addComponent(this.btnP, -2, 29, -2).addComponent(this.btnX, -2, 29, -2).addComponent(this.btnN, -2, 29, -2).addComponent(this.btnM, -2, 29, -2).addComponent(this.btnL, -2, 29, -2)).addContainerGap(25, Short.MAX_VALUE)));
    }

    private void btnSActionPerformed(ActionEvent evt) {
        this.pressKey('S');
    }

    private void btnDActionPerformed(ActionEvent evt) {
        this.pressKey('D');
    }

    private void btnFActionPerformed(ActionEvent evt) {
        this.pressKey('F');
    }

    private void btnAActionPerformed(ActionEvent evt) {
        this.pressKey('A');
    }

    private void btnGActionPerformed(ActionEvent evt) {
        this.pressKey('G');
    }

    private void btnHActionPerformed(ActionEvent evt) {
        this.pressKey('H');
    }

    private void btnJActionPerformed(ActionEvent evt) {
        this.pressKey('J');
    }

    private void btnKActionPerformed(ActionEvent evt) {
        this.pressKey('K');
    }

    private void btnBActionPerformed(ActionEvent evt) {
        this.pressKey('B');
    }

    private void btnVActionPerformed(ActionEvent evt) {
        this.pressKey('V');
    }

    private void btnCActionPerformed(ActionEvent evt) {
        this.pressKey('C');
    }

    private void btnOActionPerformed(ActionEvent evt) {
        this.pressKey('O');
    }

    private void btnQActionPerformed(ActionEvent evt) {
        this.pressKey('Q');
    }

    private void btnPActionPerformed(ActionEvent evt) {
        this.pressKey('P');
    }

    private void btnYActionPerformed(ActionEvent evt) {
        this.pressKey('Y');
    }

    private void btnXActionPerformed(ActionEvent evt) {
        this.pressKey('X');
    }

    private void btnNActionPerformed(ActionEvent evt) {
        this.pressKey('N');
    }

    private void btnMActionPerformed(ActionEvent evt) {
        this.pressKey('M');
    }

    private void btnLActionPerformed(ActionEvent evt) {
        this.pressKey('L');
    }

    private void btnWActionPerformed(ActionEvent evt) {
        this.pressKey('W');
    }

    private void btnEActionPerformed(ActionEvent evt) {
        this.pressKey('E');
    }

    private void btnRActionPerformed(ActionEvent evt) {
        this.pressKey('R');
    }

    private void btnTActionPerformed(ActionEvent evt) {
        this.pressKey('T');
    }

    private void btnZActionPerformed(ActionEvent evt) {
        this.pressKey('Z');
    }

    private void btnUActionPerformed(ActionEvent evt) {
        this.pressKey('U');
    }

    private void btnIActionPerformed(ActionEvent evt) {
        this.pressKey('I');
    }

    class EnigmaKeyListener
    extends KeyAdapter {
        EnigmaKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent event) {
            if (event.getKeyCode() == 81) {
                IKeyboardPanel.this.btnQ.doClick();
            } else if (event.getKeyCode() == 87) {
                IKeyboardPanel.this.btnW.doClick();
            } else if (event.getKeyCode() == 69) {
                IKeyboardPanel.this.btnE.doClick();
            } else if (event.getKeyCode() == 82) {
                IKeyboardPanel.this.btnR.doClick();
            } else if (event.getKeyCode() == 84) {
                IKeyboardPanel.this.btnT.doClick();
            } else if (event.getKeyCode() == 90) {
                IKeyboardPanel.this.btnZ.doClick();
            } else if (event.getKeyCode() == 85) {
                IKeyboardPanel.this.btnU.doClick();
            } else if (event.getKeyCode() == 73) {
                IKeyboardPanel.this.btnI.doClick();
            } else if (event.getKeyCode() == 79) {
                IKeyboardPanel.this.btnO.doClick();
            } else if (event.getKeyCode() == 65) {
                IKeyboardPanel.this.btnA.doClick();
            } else if (event.getKeyCode() == 83) {
                IKeyboardPanel.this.btnS.doClick();
            } else if (event.getKeyCode() == 68) {
                IKeyboardPanel.this.btnD.doClick();
            } else if (event.getKeyCode() == 70) {
                IKeyboardPanel.this.btnF.doClick();
            } else if (event.getKeyCode() == 71) {
                IKeyboardPanel.this.btnG.doClick();
            } else if (event.getKeyCode() == 72) {
                IKeyboardPanel.this.btnH.doClick();
            } else if (event.getKeyCode() == 74) {
                IKeyboardPanel.this.btnJ.doClick();
            } else if (event.getKeyCode() == 75) {
                IKeyboardPanel.this.btnK.doClick();
            } else if (event.getKeyCode() == 80) {
                IKeyboardPanel.this.btnP.doClick();
            } else if (event.getKeyCode() == 89) {
                IKeyboardPanel.this.btnY.doClick();
            } else if (event.getKeyCode() == 88) {
                IKeyboardPanel.this.btnX.doClick();
            } else if (event.getKeyCode() == 67) {
                IKeyboardPanel.this.btnC.doClick();
            } else if (event.getKeyCode() == 86) {
                IKeyboardPanel.this.btnV.doClick();
            } else if (event.getKeyCode() == 66) {
                IKeyboardPanel.this.btnB.doClick();
            } else if (event.getKeyCode() == 78) {
                IKeyboardPanel.this.btnN.doClick();
            } else if (event.getKeyCode() == 77) {
                IKeyboardPanel.this.btnM.doClick();
            } else if (event.getKeyCode() == 76) {
                IKeyboardPanel.this.btnL.doClick();
            }
        }
    }
}

