/*
 * Decompiled with CFR 0.152.
 */
package machines.panels;

import enigma.SteppingMechanism;
import frames.MessageFrame;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import machines.Exchanger;
import machines.LampFrame;
import machines.panels.GLampPanel;
import machines.panels.LampPanel;
import machines.panels.RotorPanel;

public class KeyboardPanel
extends JPanel {
    private SteppingMechanism stepMech;
    private String eType;
    private RotorPanel rotorPanel;
    private LampPanel lampPanel;
    private GLampPanel gLampPanel;
    private char prevCipher;
    private char cipher;
    private Exchanger exchanger;
    private MessageFrame msgBoard;
    private LampFrame lampFrame;
    private JButton btnA;
    private JButton btnB;
    private JButton btnC;
    private JButton btnD;
    private JButton btnE;
    private JButton btnF;
    private JButton btnG;
    private JButton btnH;
    private JButton btnI;
    private JButton btnJ;
    private JButton btnK;
    private JButton btnL;
    private JButton btnM;
    private JButton btnN;
    private JButton btnO;
    private JButton btnP;
    private JButton btnQ;
    private JButton btnR;
    private JButton btnS;
    private JButton btnT;
    private JButton btnU;
    private JButton btnV;
    private JButton btnW;
    private JButton btnX;
    private JButton btnY;
    private JButton btnZ;

    public KeyboardPanel(Exchanger e) {
        this.initComponents();
        this.exchanger = e;
        this.btnQ.getInputMap().put(KeyStroke.getKeyStroke("SPACE"), "doNothing");
        this.stepMech = this.exchanger.getSteppingMechanism();
        this.eType = this.stepMech.getType();
        this.rotorPanel = this.exchanger.getRotorPanel();
        if (this.eType.equals("G1") || this.eType.equals("G2") || this.eType.equals("G3")) {
            this.gLampPanel = this.exchanger.getGLampPanel();
            this.setSpecialKeys();
        } else {
            this.lampPanel = this.exchanger.getLampPanel();
        }
        if (this.eType.equals("KS")) {
            this.lampFrame = new LampFrame();
        }
        this.msgBoard = new MessageFrame();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D gKey = (Graphics2D)g;
        ImageIcon keyImage = new ImageIcon(this.getClass().getResource("/resources/panels/KKey.png"));
        Image image = keyImage.getImage();
        if (image != null) {
            gKey.drawImage(image, 0, 0, 360, 91, this);
        }
    }

    public MessageFrame getMessageBoard() {
        return this.msgBoard;
    }

    public LampFrame getLampFrame() {
        return this.lampFrame;
    }

    private void setSpecialKeys() {
        this.btnA.setIcon(new ImageIcon(this.getClass().getResource("/resources/keys/special/A.png")));
        this.btnA.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/keys/special/APress.png")));
        this.btnS.setIcon(new ImageIcon(this.getClass().getResource("/resources/keys/special/S.png")));
        this.btnS.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/keys/special/SPress.png")));
        this.btnD.setIcon(new ImageIcon(this.getClass().getResource("/resources/keys/special/D.png")));
        this.btnD.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/keys/special/DPress.png")));
        this.btnF.setIcon(new ImageIcon(this.getClass().getResource("/resources/keys/special/F.png")));
        this.btnF.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/keys/special/FPress.png")));
        this.btnG.setIcon(new ImageIcon(this.getClass().getResource("/resources/keys/special/G.png")));
        this.btnG.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/keys/special/GPress.png")));
        this.btnH.setIcon(new ImageIcon(this.getClass().getResource("/resources/keys/special/H.png")));
        this.btnH.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/keys/special/HPress.png")));
        this.btnJ.setIcon(new ImageIcon(this.getClass().getResource("/resources/keys/special/J.png")));
        this.btnJ.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/keys/special/JPress.png")));
        this.btnK.setIcon(new ImageIcon(this.getClass().getResource("/resources/keys/special/K.png")));
        this.btnK.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/keys/special/KPress.png")));
        this.btnY.setIcon(new ImageIcon(this.getClass().getResource("/resources/keys/special/Y.png")));
        this.btnY.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/keys/special/YPress.png")));
        this.btnX.setIcon(new ImageIcon(this.getClass().getResource("/resources/keys/special/X.png")));
        this.btnX.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/keys/special/XPress.png")));
        this.btnC.setIcon(new ImageIcon(this.getClass().getResource("/resources/keys/special/C.png")));
        this.btnC.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/keys/special/CPress.png")));
        this.btnV.setIcon(new ImageIcon(this.getClass().getResource("/resources/keys/special/V.png")));
        this.btnV.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/keys/special/VPress.png")));
        this.btnB.setIcon(new ImageIcon(this.getClass().getResource("/resources/keys/special/B.png")));
        this.btnB.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/keys/special/BPress.png")));
        this.btnN.setIcon(new ImageIcon(this.getClass().getResource("/resources/keys/special/N.png")));
        this.btnN.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/keys/special/NPress.png")));
        this.btnM.setIcon(new ImageIcon(this.getClass().getResource("/resources/keys/special/M.png")));
        this.btnM.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/keys/special/MPress.png")));
        this.btnL.setIcon(new ImageIcon(this.getClass().getResource("/resources/keys/special/L.png")));
        this.btnL.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/keys/special/LPress.png")));
    }

    private void pressKey(char letter) {
        if (this.eType.equals("KD")) {
            if (this.exchanger.getReflectorPanel().isFull()) {
                this.exchanger.getLampPanel().deactivate(this.prevCipher);
                this.exchanger.getSteppingMechanism().step();
                this.exchanger.getRotorPanel().updateWindow();
                this.exchanger.getRotorPanel().setCounter();
                this.cipher = this.exchanger.getSteppingMechanism().encipher(letter);
                this.exchanger.getLampPanel().activate(this.cipher);
                this.prevCipher = this.cipher;
                this.msgBoard.getMessagePanel().printPlain(letter);
                this.msgBoard.getMessagePanel().printCipher(this.cipher);
            } else {
                ImageIcon icon23 = new ImageIcon(this.getClass().getResource("/resources/popup/Info.png"));
                JOptionPane.showMessageDialog(this, "<html><strong style=\"font-size: 100%\">UKW-D is not fully wired.</strong><br>The machine will not operate correctly until <br>the reflector has been fitted with all twelve cables.<html>", "UKW-D reflector", 1, icon23);
            }
        } else {
            if (this.eType.equals("G1") || this.eType.equals("G2") || this.eType.equals("G3")) {
                this.gLampPanel.deactivate(this.prevCipher);
            } else {
                this.lampPanel.deactivate(this.prevCipher);
            }
            if (this.eType.equals("KS")) {
                this.lampFrame.deactivate(this.prevCipher);
            }
            this.stepMech.step();
            this.rotorPanel.updateWindow();
            this.rotorPanel.setCounter();
            this.cipher = this.stepMech.encipher(letter);
            if (this.eType.equals("G1") || this.eType.equals("G2") || this.eType.equals("G3")) {
                this.gLampPanel.activate(this.cipher);
            } else {
                this.lampPanel.activate(this.cipher);
            }
            if (this.eType.equals("KS")) {
                this.lampFrame.activate(this.cipher);
            }
            this.prevCipher = this.cipher;
            this.msgBoard.getMessagePanel().printPlain(letter);
            this.msgBoard.getMessagePanel().printCipher(this.cipher);
        }
    }

    private void initComponents() {
        this.btnQ = new JButton();
        this.btnO = new JButton();
        this.btnC = new JButton();
        this.btnV = new JButton();
        this.btnB = new JButton();
        this.btnM = new JButton();
        this.btnL = new JButton();
        this.btnX = new JButton();
        this.btnN = new JButton();
        this.btnP = new JButton();
        this.btnY = new JButton();
        this.btnD = new JButton();
        this.btnE = new JButton();
        this.btnS = new JButton();
        this.btnW = new JButton();
        this.btnT = new JButton();
        this.btnR = new JButton();
        this.btnA = new JButton();
        this.btnG = new JButton();
        this.btnH = new JButton();
        this.btnZ = new JButton();
        this.btnJ = new JButton();
        this.btnU = new JButton();
        this.btnI = new JButton();
        this.btnK = new JButton();
        this.btnF = new JButton();
        this.setFocusable(false);
        this.setMaximumSize(new Dimension(360, 91));
        this.setMinimumSize(new Dimension(360, 91));
        this.setPreferredSize(new Dimension(360, 91));
        this.btnQ.setIcon(new ImageIcon(this.getClass().getResource("/resources/keys/special/Q.png")));
        this.btnQ.setContentAreaFilled(false);
        this.btnQ.setCursor(new Cursor(12));
        this.btnQ.setFocusPainted(false);
        this.btnQ.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/keys/special/QPress.png")));
        this.btnQ.setRequestFocusEnabled(false);
        this.btnQ.setRolloverEnabled(false);
        this.btnQ.setVerifyInputWhenFocusTarget(false);
        this.btnQ.addKeyListener(new EnigmaKeyListener());
        this.btnQ.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KeyboardPanel.this.btnQActionPerformed(evt);
            }
        });
        this.btnO.setIcon(new ImageIcon(this.getClass().getResource("/resources/keys/special/O.png")));
        this.btnO.setContentAreaFilled(false);
        this.btnO.setCursor(new Cursor(12));
        this.btnO.setFocusPainted(false);
        this.btnO.setFocusable(false);
        this.btnO.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/keys/special/OPress.png")));
        this.btnO.setRequestFocusEnabled(false);
        this.btnO.setRolloverEnabled(false);
        this.btnO.setVerifyInputWhenFocusTarget(false);
        this.btnO.addKeyListener(new EnigmaKeyListener());
        this.btnO.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KeyboardPanel.this.btnOActionPerformed(evt);
            }
        });
        this.btnC.setIcon(new ImageIcon(this.getClass().getResource("/resources/keys/C.png")));
        this.btnC.setContentAreaFilled(false);
        this.btnC.setCursor(new Cursor(12));
        this.btnC.setFocusPainted(false);
        this.btnC.setFocusable(false);
        this.btnC.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/keys/Cpress.png")));
        this.btnC.setRequestFocusEnabled(false);
        this.btnC.setRolloverEnabled(false);
        this.btnC.setVerifyInputWhenFocusTarget(false);
        this.btnC.addKeyListener(new EnigmaKeyListener());
        this.btnC.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KeyboardPanel.this.btnCActionPerformed(evt);
            }
        });
        this.btnV.setIcon(new ImageIcon(this.getClass().getResource("/resources/keys/V.png")));
        this.btnV.setContentAreaFilled(false);
        this.btnV.setCursor(new Cursor(12));
        this.btnV.setFocusPainted(false);
        this.btnV.setFocusable(false);
        this.btnV.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/keys/Vpress.png")));
        this.btnV.setRequestFocusEnabled(false);
        this.btnV.setRolloverEnabled(false);
        this.btnV.setVerifyInputWhenFocusTarget(false);
        this.btnV.addKeyListener(new EnigmaKeyListener());
        this.btnV.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KeyboardPanel.this.btnVActionPerformed(evt);
            }
        });
        this.btnB.setIcon(new ImageIcon(this.getClass().getResource("/resources/keys/B.png")));
        this.btnB.setContentAreaFilled(false);
        this.btnB.setCursor(new Cursor(12));
        this.btnB.setFocusPainted(false);
        this.btnB.setFocusable(false);
        this.btnB.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/keys/Bpress.png")));
        this.btnB.setRequestFocusEnabled(false);
        this.btnB.setRolloverEnabled(false);
        this.btnB.setVerifyInputWhenFocusTarget(false);
        this.btnB.addKeyListener(new EnigmaKeyListener());
        this.btnB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KeyboardPanel.this.btnBActionPerformed(evt);
            }
        });
        this.btnM.setIcon(new ImageIcon(this.getClass().getResource("/resources/keys/M.png")));
        this.btnM.setContentAreaFilled(false);
        this.btnM.setCursor(new Cursor(12));
        this.btnM.setFocusPainted(false);
        this.btnM.setFocusable(false);
        this.btnM.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/keys/Mpress.png")));
        this.btnM.setRequestFocusEnabled(false);
        this.btnM.setRolloverEnabled(false);
        this.btnM.setVerifyInputWhenFocusTarget(false);
        this.btnM.addKeyListener(new EnigmaKeyListener());
        this.btnM.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KeyboardPanel.this.btnMActionPerformed(evt);
            }
        });
        this.btnL.setIcon(new ImageIcon(this.getClass().getResource("/resources/keys/L.png")));
        this.btnL.setContentAreaFilled(false);
        this.btnL.setCursor(new Cursor(12));
        this.btnL.setFocusPainted(false);
        this.btnL.setFocusable(false);
        this.btnL.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/keys/Lpress.png")));
        this.btnL.setRequestFocusEnabled(false);
        this.btnL.setRolloverEnabled(false);
        this.btnL.setVerifyInputWhenFocusTarget(false);
        this.btnL.addKeyListener(new EnigmaKeyListener());
        this.btnL.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KeyboardPanel.this.btnLActionPerformed(evt);
            }
        });
        this.btnX.setIcon(new ImageIcon(this.getClass().getResource("/resources/keys/X.png")));
        this.btnX.setContentAreaFilled(false);
        this.btnX.setCursor(new Cursor(12));
        this.btnX.setFocusPainted(false);
        this.btnX.setFocusable(false);
        this.btnX.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/keys/Xpress.png")));
        this.btnX.setRequestFocusEnabled(false);
        this.btnX.setRolloverEnabled(false);
        this.btnX.setVerifyInputWhenFocusTarget(false);
        this.btnX.addKeyListener(new EnigmaKeyListener());
        this.btnX.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KeyboardPanel.this.btnXActionPerformed(evt);
            }
        });
        this.btnN.setIcon(new ImageIcon(this.getClass().getResource("/resources/keys/N.png")));
        this.btnN.setContentAreaFilled(false);
        this.btnN.setCursor(new Cursor(12));
        this.btnN.setFocusPainted(false);
        this.btnN.setFocusable(false);
        this.btnN.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/keys/Npress.png")));
        this.btnN.setRequestFocusEnabled(false);
        this.btnN.setRolloverEnabled(false);
        this.btnN.setVerifyInputWhenFocusTarget(false);
        this.btnN.addKeyListener(new EnigmaKeyListener());
        this.btnN.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KeyboardPanel.this.btnNActionPerformed(evt);
            }
        });
        this.btnP.setIcon(new ImageIcon(this.getClass().getResource("/resources/keys/special/P.png")));
        this.btnP.setContentAreaFilled(false);
        this.btnP.setCursor(new Cursor(12));
        this.btnP.setFocusPainted(false);
        this.btnP.setFocusable(false);
        this.btnP.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/keys/special/PPress.png")));
        this.btnP.setRequestFocusEnabled(false);
        this.btnP.setRolloverEnabled(false);
        this.btnP.setVerifyInputWhenFocusTarget(false);
        this.btnP.addKeyListener(new EnigmaKeyListener());
        this.btnP.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KeyboardPanel.this.btnPActionPerformed(evt);
            }
        });
        this.btnY.setIcon(new ImageIcon(this.getClass().getResource("/resources/keys/Y.png")));
        this.btnY.setContentAreaFilled(false);
        this.btnY.setCursor(new Cursor(12));
        this.btnY.setFocusPainted(false);
        this.btnY.setFocusable(false);
        this.btnY.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/keys/Ypress.png")));
        this.btnY.setRequestFocusEnabled(false);
        this.btnY.setRolloverEnabled(false);
        this.btnY.setVerifyInputWhenFocusTarget(false);
        this.btnY.addKeyListener(new EnigmaKeyListener());
        this.btnY.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KeyboardPanel.this.btnYActionPerformed(evt);
            }
        });
        this.btnD.setIcon(new ImageIcon(this.getClass().getResource("/resources/keys/D.png")));
        this.btnD.setContentAreaFilled(false);
        this.btnD.setCursor(new Cursor(12));
        this.btnD.setFocusPainted(false);
        this.btnD.setFocusable(false);
        this.btnD.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/keys/Dpress.png")));
        this.btnD.setRequestFocusEnabled(false);
        this.btnD.setRolloverEnabled(false);
        this.btnD.setVerifyInputWhenFocusTarget(false);
        this.btnD.addKeyListener(new EnigmaKeyListener());
        this.btnD.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KeyboardPanel.this.btnDActionPerformed(evt);
            }
        });
        this.btnE.setIcon(new ImageIcon(this.getClass().getResource("/resources/keys/special/E.png")));
        this.btnE.setContentAreaFilled(false);
        this.btnE.setCursor(new Cursor(12));
        this.btnE.setFocusPainted(false);
        this.btnE.setFocusable(false);
        this.btnE.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/keys/special/EPress.png")));
        this.btnE.setRequestFocusEnabled(false);
        this.btnE.setRolloverEnabled(false);
        this.btnE.setVerifyInputWhenFocusTarget(false);
        this.btnE.addKeyListener(new EnigmaKeyListener());
        this.btnE.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KeyboardPanel.this.btnEActionPerformed(evt);
            }
        });
        this.btnS.addKeyListener(new EnigmaKeyListener());
        this.btnS.setIcon(new ImageIcon(this.getClass().getResource("/resources/keys/S.png")));
        this.btnS.setContentAreaFilled(false);
        this.btnS.setCursor(new Cursor(12));
        this.btnS.setFocusPainted(false);
        this.btnS.setFocusable(false);
        this.btnS.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/keys/Spress.png")));
        this.btnS.setRequestFocusEnabled(false);
        this.btnS.setRolloverEnabled(false);
        this.btnS.setVerifyInputWhenFocusTarget(false);
        this.btnS.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KeyboardPanel.this.btnSActionPerformed(evt);
            }
        });
        this.btnW.setIcon(new ImageIcon(this.getClass().getResource("/resources/keys/special/W.png")));
        this.btnW.setContentAreaFilled(false);
        this.btnW.setCursor(new Cursor(12));
        this.btnW.setFocusPainted(false);
        this.btnW.setFocusable(false);
        this.btnW.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/keys/special/WPress.png")));
        this.btnW.setRequestFocusEnabled(false);
        this.btnW.setRolloverEnabled(false);
        this.btnW.setVerifyInputWhenFocusTarget(false);
        this.btnW.addKeyListener(new EnigmaKeyListener());
        this.btnW.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KeyboardPanel.this.btnWActionPerformed(evt);
            }
        });
        this.btnT.setIcon(new ImageIcon(this.getClass().getResource("/resources/keys/special/T.png")));
        this.btnT.setContentAreaFilled(false);
        this.btnT.setCursor(new Cursor(12));
        this.btnT.setFocusPainted(false);
        this.btnT.setFocusable(false);
        this.btnT.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/keys/special/TPress.png")));
        this.btnT.setRequestFocusEnabled(false);
        this.btnT.setRolloverEnabled(false);
        this.btnT.setVerifyInputWhenFocusTarget(false);
        this.btnT.addKeyListener(new EnigmaKeyListener());
        this.btnT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KeyboardPanel.this.btnTActionPerformed(evt);
            }
        });
        this.btnR.setIcon(new ImageIcon(this.getClass().getResource("/resources/keys/special/R.png")));
        this.btnR.setContentAreaFilled(false);
        this.btnR.setCursor(new Cursor(12));
        this.btnR.setFocusPainted(false);
        this.btnR.setFocusable(false);
        this.btnR.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/keys/special/RPress.png")));
        this.btnR.setRequestFocusEnabled(false);
        this.btnR.setRolloverEnabled(false);
        this.btnR.setVerifyInputWhenFocusTarget(false);
        this.btnR.addKeyListener(new EnigmaKeyListener());
        this.btnR.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KeyboardPanel.this.btnRActionPerformed(evt);
            }
        });
        this.btnA.addKeyListener(new EnigmaKeyListener());
        this.btnA.setIcon(new ImageIcon(this.getClass().getResource("/resources/keys/A.png")));
        this.btnA.setBorder(null);
        this.btnA.setContentAreaFilled(false);
        this.btnA.setCursor(new Cursor(12));
        this.btnA.setFocusPainted(false);
        this.btnA.setFocusable(false);
        this.btnA.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/keys/Apress.png")));
        this.btnA.setRequestFocusEnabled(false);
        this.btnA.setRolloverEnabled(false);
        this.btnA.setVerifyInputWhenFocusTarget(false);
        this.btnA.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KeyboardPanel.this.btnAActionPerformed(evt);
            }
        });
        this.btnG.setIcon(new ImageIcon(this.getClass().getResource("/resources/keys/G.png")));
        this.btnG.setContentAreaFilled(false);
        this.btnG.setCursor(new Cursor(12));
        this.btnG.setFocusPainted(false);
        this.btnG.setFocusable(false);
        this.btnG.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/keys/Gpress.png")));
        this.btnG.setRequestFocusEnabled(false);
        this.btnG.setRolloverEnabled(false);
        this.btnG.setVerifyInputWhenFocusTarget(false);
        this.btnG.addKeyListener(new EnigmaKeyListener());
        this.btnG.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KeyboardPanel.this.btnGActionPerformed(evt);
            }
        });
        this.btnH.setIcon(new ImageIcon(this.getClass().getResource("/resources/keys/H.png")));
        this.btnH.setContentAreaFilled(false);
        this.btnH.setCursor(new Cursor(12));
        this.btnH.setFocusPainted(false);
        this.btnH.setFocusable(false);
        this.btnH.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/keys/Hpress.png")));
        this.btnH.setRequestFocusEnabled(false);
        this.btnH.setRolloverEnabled(false);
        this.btnH.setVerifyInputWhenFocusTarget(false);
        this.btnH.addKeyListener(new EnigmaKeyListener());
        this.btnH.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KeyboardPanel.this.btnHActionPerformed(evt);
            }
        });
        this.btnZ.setIcon(new ImageIcon(this.getClass().getResource("/resources/keys/special/Z.png")));
        this.btnZ.setContentAreaFilled(false);
        this.btnZ.setCursor(new Cursor(12));
        this.btnZ.setFocusPainted(false);
        this.btnZ.setFocusable(false);
        this.btnZ.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/keys/special/ZPress.png")));
        this.btnZ.setRequestFocusEnabled(false);
        this.btnZ.setRolloverEnabled(false);
        this.btnZ.setVerifyInputWhenFocusTarget(false);
        this.btnZ.addKeyListener(new EnigmaKeyListener());
        this.btnZ.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KeyboardPanel.this.btnZActionPerformed(evt);
            }
        });
        this.btnJ.setIcon(new ImageIcon(this.getClass().getResource("/resources/keys/J.png")));
        this.btnJ.setContentAreaFilled(false);
        this.btnJ.setCursor(new Cursor(12));
        this.btnJ.setFocusPainted(false);
        this.btnJ.setFocusable(false);
        this.btnJ.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/keys/Jpress.png")));
        this.btnJ.setRequestFocusEnabled(false);
        this.btnJ.setRolloverEnabled(false);
        this.btnJ.setVerifyInputWhenFocusTarget(false);
        this.btnJ.addKeyListener(new EnigmaKeyListener());
        this.btnJ.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KeyboardPanel.this.btnJActionPerformed(evt);
            }
        });
        this.btnU.setIcon(new ImageIcon(this.getClass().getResource("/resources/keys/special/U.png")));
        this.btnU.setContentAreaFilled(false);
        this.btnU.setCursor(new Cursor(12));
        this.btnU.setFocusPainted(false);
        this.btnU.setFocusable(false);
        this.btnU.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/keys/special/UPress.png")));
        this.btnU.setRequestFocusEnabled(false);
        this.btnU.setRolloverEnabled(false);
        this.btnU.setVerifyInputWhenFocusTarget(false);
        this.btnU.addKeyListener(new EnigmaKeyListener());
        this.btnU.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KeyboardPanel.this.btnUActionPerformed(evt);
            }
        });
        this.btnI.setIcon(new ImageIcon(this.getClass().getResource("/resources/keys/special/I.png")));
        this.btnI.setContentAreaFilled(false);
        this.btnI.setCursor(new Cursor(12));
        this.btnI.setFocusPainted(false);
        this.btnI.setFocusable(false);
        this.btnI.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/keys/special/IPress.png")));
        this.btnI.setRequestFocusEnabled(false);
        this.btnI.setRolloverEnabled(false);
        this.btnI.setVerifyInputWhenFocusTarget(false);
        this.btnI.addKeyListener(new EnigmaKeyListener());
        this.btnI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KeyboardPanel.this.btnIActionPerformed(evt);
            }
        });
        this.btnK.setIcon(new ImageIcon(this.getClass().getResource("/resources/keys/K.png")));
        this.btnK.setContentAreaFilled(false);
        this.btnK.setCursor(new Cursor(12));
        this.btnK.setFocusPainted(false);
        this.btnK.setFocusable(false);
        this.btnK.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/keys/Kpress.png")));
        this.btnK.setRequestFocusEnabled(false);
        this.btnK.setRolloverEnabled(false);
        this.btnK.setVerifyInputWhenFocusTarget(false);
        this.btnK.addKeyListener(new EnigmaKeyListener());
        this.btnK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KeyboardPanel.this.btnKActionPerformed(evt);
            }
        });
        this.btnF.setIcon(new ImageIcon(this.getClass().getResource("/resources/keys/F.png")));
        this.btnF.setContentAreaFilled(false);
        this.btnF.setCursor(new Cursor(12));
        this.btnF.setFocusPainted(false);
        this.btnF.setFocusable(false);
        this.btnF.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/keys/Fpress.png")));
        this.btnF.setRequestFocusEnabled(false);
        this.btnF.setRolloverEnabled(false);
        this.btnF.setVerifyInputWhenFocusTarget(false);
        this.btnF.addKeyListener(new EnigmaKeyListener());
        this.btnF.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KeyboardPanel.this.btnFActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(45, 45, 45).addComponent(this.btnA, -2, 29, -2).addGap(5, 5, 5).addComponent(this.btnS, -2, 29, -2).addGap(5, 5, 5).addComponent(this.btnD, -2, 29, -2).addGap(5, 5, 5).addComponent(this.btnF, -2, 29, -2).addGap(5, 5, 5).addComponent(this.btnG, -2, 29, -2).addGap(5, 5, 5).addComponent(this.btnH, -2, 29, -2).addGap(5, 5, 5).addComponent(this.btnJ, -2, 29, -2).addGap(5, 5, 5).addComponent(this.btnK, -2, 29, -2).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addGap(35, 35, 35).addComponent(this.btnQ, -2, 29, -2).addGap(5, 5, 5).addComponent(this.btnW, -2, 29, -2).addGap(5, 5, 5).addComponent(this.btnE, -2, 29, -2).addGap(5, 5, 5).addComponent(this.btnR, -2, 29, -2).addGap(5, 5, 5).addComponent(this.btnT, -2, 29, -2).addGap(5, 5, 5).addComponent(this.btnZ, -2, 29, -2).addGap(5, 5, 5).addComponent(this.btnU, -2, 29, -2).addGap(5, 5, 5).addComponent(this.btnI, -2, 29, -2).addGap(5, 5, 5).addComponent(this.btnO, -2, 29, -2)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addGap(25, 25, 25).addComponent(this.btnP, -2, 29, -2).addGap(5, 5, 5).addComponent(this.btnY, -2, 29, -2).addGap(5, 5, 5).addComponent(this.btnX, -2, 29, -2).addGap(5, 5, 5).addComponent(this.btnC, -2, 29, -2).addGap(5, 5, 5).addComponent(this.btnV, -2, 29, -2).addGap(5, 5, 5).addComponent(this.btnB, -2, 29, -2).addGap(5, 5, 5).addComponent(this.btnN, -2, 29, -2).addGap(5, 5, 5).addComponent(this.btnM, -2, 29, -2).addGap(5, 5, 5).addComponent(this.btnL, -2, 29, -2))).addGap(25, 25, 25)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 0, 0).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btnO, -2, 29, -2).addComponent(this.btnQ, -2, 29, -2).addComponent(this.btnW, -2, 29, -2).addComponent(this.btnE, -2, 29, -2).addComponent(this.btnR, -2, 29, -2).addComponent(this.btnT, -2, 29, -2).addComponent(this.btnZ, -2, 29, -2).addComponent(this.btnU, -2, 29, -2).addComponent(this.btnI, -2, 29, -2)).addGap(1, 1, 1).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btnF, -2, 29, -2).addComponent(this.btnK, -2, 29, -2).addComponent(this.btnD, -2, 29, -2).addComponent(this.btnA, -2, 29, -2).addComponent(this.btnJ, -2, 29, -2).addComponent(this.btnH, -2, 29, -2).addComponent(this.btnG, -2, 29, -2).addComponent(this.btnS, -2, 29, -2)).addGap(2, 2, 2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btnY, -2, 29, -2).addComponent(this.btnB, -2, 29, -2).addComponent(this.btnV, -2, 29, -2).addComponent(this.btnC, -2, 29, -2).addComponent(this.btnP, -2, 29, -2).addComponent(this.btnX, -2, 29, -2).addComponent(this.btnN, -2, 29, -2).addComponent(this.btnM, -2, 29, -2).addComponent(this.btnL, -2, 29, -2)).addContainerGap(1, Short.MAX_VALUE)));
    }

    private void btnQActionPerformed(ActionEvent evt) {
        this.pressKey('Q');
    }

    private void btnOActionPerformed(ActionEvent evt) {
        this.pressKey('O');
    }

    private void btnCActionPerformed(ActionEvent evt) {
        this.pressKey('C');
    }

    private void btnVActionPerformed(ActionEvent evt) {
        this.pressKey('V');
    }

    private void btnBActionPerformed(ActionEvent evt) {
        this.pressKey('B');
    }

    private void btnMActionPerformed(ActionEvent evt) {
        this.pressKey('M');
    }

    private void btnLActionPerformed(ActionEvent evt) {
        this.pressKey('L');
    }

    private void btnXActionPerformed(ActionEvent evt) {
        this.pressKey('X');
    }

    private void btnNActionPerformed(ActionEvent evt) {
        this.pressKey('N');
    }

    private void btnPActionPerformed(ActionEvent evt) {
        this.pressKey('P');
    }

    private void btnYActionPerformed(ActionEvent evt) {
        this.pressKey('Y');
    }

    private void btnDActionPerformed(ActionEvent evt) {
        this.pressKey('D');
    }

    private void btnEActionPerformed(ActionEvent evt) {
        this.pressKey('E');
    }

    private void btnSActionPerformed(ActionEvent evt) {
        this.pressKey('S');
    }

    private void btnWActionPerformed(ActionEvent evt) {
        this.pressKey('W');
    }

    private void btnTActionPerformed(ActionEvent evt) {
        this.pressKey('T');
    }

    private void btnRActionPerformed(ActionEvent evt) {
        this.pressKey('R');
    }

    private void btnAActionPerformed(ActionEvent evt) {
        this.pressKey('A');
    }

    private void btnGActionPerformed(ActionEvent evt) {
        this.pressKey('G');
    }

    private void btnHActionPerformed(ActionEvent evt) {
        this.pressKey('H');
    }

    private void btnZActionPerformed(ActionEvent evt) {
        this.pressKey('Z');
    }

    private void btnJActionPerformed(ActionEvent evt) {
        this.pressKey('J');
    }

    private void btnUActionPerformed(ActionEvent evt) {
        this.pressKey('U');
    }

    private void btnIActionPerformed(ActionEvent evt) {
        this.pressKey('I');
    }

    private void btnKActionPerformed(ActionEvent evt) {
        this.pressKey('K');
    }

    private void btnFActionPerformed(ActionEvent evt) {
        this.pressKey('F');
    }

    class EnigmaKeyListener
    extends KeyAdapter {
        EnigmaKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent event) {
            if (event.getKeyCode() == 81) {
                KeyboardPanel.this.btnQ.doClick();
            } else if (event.getKeyCode() == 87) {
                KeyboardPanel.this.btnW.doClick();
            } else if (event.getKeyCode() == 69) {
                KeyboardPanel.this.btnE.doClick();
            } else if (event.getKeyCode() == 82) {
                KeyboardPanel.this.btnR.doClick();
            } else if (event.getKeyCode() == 84) {
                KeyboardPanel.this.btnT.doClick();
            } else if (event.getKeyCode() == 90) {
                KeyboardPanel.this.btnZ.doClick();
            } else if (event.getKeyCode() == 85) {
                KeyboardPanel.this.btnU.doClick();
            } else if (event.getKeyCode() == 73) {
                KeyboardPanel.this.btnI.doClick();
            } else if (event.getKeyCode() == 79) {
                KeyboardPanel.this.btnO.doClick();
            } else if (event.getKeyCode() == 65) {
                KeyboardPanel.this.btnA.doClick();
            } else if (event.getKeyCode() == 83) {
                KeyboardPanel.this.btnS.doClick();
            } else if (event.getKeyCode() == 68) {
                KeyboardPanel.this.btnD.doClick();
            } else if (event.getKeyCode() == 70) {
                KeyboardPanel.this.btnF.doClick();
            } else if (event.getKeyCode() == 71) {
                KeyboardPanel.this.btnG.doClick();
            } else if (event.getKeyCode() == 72) {
                KeyboardPanel.this.btnH.doClick();
            } else if (event.getKeyCode() == 74) {
                KeyboardPanel.this.btnJ.doClick();
            } else if (event.getKeyCode() == 75) {
                KeyboardPanel.this.btnK.doClick();
            } else if (event.getKeyCode() == 80) {
                KeyboardPanel.this.btnP.doClick();
            } else if (event.getKeyCode() == 89) {
                KeyboardPanel.this.btnY.doClick();
            } else if (event.getKeyCode() == 88) {
                KeyboardPanel.this.btnX.doClick();
            } else if (event.getKeyCode() == 67) {
                KeyboardPanel.this.btnC.doClick();
            } else if (event.getKeyCode() == 86) {
                KeyboardPanel.this.btnV.doClick();
            } else if (event.getKeyCode() == 66) {
                KeyboardPanel.this.btnB.doClick();
            } else if (event.getKeyCode() == 78) {
                KeyboardPanel.this.btnN.doClick();
            } else if (event.getKeyCode() == 77) {
                KeyboardPanel.this.btnM.doClick();
            } else if (event.getKeyCode() == 76) {
                KeyboardPanel.this.btnL.doClick();
            }
        }
    }
}

