/*
 * Decompiled with CFR 0.152.
 */
package machines.panels;

import enigma.Plugboard;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Random;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class PlugboardPanel
extends JPanel {
    private Plugboard plugboard;
    private char[] plugPoints;
    private String[] pairs;
    private int cables;
    private int[] cableColor = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12};
    private boolean[] empty;
    private char[] position = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
    private char[] autoPosition = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
    private ImageIcon zero = new ImageIcon(this.getClass().getResource("/resources/plugs/BlueCyanPlug.png"));
    private ImageIcon one = new ImageIcon(this.getClass().getResource("/resources/plugs/BluePlug.png"));
    private ImageIcon two = new ImageIcon(this.getClass().getResource("/resources/plugs/BrownPlug.png"));
    private ImageIcon three = new ImageIcon(this.getClass().getResource("/resources/plugs/GreenGrassPlug.png"));
    private ImageIcon four = new ImageIcon(this.getClass().getResource("/resources/plugs/GreenSuedePlug.png"));
    private ImageIcon five = new ImageIcon(this.getClass().getResource("/resources/plugs/RoseRedPlug.png"));
    private ImageIcon six = new ImageIcon(this.getClass().getResource("/resources/plugs/OrangePalePlug.png"));
    private ImageIcon seven = new ImageIcon(this.getClass().getResource("/resources/plugs/OrangePlug.png"));
    private ImageIcon eight = new ImageIcon(this.getClass().getResource("/resources/plugs/PinkPlug.png"));
    private ImageIcon nine = new ImageIcon(this.getClass().getResource("/resources/plugs/PurplePlug.png"));
    private ImageIcon ten = new ImageIcon(this.getClass().getResource("/resources/plugs/RedPlug.png"));
    private ImageIcon eleven = new ImageIcon(this.getClass().getResource("/resources/plugs/DarkGreyPlug.png"));
    private ImageIcon twelve = new ImageIcon(this.getClass().getResource("/resources/plugs/YellowPlug.png"));
    private JButton aPlug;
    private JButton autoBtn;
    private JButton bPlug;
    private JLabel backgroundLabel;
    private JLabel boxSeperator;
    private JButton cPlug;
    private JButton dPlug;
    private JButton ePlug;
    private JButton fPlug;
    private JButton gPlug;
    private JButton hPlug;
    private JButton iPlug;
    private JPanel jPanel1;
    private JButton jPlug;
    private JSeparator jSeparator1;
    private JButton kPlug;
    private JButton lPlug;
    private JButton mPlug;
    private JButton nPlug;
    private JButton oPlug;
    private JButton pPlug;
    private JPanel plugPad;
    private JButton qPlug;
    private JButton rPlug;
    private JButton resetBtn;
    private JButton sPlug;
    private JTextField swapsInfo;
    private JButton tPlug;
    private JButton uPlug;
    private JButton vPlug;
    private JButton wPlug;
    private JButton xPlug;
    private JButton yPlug;
    private JButton zPlug;

    public PlugboardPanel() {
        this.initComponents();
        this.shuffleColors();
        this.plugboard = new Plugboard();
        this.plugPoints = new char[2];
        this.pairs = new String[13];
        this.cables = 0;
        this.empty = new boolean[26];
        for (int i = 0; i < 26; ++i) {
            this.empty[i] = true;
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D gPaper = (Graphics2D)g;
        ImageIcon paperImage = new ImageIcon(this.getClass().getResource("/resources/EnigmaPaper.png"));
        Image image = paperImage.getImage();
        if (image != null) {
            gPaper.drawImage(image, 0, 0, 400, 400, this);
        }
    }

    private boolean isEmpty(char letter) {
        int temp = 0;
        boolean temp2 = false;
        for (int i = 0; i < 26; ++i) {
            if (this.position[i] != letter) continue;
            temp = i;
            break;
        }
        if (this.empty[temp]) {
            temp2 = true;
        }
        return temp2;
    }

    private void setState(char letter, boolean state) {
        int temp = 0;
        for (int i = 0; i < 26; ++i) {
            if (this.position[i] != letter) continue;
            temp = i;
            break;
        }
        this.empty[temp] = state;
    }

    public void resetPlugs() {
        int i;
        this.plugboard.resetAll();
        this.plugPoints[0] = '\u0000';
        this.plugPoints[1] = '\u0000';
        this.cables = 0;
        for (i = 0; i < 13; ++i) {
            if (this.pairs[i] == null) continue;
            this.pairs[i] = null;
        }
        for (i = 0; i < 26; ++i) {
            this.removePlug(this.position[i]);
        }
        this.refreshInfo();
        this.shuffleColors();
    }

    private void autoPlugs() {
        this.resetPlugs();
        this.shuffleSwaps();
        for (int i = 0; i < 22; ++i) {
            this.plugCable(this.autoPosition[i]);
        }
    }

    private void refreshInfo() {
        String swapsString = "";
        for (int i = 0; i < 13; ++i) {
            if (this.pairs[i] == null) continue;
            swapsString = swapsString + this.pairs[i] + " ";
        }
        this.swapsInfo.removeAll();
        this.swapsInfo.setText(swapsString);
    }

    private void addPair(char letter, char letter2) {
        for (int j = 0; this.pairs[j] != null && j < 13; ++j) {
        }
        this.pairs[j] = letter + "" + letter2;
        ++this.cables;
        this.refreshInfo();
    }

    public String[] getPairs() {
        return this.pairs;
    }

    private void removePair(char letter, char letter2) {
        for (int i = 0; i < 13; ++i) {
            if (this.pairs[i] == null || (this.pairs[i].charAt(0) != letter || this.pairs[i].charAt(1) != letter2) && (this.pairs[i].charAt(1) != letter || this.pairs[i].charAt(0) != letter2)) continue;
            this.pairs[i] = null;
            --this.cables;
            if (this.cables < 0) {
                this.cables = 0;
            }
            if (this.cables == 0) {
                this.shuffleColors();
            }
            this.refreshInfo();
            break;
        }
    }

    public void plugCable(char letter) {
        if (this.isEmpty(letter)) {
            if (this.plugPoints[0] == '\u0000' && this.plugPoints[1] == '\u0000') {
                this.plugPoints[0] = letter;
                this.addPlug(this.plugPoints[0]);
            } else {
                this.plugPoints[1] = letter;
                this.addPlug(this.plugPoints[1]);
                this.plugboard.addCable(this.plugPoints[0], this.plugPoints[1]);
                this.addPair(this.plugPoints[0], this.plugPoints[1]);
                this.plugPoints[0] = '\u0000';
                this.plugPoints[1] = '\u0000';
            }
        } else if (!this.isEmpty(letter)) {
            if (this.plugPoints[0] != '\u0000') {
                this.removePlug(this.plugPoints[0]);
                this.plugPoints[0] = '\u0000';
            } else {
                this.removePlug(letter);
                this.removePlug(this.plugboard.getPair(letter));
                this.removePair(letter, this.plugboard.getPair(letter));
                this.plugboard.removeCable(letter, this.plugboard.getPair(letter));
            }
        }
    }

    private void addPlug(char letter) {
        int k;
        this.setState(letter, false);
        for (k = 0; this.pairs[k] != null && k < 13; ++k) {
        }
        int color = this.cableColor[k];
        ImageIcon plugColor = null;
        if (color == 0) {
            plugColor = this.zero;
        } else if (color == 1) {
            plugColor = this.one;
        } else if (color == 2) {
            plugColor = this.two;
        } else if (color == 3) {
            plugColor = this.three;
        } else if (color == 4) {
            plugColor = this.four;
        } else if (color == 5) {
            plugColor = this.five;
        } else if (color == 6) {
            plugColor = this.six;
        } else if (color == 7) {
            plugColor = this.seven;
        } else if (color == 8) {
            plugColor = this.eight;
        } else if (color == 9) {
            plugColor = this.nine;
        } else if (color == 10) {
            plugColor = this.ten;
        } else if (color == 11) {
            plugColor = this.eleven;
        } else if (color == 12) {
            plugColor = this.twelve;
        }
        if (letter == 'Q') {
            this.qPlug.setIcon(plugColor);
        } else if (letter == 'W') {
            this.wPlug.setIcon(plugColor);
        } else if (letter == 'E') {
            this.ePlug.setIcon(plugColor);
        } else if (letter == 'R') {
            this.rPlug.setIcon(plugColor);
        } else if (letter == 'T') {
            this.tPlug.setIcon(plugColor);
        } else if (letter == 'Z') {
            this.zPlug.setIcon(plugColor);
        } else if (letter == 'U') {
            this.uPlug.setIcon(plugColor);
        } else if (letter == 'I') {
            this.iPlug.setIcon(plugColor);
        } else if (letter == 'O') {
            this.oPlug.setIcon(plugColor);
        } else if (letter == 'A') {
            this.aPlug.setIcon(plugColor);
        } else if (letter == 'S') {
            this.sPlug.setIcon(plugColor);
        } else if (letter == 'D') {
            this.dPlug.setIcon(plugColor);
        } else if (letter == 'F') {
            this.fPlug.setIcon(plugColor);
        } else if (letter == 'G') {
            this.gPlug.setIcon(plugColor);
        } else if (letter == 'H') {
            this.hPlug.setIcon(plugColor);
        } else if (letter == 'J') {
            this.jPlug.setIcon(plugColor);
        } else if (letter == 'K') {
            this.kPlug.setIcon(plugColor);
        } else if (letter == 'P') {
            this.pPlug.setIcon(plugColor);
        } else if (letter == 'Y') {
            this.yPlug.setIcon(plugColor);
        } else if (letter == 'X') {
            this.xPlug.setIcon(plugColor);
        } else if (letter == 'C') {
            this.cPlug.setIcon(plugColor);
        } else if (letter == 'V') {
            this.vPlug.setIcon(plugColor);
        } else if (letter == 'B') {
            this.bPlug.setIcon(plugColor);
        } else if (letter == 'N') {
            this.nPlug.setIcon(plugColor);
        } else if (letter == 'M') {
            this.mPlug.setIcon(plugColor);
        } else if (letter == 'L') {
            this.lPlug.setIcon(plugColor);
        }
    }

    private void removePlug(char letter) {
        this.setState(letter, true);
        if (letter == 'Q') {
            this.qPlug.setIcon(null);
        } else if (letter == 'W') {
            this.wPlug.setIcon(null);
        } else if (letter == 'E') {
            this.ePlug.setIcon(null);
        } else if (letter == 'R') {
            this.rPlug.setIcon(null);
        } else if (letter == 'T') {
            this.tPlug.setIcon(null);
        } else if (letter == 'Z') {
            this.zPlug.setIcon(null);
        } else if (letter == 'U') {
            this.uPlug.setIcon(null);
        } else if (letter == 'I') {
            this.iPlug.setIcon(null);
        } else if (letter == 'O') {
            this.oPlug.setIcon(null);
        } else if (letter == 'A') {
            this.aPlug.setIcon(null);
        } else if (letter == 'S') {
            this.sPlug.setIcon(null);
        } else if (letter == 'D') {
            this.dPlug.setIcon(null);
        } else if (letter == 'F') {
            this.fPlug.setIcon(null);
        } else if (letter == 'G') {
            this.gPlug.setIcon(null);
        } else if (letter == 'H') {
            this.hPlug.setIcon(null);
        } else if (letter == 'J') {
            this.jPlug.setIcon(null);
        } else if (letter == 'K') {
            this.kPlug.setIcon(null);
        } else if (letter == 'P') {
            this.pPlug.setIcon(null);
        } else if (letter == 'Y') {
            this.yPlug.setIcon(null);
        } else if (letter == 'X') {
            this.xPlug.setIcon(null);
        } else if (letter == 'C') {
            this.cPlug.setIcon(null);
        } else if (letter == 'V') {
            this.vPlug.setIcon(null);
        } else if (letter == 'B') {
            this.bPlug.setIcon(null);
        } else if (letter == 'N') {
            this.nPlug.setIcon(null);
        } else if (letter == 'M') {
            this.mPlug.setIcon(null);
        } else if (letter == 'L') {
            this.lPlug.setIcon(null);
        }
    }

    private void shuffleColors() {
        Random rgen = new Random();
        for (int i = 0; i < this.cableColor.length; ++i) {
            int randomPosition = rgen.nextInt(this.cableColor.length);
            int temp = this.cableColor[i];
            this.cableColor[i] = this.cableColor[randomPosition];
            this.cableColor[randomPosition] = temp;
        }
    }

    private void shuffleSwaps() {
        Random rgen = new Random();
        for (int i = 0; i < this.autoPosition.length; ++i) {
            int randomPosition = rgen.nextInt(this.autoPosition.length);
            char temp = this.autoPosition[i];
            this.autoPosition[i] = this.autoPosition[randomPosition];
            this.autoPosition[randomPosition] = temp;
        }
    }

    public Plugboard getPlugB() {
        return this.plugboard;
    }

    private void initComponents() {
        this.plugPad = new JPanel();
        this.oPlug = new JButton();
        this.rPlug = new JButton();
        this.tPlug = new JButton();
        this.zPlug = new JButton();
        this.ePlug = new JButton();
        this.uPlug = new JButton();
        this.wPlug = new JButton();
        this.qPlug = new JButton();
        this.iPlug = new JButton();
        this.aPlug = new JButton();
        this.sPlug = new JButton();
        this.dPlug = new JButton();
        this.fPlug = new JButton();
        this.hPlug = new JButton();
        this.gPlug = new JButton();
        this.kPlug = new JButton();
        this.jPlug = new JButton();
        this.pPlug = new JButton();
        this.yPlug = new JButton();
        this.xPlug = new JButton();
        this.cPlug = new JButton();
        this.vPlug = new JButton();
        this.bPlug = new JButton();
        this.nPlug = new JButton();
        this.mPlug = new JButton();
        this.lPlug = new JButton();
        this.backgroundLabel = new JLabel();
        this.jPanel1 = new JPanel();
        this.resetBtn = new JButton();
        this.autoBtn = new JButton();
        this.jSeparator1 = new JSeparator();
        this.swapsInfo = new JTextField();
        this.boxSeperator = new JLabel();
        this.setLayout(null);
        this.plugPad.setBackground(new Color(255, 204, 204));
        this.plugPad.setFocusable(false);
        this.plugPad.setOpaque(false);
        this.oPlug.setContentAreaFilled(false);
        this.oPlug.setCursor(new Cursor(12));
        this.oPlug.setFocusable(false);
        this.oPlug.setMaximumSize(new Dimension(25, 50));
        this.oPlug.setMinimumSize(new Dimension(25, 50));
        this.oPlug.setPreferredSize(new Dimension(25, 50));
        this.oPlug.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlugboardPanel.this.oPlugActionPerformed(evt);
            }
        });
        this.rPlug.setContentAreaFilled(false);
        this.rPlug.setCursor(new Cursor(12));
        this.rPlug.setFocusable(false);
        this.rPlug.setMaximumSize(new Dimension(25, 50));
        this.rPlug.setMinimumSize(new Dimension(25, 50));
        this.rPlug.setPreferredSize(new Dimension(25, 50));
        this.rPlug.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlugboardPanel.this.rPlugActionPerformed(evt);
            }
        });
        this.tPlug.setContentAreaFilled(false);
        this.tPlug.setCursor(new Cursor(12));
        this.tPlug.setFocusable(false);
        this.tPlug.setMaximumSize(new Dimension(25, 50));
        this.tPlug.setMinimumSize(new Dimension(25, 50));
        this.tPlug.setPreferredSize(new Dimension(25, 50));
        this.tPlug.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlugboardPanel.this.tPlugActionPerformed(evt);
            }
        });
        this.zPlug.setContentAreaFilled(false);
        this.zPlug.setCursor(new Cursor(12));
        this.zPlug.setFocusable(false);
        this.zPlug.setMaximumSize(new Dimension(25, 50));
        this.zPlug.setMinimumSize(new Dimension(25, 50));
        this.zPlug.setPreferredSize(new Dimension(25, 50));
        this.zPlug.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlugboardPanel.this.zPlugActionPerformed(evt);
            }
        });
        this.ePlug.setContentAreaFilled(false);
        this.ePlug.setCursor(new Cursor(12));
        this.ePlug.setFocusable(false);
        this.ePlug.setMaximumSize(new Dimension(25, 50));
        this.ePlug.setMinimumSize(new Dimension(25, 50));
        this.ePlug.setPreferredSize(new Dimension(25, 50));
        this.ePlug.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlugboardPanel.this.ePlugActionPerformed(evt);
            }
        });
        this.uPlug.setContentAreaFilled(false);
        this.uPlug.setCursor(new Cursor(12));
        this.uPlug.setFocusable(false);
        this.uPlug.setMaximumSize(new Dimension(25, 50));
        this.uPlug.setMinimumSize(new Dimension(25, 50));
        this.uPlug.setPreferredSize(new Dimension(25, 50));
        this.uPlug.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlugboardPanel.this.uPlugActionPerformed(evt);
            }
        });
        this.wPlug.setContentAreaFilled(false);
        this.wPlug.setCursor(new Cursor(12));
        this.wPlug.setFocusable(false);
        this.wPlug.setMaximumSize(new Dimension(25, 50));
        this.wPlug.setMinimumSize(new Dimension(25, 50));
        this.wPlug.setPreferredSize(new Dimension(25, 50));
        this.wPlug.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlugboardPanel.this.wPlugActionPerformed(evt);
            }
        });
        this.qPlug.setContentAreaFilled(false);
        this.qPlug.setCursor(new Cursor(12));
        this.qPlug.setFocusable(false);
        this.qPlug.setMaximumSize(new Dimension(25, 50));
        this.qPlug.setMinimumSize(new Dimension(25, 50));
        this.qPlug.setPreferredSize(new Dimension(25, 50));
        this.qPlug.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlugboardPanel.this.qPlugActionPerformed(evt);
            }
        });
        this.iPlug.setContentAreaFilled(false);
        this.iPlug.setCursor(new Cursor(12));
        this.iPlug.setFocusable(false);
        this.iPlug.setMaximumSize(new Dimension(25, 50));
        this.iPlug.setMinimumSize(new Dimension(25, 50));
        this.iPlug.setPreferredSize(new Dimension(25, 50));
        this.iPlug.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlugboardPanel.this.iPlugActionPerformed(evt);
            }
        });
        this.aPlug.setContentAreaFilled(false);
        this.aPlug.setCursor(new Cursor(12));
        this.aPlug.setFocusable(false);
        this.aPlug.setMaximumSize(new Dimension(25, 50));
        this.aPlug.setMinimumSize(new Dimension(25, 50));
        this.aPlug.setPreferredSize(new Dimension(25, 50));
        this.aPlug.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlugboardPanel.this.aPlugActionPerformed(evt);
            }
        });
        this.sPlug.setContentAreaFilled(false);
        this.sPlug.setCursor(new Cursor(12));
        this.sPlug.setFocusable(false);
        this.sPlug.setMaximumSize(new Dimension(25, 50));
        this.sPlug.setMinimumSize(new Dimension(25, 50));
        this.sPlug.setPreferredSize(new Dimension(25, 50));
        this.sPlug.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlugboardPanel.this.sPlugActionPerformed(evt);
            }
        });
        this.dPlug.setContentAreaFilled(false);
        this.dPlug.setCursor(new Cursor(12));
        this.dPlug.setFocusable(false);
        this.dPlug.setMaximumSize(new Dimension(25, 50));
        this.dPlug.setMinimumSize(new Dimension(25, 50));
        this.dPlug.setPreferredSize(new Dimension(25, 50));
        this.dPlug.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlugboardPanel.this.dPlugActionPerformed(evt);
            }
        });
        this.fPlug.setContentAreaFilled(false);
        this.fPlug.setCursor(new Cursor(12));
        this.fPlug.setFocusable(false);
        this.fPlug.setMaximumSize(new Dimension(25, 50));
        this.fPlug.setMinimumSize(new Dimension(25, 50));
        this.fPlug.setPreferredSize(new Dimension(25, 50));
        this.fPlug.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlugboardPanel.this.fPlugActionPerformed(evt);
            }
        });
        this.hPlug.setContentAreaFilled(false);
        this.hPlug.setCursor(new Cursor(12));
        this.hPlug.setFocusable(false);
        this.hPlug.setMaximumSize(new Dimension(25, 50));
        this.hPlug.setMinimumSize(new Dimension(25, 50));
        this.hPlug.setPreferredSize(new Dimension(25, 50));
        this.hPlug.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlugboardPanel.this.hPlugActionPerformed(evt);
            }
        });
        this.gPlug.setContentAreaFilled(false);
        this.gPlug.setCursor(new Cursor(12));
        this.gPlug.setFocusable(false);
        this.gPlug.setMaximumSize(new Dimension(25, 50));
        this.gPlug.setMinimumSize(new Dimension(25, 50));
        this.gPlug.setPreferredSize(new Dimension(25, 50));
        this.gPlug.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlugboardPanel.this.gPlugActionPerformed(evt);
            }
        });
        this.kPlug.setContentAreaFilled(false);
        this.kPlug.setCursor(new Cursor(12));
        this.kPlug.setFocusable(false);
        this.kPlug.setMaximumSize(new Dimension(25, 50));
        this.kPlug.setMinimumSize(new Dimension(25, 50));
        this.kPlug.setPreferredSize(new Dimension(25, 50));
        this.kPlug.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlugboardPanel.this.kPlugActionPerformed(evt);
            }
        });
        this.jPlug.setContentAreaFilled(false);
        this.jPlug.setCursor(new Cursor(12));
        this.jPlug.setFocusable(false);
        this.jPlug.setMaximumSize(new Dimension(25, 50));
        this.jPlug.setMinimumSize(new Dimension(25, 50));
        this.jPlug.setPreferredSize(new Dimension(25, 50));
        this.jPlug.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlugboardPanel.this.jPlugActionPerformed(evt);
            }
        });
        this.pPlug.setContentAreaFilled(false);
        this.pPlug.setCursor(new Cursor(12));
        this.pPlug.setFocusable(false);
        this.pPlug.setMaximumSize(new Dimension(25, 50));
        this.pPlug.setMinimumSize(new Dimension(25, 50));
        this.pPlug.setPreferredSize(new Dimension(25, 50));
        this.pPlug.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlugboardPanel.this.pPlugActionPerformed(evt);
            }
        });
        this.yPlug.setContentAreaFilled(false);
        this.yPlug.setCursor(new Cursor(12));
        this.yPlug.setFocusable(false);
        this.yPlug.setMaximumSize(new Dimension(25, 50));
        this.yPlug.setMinimumSize(new Dimension(25, 50));
        this.yPlug.setPreferredSize(new Dimension(25, 50));
        this.yPlug.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlugboardPanel.this.yPlugActionPerformed(evt);
            }
        });
        this.xPlug.setContentAreaFilled(false);
        this.xPlug.setCursor(new Cursor(12));
        this.xPlug.setFocusable(false);
        this.xPlug.setMaximumSize(new Dimension(25, 50));
        this.xPlug.setMinimumSize(new Dimension(25, 50));
        this.xPlug.setPreferredSize(new Dimension(25, 50));
        this.xPlug.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlugboardPanel.this.xPlugActionPerformed(evt);
            }
        });
        this.cPlug.setContentAreaFilled(false);
        this.cPlug.setCursor(new Cursor(12));
        this.cPlug.setFocusable(false);
        this.cPlug.setMaximumSize(new Dimension(25, 50));
        this.cPlug.setMinimumSize(new Dimension(25, 50));
        this.cPlug.setPreferredSize(new Dimension(25, 50));
        this.cPlug.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlugboardPanel.this.cPlugActionPerformed(evt);
            }
        });
        this.vPlug.setContentAreaFilled(false);
        this.vPlug.setCursor(new Cursor(12));
        this.vPlug.setFocusable(false);
        this.vPlug.setMaximumSize(new Dimension(25, 50));
        this.vPlug.setMinimumSize(new Dimension(25, 50));
        this.vPlug.setPreferredSize(new Dimension(25, 50));
        this.vPlug.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlugboardPanel.this.vPlugActionPerformed(evt);
            }
        });
        this.bPlug.setContentAreaFilled(false);
        this.bPlug.setCursor(new Cursor(12));
        this.bPlug.setFocusable(false);
        this.bPlug.setMaximumSize(new Dimension(25, 50));
        this.bPlug.setMinimumSize(new Dimension(25, 50));
        this.bPlug.setPreferredSize(new Dimension(25, 50));
        this.bPlug.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlugboardPanel.this.bPlugActionPerformed(evt);
            }
        });
        this.nPlug.setContentAreaFilled(false);
        this.nPlug.setCursor(new Cursor(12));
        this.nPlug.setFocusable(false);
        this.nPlug.setMaximumSize(new Dimension(25, 50));
        this.nPlug.setMinimumSize(new Dimension(25, 50));
        this.nPlug.setPreferredSize(new Dimension(25, 50));
        this.nPlug.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlugboardPanel.this.nPlugActionPerformed(evt);
            }
        });
        this.mPlug.setContentAreaFilled(false);
        this.mPlug.setCursor(new Cursor(12));
        this.mPlug.setFocusable(false);
        this.mPlug.setMaximumSize(new Dimension(25, 50));
        this.mPlug.setMinimumSize(new Dimension(25, 50));
        this.mPlug.setPreferredSize(new Dimension(25, 50));
        this.mPlug.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlugboardPanel.this.mPlugActionPerformed(evt);
            }
        });
        this.lPlug.setContentAreaFilled(false);
        this.lPlug.setCursor(new Cursor(12));
        this.lPlug.setFocusable(false);
        this.lPlug.setMaximumSize(new Dimension(25, 50));
        this.lPlug.setMinimumSize(new Dimension(25, 50));
        this.lPlug.setPreferredSize(new Dimension(25, 50));
        this.lPlug.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlugboardPanel.this.lPlugActionPerformed(evt);
            }
        });
        GroupLayout plugPadLayout = new GroupLayout(this.plugPad);
        this.plugPad.setLayout(plugPadLayout);
        plugPadLayout.setHorizontalGroup(plugPadLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(plugPadLayout.createSequentialGroup().addGroup(plugPadLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(plugPadLayout.createSequentialGroup().addGap(42, 42, 42).addComponent(this.aPlug, -2, 25, -2).addGap(11, 11, 11).addComponent(this.sPlug, -2, 25, -2).addGap(11, 11, 11).addComponent(this.dPlug, -2, 25, -2).addGap(11, 11, 11).addComponent(this.fPlug, -2, 25, -2).addGap(11, 11, 11).addComponent(this.gPlug, -2, 25, -2).addGap(11, 11, 11).addComponent(this.hPlug, -2, 25, -2).addGap(11, 11, 11).addComponent(this.jPlug, -2, 25, -2).addGap(11, 11, 11).addComponent(this.kPlug, -2, 25, -2)).addGroup(plugPadLayout.createSequentialGroup().addGap(24, 24, 24).addGroup(plugPadLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(plugPadLayout.createSequentialGroup().addComponent(this.pPlug, -2, 25, -2).addGap(11, 11, 11).addComponent(this.yPlug, -2, 25, -2).addGap(11, 11, 11).addComponent(this.xPlug, -2, 25, -2).addGap(11, 11, 11).addComponent(this.cPlug, -2, 25, -2).addGap(11, 11, 11).addComponent(this.vPlug, -2, 25, -2).addGap(11, 11, 11).addComponent(this.bPlug, -2, 25, -2).addGap(11, 11, 11).addComponent(this.nPlug, -2, 25, -2).addGap(11, 11, 11).addComponent(this.mPlug, -2, 25, -2).addGap(11, 11, 11).addComponent(this.lPlug, -2, 25, -2)).addGroup(plugPadLayout.createSequentialGroup().addComponent(this.qPlug, -2, 25, -2).addGap(11, 11, 11).addComponent(this.wPlug, -2, 25, -2).addGap(11, 11, 11).addComponent(this.ePlug, -2, 25, -2).addGap(11, 11, 11).addComponent(this.rPlug, -2, 25, -2).addGap(11, 11, 11).addComponent(this.tPlug, -2, 25, -2).addGap(11, 11, 11).addComponent(this.zPlug, -2, 25, -2).addGap(11, 11, 11).addComponent(this.uPlug, -2, 25, -2).addGap(11, 11, 11).addComponent(this.iPlug, -2, 25, -2).addGap(11, 11, 11).addComponent(this.oPlug, -2, 25, -2))))).addGap(23, 23, 23)));
        plugPadLayout.setVerticalGroup(plugPadLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(plugPadLayout.createSequentialGroup().addGap(19, 19, 19).addGroup(plugPadLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.oPlug, -2, 50, -2).addComponent(this.iPlug, -2, 50, -2).addComponent(this.uPlug, -2, 50, -2).addComponent(this.zPlug, -2, 50, -2).addComponent(this.tPlug, -2, 50, -2).addComponent(this.ePlug, -2, 50, -2).addComponent(this.rPlug, -2, 50, -2).addComponent(this.wPlug, -2, 50, -2).addComponent(this.qPlug, -2, 50, -2)).addGap(4, 4, 4).addGroup(plugPadLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.aPlug, -2, 50, -2).addComponent(this.sPlug, -2, 50, -2).addComponent(this.dPlug, -2, 50, -2).addComponent(this.fPlug, -2, 50, -2).addComponent(this.gPlug, -2, 50, -2).addComponent(this.hPlug, -2, 50, -2).addComponent(this.jPlug, -2, 50, -2).addComponent(this.kPlug, -2, 50, -2)).addGap(4, 4, 4).addGroup(plugPadLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.pPlug, -2, 50, -2).addComponent(this.yPlug, -2, 50, -2).addComponent(this.xPlug, -2, 50, -2).addComponent(this.cPlug, -2, 50, -2).addComponent(this.vPlug, -2, 50, -2).addComponent(this.bPlug, -2, 50, -2).addComponent(this.nPlug, -2, 50, -2).addComponent(this.mPlug, -2, 50, -2).addComponent(this.lPlug, -2, 50, -2))));
        this.add(this.plugPad);
        this.plugPad.setBounds(0, 0, 360, 180);
        this.backgroundLabel.setHorizontalAlignment(0);
        this.backgroundLabel.setIcon(new ImageIcon(this.getClass().getResource("/resources/panels/Plugboard.png")));
        this.add(this.backgroundLabel);
        this.backgroundLabel.setBounds(0, 0, 360, 180);
        this.jPanel1.setBackground(new Color(255, 204, 204));
        this.jPanel1.setFocusable(false);
        this.jPanel1.setOpaque(false);
        this.resetBtn.setIcon(new ImageIcon(this.getClass().getResource("/resources/buttons/ClearNew.png")));
        this.resetBtn.setContentAreaFilled(false);
        this.resetBtn.setCursor(new Cursor(12));
        this.resetBtn.setFocusable(false);
        this.resetBtn.setMaximumSize(new Dimension(67, 26));
        this.resetBtn.setMinimumSize(new Dimension(67, 26));
        this.resetBtn.setPreferredSize(new Dimension(67, 26));
        this.resetBtn.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/buttons/ClearNewPress.png")));
        this.resetBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlugboardPanel.this.resetBtnActionPerformed(evt);
            }
        });
        this.autoBtn.setIcon(new ImageIcon(this.getClass().getResource("/resources/buttons/AutoNew.png")));
        this.autoBtn.setContentAreaFilled(false);
        this.autoBtn.setCursor(new Cursor(12));
        this.autoBtn.setFocusable(false);
        this.autoBtn.setMaximumSize(new Dimension(67, 26));
        this.autoBtn.setMinimumSize(new Dimension(67, 26));
        this.autoBtn.setPreferredSize(new Dimension(67, 26));
        this.autoBtn.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/buttons/AutoNewPress.png")));
        this.autoBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlugboardPanel.this.autoBtnActionPerformed(evt);
            }
        });
        this.swapsInfo.setEditable(false);
        this.swapsInfo.setHorizontalAlignment(0);
        this.swapsInfo.setToolTipText("Swaped Characters");
        this.swapsInfo.setFocusable(false);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.resetBtn, -2, 75, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 190, Short.MAX_VALUE).addComponent(this.autoBtn, -2, 75, -2)).addComponent(this.swapsInfo, GroupLayout.Alignment.TRAILING)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.swapsInfo, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.autoBtn, -2, 30, -2).addComponent(this.resetBtn, -2, 30, -2)).addContainerGap()));
        this.add(this.jPanel1);
        this.jPanel1.setBounds(0, 190, 360, 81);
        this.boxSeperator.setHorizontalAlignment(0);
        this.boxSeperator.setIcon(new ImageIcon(this.getClass().getResource("/resources/box/BoxBottomPlain.png")));
        this.boxSeperator.setFocusable(false);
        this.add(this.boxSeperator);
        this.boxSeperator.setBounds(0, 180, 360, 10);
    }

    private void qPlugActionPerformed(ActionEvent evt) {
        this.plugCable('Q');
    }

    private void wPlugActionPerformed(ActionEvent evt) {
        this.plugCable('W');
    }

    private void rPlugActionPerformed(ActionEvent evt) {
        this.plugCable('R');
    }

    private void ePlugActionPerformed(ActionEvent evt) {
        this.plugCable('E');
    }

    private void tPlugActionPerformed(ActionEvent evt) {
        this.plugCable('T');
    }

    private void zPlugActionPerformed(ActionEvent evt) {
        this.plugCable('Z');
    }

    private void uPlugActionPerformed(ActionEvent evt) {
        this.plugCable('U');
    }

    private void iPlugActionPerformed(ActionEvent evt) {
        this.plugCable('I');
    }

    private void oPlugActionPerformed(ActionEvent evt) {
        this.plugCable('O');
    }

    private void aPlugActionPerformed(ActionEvent evt) {
        this.plugCable('A');
    }

    private void sPlugActionPerformed(ActionEvent evt) {
        this.plugCable('S');
    }

    private void dPlugActionPerformed(ActionEvent evt) {
        this.plugCable('D');
    }

    private void fPlugActionPerformed(ActionEvent evt) {
        this.plugCable('F');
    }

    private void gPlugActionPerformed(ActionEvent evt) {
        this.plugCable('G');
    }

    private void hPlugActionPerformed(ActionEvent evt) {
        this.plugCable('H');
    }

    private void jPlugActionPerformed(ActionEvent evt) {
        this.plugCable('J');
    }

    private void kPlugActionPerformed(ActionEvent evt) {
        this.plugCable('K');
    }

    private void pPlugActionPerformed(ActionEvent evt) {
        this.plugCable('P');
    }

    private void yPlugActionPerformed(ActionEvent evt) {
        this.plugCable('Y');
    }

    private void xPlugActionPerformed(ActionEvent evt) {
        this.plugCable('X');
    }

    private void cPlugActionPerformed(ActionEvent evt) {
        this.plugCable('C');
    }

    private void vPlugActionPerformed(ActionEvent evt) {
        this.plugCable('V');
    }

    private void bPlugActionPerformed(ActionEvent evt) {
        this.plugCable('B');
    }

    private void nPlugActionPerformed(ActionEvent evt) {
        this.plugCable('N');
    }

    private void mPlugActionPerformed(ActionEvent evt) {
        this.plugCable('M');
    }

    private void lPlugActionPerformed(ActionEvent evt) {
        this.plugCable('L');
    }

    private void resetBtnActionPerformed(ActionEvent evt) {
        this.resetPlugs();
    }

    private void autoBtnActionPerformed(ActionEvent evt) {
        this.autoPlugs();
    }
}

