/*
 * Decompiled with CFR 0.152.
 */
package machines.panels;

import enigma.Reflector;
import enigma.SteppingMechanism;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Random;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class ReflectorPanel
extends JPanel {
    private SteppingMechanism stepMech;
    private Reflector ukw;
    private char[] plugPoints;
    private String[] pairs;
    private int cables;
    private int[] cableColor = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11};
    private boolean[] empty;
    private char[] dotPosition = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Z'};
    private char[] autoDotPosition = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Z'};
    private char[] GAF = new char[]{'H', 'K', 'G', 'L', 'N', 'Q', 'S', 'V', 'U', 'X', 'T', 'Z', 'R', 'W', 'A', 'D', 'B', 'F', 'C', 'O', 'E', 'P', 'I', 'M'};
    private ImageIcon zero = new ImageIcon(this.getClass().getResource("/resources/plugs/BlueCyanDot.png"));
    private ImageIcon one = new ImageIcon(this.getClass().getResource("/resources/plugs/BlueDot.png"));
    private ImageIcon two = new ImageIcon(this.getClass().getResource("/resources/plugs/BrownDot.png"));
    private ImageIcon three = new ImageIcon(this.getClass().getResource("/resources/plugs/GreenGrassDot.png"));
    private ImageIcon four = new ImageIcon(this.getClass().getResource("/resources/plugs/GreenSuedeDot.png"));
    private ImageIcon five = new ImageIcon(this.getClass().getResource("/resources/plugs/RoseRedDot.png"));
    private ImageIcon six = new ImageIcon(this.getClass().getResource("/resources/plugs/OrangePaleDot.png"));
    private ImageIcon seven = new ImageIcon(this.getClass().getResource("/resources/plugs/OrangeDot.png"));
    private ImageIcon eight = new ImageIcon(this.getClass().getResource("/resources/plugs/PinkDot.png"));
    private ImageIcon nine = new ImageIcon(this.getClass().getResource("/resources/plugs/PurpleDot.png"));
    private ImageIcon ten = new ImageIcon(this.getClass().getResource("/resources/plugs/RedDot.png"));
    private ImageIcon eleven = new ImageIcon(this.getClass().getResource("/resources/plugs/YellowDot.png"));
    private JLabel UKWDLabel;
    private JButton aDot;
    private JButton autoBtn;
    private JButton bDot;
    private JLabel boxSeperator;
    private JButton cDot;
    private JPanel controlsPanel;
    private JButton dDot;
    private JPanel dotsPanel;
    private JButton eDot;
    private JButton fDot;
    private JButton gDot;
    private JButton hDot;
    private JButton iDot;
    private JSeparator jSeparator1;
    private JButton kDot;
    private JButton lDot;
    private JButton mDot;
    private JButton nDot;
    private JButton oDot;
    private JButton pDot;
    private JButton qDot;
    private JButton rDot;
    private JButton resetBtn;
    private JButton sDot;
    private JButton setBtn;
    private JTextField swapsInfo;
    private JButton tDot;
    private JButton uDot;
    private JButton vDot;
    private JButton wDot;
    private JButton xDot;
    private JButton zDot;

    public ReflectorPanel(SteppingMechanism sm) {
        this.stepMech = sm;
        this.ukw = this.stepMech.getReflector();
        this.initComponents();
        this.shuffleColors();
        this.plugPoints = new char[2];
        this.pairs = new String[12];
        this.cables = 0;
        this.empty = new boolean[24];
        for (int i = 0; i < 24; ++i) {
            this.empty[i] = true;
        }
        this.setPlugs();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D gPaper = (Graphics2D)g;
        ImageIcon paperImage = new ImageIcon(this.getClass().getResource("/resources/EnigmaPaper.png"));
        Image image = paperImage.getImage();
        if (image != null) {
            gPaper.drawImage(image, 0, 0, 250, 350, this);
        }
    }

    private boolean isEmpty(char letter) {
        int temp = 0;
        boolean temp2 = false;
        for (int i = 0; i < 24; ++i) {
            if (this.dotPosition[i] != letter) continue;
            temp = i;
            break;
        }
        if (this.empty[temp]) {
            temp2 = true;
        }
        return temp2;
    }

    private void setState(char letter, boolean state) {
        int temp = 0;
        for (int i = 0; i < 24; ++i) {
            if (this.dotPosition[i] != letter) continue;
            temp = i;
            break;
        }
        this.empty[temp] = state;
    }

    public void resetPlugs() {
        int i;
        this.ukw.cleanUKWD();
        this.plugPoints[0] = '\u0000';
        this.plugPoints[1] = '\u0000';
        this.cables = 0;
        for (i = 0; i < 12; ++i) {
            if (this.pairs[i] == null) continue;
            this.pairs[i] = null;
        }
        for (i = 0; i < 24; ++i) {
            this.removePlug(this.dotPosition[i]);
        }
        this.refreshInfo();
    }

    private void autoPlugs() {
        this.resetPlugs();
        this.shuffleSwaps();
        for (int i = 0; i < 24; ++i) {
            this.plugCable(this.autoDotPosition[i]);
        }
    }

    private void setPlugs() {
        this.resetPlugs();
        this.shuffleSwaps();
        for (int i = 0; i < 24; ++i) {
            this.plugCable(this.GAF[i]);
        }
    }

    private void refreshInfo() {
        String swapsString = "";
        for (int i = 0; i < 12; ++i) {
            if (this.pairs[i] == null) continue;
            swapsString = swapsString + this.pairs[i] + " ";
        }
        this.swapsInfo.removeAll();
        this.swapsInfo.setText("JY " + swapsString);
    }

    private void addPair(char letter, char letter2) {
        for (int j = 0; this.pairs[j] != null && j < 12; ++j) {
        }
        this.pairs[j] = letter + "" + letter2;
        ++this.cables;
        this.refreshInfo();
    }

    public boolean isFull() {
        boolean tmp = false;
        if (this.cables == 12) {
            tmp = true;
        }
        return tmp;
    }

    private void removePair(char letter, char letter2) {
        for (int i = 0; i < 12; ++i) {
            if (this.pairs[i] == null || (this.pairs[i].charAt(0) != letter || this.pairs[i].charAt(1) != letter2) && (this.pairs[i].charAt(1) != letter || this.pairs[i].charAt(0) != letter2)) continue;
            this.pairs[i] = null;
            --this.cables;
            if (this.cables < 0) {
                this.cables = 0;
            }
            if (this.cables == 0) {
                this.shuffleColors();
            }
            this.refreshInfo();
            break;
        }
    }

    public void plugCable(char letter) {
        if (this.isEmpty(letter)) {
            if (this.plugPoints[0] == '\u0000' && this.plugPoints[1] == '\u0000') {
                this.plugPoints[0] = letter;
                this.addPlug(this.plugPoints[0]);
            } else {
                this.plugPoints[1] = letter;
                this.addPlug(this.plugPoints[1]);
                this.ukw.addCable(this.plugPoints[0], this.plugPoints[1]);
                this.addPair(this.plugPoints[0], this.plugPoints[1]);
                this.plugPoints[0] = '\u0000';
                this.plugPoints[1] = '\u0000';
            }
        } else if (!this.isEmpty(letter)) {
            if (this.plugPoints[0] != '\u0000') {
                this.removePlug(this.plugPoints[0]);
                this.plugPoints[0] = '\u0000';
            } else {
                this.removePlug(letter);
                this.removePlug(this.ukw.getPair(letter));
                this.removePair(letter, this.ukw.getPair(letter));
                this.ukw.removeCable(letter, this.ukw.getPair(letter));
            }
        }
    }

    public String[] getPairs() {
        return this.pairs;
    }

    private void addPlug(char letter) {
        int k;
        this.setState(letter, false);
        for (k = 0; this.pairs[k] != null && k < 12; ++k) {
        }
        int color = this.cableColor[k];
        ImageIcon plugColor = null;
        if (color == 0) {
            plugColor = this.zero;
        } else if (color == 1) {
            plugColor = this.one;
        } else if (color == 2) {
            plugColor = this.two;
        } else if (color == 3) {
            plugColor = this.three;
        } else if (color == 4) {
            plugColor = this.four;
        } else if (color == 5) {
            plugColor = this.five;
        } else if (color == 6) {
            plugColor = this.six;
        } else if (color == 7) {
            plugColor = this.seven;
        } else if (color == 8) {
            plugColor = this.eight;
        } else if (color == 9) {
            plugColor = this.nine;
        } else if (color == 10) {
            plugColor = this.ten;
        } else if (color == 11) {
            plugColor = this.eleven;
        }
        if (letter == 'Q') {
            this.qDot.setIcon(plugColor);
        } else if (letter == 'W') {
            this.wDot.setIcon(plugColor);
        } else if (letter == 'E') {
            this.eDot.setIcon(plugColor);
        } else if (letter == 'R') {
            this.rDot.setIcon(plugColor);
        } else if (letter == 'T') {
            this.tDot.setIcon(plugColor);
        } else if (letter == 'Z') {
            this.zDot.setIcon(plugColor);
        } else if (letter == 'U') {
            this.uDot.setIcon(plugColor);
        } else if (letter == 'I') {
            this.iDot.setIcon(plugColor);
        } else if (letter == 'O') {
            this.oDot.setIcon(plugColor);
        } else if (letter == 'A') {
            this.aDot.setIcon(plugColor);
        } else if (letter == 'S') {
            this.sDot.setIcon(plugColor);
        } else if (letter == 'D') {
            this.dDot.setIcon(plugColor);
        } else if (letter == 'F') {
            this.fDot.setIcon(plugColor);
        } else if (letter == 'G') {
            this.gDot.setIcon(plugColor);
        } else if (letter == 'H') {
            this.hDot.setIcon(plugColor);
        } else if (letter == 'K') {
            this.kDot.setIcon(plugColor);
        } else if (letter == 'P') {
            this.pDot.setIcon(plugColor);
        } else if (letter == 'X') {
            this.xDot.setIcon(plugColor);
        } else if (letter == 'C') {
            this.cDot.setIcon(plugColor);
        } else if (letter == 'V') {
            this.vDot.setIcon(plugColor);
        } else if (letter == 'B') {
            this.bDot.setIcon(plugColor);
        } else if (letter == 'N') {
            this.nDot.setIcon(plugColor);
        } else if (letter == 'M') {
            this.mDot.setIcon(plugColor);
        } else if (letter == 'L') {
            this.lDot.setIcon(plugColor);
        }
    }

    private void removePlug(char letter) {
        this.setState(letter, true);
        if (letter == 'Q') {
            this.qDot.setIcon(null);
        } else if (letter == 'W') {
            this.wDot.setIcon(null);
        } else if (letter == 'E') {
            this.eDot.setIcon(null);
        } else if (letter == 'R') {
            this.rDot.setIcon(null);
        } else if (letter == 'T') {
            this.tDot.setIcon(null);
        } else if (letter == 'Z') {
            this.zDot.setIcon(null);
        } else if (letter == 'U') {
            this.uDot.setIcon(null);
        } else if (letter == 'I') {
            this.iDot.setIcon(null);
        } else if (letter == 'O') {
            this.oDot.setIcon(null);
        } else if (letter == 'A') {
            this.aDot.setIcon(null);
        } else if (letter == 'S') {
            this.sDot.setIcon(null);
        } else if (letter == 'D') {
            this.dDot.setIcon(null);
        } else if (letter == 'F') {
            this.fDot.setIcon(null);
        } else if (letter == 'G') {
            this.gDot.setIcon(null);
        } else if (letter == 'H') {
            this.hDot.setIcon(null);
        } else if (letter == 'K') {
            this.kDot.setIcon(null);
        } else if (letter == 'P') {
            this.pDot.setIcon(null);
        } else if (letter == 'X') {
            this.xDot.setIcon(null);
        } else if (letter == 'C') {
            this.cDot.setIcon(null);
        } else if (letter == 'V') {
            this.vDot.setIcon(null);
        } else if (letter == 'B') {
            this.bDot.setIcon(null);
        } else if (letter == 'N') {
            this.nDot.setIcon(null);
        } else if (letter == 'M') {
            this.mDot.setIcon(null);
        } else if (letter == 'L') {
            this.lDot.setIcon(null);
        }
    }

    private void shuffleColors() {
        Random rgen = new Random();
        for (int i = 0; i < this.cableColor.length; ++i) {
            int randomPosition = rgen.nextInt(this.cableColor.length);
            int temp = this.cableColor[i];
            this.cableColor[i] = this.cableColor[randomPosition];
            this.cableColor[randomPosition] = temp;
        }
    }

    private void shuffleSwaps() {
        Random rgen = new Random();
        for (int i = 0; i < this.autoDotPosition.length; ++i) {
            int randomPosition = rgen.nextInt(this.autoDotPosition.length);
            char temp = this.autoDotPosition[i];
            this.autoDotPosition[i] = this.autoDotPosition[randomPosition];
            this.autoDotPosition[randomPosition] = temp;
        }
    }

    private void initComponents() {
        this.dotsPanel = new JPanel();
        this.zDot = new JButton();
        this.aDot = new JButton();
        this.bDot = new JButton();
        this.cDot = new JButton();
        this.dDot = new JButton();
        this.eDot = new JButton();
        this.fDot = new JButton();
        this.gDot = new JButton();
        this.hDot = new JButton();
        this.iDot = new JButton();
        this.kDot = new JButton();
        this.lDot = new JButton();
        this.xDot = new JButton();
        this.wDot = new JButton();
        this.mDot = new JButton();
        this.nDot = new JButton();
        this.oDot = new JButton();
        this.pDot = new JButton();
        this.qDot = new JButton();
        this.rDot = new JButton();
        this.sDot = new JButton();
        this.tDot = new JButton();
        this.uDot = new JButton();
        this.vDot = new JButton();
        this.boxSeperator = new JLabel();
        this.UKWDLabel = new JLabel();
        this.controlsPanel = new JPanel();
        this.resetBtn = new JButton();
        this.swapsInfo = new JTextField();
        this.setBtn = new JButton();
        this.autoBtn = new JButton();
        this.jSeparator1 = new JSeparator();
        this.setMaximumSize(new Dimension(250, 335));
        this.setMinimumSize(new Dimension(250, 335));
        this.setPreferredSize(new Dimension(250, 335));
        this.dotsPanel.setBackground(new Color(153, 153, 255));
        this.dotsPanel.setMaximumSize(new Dimension(250, 250));
        this.dotsPanel.setMinimumSize(new Dimension(250, 250));
        this.dotsPanel.setOpaque(false);
        this.dotsPanel.setPreferredSize(new Dimension(250, 250));
        this.zDot.setContentAreaFilled(false);
        this.zDot.setCursor(new Cursor(12));
        this.zDot.setMaximumSize(new Dimension(14, 14));
        this.zDot.setMinimumSize(new Dimension(14, 14));
        this.zDot.setPreferredSize(new Dimension(14, 14));
        this.zDot.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReflectorPanel.this.zDotActionPerformed(evt);
            }
        });
        this.aDot.setContentAreaFilled(false);
        this.aDot.setCursor(new Cursor(12));
        this.aDot.setMaximumSize(new Dimension(14, 14));
        this.aDot.setMinimumSize(new Dimension(14, 14));
        this.aDot.setPreferredSize(new Dimension(14, 14));
        this.aDot.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReflectorPanel.this.aDotActionPerformed(evt);
            }
        });
        this.bDot.setContentAreaFilled(false);
        this.bDot.setCursor(new Cursor(12));
        this.bDot.setMaximumSize(new Dimension(14, 14));
        this.bDot.setMinimumSize(new Dimension(14, 14));
        this.bDot.setPreferredSize(new Dimension(14, 14));
        this.bDot.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReflectorPanel.this.bDotActionPerformed(evt);
            }
        });
        this.cDot.setContentAreaFilled(false);
        this.cDot.setCursor(new Cursor(12));
        this.cDot.setMaximumSize(new Dimension(14, 14));
        this.cDot.setMinimumSize(new Dimension(14, 14));
        this.cDot.setPreferredSize(new Dimension(14, 14));
        this.cDot.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReflectorPanel.this.cDotActionPerformed(evt);
            }
        });
        this.dDot.setContentAreaFilled(false);
        this.dDot.setCursor(new Cursor(12));
        this.dDot.setMaximumSize(new Dimension(14, 14));
        this.dDot.setMinimumSize(new Dimension(14, 14));
        this.dDot.setPreferredSize(new Dimension(14, 14));
        this.dDot.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReflectorPanel.this.dDotActionPerformed(evt);
            }
        });
        this.eDot.setContentAreaFilled(false);
        this.eDot.setCursor(new Cursor(12));
        this.eDot.setMaximumSize(new Dimension(14, 14));
        this.eDot.setMinimumSize(new Dimension(14, 14));
        this.eDot.setPreferredSize(new Dimension(14, 14));
        this.eDot.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReflectorPanel.this.eDotActionPerformed(evt);
            }
        });
        this.fDot.setContentAreaFilled(false);
        this.fDot.setCursor(new Cursor(12));
        this.fDot.setMaximumSize(new Dimension(14, 14));
        this.fDot.setMinimumSize(new Dimension(14, 14));
        this.fDot.setPreferredSize(new Dimension(14, 14));
        this.fDot.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReflectorPanel.this.fDotActionPerformed(evt);
            }
        });
        this.gDot.setContentAreaFilled(false);
        this.gDot.setCursor(new Cursor(12));
        this.gDot.setMaximumSize(new Dimension(14, 14));
        this.gDot.setMinimumSize(new Dimension(14, 14));
        this.gDot.setPreferredSize(new Dimension(14, 14));
        this.gDot.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReflectorPanel.this.gDotActionPerformed(evt);
            }
        });
        this.hDot.setContentAreaFilled(false);
        this.hDot.setCursor(new Cursor(12));
        this.hDot.setMaximumSize(new Dimension(14, 14));
        this.hDot.setMinimumSize(new Dimension(14, 14));
        this.hDot.setPreferredSize(new Dimension(14, 14));
        this.hDot.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReflectorPanel.this.hDotActionPerformed(evt);
            }
        });
        this.iDot.setContentAreaFilled(false);
        this.iDot.setCursor(new Cursor(12));
        this.iDot.setMaximumSize(new Dimension(14, 14));
        this.iDot.setMinimumSize(new Dimension(14, 14));
        this.iDot.setPreferredSize(new Dimension(14, 14));
        this.iDot.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReflectorPanel.this.iDotActionPerformed(evt);
            }
        });
        this.kDot.setContentAreaFilled(false);
        this.kDot.setCursor(new Cursor(12));
        this.kDot.setMaximumSize(new Dimension(14, 14));
        this.kDot.setMinimumSize(new Dimension(14, 14));
        this.kDot.setPreferredSize(new Dimension(14, 14));
        this.kDot.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReflectorPanel.this.kDotActionPerformed(evt);
            }
        });
        this.lDot.setContentAreaFilled(false);
        this.lDot.setCursor(new Cursor(12));
        this.lDot.setMaximumSize(new Dimension(14, 14));
        this.lDot.setMinimumSize(new Dimension(14, 14));
        this.lDot.setPreferredSize(new Dimension(14, 14));
        this.lDot.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReflectorPanel.this.lDotActionPerformed(evt);
            }
        });
        this.xDot.setContentAreaFilled(false);
        this.xDot.setCursor(new Cursor(12));
        this.xDot.setMaximumSize(new Dimension(14, 14));
        this.xDot.setMinimumSize(new Dimension(14, 14));
        this.xDot.setPreferredSize(new Dimension(14, 14));
        this.xDot.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReflectorPanel.this.xDotActionPerformed(evt);
            }
        });
        this.wDot.setContentAreaFilled(false);
        this.wDot.setCursor(new Cursor(12));
        this.wDot.setMaximumSize(new Dimension(14, 14));
        this.wDot.setMinimumSize(new Dimension(14, 14));
        this.wDot.setPreferredSize(new Dimension(14, 14));
        this.wDot.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReflectorPanel.this.wDotActionPerformed(evt);
            }
        });
        this.mDot.setContentAreaFilled(false);
        this.mDot.setCursor(new Cursor(12));
        this.mDot.setMaximumSize(new Dimension(14, 14));
        this.mDot.setMinimumSize(new Dimension(14, 14));
        this.mDot.setPreferredSize(new Dimension(14, 14));
        this.mDot.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReflectorPanel.this.mDotActionPerformed(evt);
            }
        });
        this.nDot.setContentAreaFilled(false);
        this.nDot.setCursor(new Cursor(12));
        this.nDot.setMaximumSize(new Dimension(14, 14));
        this.nDot.setMinimumSize(new Dimension(14, 14));
        this.nDot.setPreferredSize(new Dimension(14, 14));
        this.nDot.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReflectorPanel.this.nDotActionPerformed(evt);
            }
        });
        this.oDot.setContentAreaFilled(false);
        this.oDot.setCursor(new Cursor(12));
        this.oDot.setMaximumSize(new Dimension(14, 14));
        this.oDot.setMinimumSize(new Dimension(14, 14));
        this.oDot.setPreferredSize(new Dimension(14, 14));
        this.oDot.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReflectorPanel.this.oDotActionPerformed(evt);
            }
        });
        this.pDot.setContentAreaFilled(false);
        this.pDot.setCursor(new Cursor(12));
        this.pDot.setMaximumSize(new Dimension(14, 14));
        this.pDot.setMinimumSize(new Dimension(14, 14));
        this.pDot.setPreferredSize(new Dimension(14, 14));
        this.pDot.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReflectorPanel.this.pDotActionPerformed(evt);
            }
        });
        this.qDot.setContentAreaFilled(false);
        this.qDot.setCursor(new Cursor(12));
        this.qDot.setMaximumSize(new Dimension(14, 14));
        this.qDot.setMinimumSize(new Dimension(14, 14));
        this.qDot.setPreferredSize(new Dimension(14, 14));
        this.qDot.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReflectorPanel.this.qDotActionPerformed(evt);
            }
        });
        this.rDot.setContentAreaFilled(false);
        this.rDot.setCursor(new Cursor(12));
        this.rDot.setMaximumSize(new Dimension(14, 14));
        this.rDot.setMinimumSize(new Dimension(14, 14));
        this.rDot.setPreferredSize(new Dimension(14, 14));
        this.rDot.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReflectorPanel.this.rDotActionPerformed(evt);
            }
        });
        this.sDot.setContentAreaFilled(false);
        this.sDot.setCursor(new Cursor(12));
        this.sDot.setMaximumSize(new Dimension(14, 14));
        this.sDot.setMinimumSize(new Dimension(14, 14));
        this.sDot.setPreferredSize(new Dimension(14, 14));
        this.sDot.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReflectorPanel.this.sDotActionPerformed(evt);
            }
        });
        this.tDot.setContentAreaFilled(false);
        this.tDot.setCursor(new Cursor(12));
        this.tDot.setMaximumSize(new Dimension(14, 14));
        this.tDot.setMinimumSize(new Dimension(14, 14));
        this.tDot.setPreferredSize(new Dimension(14, 14));
        this.tDot.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReflectorPanel.this.tDotActionPerformed(evt);
            }
        });
        this.uDot.setContentAreaFilled(false);
        this.uDot.setCursor(new Cursor(12));
        this.uDot.setMaximumSize(new Dimension(14, 14));
        this.uDot.setMinimumSize(new Dimension(14, 14));
        this.uDot.setPreferredSize(new Dimension(14, 14));
        this.uDot.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReflectorPanel.this.uDotActionPerformed(evt);
            }
        });
        this.vDot.setContentAreaFilled(false);
        this.vDot.setCursor(new Cursor(12));
        this.vDot.setMaximumSize(new Dimension(14, 14));
        this.vDot.setMinimumSize(new Dimension(14, 14));
        this.vDot.setPreferredSize(new Dimension(14, 14));
        this.vDot.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReflectorPanel.this.vDotActionPerformed(evt);
            }
        });
        GroupLayout dotsPanelLayout = new GroupLayout(this.dotsPanel);
        this.dotsPanel.setLayout(dotsPanelLayout);
        dotsPanelLayout.setHorizontalGroup(dotsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(dotsPanelLayout.createSequentialGroup().addGroup(dotsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(dotsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, dotsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.vDot, -2, -1, -2)).addGroup(dotsPanelLayout.createSequentialGroup().addGroup(dotsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(dotsPanelLayout.createSequentialGroup().addGap(40, 40, 40).addGroup(dotsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tDot, -2, -1, -2).addComponent(this.sDot, -2, -1, -2))).addGroup(dotsPanelLayout.createSequentialGroup().addGap(45, 45, 45).addComponent(this.uDot, -2, -1, -2))).addGap(9, 9, 9))).addGroup(dotsPanelLayout.createSequentialGroup().addGap(53, 53, 53).addComponent(this.qDot, -2, -1, -2)).addGroup(dotsPanelLayout.createSequentialGroup().addGap(66, 66, 66).addGroup(dotsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(dotsPanelLayout.createSequentialGroup().addComponent(this.wDot, -2, -1, -2).addGap(3, 3, 3).addComponent(this.xDot, -2, -1, -2).addGap(4, 4, 4).addComponent(this.zDot, -2, 14, -2).addGap(23, 23, 23).addComponent(this.aDot, -2, 14, -2).addGap(4, 4, 4).addComponent(this.bDot, -2, 14, -2)).addGroup(dotsPanelLayout.createSequentialGroup().addComponent(this.pDot, -2, -1, -2).addGap(2, 2, 2).addComponent(this.oDot, -2, -1, -2).addGap(3, 3, 3).addComponent(this.nDot, -2, -1, -2).addGap(23, 23, 23).addComponent(this.mDot, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lDot, -2, 14, -2))).addGap(1, 1, 1).addGroup(dotsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cDot, -2, 14, -2).addGroup(dotsPanelLayout.createSequentialGroup().addGap(12, 12, 12).addGroup(dotsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.dDot, -2, 14, -2).addGroup(dotsPanelLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.eDot, -2, 14, -2)).addGroup(dotsPanelLayout.createSequentialGroup().addGap(14, 14, 14).addGroup(dotsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.gDot, -2, 14, -2).addComponent(this.fDot, -2, 14, -2))).addComponent(this.iDot, -2, 14, -2))).addComponent(this.kDot, -2, 14, -2)))).addContainerGap(39, Short.MAX_VALUE)).addGroup(dotsPanelLayout.createSequentialGroup().addGap(45, 45, 45).addComponent(this.rDot, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.hDot, -2, 14, -2).addGap(45, 45, 45)));
        dotsPanelLayout.setVerticalGroup(dotsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(dotsPanelLayout.createSequentialGroup().addGroup(dotsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(dotsPanelLayout.createSequentialGroup().addGap(60, 60, 60).addComponent(this.cDot, -2, 14, -2)).addGroup(dotsPanelLayout.createSequentialGroup().addGap(49, 49, 49).addGroup(dotsPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.xDot, -2, -1, -2).addComponent(this.bDot, -2, 14, -2))).addGroup(GroupLayout.Alignment.TRAILING, dotsPanelLayout.createSequentialGroup().addGap(13, 13, 13).addComponent(this.wDot, -2, -1, -2).addGap(1, 1, 1)).addGroup(dotsPanelLayout.createSequentialGroup().addGap(43, 43, 43).addGroup(dotsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.zDot, -2, 14, -2).addComponent(this.aDot, -2, 14, -2)))).addGroup(dotsPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.vDot, -2, -1, -2).addComponent(this.dDot, -2, 14, -2)).addGap(2, 2, 2).addGroup(dotsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.eDot, -2, -1, -2).addComponent(this.uDot, -2, -1, -2)).addGap(5, 5, 5).addGroup(dotsPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.fDot, -2, -1, -2).addComponent(this.tDot, -2, -1, -2)).addGap(4, 4, 4).addGroup(dotsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(dotsPanelLayout.createSequentialGroup().addComponent(this.gDot, -2, -1, -2).addGap(5, 5, 5).addGroup(dotsPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.hDot, GroupLayout.Alignment.LEADING, -2, -1, -2).addComponent(this.rDot, -2, 14, -2)).addGap(2, 2, 2).addGroup(dotsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.qDot, -1, -1, Short.MAX_VALUE).addComponent(this.iDot, -2, 16, -2)).addGap(0, 0, 0).addGroup(dotsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(dotsPanelLayout.createSequentialGroup().addComponent(this.pDot, -2, -1, -2).addGap(65, 65, 65)).addGroup(GroupLayout.Alignment.TRAILING, dotsPanelLayout.createSequentialGroup().addComponent(this.kDot, -2, -1, -2).addGap(66, 66, 66)).addGroup(GroupLayout.Alignment.TRAILING, dotsPanelLayout.createSequentialGroup().addGroup(dotsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lDot, -2, -1, -2).addComponent(this.oDot, -2, -1, -2)).addGap(56, 56, 56)).addGroup(GroupLayout.Alignment.TRAILING, dotsPanelLayout.createSequentialGroup().addGroup(dotsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.mDot, -2, -1, -2).addComponent(this.nDot, -2, -1, -2)).addGap(50, 50, 50)))).addComponent(this.sDot, -2, -1, -2))));
        this.boxSeperator.setHorizontalAlignment(0);
        this.boxSeperator.setIcon(new ImageIcon(this.getClass().getResource("/resources/box/BoxBottomPlain.png")));
        this.boxSeperator.setFocusable(false);
        this.UKWDLabel.setHorizontalAlignment(0);
        this.UKWDLabel.setIcon(new ImageIcon(this.getClass().getResource("/resources/panels/Reflector.png")));
        this.UKWDLabel.setFocusable(false);
        this.UKWDLabel.setName("");
        this.controlsPanel.setOpaque(false);
        this.resetBtn.setIcon(new ImageIcon(this.getClass().getResource("/resources/buttons/ClearNew.png")));
        this.resetBtn.setContentAreaFilled(false);
        this.resetBtn.setCursor(new Cursor(12));
        this.resetBtn.setFocusable(false);
        this.resetBtn.setMaximumSize(new Dimension(67, 26));
        this.resetBtn.setMinimumSize(new Dimension(67, 26));
        this.resetBtn.setPreferredSize(new Dimension(67, 26));
        this.resetBtn.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/buttons/ClearNewPress.png")));
        this.resetBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReflectorPanel.this.resetBtnActionPerformed(evt);
            }
        });
        this.swapsInfo.setEditable(false);
        this.swapsInfo.setFont(new Font("Tahoma", 0, 10));
        this.swapsInfo.setHorizontalAlignment(0);
        this.swapsInfo.setText("JY ");
        this.swapsInfo.setToolTipText("Reflected Characters");
        this.swapsInfo.setFocusable(false);
        this.setBtn.setIcon(new ImageIcon(this.getClass().getResource("/resources/buttons/ResetNew.png")));
        this.setBtn.setContentAreaFilled(false);
        this.setBtn.setCursor(new Cursor(12));
        this.setBtn.setFocusable(false);
        this.setBtn.setMaximumSize(new Dimension(67, 26));
        this.setBtn.setMinimumSize(new Dimension(67, 26));
        this.setBtn.setPreferredSize(new Dimension(67, 26));
        this.setBtn.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/buttons/ResetNewPress.png")));
        this.setBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReflectorPanel.this.setBtnActionPerformed(evt);
            }
        });
        this.autoBtn.setIcon(new ImageIcon(this.getClass().getResource("/resources/buttons/AutoNew.png")));
        this.autoBtn.setContentAreaFilled(false);
        this.autoBtn.setCursor(new Cursor(12));
        this.autoBtn.setFocusable(false);
        this.autoBtn.setMaximumSize(new Dimension(67, 26));
        this.autoBtn.setMinimumSize(new Dimension(67, 26));
        this.autoBtn.setPreferredSize(new Dimension(67, 26));
        this.autoBtn.setPressedIcon(new ImageIcon(this.getClass().getResource("/resources/buttons/AutoNewPress.png")));
        this.autoBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReflectorPanel.this.autoBtnActionPerformed(evt);
            }
        });
        GroupLayout controlsPanelLayout = new GroupLayout(this.controlsPanel);
        this.controlsPanel.setLayout(controlsPanelLayout);
        controlsPanelLayout.setHorizontalGroup(controlsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, controlsPanelLayout.createSequentialGroup().addContainerGap().addGroup(controlsPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jSeparator1).addGroup(GroupLayout.Alignment.LEADING, controlsPanelLayout.createSequentialGroup().addComponent(this.resetBtn, -2, 75, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.setBtn, -2, 75, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.autoBtn, -2, 75, -2)).addComponent(this.swapsInfo, GroupLayout.Alignment.LEADING)).addContainerGap()));
        controlsPanelLayout.setVerticalGroup(controlsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, controlsPanelLayout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.swapsInfo, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, 2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(controlsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.resetBtn, GroupLayout.Alignment.TRAILING, -2, 30, -2).addComponent(this.setBtn, GroupLayout.Alignment.TRAILING, -2, 30, -2).addComponent(this.autoBtn, GroupLayout.Alignment.TRAILING, -2, 30, -2)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.boxSeperator, -2, 0, Short.MAX_VALUE).addComponent(this.dotsPanel, -2, -1, -2).addComponent(this.UKWDLabel).addComponent(this.controlsPanel, -2, -1, -2));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.dotsPanel, -2, -1, -2).addComponent(this.UKWDLabel)).addComponent(this.boxSeperator).addGap(0, 0, 0).addComponent(this.controlsPanel, -2, -1, -2)));
    }

    private void resetBtnActionPerformed(ActionEvent evt) {
        this.resetPlugs();
    }

    private void setBtnActionPerformed(ActionEvent evt) {
        this.setPlugs();
    }

    private void autoBtnActionPerformed(ActionEvent evt) {
        this.autoPlugs();
    }

    private void aDotActionPerformed(ActionEvent evt) {
        this.plugCable('A');
    }

    private void bDotActionPerformed(ActionEvent evt) {
        this.plugCable('B');
    }

    private void cDotActionPerformed(ActionEvent evt) {
        this.plugCable('C');
    }

    private void dDotActionPerformed(ActionEvent evt) {
        this.plugCable('D');
    }

    private void eDotActionPerformed(ActionEvent evt) {
        this.plugCable('E');
    }

    private void fDotActionPerformed(ActionEvent evt) {
        this.plugCable('F');
    }

    private void gDotActionPerformed(ActionEvent evt) {
        this.plugCable('G');
    }

    private void hDotActionPerformed(ActionEvent evt) {
        this.plugCable('H');
    }

    private void iDotActionPerformed(ActionEvent evt) {
        this.plugCable('I');
    }

    private void kDotActionPerformed(ActionEvent evt) {
        this.plugCable('K');
    }

    private void lDotActionPerformed(ActionEvent evt) {
        this.plugCable('L');
    }

    private void mDotActionPerformed(ActionEvent evt) {
        this.plugCable('M');
    }

    private void nDotActionPerformed(ActionEvent evt) {
        this.plugCable('N');
    }

    private void oDotActionPerformed(ActionEvent evt) {
        this.plugCable('O');
    }

    private void pDotActionPerformed(ActionEvent evt) {
        this.plugCable('P');
    }

    private void qDotActionPerformed(ActionEvent evt) {
        this.plugCable('Q');
    }

    private void rDotActionPerformed(ActionEvent evt) {
        this.plugCable('R');
    }

    private void sDotActionPerformed(ActionEvent evt) {
        this.plugCable('S');
    }

    private void tDotActionPerformed(ActionEvent evt) {
        this.plugCable('T');
    }

    private void uDotActionPerformed(ActionEvent evt) {
        this.plugCable('U');
    }

    private void vDotActionPerformed(ActionEvent evt) {
        this.plugCable('V');
    }

    private void wDotActionPerformed(ActionEvent evt) {
        this.plugCable('W');
    }

    private void xDotActionPerformed(ActionEvent evt) {
        this.plugCable('X');
    }

    private void zDotActionPerformed(ActionEvent evt) {
        this.plugCable('Z');
    }
}

