/*
 * Decompiled with CFR 0.152.
 */
package machines.panels;

import enigma.SteppingMechanism;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;

public class RotorPanel
extends JPanel {
    private SteppingMechanism smAccess;
    private boolean silverSwitch = false;
    private int switchState = 0;
    private int erState = 1;
    private int emState = 1;
    private int elState = 1;
    private int eflState = 1;
    private String rightFace = "";
    private String middleFace = "";
    private String leftFace = "";
    private String farLeftFace = "";
    private int lockState = 1;
    private int[] count = new int[]{0, 0, 0, 0};
    private String variant;
    private String[] contacts = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};
    private String[] translator = new String[]{"01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26"};
    private JLabel counterLabel;
    private JLabel counterLabel2;
    private JButton downFarLeft;
    private JButton downLeft;
    private JButton downMiddle;
    private JButton downRight;
    private JLabel faceFarLeft;
    private JLabel faceLeft;
    private JLabel faceMiddle;
    private JLabel faceRight;
    private JLabel farLeftRotor;
    private JPanel indexPanel;
    private JLabel leftRotor;
    private JButton leverG3;
    private JButton leverGA;
    private JButton lowerSwitch;
    private JLabel middleRotor;
    private JLabel rightRotor;
    private JPanel rotorEffectPanel;
    private JButton switchG3;
    private JButton upFarLeft;
    private JButton upLeft;
    private JButton upMiddle;
    private JButton upRight;

    public RotorPanel(SteppingMechanism sm) {
        this.smAccess = sm;
        this.variant = this.smAccess.getType();
        this.initComponents();
        this.setActions();
    }

    @Override
    public void paintComponent(Graphics g) {
        ImageIcon rotorImage;
        super.paintComponent(g);
        Graphics2D gRotor = (Graphics2D)g;
        switch (this.variant) {
            case "D": {
                rotorImage = new ImageIcon(this.getClass().getResource("/resources/panels/DRotor.png"));
                break;
            }
            case "KS": 
            case "KR": {
                rotorImage = new ImageIcon(this.getClass().getResource("/resources/panels/KRotor.png"));
                break;
            }
            case "KD": {
                rotorImage = new ImageIcon(this.getClass().getResource("/resources/panels/KDRotor.png"));
                break;
            }
            case "KT": {
                rotorImage = new ImageIcon(this.getClass().getResource("/resources/panels/KTRotor.png"));
                break;
            }
            case "GA": {
                rotorImage = new ImageIcon(this.getClass().getResource("/resources/panels/GARotor.png"));
                break;
            }
            case "G1": 
            case "G2": 
            case "G3": {
                rotorImage = new ImageIcon(this.getClass().getResource("/resources/panels/GRotor.png"));
                break;
            }
            case "IS": 
            case "IN": {
                rotorImage = new ImageIcon(this.getClass().getResource("/resources/panels/IRotor.png"));
                break;
            }
            case "IM3": {
                rotorImage = new ImageIcon(this.getClass().getResource("/resources/panels/IM3Rotor.png"));
                break;
            }
            case "IM4": {
                rotorImage = new ImageIcon(this.getClass().getResource("/resources/panels/IM4Rotor.png"));
                break;
            }
            case "IM4D": {
                rotorImage = new ImageIcon(this.getClass().getResource("/resources/panels/IM4DRotor.png"));
                break;
            }
            default: {
                rotorImage = new ImageIcon(this.getClass().getResource("/resources/panels/IRotor.png"));
            }
        }
        Image image = rotorImage.getImage();
        if (image != null) {
            gRotor.drawImage(image, 0, 0, 360, 181, this);
        }
    }

    private void setActions() {
        switch (this.variant) {
            case "KT": {
                this.counterLabel.setVisible(false);
                this.counterLabel2.setVisible(false);
                this.switchG3.setEnabled(false);
                this.switchG3.setVisible(false);
                this.leverGA.setEnabled(false);
                this.leverGA.setVisible(false);
                this.leverG3.setEnabled(false);
                this.leverG3.setVisible(false);
                this.farLeftRotor.setIcon(new ImageIcon(this.getClass().getResource("/resources/panels/buttons/REOneBlack.png")));
                break;
            }
            case "D": 
            case "KR": 
            case "KS": {
                this.counterLabel.setVisible(false);
                this.counterLabel2.setVisible(false);
                this.switchG3.setEnabled(false);
                this.switchG3.setVisible(false);
                this.leverGA.setEnabled(false);
                this.leverGA.setVisible(false);
                this.leverG3.setEnabled(false);
                this.leverG3.setVisible(false);
                break;
            }
            case "IM4": {
                this.counterLabel.setVisible(false);
                this.counterLabel2.setVisible(false);
                this.switchG3.setEnabled(false);
                this.switchG3.setVisible(false);
                this.lowerSwitch.setEnabled(false);
                this.lowerSwitch.setVisible(false);
                this.leverGA.setEnabled(false);
                this.leverGA.setVisible(false);
                this.leverG3.setEnabled(false);
                this.leverG3.setVisible(false);
                this.farLeftRotor.setIcon(new ImageIcon(this.getClass().getResource("/resources/panels/buttons/REOneBlack.png")));
                break;
            }
            case "IS": 
            case "IN": {
                this.counterLabel.setVisible(false);
                this.counterLabel2.setVisible(false);
                this.upFarLeft.setEnabled(false);
                this.downFarLeft.setEnabled(false);
                this.faceFarLeft.setText(" ");
                this.faceLeft.setText("01");
                this.faceMiddle.setText("01");
                this.faceRight.setText("01");
                this.switchG3.setEnabled(false);
                this.switchG3.setVisible(false);
                this.leverGA.setEnabled(false);
                this.leverGA.setVisible(false);
                this.leverG3.setEnabled(false);
                this.leverG3.setVisible(false);
                this.leftRotor.setVisible(false);
                this.middleRotor.setVisible(false);
                this.rightRotor.setVisible(false);
                this.farLeftRotor.setVisible(false);
                break;
            }
            case "IM4D": {
                this.counterLabel.setVisible(false);
                this.counterLabel2.setVisible(false);
                this.upFarLeft.setEnabled(false);
                this.faceFarLeft.setText("D");
                this.faceFarLeft.setForeground(Color.red);
                this.downFarLeft.setEnabled(false);
                this.switchG3.setEnabled(false);
                this.switchG3.setVisible(false);
                this.lowerSwitch.setEnabled(false);
                this.lowerSwitch.setVisible(false);
                this.leverGA.setEnabled(false);
                this.leverGA.setVisible(false);
                this.leverG3.setEnabled(false);
                this.leverG3.setVisible(false);
                this.farLeftRotor.setVisible(false);
                break;
            }
            case "KD": {
                this.counterLabel.setVisible(false);
                this.counterLabel2.setVisible(false);
                this.upFarLeft.setEnabled(false);
                this.faceFarLeft.setText("D");
                this.faceFarLeft.setForeground(Color.red);
                this.downFarLeft.setEnabled(false);
                this.switchG3.setEnabled(false);
                this.switchG3.setVisible(false);
                this.leverGA.setEnabled(false);
                this.leverGA.setVisible(false);
                this.leverG3.setEnabled(false);
                this.leverG3.setVisible(false);
                this.farLeftRotor.setVisible(false);
                break;
            }
            case "IM3": {
                this.counterLabel.setVisible(false);
                this.counterLabel2.setVisible(false);
                this.upFarLeft.setEnabled(false);
                this.faceFarLeft.setText(" ");
                this.downFarLeft.setEnabled(false);
                this.switchG3.setEnabled(false);
                this.switchG3.setVisible(false);
                this.lowerSwitch.setEnabled(false);
                this.lowerSwitch.setVisible(false);
                this.leverGA.setEnabled(false);
                this.leverGA.setVisible(false);
                this.leverG3.setEnabled(false);
                this.leverG3.setVisible(false);
                this.farLeftRotor.setVisible(false);
                break;
            }
            case "GA": {
                this.counterLabel2.setVisible(false);
                this.switchG3.setEnabled(false);
                this.switchG3.setVisible(false);
                this.leverG3.setEnabled(false);
                this.leverG3.setVisible(false);
                this.silverSwitch = true;
                this.lowerSwitch.setIcon(new ImageIcon(this.getClass().getResource("/resources/panels/buttons/OnSwitchSilver.png")));
                break;
            }
            case "G1": 
            case "G2": 
            case "G3": {
                this.counterLabel.setVisible(false);
                this.lowerSwitch.setEnabled(false);
                this.lowerSwitch.setVisible(false);
                this.leverGA.setEnabled(false);
                this.leverGA.setVisible(false);
            }
        }
    }

    private String translate(String contact) {
        for (int i = 0; i < 26; ++i) {
            if (!contact.equals(this.contacts[i])) continue;
            return this.translator[i];
        }
        return null;
    }

    public void updateWindow() {
        switch (this.variant) {
            case "D": 
            case "KT": 
            case "KR": 
            case "KS": 
            case "IM4": 
            case "GA": 
            case "G1": 
            case "G2": 
            case "G3": {
                if (!this.rightFace.equals(this.smAccess.getFace("RIGHT"))) {
                    this.rotateEffect("RIGHT");
                    this.rightFace = this.smAccess.getFace("RIGHT");
                }
                this.faceRight.setText(this.smAccess.getFace("RIGHT"));
                this.faceRight.setToolTipText("<html><strong style=\"font-size: 100%\"><center>" + this.smAccess.getRotorType("RIGHT") + "</strong></center></html>");
                if (!this.middleFace.equals(this.smAccess.getFace("MIDDLE"))) {
                    this.rotateEffect("MIDDLE");
                    this.middleFace = this.smAccess.getFace("MIDDLE");
                }
                this.faceMiddle.setText(this.smAccess.getFace("MIDDLE"));
                this.faceMiddle.setToolTipText(this.smAccess.getRotorType("MIDDLE"));
                if (!this.leftFace.equals(this.smAccess.getFace("LEFT"))) {
                    this.rotateEffect("LEFT");
                    this.leftFace = this.smAccess.getFace("LEFT");
                }
                this.faceLeft.setText(this.smAccess.getFace("LEFT"));
                this.faceLeft.setToolTipText(this.smAccess.getRotorType("LEFT"));
                if (!this.farLeftFace.equals(this.smAccess.getFace("FARLEFT"))) {
                    this.rotateEffect("FARLEFT");
                    this.farLeftFace = this.smAccess.getFace("FARLEFT");
                }
                this.faceFarLeft.setText(this.smAccess.getFace("FARLEFT"));
                this.faceFarLeft.setToolTipText(this.smAccess.getRotorType("FARLEFT"));
                break;
            }
            case "IS": 
            case "IN": {
                this.faceRight.setText(this.translate(this.smAccess.getFace("RIGHT")));
                this.faceRight.setToolTipText(this.smAccess.getRotorType("RIGHT"));
                this.faceMiddle.setText(this.translate(this.smAccess.getFace("MIDDLE")));
                this.faceMiddle.setToolTipText(this.smAccess.getRotorType("MIDDLE"));
                this.faceLeft.setText(this.translate(this.smAccess.getFace("LEFT")));
                this.faceLeft.setToolTipText(this.smAccess.getRotorType("LEFT"));
                break;
            }
            case "IM3": 
            case "KD": 
            case "IM4D": {
                if (!this.rightFace.equals(this.smAccess.getFace("RIGHT"))) {
                    this.rotateEffect("RIGHT");
                    this.rightFace = this.smAccess.getFace("RIGHT");
                }
                this.faceRight.setText(this.smAccess.getFace("RIGHT"));
                this.faceRight.setToolTipText(this.smAccess.getRotorType("RIGHT"));
                if (!this.middleFace.equals(this.smAccess.getFace("MIDDLE"))) {
                    this.rotateEffect("MIDDLE");
                    this.middleFace = this.smAccess.getFace("MIDDLE");
                }
                this.faceMiddle.setText(this.smAccess.getFace("MIDDLE"));
                this.faceMiddle.setToolTipText(this.smAccess.getRotorType("MIDDLE"));
                if (!this.leftFace.equals(this.smAccess.getFace("LEFT"))) {
                    this.rotateEffect("LEFT");
                    this.leftFace = this.smAccess.getFace("LEFT");
                }
                this.faceLeft.setText(this.smAccess.getFace("LEFT"));
                this.faceLeft.setToolTipText(this.smAccess.getRotorType("LEFT"));
            }
        }
    }

    public void rotateEffect(String position) {
        switch (position) {
            case "RIGHT": {
                ++this.erState;
                if (this.erState > 3) {
                    this.erState = 0;
                }
                if (this.erState == 0) {
                    this.rightRotor.setIcon(new ImageIcon(this.getClass().getResource("/resources/panels/buttons/RENormal.png")));
                    break;
                }
                if (this.erState == 1) {
                    this.rightRotor.setIcon(new ImageIcon(this.getClass().getResource("/resources/panels/buttons/REOne.png")));
                    break;
                }
                if (this.erState == 2) {
                    this.rightRotor.setIcon(new ImageIcon(this.getClass().getResource("/resources/panels/buttons/RETwo.png")));
                    break;
                }
                if (this.erState != 3) break;
                this.rightRotor.setIcon(new ImageIcon(this.getClass().getResource("/resources/panels/buttons/REThree.png")));
                break;
            }
            case "MIDDLE": {
                ++this.emState;
                if (this.emState > 3) {
                    this.emState = 0;
                }
                if (this.emState == 0) {
                    this.middleRotor.setIcon(new ImageIcon(this.getClass().getResource("/resources/panels/buttons/RENormal.png")));
                    break;
                }
                if (this.emState == 1) {
                    this.middleRotor.setIcon(new ImageIcon(this.getClass().getResource("/resources/panels/buttons/REOne.png")));
                    break;
                }
                if (this.emState == 2) {
                    this.middleRotor.setIcon(new ImageIcon(this.getClass().getResource("/resources/panels/buttons/RETwo.png")));
                    break;
                }
                if (this.emState != 3) break;
                this.middleRotor.setIcon(new ImageIcon(this.getClass().getResource("/resources/panels/buttons/REThree.png")));
                break;
            }
            case "LEFT": {
                ++this.elState;
                if (this.elState > 3) {
                    this.elState = 0;
                }
                if (this.elState == 0) {
                    this.leftRotor.setIcon(new ImageIcon(this.getClass().getResource("/resources/panels/buttons/RENormal.png")));
                    break;
                }
                if (this.elState == 1) {
                    this.leftRotor.setIcon(new ImageIcon(this.getClass().getResource("/resources/panels/buttons/REOne.png")));
                    break;
                }
                if (this.elState == 2) {
                    this.leftRotor.setIcon(new ImageIcon(this.getClass().getResource("/resources/panels/buttons/RETwo.png")));
                    break;
                }
                if (this.elState != 3) break;
                this.leftRotor.setIcon(new ImageIcon(this.getClass().getResource("/resources/panels/buttons/REThree.png")));
                break;
            }
            case "FARLEFT": {
                ++this.eflState;
                if (this.eflState > 3) {
                    this.eflState = 0;
                }
                if (this.variant.equals("IM4") || this.variant.equals("KT")) {
                    if (this.eflState == 0) {
                        this.farLeftRotor.setIcon(new ImageIcon(this.getClass().getResource("/resources/panels/buttons/RENormalBlack.png")));
                        break;
                    }
                    if (this.eflState == 1) {
                        this.farLeftRotor.setIcon(new ImageIcon(this.getClass().getResource("/resources/panels/buttons/REOneBlack.png")));
                        break;
                    }
                    if (this.eflState == 2) {
                        this.farLeftRotor.setIcon(new ImageIcon(this.getClass().getResource("/resources/panels/buttons/RETwoBlack.png")));
                        break;
                    }
                    if (this.eflState != 3) break;
                    this.farLeftRotor.setIcon(new ImageIcon(this.getClass().getResource("/resources/panels/buttons/REThreeBlack.png")));
                    break;
                }
                if (this.eflState == 0) {
                    this.farLeftRotor.setIcon(new ImageIcon(this.getClass().getResource("/resources/panels/buttons/RENormal.png")));
                    break;
                }
                if (this.eflState == 1) {
                    this.farLeftRotor.setIcon(new ImageIcon(this.getClass().getResource("/resources/panels/buttons/REOne.png")));
                    break;
                }
                if (this.eflState == 2) {
                    this.farLeftRotor.setIcon(new ImageIcon(this.getClass().getResource("/resources/panels/buttons/RETwo.png")));
                    break;
                }
                if (this.eflState != 3) break;
                this.farLeftRotor.setIcon(new ImageIcon(this.getClass().getResource("/resources/panels/buttons/REThree.png")));
            }
        }
    }

    public void setCounter() {
        this.count[0] = this.count[0] + 1;
        if (this.count[0] == 10) {
            this.count[0] = 0;
            this.count[1] = this.count[1] + 1;
            if (this.count[1] == 10) {
                this.count[1] = 0;
                this.count[2] = this.count[2] + 1;
                if (this.count[2] == 10) {
                    this.count[2] = 0;
                    this.count[3] = this.count[3] + 1;
                    if (this.count[3] == 10) {
                        this.count[0] = 0;
                        this.count[1] = 0;
                        this.count[2] = 0;
                        this.count[3] = 0;
                    }
                }
            }
        }
        this.counterLabel.setText(this.count[3] + " " + this.count[2] + " " + this.count[1] + " " + this.count[0]);
        this.counterLabel2.setText(this.count[3] + " " + this.count[2] + " " + this.count[1] + " " + this.count[0]);
    }

    private void switchPress() {
        if (this.lowerSwitch.isVisible()) {
            if (this.silverSwitch) {
                if (this.switchState == 0) {
                    this.lowerSwitch.setIcon(new ImageIcon(this.getClass().getResource("/resources/panels/buttons/OffSwitchSilver.png")));
                    ++this.switchState;
                } else if (this.switchState == 1) {
                    this.lowerSwitch.setIcon(new ImageIcon(this.getClass().getResource("/resources/panels/buttons/OnSwitchSilver.png")));
                    this.switchState = 0;
                }
            } else if (this.switchState == 0) {
                this.lowerSwitch.setIcon(new ImageIcon(this.getClass().getResource("/resources/panels/buttons/OffSwitchBlack.png")));
                ++this.switchState;
            } else if (this.switchState == 1) {
                this.lowerSwitch.setIcon(new ImageIcon(this.getClass().getResource("/resources/panels/buttons/OnSwitchBlack.png")));
                this.switchState = 0;
            }
        } else if (this.switchState == 0) {
            this.switchG3.setIcon(new ImageIcon(this.getClass().getResource("/resources/panels/buttons/OffSwitchBlack.png")));
            ++this.switchState;
        } else if (this.switchState == 1) {
            this.switchG3.setIcon(new ImageIcon(this.getClass().getResource("/resources/panels/buttons/OnSwitchBlack.png")));
            this.switchState = 0;
        }
    }

    private void lockMechanism() {
        if (this.leverGA.isVisible()) {
            if (this.lockState == 0) {
                this.leverGA.setIcon(new ImageIcon(this.getClass().getResource("/resources/panels/buttons/GALever.png")));
                ++this.lockState;
            } else if (this.lockState == 1) {
                this.leverGA.setIcon(new ImageIcon(this.getClass().getResource("/resources/panels/buttons/GALeverPressed.png")));
                this.lockState = 0;
            }
        } else if (this.lockState == 0) {
            this.leverG3.setIcon(new ImageIcon(this.getClass().getResource("/resources/panels/buttons/G3Lever.png")));
            ++this.lockState;
        } else if (this.lockState == 1) {
            this.leverG3.setIcon(new ImageIcon(this.getClass().getResource("/resources/panels/buttons/G3LeverPressed.png")));
            this.lockState = 0;
        }
    }

    private void initComponents() {
        this.indexPanel = new JPanel();
        this.upLeft = new JButton();
        this.upMiddle = new JButton();
        this.faceLeft = new JLabel();
        this.downLeft = new JButton();
        this.downMiddle = new JButton();
        this.downRight = new JButton();
        this.upRight = new JButton();
        this.faceRight = new JLabel();
        this.upFarLeft = new JButton();
        this.downFarLeft = new JButton();
        this.faceFarLeft = new JLabel();
        this.faceMiddle = new JLabel();
        this.counterLabel = new JLabel();
        this.counterLabel2 = new JLabel();
        this.leverGA = new JButton();
        this.switchG3 = new JButton();
        this.lowerSwitch = new JButton();
        this.leverG3 = new JButton();
        this.rotorEffectPanel = new JPanel();
        this.rightRotor = new JLabel();
        this.middleRotor = new JLabel();
        this.leftRotor = new JLabel();
        this.farLeftRotor = new JLabel();
        this.setMaximumSize(new Dimension(360, 181));
        this.setMinimumSize(new Dimension(360, 181));
        this.setPreferredSize(new Dimension(360, 181));
        this.setLayout(null);
        this.indexPanel.setFocusable(false);
        this.indexPanel.setOpaque(false);
        this.upLeft.setContentAreaFilled(false);
        this.upLeft.setFocusable(false);
        this.upLeft.setRolloverIcon(new ImageIcon(this.getClass().getResource("/resources/buttons/ArrowUp.png")));
        this.upLeft.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RotorPanel.this.upLeftActionPerformed(evt);
            }
        });
        this.upMiddle.setContentAreaFilled(false);
        this.upMiddle.setFocusable(false);
        this.upMiddle.setRolloverIcon(new ImageIcon(this.getClass().getResource("/resources/buttons/ArrowUp.png")));
        this.upMiddle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RotorPanel.this.upMiddleActionPerformed(evt);
            }
        });
        this.faceLeft.setFont(new Font("Arial", 1, 11));
        this.faceLeft.setHorizontalAlignment(0);
        this.faceLeft.setText("A");
        this.faceLeft.setFocusable(false);
        this.faceLeft.setHorizontalTextPosition(0);
        this.downLeft.setContentAreaFilled(false);
        this.downLeft.setFocusable(false);
        this.downLeft.setRolloverIcon(new ImageIcon(this.getClass().getResource("/resources/buttons/ArrowDown.png")));
        this.downLeft.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RotorPanel.this.downLeftActionPerformed(evt);
            }
        });
        this.downMiddle.setContentAreaFilled(false);
        this.downMiddle.setFocusable(false);
        this.downMiddle.setRolloverIcon(new ImageIcon(this.getClass().getResource("/resources/buttons/ArrowDown.png")));
        this.downMiddle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RotorPanel.this.downMiddleActionPerformed(evt);
            }
        });
        this.downRight.setContentAreaFilled(false);
        this.downRight.setFocusable(false);
        this.downRight.setRolloverIcon(new ImageIcon(this.getClass().getResource("/resources/buttons/ArrowDown.png")));
        this.downRight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RotorPanel.this.downRightActionPerformed(evt);
            }
        });
        this.upRight.setContentAreaFilled(false);
        this.upRight.setFocusable(false);
        this.upRight.setRolloverIcon(new ImageIcon(this.getClass().getResource("/resources/buttons/ArrowUp.png")));
        this.upRight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RotorPanel.this.upRightActionPerformed(evt);
            }
        });
        this.faceRight.setFont(new Font("Arial", 1, 11));
        this.faceRight.setHorizontalAlignment(0);
        this.faceRight.setText("A");
        this.faceRight.setFocusable(false);
        this.faceRight.setHorizontalTextPosition(0);
        this.upFarLeft.setContentAreaFilled(false);
        this.upFarLeft.setFocusable(false);
        this.upFarLeft.setRolloverIcon(new ImageIcon(this.getClass().getResource("/resources/buttons/ArrowUp.png")));
        this.upFarLeft.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RotorPanel.this.upFarLeftActionPerformed(evt);
            }
        });
        this.downFarLeft.setContentAreaFilled(false);
        this.downFarLeft.setFocusable(false);
        this.downFarLeft.setRolloverIcon(new ImageIcon(this.getClass().getResource("/resources/buttons/ArrowDown.png")));
        this.downFarLeft.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RotorPanel.this.downFarLeftActionPerformed(evt);
            }
        });
        this.faceFarLeft.setFont(new Font("Arial", 1, 11));
        this.faceFarLeft.setHorizontalAlignment(0);
        this.faceFarLeft.setText("A");
        this.faceFarLeft.setFocusable(false);
        this.faceFarLeft.setHorizontalTextPosition(0);
        this.faceMiddle.setFont(new Font("Arial", 1, 11));
        this.faceMiddle.setHorizontalAlignment(0);
        this.faceMiddle.setText("A");
        this.faceMiddle.setFocusable(false);
        this.faceMiddle.setHorizontalTextPosition(0);
        GroupLayout indexPanelLayout = new GroupLayout(this.indexPanel);
        this.indexPanel.setLayout(indexPanelLayout);
        indexPanelLayout.setHorizontalGroup(indexPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(indexPanelLayout.createSequentialGroup().addGroup(indexPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(indexPanelLayout.createSequentialGroup().addGap(2, 2, 2).addComponent(this.downFarLeft).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.downLeft, -2, 32, -2).addGap(7, 7, 7).addComponent(this.downMiddle, -2, 32, -2).addGap(7, 7, 7).addComponent(this.downRight, -2, 32, -2)).addGroup(indexPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.faceFarLeft, -2, 20, -2).addGap(17, 17, 17).addComponent(this.faceLeft, -2, 20, -2).addGap(18, 18, 18).addComponent(this.faceMiddle, -2, 20, -2).addGap(19, 19, 19).addComponent(this.faceRight, -2, 20, -2)).addGroup(indexPanelLayout.createSequentialGroup().addComponent(this.upFarLeft, -2, 32, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.upLeft, -2, 32, -2).addGap(5, 5, 5).addComponent(this.upMiddle, -2, 32, -2).addGap(8, 8, 8).addComponent(this.upRight, -2, 32, -2))).addGap(8, 9, Short.MAX_VALUE)));
        indexPanelLayout.setVerticalGroup(indexPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(indexPanelLayout.createSequentialGroup().addGroup(indexPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.upFarLeft, -2, 32, -2).addComponent(this.upLeft, -2, 32, -2).addComponent(this.upMiddle, -2, 32, -2).addComponent(this.upRight, -2, 32, -2)).addGap(8, 8, 8).addGroup(indexPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, indexPanelLayout.createSequentialGroup().addGroup(indexPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.faceFarLeft, -2, 15, -2).addComponent(this.faceLeft, -2, 15, -2).addComponent(this.faceMiddle, -2, 15, -2).addComponent(this.faceRight, -2, 15, -2)).addGap(7, 7, 7).addGroup(indexPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.downFarLeft, -2, 32, -2).addComponent(this.downLeft, -2, 32, -2).addComponent(this.downMiddle, -2, 32, -2))).addComponent(this.downRight, GroupLayout.Alignment.TRAILING, -2, 32, -2))));
        this.add(this.indexPanel);
        this.indexPanel.setBounds(50, 70, 160, 100);
        this.counterLabel.setFont(new Font("Arial", 0, 10));
        this.counterLabel.setHorizontalAlignment(0);
        this.counterLabel.setText("0 0 0 0");
        this.counterLabel.setFocusable(false);
        this.counterLabel.setHorizontalTextPosition(0);
        this.counterLabel.setMaximumSize(new Dimension(33, 12));
        this.counterLabel.setMinimumSize(new Dimension(33, 12));
        this.counterLabel.setPreferredSize(new Dimension(33, 12));
        this.add(this.counterLabel);
        this.counterLabel.setBounds(20, 160, 33, 9);
        this.counterLabel2.setFont(new Font("Arial", 0, 10));
        this.counterLabel2.setHorizontalAlignment(0);
        this.counterLabel2.setText("0 0 0 0");
        this.counterLabel2.setFocusable(false);
        this.counterLabel2.setHorizontalTextPosition(0);
        this.counterLabel2.setMaximumSize(new Dimension(33, 12));
        this.counterLabel2.setMinimumSize(new Dimension(33, 12));
        this.counterLabel2.setPreferredSize(new Dimension(33, 12));
        this.add(this.counterLabel2);
        this.counterLabel2.setBounds(280, 140, 33, 12);
        this.leverGA.setIcon(new ImageIcon(this.getClass().getResource("/resources/panels/buttons/GALever.png")));
        this.leverGA.setContentAreaFilled(false);
        this.leverGA.setFocusable(false);
        this.leverGA.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RotorPanel.this.leverGAActionPerformed(evt);
            }
        });
        this.add(this.leverGA);
        this.leverGA.setBounds(35, 13, 28, 56);
        this.switchG3.setIcon(new ImageIcon(this.getClass().getResource("/resources/panels/buttons/OnSwitchBlack.png")));
        this.switchG3.setContentAreaFilled(false);
        this.switchG3.setFocusable(false);
        this.switchG3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RotorPanel.this.switchG3ActionPerformed(evt);
            }
        });
        this.add(this.switchG3);
        this.switchG3.setBounds(290, 20, 50, 60);
        this.lowerSwitch.setIcon(new ImageIcon(this.getClass().getResource("/resources/panels/buttons/OnSwitchBlack.png")));
        this.lowerSwitch.setContentAreaFilled(false);
        this.lowerSwitch.setFocusable(false);
        this.lowerSwitch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RotorPanel.this.lowerSwitchActionPerformed(evt);
            }
        });
        this.add(this.lowerSwitch);
        this.lowerSwitch.setBounds(240, 130, 60, 50);
        this.leverG3.setIcon(new ImageIcon(this.getClass().getResource("/resources/panels/buttons/G3Lever.png")));
        this.leverG3.setContentAreaFilled(false);
        this.leverG3.setFocusable(false);
        this.leverG3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RotorPanel.this.leverG3ActionPerformed(evt);
            }
        });
        this.add(this.leverG3);
        this.leverG3.setBounds(130, 5, 40, 90);
        this.rotorEffectPanel.setFocusable(false);
        this.rotorEffectPanel.setOpaque(false);
        this.rightRotor.setHorizontalAlignment(0);
        this.rightRotor.setIcon(new ImageIcon(this.getClass().getResource("/resources/panels/buttons/RENormal.png")));
        this.rightRotor.setFocusable(false);
        this.middleRotor.setHorizontalAlignment(0);
        this.middleRotor.setIcon(new ImageIcon(this.getClass().getResource("/resources/panels/buttons/RENormal.png")));
        this.middleRotor.setFocusable(false);
        this.leftRotor.setHorizontalAlignment(0);
        this.leftRotor.setIcon(new ImageIcon(this.getClass().getResource("/resources/panels/buttons/RENormal.png")));
        this.leftRotor.setFocusable(false);
        this.farLeftRotor.setHorizontalAlignment(0);
        this.farLeftRotor.setIcon(new ImageIcon(this.getClass().getResource("/resources/panels/buttons/RENormal.png")));
        this.farLeftRotor.setFocusable(false);
        GroupLayout rotorEffectPanelLayout = new GroupLayout(this.rotorEffectPanel);
        this.rotorEffectPanel.setLayout(rotorEffectPanelLayout);
        rotorEffectPanelLayout.setHorizontalGroup(rotorEffectPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, rotorEffectPanelLayout.createSequentialGroup().addContainerGap(32, Short.MAX_VALUE).addComponent(this.farLeftRotor).addGap(32, 32, 32).addComponent(this.leftRotor).addGap(34, 34, 34).addComponent(this.middleRotor).addGap(35, 35, 35).addComponent(this.rightRotor).addGap(17, 17, 17)));
        rotorEffectPanelLayout.setVerticalGroup(rotorEffectPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(rotorEffectPanelLayout.createSequentialGroup().addGap(25, 25, 25).addGroup(rotorEffectPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.farLeftRotor).addComponent(this.leftRotor).addComponent(this.middleRotor).addComponent(this.rightRotor)).addContainerGap(20, Short.MAX_VALUE)));
        this.add(this.rotorEffectPanel);
        this.rotorEffectPanel.setBounds(50, 30, 170, 140);
    }

    private void upMiddleActionPerformed(ActionEvent evt) {
        this.smAccess.rotorUp("MIDDLE");
        this.updateWindow();
    }

    private void downFarLeftActionPerformed(ActionEvent evt) {
        this.smAccess.rotorDown("FARLEFT");
        this.updateWindow();
    }

    private void upFarLeftActionPerformed(ActionEvent evt) {
        this.smAccess.rotorUp("FARLEFT");
        this.updateWindow();
    }

    private void downRightActionPerformed(ActionEvent evt) {
        this.smAccess.rotorDown("RIGHT");
        this.updateWindow();
    }

    private void downMiddleActionPerformed(ActionEvent evt) {
        this.smAccess.rotorDown("MIDDLE");
        this.updateWindow();
    }

    private void downLeftActionPerformed(ActionEvent evt) {
        this.smAccess.rotorDown("LEFT");
        this.updateWindow();
    }

    private void upRightActionPerformed(ActionEvent evt) {
        this.smAccess.rotorUp("RIGHT");
        this.updateWindow();
    }

    private void upLeftActionPerformed(ActionEvent evt) {
        this.smAccess.rotorUp("LEFT");
        this.updateWindow();
    }

    private void switchG3ActionPerformed(ActionEvent evt) {
        this.switchPress();
    }

    private void lowerSwitchActionPerformed(ActionEvent evt) {
        this.switchPress();
    }

    private void leverG3ActionPerformed(ActionEvent evt) {
        this.lockMechanism();
    }

    private void leverGAActionPerformed(ActionEvent evt) {
        this.lockMechanism();
    }
}

